/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.tools.SQLUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.report.app.AbstractPurPriceRecordFacadeControllerBean;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurPriceRecordFacadeControllerBean
extends AbstractPurPriceRecordFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.PurPriceRecordFacadeControllerBean");
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable"), ctx);
        String tempTable = this.getTempTableName(this.getServerResource("PurchaseORGUintTempTable", ctx), ctx);
        params.setString("tempTable", tempTable);
        this.createTempTableAndInsertData(ctx, tempTable, params);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setTableHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString("TempTableObject", tempTable);
        return result;
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, sql);
        SqlParams sqlParams = new SqlParams();
        String orderSelect = params.getString("OrderSource");
        if (orderSelect.equals(String.valueOf(10))) {
            this.setRPTData(sqlParams, params);
            sql = this.getRptSqlFromOrder(params, tempTable, ctx);
        } else if (orderSelect.equals(String.valueOf(20))) {
            this.setRPTData(sqlParams, params);
            sql = this.getRptSqlFromOtherOrder(params, tempTable, ctx);
        } else if (orderSelect.equals(String.valueOf(30))) {
            this.setRPTData(sqlParams, params);
            sql = this.getRptSqlFromInWarehsBill(params, tempTable, ctx);
        }
        this.executeUpdate(sql, sqlParams, ctx);
        this.UpdateTemp(params, tempTable, ctx);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FPurChaseORGUnitID Varchar(44)\r\n");
        sql.append(",FSupplierID Varchar(44)\r\n");
        sql.append(",FAdminOrgUnitID Varchar(44)\r\n");
        sql.append(",FPersonID Varchar(44)\r\n");
        sql.append(",FBizDate DateTime\r\n");
        sql.append(",FNumber Varchar(88)\r\n");
        sql.append(",FCurrencyID Varchar(44)\r\n");
        sql.append(",FExchangeRate Decimal(28,10)\r\n");
        sql.append(",FUnitID Varchar(44)\r\n");
        sql.append(",FQty Decimal(28,10)\r\n");
        sql.append(",FTaxPrice Decimal(28,10)\r\n");
        sql.append(",FDiscountRate Decimal(28,10)\r\n");
        sql.append(",FActualPrice Decimal(28,10)\r\n");
        sql.append(",FAmount Decimal(28,10)\r\n");
        sql.append(",FTaxAmount Decimal(28,10)\r\n");
        sql.append(",FCompare varchar(44)\r\n");
        sql.append(",FMaxPrice Decimal(28,10)\r\n");
        sql.append(",FMinPrice Decimal(28,10)\r\n");
        sql.append(",FBaseQty Decimal(28,10)\r\n");
        sql.append(",FRemark NVARCHAR(255)\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int count = sqlParams.size() + 1;
        if (params.getString("SupplierTo") != null) {
            sqlParams.setString(count++, params.getString("SupplierTo"));
        }
        if (params.getString("materialTo") != null) {
            sqlParams.setString(count++, params.getString("materialTo"));
        }
    }

    private String getRptSqlFromOrder(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer temFrOrder = new StringBuffer();
        Object[] fullOrg = (Object[])params.getObject("fullOrgUnit");
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        String orgIDlist = this.getOrgIdList(ctx, fullOrg, "PurPriceRecord_view");
        temFrOrder.append("insert into " + tableName);
        temFrOrder.append(" \r\n SELECT ");
        temFrOrder.append(" \r\n newbosid('88888888'),entry.FMaterialID");
        temFrOrder.append(" \r\n ,purorder.FPurChaseORGUnitID");
        temFrOrder.append(" \r\n ,purorder.FSupplierID,purorder.FAdminOrgUnitID");
        temFrOrder.append(" \r\n ,purorder.FPurchasePersonID,purorder.FBizDate,purorder.FNumber");
        temFrOrder.append(" \r\n ,purorder.FCurrencyID,purorder.FExchangeRate");
        temFrOrder.append(" \r\n ,entry.FUnitID,entry.FQty");
        temFrOrder.append(" \r\n ,entry.FTaxPrice,entry.FDiscountRate");
        temFrOrder.append(" \r\n ,entry.FActualTaxPrice,entry.FAmount");
        temFrOrder.append(" \r\n ,entry.FTaxAmount,null FCompare,0 FMaxPrice,0 FMinPrice,entry.FBaseQty");
        temFrOrder.append(" \r\n ,entry.FRemark");
        temFrOrder.append(" \r\n  from T_SM_PurOrder purorder ");
        temFrOrder.append(" \r\n  inner join  T_SM_PurOrderentry entry on purorder.FID = entry.FParentID ");
        temFrOrder.append(this.getMaterialSupWhere(params, "purorder.FSupplierID"));
        temFrOrder.append(" \r\n  where ");
        temFrOrder.append(" \r\n  (purorder.Fbasestatus =4 or purorder.Fbasestatus = 5 ");
        temFrOrder.append(" \r\n   or purorder.Fbasestatus = 6 or purorder.Fbasestatus = 7)");
        temFrOrder.append(" \r\n and purorder.FPurChaseORGUnitID in (" + orgIDlist);
        temFrOrder.append(" \r\n  )");
        temFrOrder.append(" \r\n  and purorder.FBizDate >= {" + beginDate + "}");
        temFrOrder.append(" \r\n  and purorder.FBizDate <= {" + endDate + "}");
        temFrOrder.append(" \r\n AND entry.FQty > 0 ");
        return temFrOrder.toString();
    }

    private StringBuffer getMaterialSupWhere(RptParams params, String billField) {
        String[] numArray;
        boolean isSupplierFr = false;
        boolean isSupplierTo = false;
        boolean isMatFr = false;
        boolean isMatTo = false;
        if (params.getObject("SupplierFrom") != null) {
            isSupplierFr = true;
        }
        if (params.getString("SupplierTo") != null) {
            isSupplierTo = true;
        }
        if (params.getObject("materialFrom") != null) {
            isMatFr = true;
        }
        if (params.getString("materialTo") != null) {
            isMatTo = true;
        }
        StringBuffer temFrOrder = new StringBuffer();
        if (isSupplierFr || isSupplierTo) {
            temFrOrder.append(" \r\n  inner join  T_BD_Supplier supplier on " + billField + " = supplier.FID ");
            if (isSupplierFr) {
                numArray = SCMUtil.getF7Numbers((Object)params.getObject("SupplierFrom"));
                if (numArray[0] != null) {
                    temFrOrder.append(" \r\n  and supplier.FNumber >= '").append(numArray[0]).append("'");
                } else if (numArray[1] != null) {
                    temFrOrder.append(" \r\n  and supplier.FNumber in (").append(numArray[1]).append(")");
                }
            }
            if (isSupplierTo) {
                temFrOrder.append(" \r\n  and supplier.FNumber <= ?");
            }
        }
        if (isMatFr || isMatTo) {
            temFrOrder.append(" \r\n  inner join  T_BD_Material mat on entry.FMaterialID = mat.FID ");
            if (isMatFr) {
                numArray = SCMUtil.getF7Numbers((Object)params.getObject("materialFrom"));
                if (numArray[0] != null) {
                    temFrOrder.append(" \r\n  and mat.FNumber >= '").append(numArray[0]).append("'");
                } else if (numArray[1] != null) {
                    temFrOrder.append(" \r\n  and mat.FNumber in (").append(numArray[1]).append(")");
                }
            }
            if (isMatTo) {
                temFrOrder.append(" \r\n  and mat.FNumber <= ? ");
            }
        }
        return temFrOrder;
    }

    private String getRptSqlFromOtherOrder(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer temFrOrder = new StringBuffer();
        Object[] fullOrg = (Object[])params.getObject("fullOrgUnit");
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        String orgIDlist = this.getOrgIdList(ctx, fullOrg, "PurPriceRecord_view");
        temFrOrder.append("insert into " + tableName);
        temFrOrder.append(" \r\n SELECT ");
        temFrOrder.append(" \r\n newbosid('88888888'),entry.FMaterialID");
        temFrOrder.append(" \r\n ,Bill.FPurOrgID");
        temFrOrder.append(" \r\n ,Bill.FAsstActID,Bill.FAdminOrgUnitID");
        temFrOrder.append(" \r\n ,Bill.FPersonID,Bill.FBizDate,Bill.FNumber");
        temFrOrder.append(" \r\n ,Bill.FCurrencyID,Bill.FExchangeRate");
        temFrOrder.append(" \r\n ,entry.FMeasureUnitID,entry.FQuantity");
        temFrOrder.append(" \r\n ,entry.FTaxPrice,entry.FDiscountRate");
        temFrOrder.append(" \r\n ,entry.FActualPrice,entry.FAmount");
        temFrOrder.append(" \r\n ,(entry.FTaxAmount + entry.FAmount),null FCompare,0 FMaxPrice,0 FMinPrice,entry.FBaseQty");
        temFrOrder.append(" \r\n ,entry.FRemark");
        temFrOrder.append(" \r\n  from T_AP_OtherBill Bill ");
        temFrOrder.append(" \r\n  inner join  T_AP_OtherBillEntry entry on bill.FID = entry.FParentID ");
        temFrOrder.append(this.getMaterialSupWhere(params, "Bill.FAsstActID"));
        temFrOrder.append(" \r\n  where ");
        temFrOrder.append(" \r\n  Bill.FBillstatus = 3 and BIll.FBillType =202");
        temFrOrder.append(" \r\n  and Bill.FPurOrgID in (" + orgIDlist);
        temFrOrder.append(" \r\n  )");
        temFrOrder.append(" \r\n  and Bill.FBizDate >= {" + beginDate + "}");
        temFrOrder.append(" \r\n  and Bill.FBizDate <= {" + endDate + "}");
        return temFrOrder.toString();
    }

    private String getOrgIdList(Context ctx, Object[] fullOrg, String permissionName) throws BOSException, EASBizException {
        String orgIDlist = "";
        Set cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)permissionName);
        if (null == fullOrg || fullOrg.length == 0 || null == cuUnitSets) {
            orgIDlist = "'xxx_xxx'";
        } else {
            Set havePermOrgUnitSet = InvServerUtils.getSelAuthorUnit((Set)cuUnitSets, (Object[])fullOrg);
            fullOrg = havePermOrgUnitSet.toArray();
            orgIDlist = this.getOrgListId(fullOrg);
        }
        return orgIDlist;
    }

    private void UpdateTemp(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer temFrOrder = new StringBuffer();
        temFrOrder.append(" \r\n update " + tableName);
        temFrOrder.append(" \r\n set (FMaxPrice,FMinPrice)=");
        temFrOrder.append(" \r\n  (select mm.FMaxPrice, mm.FMinPrice from ");
        temFrOrder.append(" \r\n  ( select  FMaterialID ");
        temFrOrder.append(" \r\n  ,Max(case when temp.FBaseQty=0 then 0 else TO_DECIMAL((temp.FAmount/temp.FBaseQty)*temp.FExchangeRate,31,7) end ) FMaxPrice");
        temFrOrder.append(" \r\n  ,Min(case when temp.FBaseQty=0 then 0 else TO_DECIMAL((temp.FAmount/temp.FBaseQty)*temp.FExchangeRate,31,7) end ) FMinPrice");
        temFrOrder.append(" \r\n from " + tableName + " as  temp ");
        temFrOrder.append(" \r\n group by FMaterialID )");
        temFrOrder.append(" \r\n  mm where mm.FMaterialID=");
        temFrOrder.append(tableName + ".FMaterialID)");
        this.executeUpdate(temFrOrder.toString(), null, ctx);
    }

    private String getRptSqlFromInWarehsBill(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer temInWarehsBill = new StringBuffer();
        Object[] fullOrg = (Object[])params.getObject("fullOrgUnit");
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        String orgIDlist = this.getOrgIdList(ctx, fullOrg, "PurPriceRecord_view");
        temInWarehsBill.append("insert into " + tableName);
        temInWarehsBill.append(" \r\n SELECT ");
        temInWarehsBill.append(" \r\n newbosid('88888888'),entry.FMaterialID");
        temInWarehsBill.append(" \r\n ,entry.FPurchaseOrgUnitID");
        temInWarehsBill.append(" \r\n ,Bill.FSupplierID,Bill.FAdminOrgUnitID");
        temInWarehsBill.append(" \r\n ,Bill.FCreatorID FPersonID,Bill.FBizDate,Bill.FNumber");
        temInWarehsBill.append(" \r\n ,Bill.FCurrencyID,Bill.FExchangeRate");
        temInWarehsBill.append(" \r\n ,entry.FUnitID,entry.FQty");
        temInWarehsBill.append(" \r\n ,entry.FTaxPrice,entry.FDiscountRate");
        temInWarehsBill.append(" \r\n ,entry.FActualTaxPrice,entry.FAmount");
        temInWarehsBill.append(" \r\n ,entry.FTaxAmount,null FCompare,0 FMaxPrice,0 FMinPrice,entry.FBaseQty");
        temInWarehsBill.append(" \r\n ,entry.FRemark");
        temInWarehsBill.append(" \r\n  from T_IM_PurInWarehsBill Bill ");
        temInWarehsBill.append(" \r\n  left join  T_IM_PurInWarehsEntry entry on Bill.FID = entry.FParentID ");
        temInWarehsBill.append(this.getMaterialSupWhere(params, "Bill.FSupplierID"));
        temInWarehsBill.append(" \r\n  where ");
        temInWarehsBill.append(" \r\n  Bill.FBaseStatus in (4,5,6,7) ");
        temInWarehsBill.append(" \r\n  and entry.FPurchaseOrgUnitID in (" + orgIDlist);
        temInWarehsBill.append(" \r\n  )");
        temInWarehsBill.append(" \r\n  and Bill.FBizDate >= {" + beginDate + "}");
        temInWarehsBill.append(" \r\n  and Bill.FBizDate <= {" + endDate + "}");
        return temInWarehsBill.toString();
    }

    private RptTableHeader setTableHead(RptTableHeader header, RptParams params, Context ctx) {
        String materialNum = this.getServerResource("MaterialNumber", ctx);
        String materialName = this.getServerResource("MaterialName", ctx);
        String materialModel = this.getServerResource("MaterialModel", ctx);
        String purchaseUnitName = this.getServerResource("PurchaseUnit", ctx);
        String supplierName = this.getServerResource("supplierNameABC", ctx);
        String deptName = this.getServerResource("DeptName", ctx);
        String personName = this.getServerResource("Person", ctx);
        String bizDate = this.getServerResource("BizDate", ctx);
        String billNumber = this.getServerResource("BillNumber", ctx);
        String currencyName = this.getServerResource("Currency", ctx);
        String exchangRate = this.getServerResource("ExchangRate", ctx);
        String unitName = this.getServerResource("Unit_PurPricRecord", ctx);
        String qty = this.getServerResource("Qty_PurPriceRecord", ctx);
        String taxprice = this.getServerResource("Taxprice", ctx);
        String discountRate = this.getServerResource("DiscountRate", ctx);
        String actualPrice = this.getServerResource("ActualTaxPrice", ctx);
        String amount = this.getServerResource("Amount", ctx);
        String taxAmount = this.getServerResource("TaxAmount", ctx);
        String compare = this.getServerResource("Compare", ctx);
        String maxPrice = this.getServerResource("MaxPrice", ctx);
        String minPrice = this.getServerResource("MinPrice", ctx);
        String baseQty = this.getServerResource("BaseQty", ctx);
        String remark = this.getServerResource("Memo", ctx);
        String materilShortName = this.getServerResource("MaterialShortName", ctx);
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        Object[][] labels = new Object[1][24];
        String[] cols = new String[24];
        if (ckBxShowMShortName) {
            labels = new Object[1][25];
            cols = new String[25];
        }
        int m = 2;
        cols[0] = "MATERIAL_NUMBER";
        cols[1] = "MATERIAL_NAME";
        if (ckBxShowMShortName) {
            cols[m++] = "MATERIAL_SHORTNAME";
        }
        cols[m++] = "MATERIAL_MODEL";
        cols[m++] = "PURCHASEORG_NAME";
        cols[m++] = "SUPPLIER_NAME";
        cols[m++] = "DEPT_TNAME";
        cols[m++] = "PERSON_NAME";
        cols[m++] = "BIZDATE";
        cols[m++] = "FNUMBER";
        cols[m++] = "CURRENCY";
        cols[m++] = "EXCHANGRATE";
        cols[m++] = "UNIT_NAME";
        cols[m++] = "QTY";
        cols[m++] = "TAXPRICE";
        cols[m++] = "DISCOUNTRATE";
        cols[m++] = "ACTUALPRICE";
        cols[m++] = "AMOUNT";
        cols[m++] = "TAXAMOUNT";
        cols[m++] = "REMARK";
        cols[m++] = "MATERIAL_ID";
        cols[m++] = "COMPARE";
        cols[m++] = "MAXPRICE";
        cols[m++] = "MINPRICE";
        cols[m++] = "BASEQTY";
        m = 2;
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = materialNum;
        labels[0][1] = materialName;
        if (ckBxShowMShortName) {
            labels[0][m++] = materilShortName;
        }
        labels[0][m++] = materialModel;
        labels[0][m++] = purchaseUnitName;
        labels[0][m++] = supplierName;
        labels[0][m++] = deptName;
        labels[0][m++] = personName;
        labels[0][m++] = bizDate;
        labels[0][m++] = billNumber;
        labels[0][m++] = currencyName;
        labels[0][m++] = exchangRate;
        labels[0][m++] = unitName;
        labels[0][m++] = qty;
        labels[0][m++] = taxprice;
        labels[0][m++] = discountRate;
        labels[0][m++] = actualPrice;
        labels[0][m++] = amount;
        labels[0][m++] = taxAmount;
        labels[0][m++] = remark;
        labels[0][m++] = "MateialID";
        labels[0][m++] = compare;
        labels[0][m++] = maxPrice;
        labels[0][m++] = minPrice;
        labels[0][m++] = baseQty;
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        int i;
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        RptTableColumn col = null;
        String[] colNeedRight = new String[]{"EXCHANGRATE", "QTY", "TAXPRICE", "DISCOUNTRATE", "ACTUALPRICE", "AMOUNT", "TAXAMOUNT", "MAXPRICE", "MINPRICE", "BASEQTY"};
        String[] colNeedHide = new String[]{"MAXPRICE", "MINPRICE", "BASEQTY"};
        HashSet<String> hsRight = new HashSet<String>();
        HashSet<String> hsHide = new HashSet<String>();
        for (i = 0; i < colNeedRight.length; ++i) {
            hsRight.add(colNeedRight[i]);
        }
        for (i = 0; i < colNeedHide.length; ++i) {
            hsHide.add(colNeedHide[i]);
        }
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        for (int i2 = 0; i2 < columns.length; ++i2) {
            col = new RptTableColumn(columns[i2]);
            if (ckBxShowMShortName && col.getName().equals("BIZDATE")) {
                col.setFormatPattern(dateFormat);
            }
            if (hsRight.contains(col.getName())) {
                col.setWidth(-1);
                col.setWidth(120);
                col.setAligment(2);
            }
            if (hsHide.contains(col.getName())) {
                col.setHided(true);
            }
            if (col.getName().equals("MATERIAL_ID")) {
                col.setWidth(-1);
                col.setHided(true);
            }
            if (col.getName().equals("BIZDATE")) {
                col.setFormatPattern(dateFormat);
            }
            header.addColumn(col);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptRowSet rs = this.executeQuery(this.getQuerySql(ctx, params), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    protected String getOrgListId(Object[] infos) throws EASBizException {
        StringBuffer OrgunitId = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)infos[i]).get("isleaf");
            boolean fisleaf = isleaf != false;
            if (!fisleaf) continue;
            OrgunitId.append(",'" + ((FullOrgUnitInfo)infos[i]).getId().toString() + "'");
        }
        if (OrgunitId.length() <= 0) {
            return "'xxx_xxx'";
        }
        String orgunitListId = new String();
        orgunitListId = OrgunitId.toString().substring(1, OrgunitId.toString().length());
        return orgunitListId;
    }

    @Override
    protected void _updateProperty(Context ctx, String UserNumber, String orderResource, int month) throws BOSException, EASBizException {
        StringBuffer sql_update = new StringBuffer();
        sql_update.append(" update T_sm_PurpriceRecProperty");
        sql_update.append(" \r\n set (FOrderResource,FDateRange,FLastUpdateTime)");
        sql_update.append(" \r\n =(select '" + orderResource + "','" + month);
        sql_update.append("',getDate())");
        sql_update.append(" \r\n where FUserNumber='" + UserNumber + "'");
        this.executeUpdate(sql_update.toString(), null, ctx);
    }

    @Override
    protected void _insertProperty(Context ctx, String UserNumber, String orderResource, int month) throws BOSException, EASBizException {
        String createTime = "2007-01-14 23:59:59";
        String updateTime = "2007-01-14 23:59:59";
        StringBuffer sql_insert = new StringBuffer();
        sql_insert.append(" insert into T_sm_PurpriceRecProperty");
        sql_insert.append(" \r\n values('" + UserNumber);
        sql_insert.append("','" + orderResource + "','" + month);
        sql_insert.append("',{" + createTime + "},{" + updateTime + "})");
        this.executeUpdate(sql_insert.toString(), null, ctx);
    }

    @Override
    protected int _queryProperty(Context ctx, String unserName) throws BOSException, EASBizException {
        StringBuffer sql_select = new StringBuffer();
        sql_select.append(" select top 1 FUserNumber from T_sm_PurpriceRecProperty");
        sql_select.append(" \r\n where FUserNumber=");
        sql_select.append("'" + unserName + "' order by FLastUpdateTime");
        RptRowSet rs = this.executeQuery(sql_select.toString(), null, ctx);
        return rs.getRowCount();
    }

    @Override
    protected RptRowSet _selectProperty(Context ctx, String unserName) throws BOSException, EASBizException {
        StringBuffer sql_select = new StringBuffer();
        sql_select.append(" select top 1 FORDERRESOURCE, FDATERANGE from T_sm_PurpriceRecProperty");
        sql_select.append(" \r\n where FUserNumber=");
        sql_select.append("'" + unserName + "' order by FLastUpdateTime");
        RptRowSet rs = this.executeQuery(sql_select.toString(), null, ctx);
        return rs;
    }

    @Override
    protected RptParams _queryByWeb(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("select * from ").append(tempTable);
        RptRowSet rs = this.executeQuery(sqlbf.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rsNum = this.executeQuery(countSql, null, ctx);
        rsNum.next();
        int count = rsNum.getInt(0);
        pp.setInt("verticalCount", count);
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    @Override
    protected RptParams _createTempTableByWeb(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        TempTablePool tempTablePool = TempTablePool.getInstance((Context)ctx);
        try {
            if (tempTable != null) {
                tempTablePool.releaseTable(tempTable);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        RptParams param = this._createTempTable(ctx, params);
        String newTempSql = this.getCreateTempTableByWeb("TEMP_RECORDTABLE_0", params);
        try {
            tempTable = tempTablePool.createTempTable(newTempSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String dataSql = this.getQuerySql(ctx, params);
        StringBuffer inSertSql = new StringBuffer();
        inSertSql.append("insert into ").append(tempTable);
        inSertSql.append(" (FMaterialNum,FMaterialName,");
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        if (ckBxShowMShortName) {
            inSertSql.append("MATERIAL_SHORTNAME,");
        }
        inSertSql.append("FMODEL,FNAME,FSupplierName,FDepartment,FSalesMen,FBIZDATE,FNumber,FCurrencyName,FEXCHANGERATE,FMessureUnit,FQTY,");
        inSertSql.append("FTAXPRICE,FDISCOUNTRATE,FACTUALPRICE,FAMOUNT,FTAXAMOUNT,FRemark,FID,FPRICETYPE,FMAXPRICE,");
        inSertSql.append("FMINPRICE,FBaseQty) ");
        inSertSql.append("(").append(dataSql).append(")");
        SQLUtils.execute((Context)ctx, (String)inSertSql.toString());
        this.dropTempTable(ctx, param.getString("tempTable"));
        param.setString("tempTable", tempTable);
        return param;
    }

    private String getCreateTempTableByWeb(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FMaterialNum Varchar(80)\r\n");
        sql.append(",FMaterialName Varchar(255)\r\n");
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        if (ckBxShowMShortName) {
            sql.append(",MATERIAL_SHORTNAME Varchar(80)\r\n");
        }
        sql.append(",FMODEL NVARCHAR(255)\r\n");
        sql.append(",FNAME NVARCHAR(255)\r\n");
        sql.append(",FSupplierName NVARCHAR(255)\r\n");
        sql.append(",FDepartment NVARCHAR(255)\r\n");
        sql.append(",FSalesMen NVARCHAR(80)\r\n");
        sql.append(",FBIZDATE DateTime\r\n");
        sql.append(",FNumber Varchar(88)\r\n");
        sql.append(",FCurrencyName NVARCHAR(255)\r\n");
        sql.append(",FEXCHANGERATE Decimal(28,10)\r\n");
        sql.append(",FMessureUnit Varchar(80)\r\n");
        sql.append(",FQTY Decimal(28,10)\r\n");
        sql.append(",FTAXPRICE Decimal(28,10)\r\n");
        sql.append(",FDISCOUNTRATE Decimal(28,10)\r\n");
        sql.append(",FACTUALPRICE Decimal(28,10)\r\n");
        sql.append(",FAMOUNT Decimal(28,10)\r\n");
        sql.append(",FTAXAMOUNT Decimal(28,10)\r\n");
        sql.append(",FRemark NVARCHAR(255)\r\n");
        sql.append(",FID Varchar(44)\r\n");
        sql.append(",FPRICETYPE Varchar(44)\r\n");
        sql.append(",FMAXPRICE Decimal(28,10)\r\n");
        sql.append(",FMINPRICE Decimal(28,10)\r\n");
        sql.append(",FBaseQty Decimal(28,10)\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private String getQuerySql(Context ctx, RptParams params) {
        String local_lan = ctx.getLocale().getLanguage();
        StringBuffer sqlbf = new StringBuffer();
        String tempTable = params.getString("tempTable");
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        sqlbf.append(" select MAT.FNUMBER AS FMaterialNum,MAT.FNAME_" + local_lan + " AS FMaterialName ,");
        sqlbf.append(ckBxShowMShortName ? "MAT.FShortName AS MATERIAL_SHORTNAME," : "");
        sqlbf.append("MAT.FMODEL");
        sqlbf.append(" \r\n ,ORG.FNAME_" + local_lan + " AS FNAME,SUPPLIER.FNAME_" + local_lan);
        sqlbf.append(" AS FSupplierName \r\n ,ADMINORG.FNAME_" + local_lan + " AS FDepartment,PERSON.FNAME_" + local_lan);
        sqlbf.append(" AS FSalesMen \r\n ,TEMP.FBIZDATE,TEMP.FNUMBER");
        sqlbf.append(" \r\n ,CURRENCY.FNAME_" + local_lan + " AS FCurrencyName,TEMP.FEXCHANGERATE");
        sqlbf.append(" \r\n ,BASEUNIT.FNAME_" + local_lan + " AS FMessureUnit,TEMP.FQTY");
        sqlbf.append(" \r\n ,TEMP.FTAXPRICE,TEMP.FDISCOUNTRATE");
        sqlbf.append(" \r\n ,TEMP.FACTUALPRICE");
        sqlbf.append(" \r\n ,TEMP.FAMOUNT");
        sqlbf.append(" \r\n ,TEMP.FTAXAMOUNT");
        sqlbf.append(" \r\n ,TEMP.FRemark");
        sqlbf.append(" \r\n ,MAT.FID");
        sqlbf.append(" \r\n , (case when (case when temp.FBaseQty=0 then 0 else TO_DECIMAL((temp.FAmount/temp.FBaseQty)*temp.FExchangeRate,31,7) end < TEMP.FMAXPRICE");
        sqlbf.append(" and case when temp.FBaseQty=0 then 0 else TO_DECIMAL((temp.FAmount/temp.FBaseQty)*temp.FExchangeRate,31,7) end >TEMP.FMINPRICE)");
        sqlbf.append(" Then '").append(ResourceBase.getString((String)resClassName, (String)"MiddlePrice", (Locale)ctx.getLocale())).append("'");
        sqlbf.append(" \r\n when (case when temp.FBaseQty=0 then 0 else TO_DECIMAL((temp.FAmount/temp.FBaseQty)*temp.FExchangeRate,31,7) end = TEMP.FMAXPRICE");
        sqlbf.append(" and case when temp.FBaseQty=0 then 0 else TO_DECIMAL((temp.FAmount/temp.FBaseQty)*temp.FExchangeRate,31,7) end =TEMP.FMINPRICE)");
        sqlbf.append(" THEN '").append(ResourceBase.getString((String)resClassName, (String)"AveragePrice", (Locale)ctx.getLocale())).append("'");
        sqlbf.append(" \r\n WHEN case when temp.FBaseQty=0 then 0 else TO_DECIMAL((temp.FAmount/temp.FBaseQty)*temp.FExchangeRate,31,7) end = TEMP.FMAXPRICE then '").append(ResourceBase.getString((String)resClassName, (String)"MaxPrice", (Locale)ctx.getLocale())).append("'");
        sqlbf.append(" \r\n when case when temp.FBaseQty=0 then 0 else TO_DECIMAL((temp.FAmount/temp.FBaseQty)*temp.FExchangeRate,31,7) end = TEMP.FMINPRICE then '").append(ResourceBase.getString((String)resClassName, (String)"MinPrice", (Locale)ctx.getLocale())).append("'");
        sqlbf.append(" \r\n END) as FPRICETYPE");
        sqlbf.append(" \r\n ,TEMP.FMAXPRICE,TEMP.FMINPRICE");
        sqlbf.append(" \r\n ,temp.FBaseQty");
        sqlbf.append(" \r\n FROM  " + tempTable + " AS TEMP ");
        sqlbf.append(" \r\n INNER JOIN T_BD_MATERIAL MAT ON TEMP.FMATERIALID = MAT.FID ");
        sqlbf.append(" \r\n INNER JOIN T_ORG_Purchase AS org ON TEMP.FPurChaseORGUnitID = org.FID ");
        sqlbf.append(" \r\n INNER JOIN T_BD_Supplier AS SUPPLIER ON TEMP.FSupplierID = SUPPLIER.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_ORG_Admin AS ADMINORG ON TEMP.FAdminOrgUnitID = ADMINORG.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_Person AS PERSON ON TEMP.FPersonId = PERSON.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON TEMP.FCurrencyID = CURRENCY.FID ");
        sqlbf.append(" \r\n INNER JOIN T_BD_MeasureUnit AS BASEUNIT ON TEMP.FUnitID = BASEUNIT.FID ");
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                if (sqlbf.toString().indexOf("where") == -1) {
                    sqlbf.append("\r\n where ");
                    sqlbf.append(" MAT.FShortName >= '").append(shortNameFrom.trim()).append("' ");
                } else {
                    sqlbf.append(" and MAT.FShortName >= '").append(shortNameFrom.trim()).append("' ");
                }
            }
            if (shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                if (sqlbf.toString().indexOf("where") == -1) {
                    sqlbf.append("\r\n where ");
                    sqlbf.append(" MAT.FShortName <= '").append(shortNameTo.trim()).append("' ");
                } else {
                    sqlbf.append(" and MAT.FShortName <= '").append(shortNameTo.trim()).append("' ");
                }
            }
        }
        return sqlbf.toString() + " order by MAT.FNUMBER";
    }
}

