/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeInfo;
import com.kingdee.eas.basedata.scm.sm.sc.MaterialPurchaseTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.service.SCMPermissionService;
import com.kingdee.eas.scm.common.util.SCMRptUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.calculate.PurRequestCal;
import com.kingdee.eas.scm.sm.report.app.AbstractPurRequestTotalFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurRequestTotalFacadeControllerBean
extends AbstractPurRequestTotalFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.PurRequestTotalFacadeControllerBean");
    private String LNAME = "L2";
    private String sp = "\r\n";
    private String tempTable = null;

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.LNAME = this.getLoc(ctx);
        this.tempTable = this.getTempTableName("PurRequestTotal", ctx);
        RptRowSet rowSet = null;
        QuerySql mainQuery = this.buildMainSql(ctx, params);
        if (params.getInt("targetBill") == 1) {
            rowSet = this.checkAvailable(ctx, mainQuery, params);
        }
        TempTablePool tempTablePool = TempTablePool.getInstance((Context)ctx);
        try {
            tempTablePool.releaseTable(this.tempTable);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        RptParams retParams = new RptParams();
        retParams.setObject("rowSet", (Object)rowSet);
        return retParams;
    }

    private RptRowSet checkAvailable(Context ctx, QuerySql mainQuery, RptParams params) throws EASBizException, BOSException {
        CreateTempTableResult result = SCMRptUtils.executeCreateAsSelectInto((Context)ctx, (String)mainQuery.getSql(), null);
        this.tempTable = result.getTempTable();
        StringBuffer sbSQL = new StringBuffer(400);
        sbSQL.append("SELECT reqfid, fbizdate, reqNumber, billstate, fcompanyorgunitid, fromCompanyName, entryfid,\n");
        sbSQL.append(" entrystate, matrerilGroupName, fmaterialid, materialNumber, materialName, fmodel, fassistPropertyid,\n");
        sbSQL.append(" assitName, fbaseunitid, baseUnitName, qty, confirmqty, requestqty, fsupplierid, supplierName,\n");
        sbSQL.append(" fcurrencyid, bdCurrencyName, curPrecision, fexchangerate, FPrice, frequirementdate,\n");
        sbSQL.append(" fproposedeliverydate, ftracknumber, trackNo, trackNumber, fprojectID, projectNumber, rowTypeId,\n");
        sbSQL.append(" rowTypeNumber, rowtypeName, receivingOrgId, receivingOrgNum, receivingOrgName, adminOrgId, adminOrgNum, ");
        sbSQL.append(" adminOrgName, FAvailable, QtyPrec, PricePrec, fassistunitid ,");
        sbSQL.append(" isInTax, isPriceInTax,taxRate ,discountRate,");
        sbSQL.append(" fpurUnitid,fpurQtyPrecision,FpurConvsRate \n");
        sbSQL.append("FROM ").append(this.tempTable).append(" ");
        sbSQL.append(" WHERE NOT EXISTS ( SELECT preq.FID FROM T_SM_PurRequest preq LEFT JOIN T_SM_PurRequestEntry pre");
        sbSQL.append(" ON preq.FID=pre.FParentID WHERE preq.FID=reqfid and pre.FMaterialID IS NULL )");
        sbSQL.append(" ORDER BY FAvailable,materialNumber,materialName,fbaseunitid,rowTypeId,reqNumber");
        RptRowSet rowSet = this.executeQuery(sbSQL.toString(), null, ctx);
        return rowSet;
    }

    private void updatePrice(Context ctx, RptParams params) throws EASBizException, BOSException {
        OrgUnitInfo fromPur = (OrgUnitInfo)params.getObject("purchaseOrgFrom");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = sdf.format(new Date());
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("SELECT tmp.FMaterialId,si.FPrice,mm.FBaseConvsRate,mm.FConvsPrecision,mm.FIsBasicUnit,tmp.PricePrec ").append(" FROM  T_SM_SupplyInfo si, ").append(this.tempTable).append(" tmp,T_BD_MultiMeasureUnit mm ").append(this.sp).append(" WHERE tmp.fsupplierid = si.FSupplierID ").append(this.sp).append(" AND tmp.FMaterialId = mm.FMaterialID ").append(this.sp).append(" AND si.FPurMeasureUnitID = mm.FMeasureUnitID ").append(this.sp).append(" AND si.FPurchaseOrgID = '").append(fromPur.getId().toString()).append("' ").append(this.sp).append(" AND tmp.fmaterialid = si.FMaterialItemID ").append(this.sp).append(" AND si.FEffectualDate <= to_date('").append(sDate).append("') AND si.FUneffectualDate >= to_date('").append(sDate).append("')  AND FIsUseable = 1 ").append(this.sp).append(" and si.fmaterialPurchaseType = ").append(0).append(" ORDER BY si.FauditDate DESC ");
        RptRowSet rowSet = this.executeQuery(selectSql.toString(), null, ctx);
        Connection conn = null;
        PreparedStatement ps = null;
        String updateSql = "UPDATE " + this.tempTable + " SET FPrice = ? WHERE fmaterialid = ?";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(updateSql);
            HashSet<String> setMaterial = new HashSet<String>();
            while (rowSet.next()) {
                String materialId = rowSet.getString("FMaterialId");
                if (setMaterial.contains(materialId)) continue;
                if (rowSet.getBigDecimal("FPrice") != null) {
                    BigDecimal purchasePrice = rowSet.getBigDecimal("FPrice");
                    if (!rowSet.getBoolean("FIsBasicUnit", true)) {
                        int convsPre = rowSet.getInt("PricePrec");
                        BigDecimal convsRate = rowSet.getBigDecimal("FBaseConvsRate");
                        purchasePrice = purchasePrice.divide(convsRate, convsPre, 4);
                    }
                    ps.setBigDecimal(1, purchasePrice);
                    ps.setString(2, materialId);
                    ps.addBatch();
                }
                setMaterial.add(materialId);
            }
            if (rowSet.getRowCount() > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updateSql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private String getAllCompanys(Context ctx, RptParams params) {
        String nums = params.getString("fromCompanys");
        if (nums == null || nums.trim().length() == 0) {
            StringBuffer orgsBuf = new StringBuffer();
            orgsBuf.append("'xxx_xxxx'");
            try {
                SCMPermissionService permSrv = new SCMPermissionService(ctx);
                OrgUnitInfo[] orgs = permSrv.getAuthorizedBizOrgUnits(ctx.getCaller(), OrgType.Company, "purreqtotal_view");
                for (int i = 0; i < orgs.length; ++i) {
                    orgsBuf.append(",'").append(orgs[i].getNumber()).append("'");
                }
            }
            catch (Exception exp) {
                logger.error((Object)exp);
            }
            return orgsBuf.toString();
        }
        String[] numArray = nums.split(";");
        return this.array2String(numArray);
    }

    private String array2String(String[] strArray) {
        StringBuffer numString = new StringBuffer();
        numString.append("'xxx_xxxx'");
        for (int i = 0; i < strArray.length; ++i) {
            numString.append(",'").append(strArray[i].trim()).append("'");
        }
        return numString.toString();
    }

    private String getStatusRange(Context ctx, RptParams params) {
        StringBuffer status = new StringBuffer();
        status.append(4);
        if (params.getBoolean("conatainRevoke")) {
            status.append(",").append(3);
        }
        if (params.getBoolean("conatainClose")) {
            status.append(",").append(7);
        }
        return status.toString();
    }

    private QuerySql buildMainSql(Context ctx, RptParams params) {
        QuerySql query = new QuerySql();
        AdminOrgUnitInfo adminOrg = (AdminOrgUnitInfo)params.getObject("adminOrgTo");
        StorageOrgUnitInfo storageOrg = (StorageOrgUnitInfo)params.getObject("requestOrgTo");
        DemandTypeInfo demandType = (DemandTypeInfo)params.getObject("demandType");
        String fromDate = params.getString("dateFrom");
        String toDate = params.getString("dateTo");
        OrgUnitInfo fromPur = (OrgUnitInfo)params.getObject("purchaseOrgFrom");
        query.selectPart.append("SELECT req.fid reqfid,req.fbizdate,req.fnumber reqNumber,req.fbasestatus billstate,req.fcompanyorgunitid,").append(this.sp).append(" orgcom.fname_").append(this.LNAME).append(" fromCompanyName,entry.fid entryfid,entry.fbasestatus entrystate,").append(this.sp).append(" mg.fname_").append(this.LNAME).append(" matrerilGroupName,").append(this.sp).append(" entry.fmaterialid,material.fnumber materialNumber,").append(" CASE WHEN entry.fmaterialid IS NULL THEN entry.FMaterialName ELSE material.fname_").append(this.LNAME).append(" END as materialName,entry.fnonummaterialmodel as fmodel,entry.fassistPropertyid,").append(this.sp).append(" assit.fname_").append(this.LNAME).append(" assitName,entry.fbaseunitid,baseunit.fname_").append(this.LNAME).append(" baseUnitName,Case When entry.fbaseqty is null then 0 else entry.fbaseqty end as qty,entry.fbaseqty confirmqty,").append(" round(decimal(entry.frequestqty*mmUnit.FBaseConvsRate,21,8),mmUnit2.FQtyPrecision) requestqty,").append(this.sp).append(" entry.fsupplierid,").append(" supplier.fname_").append(this.LNAME).append(" supplierName,").append(" bdCurrency.fid fcurrencyid,bdCurrency.fname_").append(this.LNAME).append(" bdCurrencyName,bdCurrency.FPrecision curPrecision,").append(" to_decimal(1.0,19,4) fexchangerate, CASE WHEN mmUnit.FBaseConvsRate > 0 THEN decimal(entry.FPrice/mmUnit.FBaseConvsRate,21,8) ELSE entry.FPrice  END as FPrice, entry.frequirementdate,").append(this.sp).append(" entry.fproposedeliverydate,entry.ftracknumber,").append(this.sp).append(" entry.FTrackNoID trackNo,t12.Fnumber trackNumber, ").append(" entry.FProjectID fprojectID,t13.Fnumber projectNumber, ").append("req.FIsInTax isInTax, req.FIsPriceInTax isPriceInTax, entry.FTaxRate taxRate, entry.FDiscountRate discountRate,").append(" t9.fid rowTypeId,t9.fnumber rowTypeNumber,t9.fname_").append(this.LNAME).append(" rowtypeName,t10.fid receivingOrgId,t10.fnumber receivingOrgNum,t10.fname_").append(this.LNAME).append(" receivingOrgName,").append(" t11.fid adminOrgId,t11.fnumber adminOrgNum,t11.fname_").append(this.LNAME).append(" adminOrgName,").append("purUnit.FMeasureUnitID as fpurUnitid,purUnit.FQtyPrecision as fpurQtyPrecision,purUnit.FBaseConvsRate as FpurConvsRate,");
        if (storageOrg != null) {
            query.selectPart.append(" Case When entry.fmaterialid is not null and bdMI.fmaterialid Is Null  Then '1' ").append(" Else '0' End AS FAvailable,");
        } else {
            query.selectPart.append(" '0' FAvailable,");
        }
        query.selectPart.append(" case when entry.fmaterialid IS NULL THEN baseunit.FQtyPrecision ELSE mmUnit2.FQtyPrecision END as QtyPrec,").append(this.sp);
        query.selectPart.append(" case when entry.fmaterialid IS NULL THEN t9.FPrecision ELSE material.FPricePrecision END as PricePrec,").append(this.sp);
        query.selectPart.append(" entry.fassistunitid  ").append(this.sp);
        query.selectPart.append(" INTO ").append(this.tempTable).append(this.sp);
        query.fromPart.append(" FROM t_sm_purrequest req ").append(this.sp).append(" INNER JOIN t_sm_purrequestentry entry ON req.fid = entry.fparentid").append(this.sp).append(" INNER JOIN t_org_company orgcom ON req.FCompanyOrgUnitID = orgcom.fid").append(this.sp).append(" INNER JOIN T_SCM_RowType t9 ON entry.FRowTypeID = t9.fid ").append(this.sp).append(" LEFT OUTER JOIN T_BD_MaterialGroup mg ON entry.FMaterialGroupID = mg.fid").append(this.sp).append(" LEFT OUTER JOIN t_bd_material material ON entry.fmaterialid = material.fid").append(this.sp).append(" INNER JOIN t_bd_measureunit baseunit ON entry.fbaseunitid = baseunit.fid").append(this.sp).append(" LEFT OUTER JOIN t_bd_multimeasureunit mmUnit ON entry.funitid = mmUnit.FMeasureUnitID ").append(" AND entry.fmaterialid = mmUnit.FMaterialID").append(this.sp).append(" LEFT OUTER JOIN t_bd_multimeasureunit mmUnit2 ON entry.fbaseunitid = mmUnit2.FMeasureUnitID ").append(" AND entry.fmaterialid = mmUnit2.FMaterialID").append(this.sp).append(" left join T_BD_MaterialPurchasing as mp on mp.fmaterialid = entry.fmaterialid").append(" and mp.forgunit = entry.FPurchaseOrgUnitID ").append("LEFT OUTER JOIN t_bd_multimeasureunit purUnit ON mp.funitid = purUnit.FMeasureUnitID ").append("AND entry.fmaterialid = purUnit.FMaterialID ").append(" LEFT OUTER JOIN t_bd_supplier supplier ON entry.fsupplierid = supplier.fid").append(this.sp).append(" LEFT OUTER JOIN T_BD_AsstAttrValue assit ON entry.FAssistPropertyID = assit.fid ").append(this.sp).append(" LEFT OUTER JOIN T_BD_Currency bdCurrency ON orgcom.FbaseCurrencyID = bdCurrency.fid ").append(this.sp).append(" LEFT OUTER JOIN t_org_storage t10 ON entry.FReceivedOrgUnitID = t10.fid ").append(this.sp).append(" LEFT OUTER JOIN t_org_admin t11 ON entry.FAdminOrgUnitID = t11.fid ").append(this.sp).append(" LEFT OUTER JOIN t_mm_tracknumber t12 ON entry.FTrackNoID=t12.FID ").append(this.sp).append(" LEFT OUTER JOIN t_mm_Project t13 ON entry.FProjectID=t13.FID");
        if (storageOrg != null) {
            query.fromPart.append(" LEFT OUTER JOIN T_BD_MaterialInventory bdMI on entry.fmaterialid = bdMI.fmaterialid ").append(" AND bdMI.forgunit = '").append(storageOrg.getId().toString()).append("' ");
        }
        query.wherePart.append(" WHERE req.FIsMergeBill = 0   ").append(this.sp);
        if (fromDate != null) {
            query.wherePart.append(" AND req.fbizdate >= to_date('").append(fromDate).append("')");
        }
        if (toDate != null) {
            query.wherePart.append(" AND req.fbizdate <= to_date('").append(toDate).append("')");
        }
        query.wherePart.append(" AND entry.FPurchaseOrgUnitID = '").append(fromPur.getId().toString()).append("'");
        String companyNums = this.getAllCompanys(ctx, params);
        query.wherePart.append(" AND orgcom.fnumber IN (").append(companyNums).append(")");
        query.wherePart.append(" AND (");
        String conS = " ";
        if (adminOrg != null) {
            query.wherePart.append(" t9.FRequestOrgType = '").append("20").append("' ");
            conS = " OR ";
        }
        if (storageOrg != null) {
            query.wherePart.append(conS).append(" t9.FRequestOrgType = '").append("10").append("' ");
        }
        query.wherePart.append(" )");
        if (storageOrg != null) {
            query.wherePart.append(" and entry.FStorageOrgUnitID = '").append(storageOrg.getId().toString()).append("' ");
        }
        if (demandType != null) {
            query.wherePart.append(" and req.FDemandTypeID = '").append(demandType.getId().toString()).append("' ");
        }
        if (params.getObject("materialFrom") != null || params.getString("materialTo") != null && params.getString("materialTo").length() != 0) {
            query.wherePart.append(" AND (entry.fmaterialid is not null ");
            if (params.getObject("materialFrom") != null) {
                String[] numArray = SCMUtil.getF7Numbers((Object)params.getObject("materialFrom"));
                if (numArray[1] != null) {
                    query.wherePart.append(" AND material.fnumber in (").append(numArray[1]).append(")").append(this.sp);
                } else if (numArray[0] != null) {
                    query.wherePart.append(" AND material.fnumber >= '").append(numArray[0]).append("'").append(this.sp);
                }
            }
            if (params.getString("materialTo") != null && params.getString("materialTo").length() != 0) {
                query.wherePart.append(" AND material.fnumber <= '").append(params.getString("materialTo")).append("'").append(this.sp);
            }
            query.wherePart.append(")");
        }
        if (params.getString("requestorFrom") != null && params.getString("requestorFrom").length() != 0 || params.getString("requestorTo") != null && params.getString("requestorTo").length() != 0) {
            query.fromPart.append(" LEFT OUTER JOIN t_bd_person p11 ON req.FPersonID = p11.fid").append(this.sp);
            if (params.getString("requestorFrom") != null && params.getString("requestorFrom").length() != 0) {
                query.wherePart.append(" AND p11.fnumber >='").append(params.getString("requestorFrom")).append("'").append(this.sp);
            }
            if (params.getString("requestorTo") != null && params.getString("requestorTo").length() != 0) {
                query.wherePart.append(" AND p11.fnumber <='").append(params.getString("requestorTo")).append("'").append(this.sp);
            }
        }
        if (params.getString("traceNoFrom") != null && params.getString("traceNoFrom").length() != 0) {
            query.wherePart.append(" AND entry.ftracknumber >='").append(params.getString("traceNoFrom")).append("'").append(this.sp);
        }
        if (params.getString("traceNoTo") != null && params.getString("traceNoTo").length() != 0) {
            query.wherePart.append(" AND entry.ftracknumber <='").append(params.getString("traceNoTo")).append("'").append(this.sp);
        }
        if (params.getString("trackNo") != null && params.getString("trackNo").length() != 0) {
            query.wherePart.append(" AND entry.FTrackNoID = ").append("(select FID FROM T_MM_TrackNumber WHERE FNUMBER='").append(params.getString("trackNo")).append("')").append(this.sp);
        }
        if (params.getString("fprojectID") != null && params.getString("fprojectID").length() != 0) {
            query.wherePart.append(" AND entry.FProjectID = ").append("(select FID FROM T_MM_Project WHERE FNUMBER='").append(params.getString("fprojectID")).append("')").append(this.sp);
        }
        query.wherePart.append(" AND req.fid not IN (select FSrcObjectID from T_BOT_Relation) ").append(this.sp);
        String statusRange = this.getStatusRange(ctx, params);
        query.wherePart.append(" AND entry.fbasestatus IN (").append(statusRange).append(")").append(this.sp);
        query.wherePart.append(" AND t9.FISHASMATERIALNUMBER=1");
        query.wherePart.append(" AND req.FPurchaseType= ").append(0);
        query.wherePart.append(" AND t9.FDESTINATIONTYPE= '").append("10").append("'");
        logger.debug((Object)query.getSql());
        return query;
    }

    @Override
    protected void _genRequestBill(Context ctx, PurRequestInfo requestBillInfo, String[] sourceBillIdArray, String[] sourceEntryIdArray) throws BOSException, EASBizException {
        IPurRequest purRequestCtrl = PurRequestFactory.getLocalInstance(ctx);
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        String fid = null;
        String parentid = null;
        Object destEntryId = null;
        StringBuffer gatherBillSql = new StringBuffer();
        HashMap<String, String> srcDestMap = new HashMap<String, String>();
        HashMap<String, ArrayList<String>> parentEntryMap = new HashMap<String, ArrayList<String>>();
        ArrayList<String> idList = null;
        boolean hasbotp = BOTMappingFactory.getLocalInstance((Context)ctx).exists(" where id ='XpnhyG7gQbeQV6u0QD2BAwRRIsQ='");
        if (!hasbotp) {
            throw new PurReqException(PurReqException.NO_BOTP, new String[]{"PUR030"});
        }
        StringBuffer params = new StringBuffer();
        int c = requestBillInfo.getEntries().size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(requestBillInfo.getEntries().get(i).toString());
            params.append("'");
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo.getPerson() != null) {
            requestBillInfo.setAdminOrg(PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(userInfo.getPerson().getId()));
        }
        StringBuffer materialBuf = new StringBuffer();
        boolean firstMat = true;
        HashSet<String> setMaterial = new HashSet<String>();
        HashSet<String> setPurOrg = new HashSet<String>();
        IRowType rowTypeCtrl = RowTypeFactory.getLocalInstance((Context)ctx);
        requestBillInfo.setIsMergeBill(true);
        int size = requestBillInfo.getEntries().size();
        for (int rowInx = 0; rowInx < size; ++rowInx) {
            PurRequestEntryInfo entry = requestBillInfo.getEntries().get(rowInx);
            ObjectUuidPK rowTypePK = new ObjectUuidPK(entry.getRowType().getId());
            RowTypeInfo rowType = rowTypeCtrl.getRowTypeInfo((IObjectPK)rowTypePK);
            entry.setRowType(rowType);
            MaterialInfo material = entry.getMaterial();
            PurchaseOrgUnitInfo purOrgInfo = entry.getPurchaseOrgUnit();
            if (material != null && purOrgInfo != null) {
                setMaterial.add(material.getId().toString());
                setPurOrg.add(purOrgInfo.getId().toString());
            }
            entry.setDestinationType(rowType.getDestinationType());
            if (entry.getMaterial() == null) continue;
            if (firstMat) {
                firstMat = false;
            } else {
                materialBuf.append(",");
            }
            materialBuf.append("'").append(entry.getMaterial().getId().toString()).append("'");
        }
        MaterialInfo material = null;
        PurchaseOrgUnitInfo purOrgInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("isNotControlQty"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", setMaterial, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", setPurOrg, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        MaterialPurchasingCollection col = MaterialPurchasingFactory.getLocalInstance((Context)ctx).getMaterialPurchasingCollection(view);
        if (col != null && col.size() > 0) {
            int size2 = requestBillInfo.getEntries().size();
            block8: for (int rowInx = 0; rowInx < size2; ++rowInx) {
                PurRequestEntryInfo entry = requestBillInfo.getEntries().get(rowInx);
                material = entry.getMaterial();
                purOrgInfo = entry.getPurchaseOrgUnit();
                if (material == null || purOrgInfo == null) continue;
                int length = col.size();
                for (int j = 0; j < length; ++j) {
                    if (!col.get(j).getMaterial().getId().toString().equals(material.getId().toString()) || !col.get(j).getOrgUnit().getId().toString().equals(purOrgInfo.getId().toString())) continue;
                    entry.setIsQuantityUnCtrl(col.get(j).isIsNotControlQty());
                    continue block8;
                }
            }
        }
        if (materialBuf.length() > 0) {
            StringBuffer getConvertSQLBuf = new StringBuffer();
            getConvertSQLBuf.append("SELECT t0.fid,t0.FAssistUnit,t1.FBaseConvsRate,t1.FQtyPrecision ").append(this.sp).append(" FROM t_bd_material t0 ").append(this.sp).append(" INNER JOIN t_bd_multimeasureunit t1 ON t0.FAssistUnit = t1.FMeasureUnitID ").append(this.sp).append(" AND t0.fid = t1.FMaterialID").append(this.sp).append(" WHERE t0.FAssistUnit is not null ").append(this.sp).append(" AND t0.fid in (").append(materialBuf.toString()).append(")").append(this.sp);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getConvertSQLBuf.toString());
            try {
                while (rs.next()) {
                    int size3 = requestBillInfo.getEntries().size();
                    for (int rowInx = 0; rowInx < size3; ++rowInx) {
                        PurRequestEntryInfo entry = requestBillInfo.getEntries().get(rowInx);
                        if (entry.getMaterial() == null || !entry.getMaterial().getId().toString().equals(rs.getString("fid"))) continue;
                        BigDecimal asstQty = entry.getBaseQty().divide(rs.getBigDecimal("FBaseConvsRate"), rs.getInt("FQtyPrecision"), 4);
                        MeasureUnitInfo asstUnit = new MeasureUnitInfo();
                        asstUnit.setId(BOSUuid.read((String)rs.getString("FAssistUnit")));
                        entry.setAssistUnit(asstUnit);
                        entry.setAssistQty(asstQty);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        PurRequestCal purRequestCal = new PurRequestCal();
        PurRequestCal.reCalcAmount(ctx, requestBillInfo);
        this.fetchPrice(ctx, requestBillInfo);
        purRequestCtrl.saveRelations((CoreBillBaseInfo)requestBillInfo, null);
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            gatherBillSql.append("");
            gatherBillSql = gatherBillSql.append("select FRowTypeID,FPurchaseOrgUnitID,FReceivedOrgUnitID,");
            gatherBillSql = gatherBillSql.append("FMaterialID,FAssistPropertyID,FPurpose,FBaseUnitID,sum(FBaseQty) as FBaseQty,sum(ISNULL(FAssistQty,0)) as FAssistQty ");
            gatherBillSql = gatherBillSql.append(",SUM(ISNULL(FRequestQty,0)) AS FRequestQty ");
            gatherBillSql = gatherBillSql.append("from T_SM_PurRequestEntry ");
            gatherBillSql = gatherBillSql.append("where Fid in(" + params.toString() + ") ");
            gatherBillSql = gatherBillSql.append("group by FRowTypeID,FPurchaseOrgUnitID,FReceivedOrgUnitID,FMaterialID,FAssistPropertyID,FPurpose,FBaseUnitID ");
            ResultSet gatherSet = statement.executeQuery(gatherBillSql.toString());
            int seq = 0;
            PurRequestEntryInfo entry = null;
            int descEntrySize = requestBillInfo.getEntries().size();
            while (gatherSet.next()) {
                if (++seq < descEntrySize) {
                    entry = requestBillInfo.getEntries().get(seq);
                }
                gatherBillSql.setLength(0);
                gatherBillSql = gatherBillSql.append("select ");
                gatherBillSql = gatherBillSql.append("FID,FParentId,FRequirementDate,FProposeDeliveryDate,FProposePurchaseDate,FRemark ");
                gatherBillSql = gatherBillSql.append("from T_SM_PurRequestEntry ");
                gatherBillSql = gatherBillSql.append("where Fid in(" + params.toString() + ") ");
                gatherBillSql = gatherBillSql.append("and FRowTypeID='" + gatherSet.getString("FRowTypeID") + "'  ");
                gatherBillSql = gatherBillSql.append("and FPurchaseOrgUnitID='" + gatherSet.getString("FPurchaseOrgUnitID") + "' ");
                gatherBillSql = gatherBillSql.append("and FReceivedOrgUnitID='" + gatherSet.getString("FReceivedOrgUnitID") + "' ");
                gatherBillSql = gatherBillSql.append("and FMaterialID='" + gatherSet.getString("FMaterialID") + "' ");
                gatherBillSql = gatherSet.getString("FAssistPropertyID") != null ? gatherBillSql.append("and FAssistPropertyID='" + gatherSet.getString("FAssistPropertyID") + "' ") : gatherBillSql.append("and FAssistPropertyID is null ");
                gatherBillSql = gatherSet.getString("FPurpose") != null ? gatherBillSql.append("and FPurpose='" + gatherSet.getString("FPurpose") + "'") : gatherBillSql.append("and FPurpose is null");
                statement = con.createStatement(1004, 1007);
                gatherSet = statement.executeQuery(gatherBillSql.toString());
                while (gatherSet.next()) {
                    fid = gatherSet.getString("FID");
                    parentid = gatherSet.getString("FParentId");
                    if (entry != null) {
                        srcDestMap.put(fid, entry.getId().toString());
                    }
                    if ((idList = (ArrayList<String>)parentEntryMap.get(parentid)) == null) {
                        idList = new ArrayList<String>();
                    }
                    idList.add(fid);
                    parentEntryMap.put(parentid, idList);
                }
            }
            BOTRelationInfo info = new BOTRelationInfo();
            for (int i = 0; i < sourceBillIdArray.length; ++i) {
                info = new BOTRelationInfo();
                info.setSrcObjectID(sourceBillIdArray[i].toString());
                info.setSrcEntityID("25428F2E");
                info.setDestEntityID("25428F2E");
                info.setDestObjectID(requestBillInfo.getId().toString());
                info.setOperatorID(ctx.getUserName());
                info.setType(0);
                info.setBOTMappingID("XpnhyG7gQbeQV6u0QD2BAwRRIsQ=");
                BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup(batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        String entryIds = this.array2String(sourceEntryIdArray);
        StringBuffer closeEntry = new StringBuffer();
        closeEntry.append(" UPDATE t_sm_purrequestentry ").append(" SET fbasestatus = ").append(7).append(",FMergeBillNumber = '").append(requestBillInfo.getNumber()).append("' ").append(this.sp).append(" WHERE fid IN (").append(entryIds).append(")");
        this.executeUpdate(closeEntry.toString(), null, ctx);
        StringBuffer updateSqlBuf = new StringBuffer();
        updateSqlBuf.append(" UPDATE t_sm_purrequestentry  AS t1 ").append(" SET (FMergeBillSeq) = (SELECT t2.FSeq ").append(" FROM t_sm_purrequestentry AS t3,t_sm_purrequestentry AS t2 ").append(" WHERE t1.fid = t3.fid and t1.fmaterialid = t2.fmaterialid ").append(" AND t1.fid IN (").append(entryIds).append(") ").append(" AND t2.fparentid = '").append(requestBillInfo.getId().toString()).append("') ");
        this.executeUpdate(updateSqlBuf.toString(), null, ctx);
        updateSqlBuf.setLength(0);
        updateSqlBuf.append(" UPDATE t_sm_purrequestentry  AS t1 ").append(" SET (FMergeBillSeq) = (SELECT t2.FSeq ").append(" FROM t_sm_purrequestentry AS t3,t_sm_purrequestentry AS t2 ").append(" WHERE t1.fid = t3.fid and t1.FMaterialName = t2.FMaterialName ").append(" AND t1.fbaseunitid = t2.Fbaseunitid ").append(" AND t1.FRowTypeID = t2.FRowTypeID ").append(" AND t1.fmaterialid is null ").append(" AND t2.fmaterialid is null ").append(" AND t1.fid IN (").append(entryIds).append(") ").append(" AND t2.fparentid = '").append(requestBillInfo.getId().toString()).append("') ");
        this.executeUpdate(updateSqlBuf.toString(), null, ctx);
        String billIds = this.array2String(sourceBillIdArray);
        StringBuffer closeBill = new StringBuffer();
        closeBill.append(" UPDATE t_sm_purrequest SET fbasestatus = ").append(7).append(this.sp).append(" WHERE fid in (").append(this.sp).append(" SELECT fid FROM (").append(this.sp).append(" SELECT fid,SUM(entryCount) entryCount,SUM(closeCount) closeCount FROM (").append(this.sp).append(" SELECT req.fid,count(req.fid) entryCount,0 closeCount ").append(this.sp).append(" FROM t_sm_purrequest req inner join t_sm_purrequestentry entry on req.fid = entry.fparentid ").append(this.sp).append(" WHERE req.fid in (").append(billIds).append(")").append(this.sp).append(" GROUP BY req.fid ").append(this.sp).append(" UNION ALL ").append(this.sp).append(" SELECT req.fid,0 entryCount,count(req.fid) closeCount ").append(this.sp).append(" FROM t_sm_purrequest req inner join t_sm_purrequestentry entry on req.fid = entry.fparentid ").append(this.sp).append(" WHERE req.fid in (").append(billIds).append(")").append(this.sp).append(" AND entry.fbasestatus = ").append(7).append(this.sp).append(" GROUP BY req.fid) AS TMP__").append(this.sp).append(" GROUP BY fid) AS TMP___").append(this.sp).append(" WHERE TMP___.entryCount = TMP___.closeCount)");
        this.executeUpdate(closeBill.toString(), null, ctx);
    }

    @Override
    protected RptRowSet _getOnlyAvailableSupplier(Context ctx, RptRowSet param) throws BOSException, EASBizException {
        this.LNAME = this.getLoc(ctx);
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" SELECT distinct t1.FID,t1.FName_").append(this.LNAME).append(" FName,t1.FNumber ").append(this.sp).append(" FROM  T_BD_Supplier t1  ").append(this.sp).append(" INNER JOIN  T_BD_MaterialPurchasing t2  ON t2.FSupplier = t1.FID ").append(this.sp).append(" WHERE  t1.FUsedStatus = 1 ").append(this.sp).append(" AND t2.FOrgUnit = ? ").append(this.sp).append(" AND t2.FMaterialid = ? ").append(this.sp).append(" ORDER BY t1.FNumber ASC ");
        RptRowSet retRowSet = new RptRowSet(new String[]{"rowIndex", "supplier"}, new ArrayList());
        SqlParams sqlParams = new SqlParams();
        while (param.next()) {
            SupplierInfo supplier = null;
            sqlParams.clear();
            sqlParams.addString(param.getString("purOrgId"));
            sqlParams.addString(param.getString("materialId"));
            RptRowSet r1 = this.executeQuery(selectSql.toString(), sqlParams, ctx);
            if (r1.next() && r1.getRowCount() == 1) {
                supplier = new SupplierInfo();
                supplier.setId(BOSUuid.read((String)r1.getString("FID")));
                supplier.setNumber(r1.getString("FNumber"));
                supplier.setName(r1.getString("FName"));
            }
            retRowSet.addRow(new Object[]{param.getObject("rowIndex"), supplier});
        }
        return retRowSet;
    }

    private void fetchPrice(Context ctx, PurRequestInfo requestBillInfo) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = this.getPriceParamCol(ctx, requestBillInfo);
        paramCol.setBillTypeId("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        PurPriceInfoCollection cols = PurServiceFacadeFactory.getLocalInstance(ctx).fetchPrice(paramCol);
        PurRequestEntryInfo entryInfo = null;
        PurPriceInfo priceInfo = null;
        int size = requestBillInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = requestBillInfo.getEntries().get(i);
            if (entryInfo.getMaterial() == null || entryInfo.getPrice() != null && BigDecimal.ZERO.compareTo(entryInfo.getPrice()) != 0) continue;
            priceInfo = cols.getPurPriceInfoBySeq(i);
            if (entryInfo.getSupplier() == null) {
                entryInfo.setSupplier(priceInfo.getSupplier());
            }
            if (priceInfo == null || priceInfo.getPrice() == null) continue;
            PurRequestCal purRequestCal = new PurRequestCal();
            purRequestCal.setInTax(priceInfo.isInTaxPrice());
            if (entryInfo.getTaxRate() == null || BigDecimal.ZERO.compareTo(entryInfo.getTaxRate()) == 0) {
                entryInfo.setTaxRate(priceInfo.getTaxRate());
            }
            if (priceInfo.getDiscountRate() != null) {
                entryInfo.setDiscountRate(priceInfo.getDiscountRate());
            }
            if (priceInfo.isInTaxPrice()) {
                entryInfo.setTaxPrice(priceInfo.getPrice());
                purRequestCal.calByEntryTaxPriceChange(requestBillInfo, entryInfo);
                continue;
            }
            entryInfo.setPrice(priceInfo.getPrice());
            purRequestCal.calByEntryPriceChange(requestBillInfo, entryInfo);
        }
        PurRequestCal.calcAmount(ctx, requestBillInfo);
    }

    private PurPriceParamCollection getPriceParamCol(Context ctx, PurRequestInfo requestBillInfo) {
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        paramCol.setPurchaseType(MaterialPurchaseTypeEnum.PURCHASE);
        paramCol.setBizTypeId(requestBillInfo.getBizType().getId().toString());
        PurPriceParam param = null;
        PurRequestEntryInfo entryInfo = null;
        int size = requestBillInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = requestBillInfo.getEntries().get(i);
            param = PurRequestCal.getPriceParam(entryInfo.getSeq(), requestBillInfo, entryInfo);
            paramCol.addPurPriceParam(param);
        }
        paramCol.addPurPriceParam(param);
        return paramCol;
    }

    class QuerySql {
        StringBuffer selectPart = new StringBuffer();
        StringBuffer fromPart = new StringBuffer();
        StringBuffer wherePart = new StringBuffer();
        StringBuffer orderByPart = new StringBuffer();
        StringBuffer groupPart = new StringBuffer();
        Set tables = new HashSet();
        String aliasName = "";

        QuerySql() {
        }

        String getSql() {
            return this.selectPart.toString() + PurRequestTotalFacadeControllerBean.this.sp + this.fromPart.toString() + PurRequestTotalFacadeControllerBean.this.sp + this.wherePart.toString() + PurRequestTotalFacadeControllerBean.this.sp + this.groupPart.toString() + PurRequestTotalFacadeControllerBean.this.sp + this.orderByPart.toString();
        }
    }
}

