/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.QueryConnectionProvider;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.sc.MaterialPurchaseTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.service.SCMPermissionService;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.calculate.PurRequestCal;
import com.kingdee.eas.scm.sm.report.app.AbstractPurRequestTotalWebFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurRequestTotalWebFacadeControllerBean
extends AbstractPurRequestTotalWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.PurRequestTotalWebFacadeControllerBean");
    private static final long serialVersionUID = 1L;
    private String LNAME = "L2";
    private String sp = "\r\n";
    private String tempTable = null;

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.LNAME = this.getLoc(ctx);
        this.tempTable = this.getTempTableName("PurRequestTotal", ctx);
        this.CreateTempTab(ctx);
        RptRowSet rowSet = null;
        String mainQuery = this.buildMainSql(ctx, params);
        if (params.getInt("targetBill") == 1) {
            rowSet = this.checkAvailable(ctx, mainQuery, params);
        }
        TempTablePool tempTablePool = TempTablePool.getInstance((Context)ctx);
        try {
            tempTablePool.releaseTable(this.tempTable);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        RptParams retParams = new RptParams();
        retParams.setObject("rowSet", (Object)rowSet);
        return retParams;
    }

    private RptRowSet checkAvailable(Context ctx, String mainQuery, RptParams params) throws EASBizException, BOSException {
        RptRowSet totalSetting;
        DbUtil.execute((Context)ctx, (String)mainQuery);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT reqfid, fbizdate, reqNumber, entryseq, billstate, fcompanyorgunitid, fromCompanyName,toCompanyName, entryfid,\n");
        sbSQL.append(" entrystate, matrerilGroupName, fmaterialid, materialNumber, materialName, fmodel, fassistPropertyid,\n");
        sbSQL.append(" assitName, fbaseunitid, baseUnitName, qty,amount, confirmqty, requestqty, fsupplierid, supplierName,\n");
        sbSQL.append(" fcurrencyid, bdCurrencyName, curPrecision, fexchangerate, FPrice, ftaxprice,ftaxrate,fdiscountrate,frequirementdate,\n");
        sbSQL.append(" fproposedeliverydate, ftracknumber, trackNo, trackNumber, fprojectID, projectNumber, rowTypeId,\n");
        sbSQL.append(" rowTypeNumber, rowtypeName, receivingOrgId, receivingOrgNum, receivingOrgName, adminOrgId, adminOrgNum, ");
        sbSQL.append(" adminOrgName, FAvailable, QtyPrec, PricePrec, fassistunitid ,");
        sbSQL.append(" fpurUnitid,fpurQtyPrecision,FpurConvsRate ,");
        sbSQL.append(" purpose,storageOrgUnitID,storageOrgName ,");
        sbSQL.append(" demandTypeID,demandTypeName \n");
        sbSQL.append("FROM ").append(this.tempTable).append(" ");
        sbSQL.append(" WHERE NOT EXISTS ( SELECT preq.FID FROM T_SM_PurRequest preq LEFT JOIN T_SM_PurRequestEntry pre");
        sbSQL.append(" ON preq.FID=pre.FParentID WHERE preq.FID=reqfid and pre.FMaterialID IS NULL )");
        sbSQL.append(" ORDER BY FAvailable,materialNumber,materialName,fbaseunitid,rowTypeId,receivingorgid,demandTypeID");
        if (params.getObject("totalSetting") != null && (totalSetting = (RptRowSet)params.getObject("totalSetting")).next()) {
            if (totalSetting.getInt("FISREQUESTORG") == 1) {
                sbSQL.append(",storageOrgUnitID");
            }
            if (totalSetting.getInt("FISSUPPLIER") == 1) {
                sbSQL.append(",fsupplierid");
            }
            if (totalSetting.getInt("FISTRACKNO") == 1) {
                sbSQL.append(",trackNo");
            }
            if (totalSetting.getInt("FISPROJECT") == 1) {
                sbSQL.append(",fprojectID");
            }
            if (totalSetting.getInt("FISASSISTANT") == 1) {
                sbSQL.append(",fassistPropertyid");
            }
            if (totalSetting.getInt("FISPROPOSEDELIVERYDATA") == 1) {
                sbSQL.append(",fproposedeliverydate");
            }
        }
        sbSQL.append(",reqNumber");
        RptRowSet rowSet = this.executeQuery(sbSQL.toString(), null, ctx);
        return rowSet;
    }

    private void CreateTempTab(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String n = ",\r\n";
        sql.append("Create Table " + this.tempTable + "(\r\n");
        sql.append("REQFID Varchar(44)" + n);
        sql.append("FBIZDATE DATETIME" + n);
        sql.append("REQNUMBER NVARCHAR(80)" + n);
        sql.append("BILLSTATE INT " + n);
        sql.append("FCOMPANYORGUNITID Varchar(44)" + n);
        sql.append("TOCOMPANYNAME NVARCHAR(255)" + n);
        sql.append("FROMCOMPANYNAME NVARCHAR(255)" + n);
        sql.append("ENTRYFID Varchar(44)" + n);
        sql.append("ENTRYSTATE INT" + n);
        sql.append("MATRERILGROUPNAME NVARCHAR(255)" + n);
        sql.append("FMATERIALID Varchar(44)" + n);
        sql.append("MATERIALNUMBER NVARCHAR(80)" + n);
        sql.append("ENTRYSEQ INT DEFAULT 0" + n);
        sql.append("AMOUNT  NUMERIC(19,4) default 0" + n);
        sql.append("MATERIALNAME NVARCHAR(255)" + n);
        sql.append("FMODEL NVARCHAR(255)" + n);
        sql.append("FASSISTPROPERTYID Varchar(44)" + n);
        sql.append("ASSITNAME NVARCHAR(255)" + n);
        sql.append("FBASEUNITID Varchar(44)" + n);
        sql.append("BASEUNITNAME NVARCHAR(255)" + n);
        sql.append("QTY NUMERIC(28,16) default 0" + n);
        sql.append("CONFIRMQTY NUMERIC(28,16) default 0" + n);
        sql.append("REQUESTQTY NUMERIC(28,16) default 0" + n);
        sql.append("FSUPPLIERID Varchar(44)" + n);
        sql.append("SUPPLIERNAME NVARCHAR(255)" + n);
        sql.append("FCURCURRENCYID Varchar(44)" + n);
        sql.append("FCURRENCYID Varchar(44)" + n);
        sql.append("BDCURRENCYNAME NVARCHAR(255)" + n);
        sql.append("CURPRECISION INT" + n);
        sql.append("FEXCHANGERATE NUMERIC(28,16) default 0" + n);
        sql.append("FPRICE NUMERIC(28,16) default 0" + n);
        sql.append("FTAXPRICE NUMERIC(28,16) default 0" + n);
        sql.append("FTAXRATE NUMERIC(28,16) default 0" + n);
        sql.append("FDISCOUNTRATE NUMERIC(28,16) default 0" + n);
        sql.append("FREQUIREMENTDATE DATETIME" + n);
        sql.append("FPROPOSEDELIVERYDATE DATETIME" + n);
        sql.append("FTRACKNUMBER NVARCHAR(80)" + n);
        sql.append("TRACKNO NVARCHAR(80)" + n);
        sql.append("TRACKNUMBER NVARCHAR(80)" + n);
        sql.append("FPROJECTID Varchar(44)" + n);
        sql.append("PROJECTNUMBER NVARCHAR(80)" + n);
        sql.append("PURPOSE NVARCHAR(80)" + n);
        sql.append("STORAGEORGUNITID Varchar(44)" + n);
        sql.append("STORAGEORGNAME NVARCHAR(80)" + n);
        sql.append("DEMANDTYPEID Varchar(44)" + n);
        sql.append("DEMANDTYPENAME NVARCHAR(80)" + n);
        sql.append("ROWTYPEID Varchar(44)" + n);
        sql.append("ROWTYPENUMBER NVARCHAR(80)" + n);
        sql.append("ROWTYPENAME NVARCHAR(80)" + n);
        sql.append("RECEIVINGORGID Varchar(44)" + n);
        sql.append("RECEIVINGORGNUM NVARCHAR(80)" + n);
        sql.append("RECEIVINGORGNAME NVARCHAR(80)" + n);
        sql.append("ADMINORGID Varchar(44)" + n);
        sql.append("ADMINORGNUM NVARCHAR(80)" + n);
        sql.append("ADMINORGNAME NVARCHAR(80)" + n);
        sql.append("FPURUNITID Varchar(44)" + n);
        sql.append("FPURQTYPRECISION INT" + n);
        sql.append("FPURCONVSRATE NUMERIC(28,16) default 0" + n);
        sql.append("FAVAILABLE Varchar(44)" + n);
        sql.append("QTYPREC INT" + n);
        sql.append("PRICEPREC INT" + n);
        sql.append("FASSISTUNITID Varchar(44)");
        sql.append(");\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getAllCompanys(Context ctx, RptParams params) {
        String nums = params.getString("fromCompanys");
        if (nums == null || nums.trim().length() == 0) {
            StringBuffer orgsBuf = new StringBuffer();
            orgsBuf.append("'xxx_xxxx'");
            try {
                SCMPermissionService permSrv = new SCMPermissionService(ctx);
                OrgUnitInfo[] orgs = permSrv.getAuthorizedBizOrgUnits(ctx.getCaller(), OrgType.Company, "purreqtotal_view");
                for (int i = 0; i < orgs.length; ++i) {
                    orgsBuf.append(",'").append(orgs[i].getNumber()).append("'");
                }
            }
            catch (Exception exp) {
                logger.error((Object)exp);
            }
            return orgsBuf.toString();
        }
        String[] numArray = nums.split(";");
        return this.array2String(numArray);
    }

    private String array2String(String[] strArray) {
        StringBuffer numString = new StringBuffer();
        numString.append("'xxx_xxxx'");
        for (int i = 0; i < strArray.length; ++i) {
            numString.append(",'").append(strArray[i].trim()).append("'");
        }
        return numString.toString();
    }

    private String getStatusRange(Context ctx, RptParams params) {
        StringBuffer status = new StringBuffer();
        status.append(4);
        if (params.getBoolean("conatainRevoke")) {
            status.append(",").append(3);
        }
        if (params.getBoolean("conatainClose")) {
            status.append(",").append(7);
        }
        return status.toString();
    }

    private String buildMainSql(Context ctx, RptParams params) {
        StringBuffer query = new StringBuffer();
        AdminOrgUnitInfo adminOrg = null;
        if (params.getObject("adminOrgTo") != null) {
            adminOrg = (AdminOrgUnitInfo)params.getObject("adminOrgTo");
        }
        StorageOrgUnitInfo storageOrg = null;
        if (params.getObject("requestOrgTo") != null) {
            storageOrg = (StorageOrgUnitInfo)params.getObject("requestOrgTo");
        }
        String fromDate = params.getString("dateFrom");
        String toDate = params.getString("dateTo");
        OrgUnitInfo fromPur = (OrgUnitInfo)params.getObject("purchaseOrgFrom");
        query.append("INSERT INTO " + this.tempTable + "(REQFID,\nFBIZDATE,\nREQNUMBER,\nBILLSTATE,\nFCOMPANYORGUNITID,\nTOCOMPANYNAME,\nFROMCOMPANYNAME,\nENTRYFID,\nENTRYSTATE,\nMATRERILGROUPNAME,\nFMATERIALID,\nMATERIALNUMBER,\nENTRYSEQ,\nAMOUNT,\nMATERIALNAME,\nFMODEL,\nFASSISTPROPERTYID,\nASSITNAME,\nFBASEUNITID,\nBASEUNITNAME,\nQTY,\nCONFIRMQTY,\nREQUESTQTY,\nFSUPPLIERID,\nSUPPLIERNAME,\nFCURCURRENCYID,\nFCURRENCYID,\nBDCURRENCYNAME,\nCURPRECISION,\nFEXCHANGERATE,\nFPRICE,\nFTAXPRICE,\nFTAXRATE,\nFDISCOUNTRATE,\nFREQUIREMENTDATE,\nFPROPOSEDELIVERYDATE,\nFTRACKNUMBER,\nTRACKNO,\nTRACKNUMBER,\nFPROJECTID,\nPROJECTNUMBER,\nPURPOSE,\nSTORAGEORGUNITID,\nSTORAGEORGNAME,\nDEMANDTYPEID,\nDEMANDTYPENAME,\nROWTYPEID,\nROWTYPENUMBER,\nROWTYPENAME,\nRECEIVINGORGID,\nRECEIVINGORGNUM,\nRECEIVINGORGNAME,\nADMINORGID,\nADMINORGNUM,\nADMINORGNAME,\nFPURUNITID,\nFPURQTYPRECISION,\nFPURCONVSRATE,\nFAVAILABLE,\nQTYPREC,\nPRICEPREC,\nFASSISTUNITID)");
        query.append("SELECT req.fid reqfid,req.fbizdate,req.fnumber reqNumber,req.fbasestatus billstate,req.fcompanyorgunitid,").append(this.sp).append(" orgcom.fname_").append(this.LNAME).append(" toCompanyName,").append(this.sp).append(" orgcom.fname_").append(this.LNAME).append(" fromCompanyName,entry.fid entryfid,entry.fbasestatus entrystate,").append(this.sp).append(" mg.fname_").append(this.LNAME).append(" matrerilGroupName,").append(this.sp).append(" entry.fmaterialid,material.fnumber materialNumber,entry.fseq entryseq,entry.FAmount amount,").append(" CASE WHEN entry.fmaterialid IS NULL THEN entry.FMaterialName ELSE material.fname_").append(this.LNAME).append(" END as materialName,entry.fnonummaterialmodel as fmodel,entry.fassistPropertyid,").append(this.sp).append(" assit.fname_").append(this.LNAME).append(" assitName,entry.fbaseunitid,baseunit.fname_").append(this.LNAME).append(" baseUnitName,Case When entry.fbaseqty is null then 0 else entry.fbaseqty end as qty,entry.fbaseqty confirmqty,").append(" round(decimal(entry.frequestqty*mmUnit.FBaseConvsRate,21,8),mmUnit2.FQtyPrecision) requestqty,").append(this.sp).append(" entry.fsupplierid,").append(" supplier.fname_").append(this.LNAME).append(" supplierName,").append(" entry.fcurrencyid fcurcurrencyid,bdCurrency.fid fcurrencyid,bdCurrency.fname_").append(this.LNAME).append(" bdCurrencyName,bdCurrency.FPrecision curPrecision,").append(" entry.FExchangeRate fexchangerate,entry.fprice FPrice,entry.ftaxprice Ftaxprice,").append(this.sp).append(" entry.ftaxrate ftaxrate,entry.fdiscountrate fdiscountrate,").append(this.sp).append(" entry.frequirementdate, entry.fproposedeliverydate,entry.ftracknumber,").append(this.sp).append(" entry.FTrackNoID trackNo,mmTrackNum.Fnumber trackNumber, ").append(" entry.FProjectID fprojectID,mmProject.Fnumber projectNumber, ").append(" entry.FPurpose purpose, orgStorage.fid storageOrgUnitID, orgStorage.fname_").append(this.LNAME).append(" storageOrgName,").append(" smDemandType.fid demandTypeID, smDemandType.fname_").append(this.LNAME).append(" demandTypeName,").append(" scmRowType.fid rowTypeId,scmRowType.fnumber rowTypeNumber,scmRowType.fname_").append(this.LNAME).append(" rowtypeName,orgReceive.fid receivingOrgId,orgReceive.fnumber receivingOrgNum,orgReceive.fname_").append(this.LNAME).append(" receivingOrgName,").append(" orgAdmin.fid adminOrgId,orgAdmin.fnumber adminOrgNum,orgAdmin.fname_").append(this.LNAME).append(" adminOrgName,").append("purUnit.FMeasureUnitID as fpurUnitid,purUnit.FQtyPrecision as fpurQtyPrecision,purUnit.FBaseConvsRate as FpurConvsRate,");
        if (storageOrg != null) {
            query.append(" Case When entry.fmaterialid is not null and bdMI.fmaterialid Is Null  Then '1' ").append(" Else '0' End AS FAvailable,");
        } else {
            query.append(" '0' FAvailable,");
        }
        query.append(" case when entry.fmaterialid IS NULL THEN baseunit.FQtyPrecision ELSE mmUnit2.FQtyPrecision END as QtyPrec,").append(this.sp);
        query.append(" case when entry.fmaterialid IS NULL THEN scmRowType.FPrecision ELSE material.FPricePrecision END as PricePrec,").append(this.sp);
        query.append(" entry.fassistunitid  ").append(this.sp);
        query.append(" FROM t_sm_purrequest req ").append(this.sp).append(" INNER JOIN t_sm_purrequestentry entry ON req.fid = entry.fparentid").append(this.sp).append(" INNER JOIN t_org_company orgcom ON req.FCompanyOrgUnitID = orgcom.fid").append(this.sp).append(" INNER JOIN T_SCM_RowType scmRowType ON entry.FRowTypeID = scmRowType.fid ").append(this.sp).append(" LEFT OUTER JOIN T_BD_MaterialGroup mg ON entry.FMaterialGroupID = mg.fid").append(this.sp).append(" LEFT OUTER JOIN t_bd_material material ON entry.fmaterialid = material.fid").append(this.sp).append(" INNER JOIN t_bd_measureunit baseunit ON entry.fbaseunitid = baseunit.fid").append(this.sp).append(" LEFT OUTER JOIN t_bd_multimeasureunit mmUnit ON entry.funitid = mmUnit.FMeasureUnitID ").append(" AND entry.fmaterialid = mmUnit.FMaterialID").append(this.sp).append(" LEFT OUTER JOIN t_bd_multimeasureunit mmUnit2 ON entry.fbaseunitid = mmUnit2.FMeasureUnitID ").append(" AND entry.fmaterialid = mmUnit2.FMaterialID").append(this.sp).append(" left join T_BD_MaterialPurchasing as mp on mp.fmaterialid = entry.fmaterialid").append(" and mp.forgunit = entry.FPurchaseOrgUnitID ").append("LEFT OUTER JOIN t_bd_multimeasureunit purUnit ON mp.funitid = purUnit.FMeasureUnitID ").append("AND entry.fmaterialid = purUnit.FMaterialID ").append(" LEFT OUTER JOIN t_bd_supplier supplier ON entry.fsupplierid = supplier.fid").append(this.sp).append(" LEFT OUTER JOIN T_BD_AsstAttrValue assit ON entry.FAssistPropertyID = assit.fid ").append(this.sp).append(" LEFT OUTER JOIN T_BD_Currency bdCurrency ON orgcom.FbaseCurrencyID = bdCurrency.fid ").append(this.sp).append(" LEFT OUTER JOIN t_org_storage orgReceive ON entry.FReceivedOrgUnitID = orgReceive.fid ").append(this.sp).append(" LEFT OUTER JOIN t_org_admin orgAdmin ON entry.FAdminOrgUnitID = orgAdmin.fid ").append(this.sp).append(" LEFT OUTER JOIN t_mm_tracknumber mmTrackNum ON entry.FTrackNoID=mmTrackNum.FID ").append(this.sp).append(" LEFT OUTER JOIN t_mm_Project mmProject ON entry.FProjectID=mmProject.FID").append(" LEFT OUTER JOIN t_org_storage orgStorage ON entry.FStorageOrgUnitID = orgStorage.fid ").append(this.sp).append(" LEFT OUTER JOIN T_SM_DemandType smDemandType ON req.FDemandTypeID = smDemandType.fid ").append(this.sp);
        if (storageOrg != null) {
            query.append(" LEFT OUTER JOIN T_BD_MaterialInventory bdMI on entry.fmaterialid = bdMI.fmaterialid ").append(" AND bdMI.forgunit = '").append(storageOrg.getId().toString()).append("' ");
        }
        if (params.getString("requestorFrom") != null && params.getString("requestorFrom").length() != 0) {
            query.append(" LEFT OUTER JOIN t_bd_person p11 ON req.FPersonID = p11.fid").append(this.sp);
        }
        query.append(" WHERE req.FIsMergeBill = 0   ").append(this.sp);
        if (fromDate != null) {
            query.append(" AND req.fbizdate >= to_date('").append(fromDate).append("')");
        }
        if (toDate != null) {
            query.append(" AND req.fbizdate <= to_date('").append(toDate).append("')");
        }
        query.append(" AND entry.FPurchaseOrgUnitID = '").append(fromPur.getId().toString()).append("'");
        String companyNums = this.getAllCompanys(ctx, params);
        query.append(" AND orgcom.fnumber IN (").append(companyNums).append(")");
        query.append(" AND (");
        String conS = " ";
        if (adminOrg != null) {
            query.append(" scmRowType.FRequestOrgType = '").append("20").append("' ");
            conS = " OR ";
        }
        if (storageOrg != null) {
            query.append(conS).append(" scmRowType.FRequestOrgType = '").append("10").append("' ");
        }
        query.append(" )");
        if (storageOrg != null) {
            query.append(" and entry.FStorageOrgUnitID = '").append(storageOrg.getId().toString()).append("' ");
        }
        if (params.getString("materialFrom") != null && params.getString("materialFrom").length() != 0 || params.getString("materialTo") != null && params.getString("materialTo").length() != 0) {
            query.append(" AND (entry.fmaterialid is not null ");
            if (params.getString("materialFrom") != null && params.getString("materialFrom").length() != 0) {
                query.append(" AND material.fnumber >='").append(params.getString("materialFrom")).append("'").append(this.sp);
            }
            if (params.getString("materialTo") != null && params.getString("materialTo").length() != 0) {
                query.append(" AND material.fnumber <='").append(params.getString("materialTo")).append("'").append(this.sp);
            }
            query.append(")");
        }
        if (params.getString("requestorFrom") != null && params.getString("requestorFrom").length() != 0) {
            query.append(" AND p11.fnumber ='").append(params.getString("requestorFrom")).append("'").append(this.sp);
        }
        if (params.getString("traceNoFrom") != null && params.getString("traceNoFrom").length() != 0) {
            query.append(" AND entry.ftracknumber >='").append(params.getString("traceNoFrom")).append("'").append(this.sp);
        }
        if (params.getString("traceNoTo") != null && params.getString("traceNoTo").length() != 0) {
            query.append(" AND entry.ftracknumber <='").append(params.getString("traceNoTo")).append("'").append(this.sp);
        }
        if (params.getString("trackNo") != null && params.getString("trackNo").length() != 0) {
            query.append(" AND entry.FTrackNoID = ").append("(select FID FROM T_MM_TrackNumber WHERE FNUMBER='").append(params.getString("trackNo")).append("')").append(this.sp);
        }
        if (params.getString("fprojectNumber") != null && params.getString("fprojectNumber").length() != 0) {
            query.append(" AND entry.FProjectID = ").append("(select FID FROM T_MM_Project WHERE FNUMBER='").append(params.getString("fprojectNumber")).append("')").append(this.sp);
        }
        query.append(" AND req.fid not IN (select FSrcObjectID from T_BOT_Relation) ").append(this.sp);
        String statusRange = this.getStatusRange(ctx, params);
        query.append(" AND entry.fbasestatus IN (").append(statusRange).append(")").append(this.sp);
        query.append(" AND scmRowType.FISHASMATERIALNUMBER=1");
        query.append(" AND req.FPurchaseType= ").append(0);
        logger.debug((Object)query.toString());
        return query.toString();
    }

    @Override
    protected void _genRequestBill(Context ctx, PurRequestInfo requestBillInfo, String[] sourceBillIdArray, String[] sourceEntryIdArray) throws BOSException, EASBizException {
        IPurRequest purRequestCtrl = PurRequestFactory.getLocalInstance(ctx);
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        String fid = null;
        String parentid = null;
        Object destEntryId = null;
        StringBuffer gatherBillSql = new StringBuffer();
        HashMap<String, String> srcDestMap = new HashMap<String, String>();
        HashMap<String, ArrayList<String>> parentEntryMap = new HashMap<String, ArrayList<String>>();
        ArrayList<String> idList = null;
        StringBuffer params = new StringBuffer();
        StringBuffer parentParams = new StringBuffer();
        int c = requestBillInfo.getEntries().size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(requestBillInfo.getEntries().get(i).toString());
            params.append("'");
        }
        StringBuffer materialBuf = new StringBuffer();
        boolean firstMat = true;
        IRowType rowTypeCtrl = RowTypeFactory.getLocalInstance((Context)ctx);
        requestBillInfo.setIsMergeBill(true);
        int size = requestBillInfo.getEntries().size();
        for (int rowInx = 0; rowInx < size; ++rowInx) {
            PurRequestEntryInfo entry = requestBillInfo.getEntries().get(rowInx);
            ObjectUuidPK rowTypePK = new ObjectUuidPK(entry.getRowType().getId());
            RowTypeInfo rowType = rowTypeCtrl.getRowTypeInfo((IObjectPK)rowTypePK);
            entry.setRowType(rowType);
            entry.setDestinationType(rowType.getDestinationType());
            if (entry.getMaterial() == null) continue;
            if (firstMat) {
                firstMat = false;
            } else {
                materialBuf.append(",");
            }
            materialBuf.append("'").append(entry.getMaterial().getId().toString()).append("'");
        }
        if (materialBuf.length() > 0) {
            StringBuffer getConvertSQLBuf = new StringBuffer();
            getConvertSQLBuf.append("SELECT t0.fid,t0.FAssistUnit,t1.FBaseConvsRate,t1.FQtyPrecision ").append(this.sp).append(" FROM t_bd_material t0 ").append(this.sp).append(" INNER JOIN t_bd_multimeasureunit t1 ON t0.FAssistUnit = t1.FMeasureUnitID ").append(this.sp).append(" AND t0.fid = t1.FMaterialID").append(this.sp).append(" WHERE t0.FAssistUnit is not null ").append(this.sp).append(" AND t0.fid in (").append(materialBuf.toString()).append(")").append(this.sp);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getConvertSQLBuf.toString());
            try {
                while (rs.next()) {
                    int size2 = requestBillInfo.getEntries().size();
                    for (int rowInx = 0; rowInx < size2; ++rowInx) {
                        PurRequestEntryInfo entry = requestBillInfo.getEntries().get(rowInx);
                        if (entry.getMaterial() == null || !entry.getMaterial().getId().toString().equals(rs.getString("fid"))) continue;
                        BigDecimal asstQty = entry.getBaseQty().divide(rs.getBigDecimal("FBaseConvsRate"), rs.getInt("FQtyPrecision"), 4);
                        MeasureUnitInfo asstUnit = new MeasureUnitInfo();
                        asstUnit.setId(BOSUuid.read((String)rs.getString("FAssistUnit")));
                        entry.setAssistUnit(asstUnit);
                        entry.setAssistQty(asstQty);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        PurRequestCal purRequestCal = new PurRequestCal();
        requestBillInfo.setIsPriceInTax(true);
        this.fetchPrice(ctx, requestBillInfo);
        PurRequestCal.reCalcAmount(ctx, requestBillInfo);
        purRequestCtrl.save((CoreBaseInfo)requestBillInfo);
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            gatherBillSql.append("");
            gatherBillSql = gatherBillSql.append("select FRowTypeID,FPurchaseOrgUnitID,FReceivedOrgUnitID,");
            gatherBillSql = gatherBillSql.append("FMaterialID,FAssistPropertyID,FPurpose,FBaseUnitID,sum(FBaseQty) as FBaseQty,sum(ISNULL(FAssistQty,0)) as FAssistQty ");
            gatherBillSql = gatherBillSql.append(",SUM(ISNULL(FRequestQty,0)) AS FRequestQty ");
            gatherBillSql = gatherBillSql.append("from T_SM_PurRequestEntry ");
            gatherBillSql = gatherBillSql.append("where Fid in(" + params.toString() + ") ");
            gatherBillSql = gatherBillSql.append("group by FRowTypeID,FPurchaseOrgUnitID,FReceivedOrgUnitID,FMaterialID,FAssistPropertyID,FPurpose,FBaseUnitID ");
            ResultSet gatherSet = statement.executeQuery(gatherBillSql.toString());
            int seq = 0;
            PurRequestEntryInfo entry = null;
            int descEntrySize = requestBillInfo.getEntries().size();
            while (gatherSet.next()) {
                if (++seq < descEntrySize) {
                    entry = requestBillInfo.getEntries().get(seq);
                }
                gatherBillSql.setLength(0);
                gatherBillSql = gatherBillSql.append("select ");
                gatherBillSql = gatherBillSql.append("FID,FParentId,FRequirementDate,FProposeDeliveryDate,FProposePurchaseDate,FRemark ");
                gatherBillSql = gatherBillSql.append("from T_SM_PurRequestEntry ");
                gatherBillSql = gatherBillSql.append("where Fid in(" + params.toString() + ") ");
                gatherBillSql = gatherBillSql.append("and FRowTypeID='" + gatherSet.getString("FRowTypeID") + "'  ");
                gatherBillSql = gatherBillSql.append("and FPurchaseOrgUnitID='" + gatherSet.getString("FPurchaseOrgUnitID") + "' ");
                gatherBillSql = gatherBillSql.append("and FReceivedOrgUnitID='" + gatherSet.getString("FReceivedOrgUnitID") + "' ");
                gatherBillSql = gatherBillSql.append("and FMaterialID='" + gatherSet.getString("FMaterialID") + "' ");
                gatherBillSql = gatherSet.getString("FAssistPropertyID") != null ? gatherBillSql.append("and FAssistPropertyID='" + gatherSet.getString("FAssistPropertyID") + "' ") : gatherBillSql.append("and FAssistPropertyID is null ");
                gatherBillSql = gatherSet.getString("FPurpose") != null ? gatherBillSql.append("and FPurpose='" + gatherSet.getString("FPurpose") + "'") : gatherBillSql.append("and FPurpose is null");
                statement = con.createStatement(1004, 1007);
                gatherSet = statement.executeQuery(gatherBillSql.toString());
                while (gatherSet.next()) {
                    fid = gatherSet.getString("FID");
                    parentid = gatherSet.getString("FParentId");
                    if (entry != null) {
                        srcDestMap.put(fid, entry.getId().toString());
                    }
                    if ((idList = (ArrayList<String>)parentEntryMap.get(parentid)) == null) {
                        idList = new ArrayList<String>();
                    }
                    idList.add(fid);
                    parentEntryMap.put(parentid, idList);
                }
            }
            BOTRelationInfo info = new BOTRelationInfo();
            for (int i = 0; i < sourceBillIdArray.length; ++i) {
                info = new BOTRelationInfo();
                info.setSrcObjectID(sourceBillIdArray[i].toString());
                info.setSrcEntityID("25428F2E");
                info.setDestEntityID("25428F2E");
                info.setDestObjectID(requestBillInfo.getId().toString());
                info.setOperatorID(ctx.getUserName());
                info.setType(0);
                BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup(batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        String entryIds = this.array2String(sourceEntryIdArray);
        StringBuffer closeEntry = new StringBuffer();
        closeEntry.append(" UPDATE t_sm_purrequestentry ").append(" SET fbasestatus = ").append(7).append(",FMergeBillNumber = '").append(requestBillInfo.getNumber()).append("' ").append(this.sp).append(" WHERE fid IN (").append(entryIds).append(")");
        this.executeUpdate(closeEntry.toString(), null, ctx);
        StringBuffer updateSqlBuf = new StringBuffer();
        updateSqlBuf.append(" UPDATE t_sm_purrequestentry  AS t1 ").append(" SET (FMergeBillSeq) = (SELECT t2.FSeq ").append(" FROM t_sm_purrequestentry AS t2 ").append(" WHERE  t1.fmaterialid = t2.fmaterialid ");
        try {
            this.setSettingSqlStr(ctx, updateSqlBuf);
        }
        catch (Exception e) {
            throw new BOSException();
        }
        updateSqlBuf.append(" AND t1.fid IN (").append(entryIds).append(") ").append(" AND t2.fparentid = '").append(requestBillInfo.getId().toString()).append("') ");
        this.executeUpdate(updateSqlBuf.toString(), null, ctx);
        updateSqlBuf.setLength(0);
        updateSqlBuf.append(" UPDATE t_sm_purrequestentry  AS t1 ").append(" SET (FMergeBillSeq) = (SELECT t2.FSeq ").append(" FROM t_sm_purrequestentry AS t2 ").append(" WHERE t1.FMaterialName = t2.FMaterialName ").append(" AND t1.fbaseunitid = t2.Fbaseunitid ").append(" AND t1.FRowTypeID = t2.FRowTypeID ").append(" AND t1.fmaterialid is null ").append(" AND t2.fmaterialid is null ");
        try {
            this.setSettingSqlStr(ctx, updateSqlBuf);
        }
        catch (Exception e) {
            throw new BOSException();
        }
        updateSqlBuf.append(" AND t1.fid IN (").append(entryIds).append(") ").append(" AND t2.fparentid = '").append(requestBillInfo.getId().toString()).append("') ");
        this.executeUpdate(updateSqlBuf.toString(), null, ctx);
        String billIds = this.array2String(sourceBillIdArray);
        StringBuffer closeBill = new StringBuffer();
        closeBill.append(" UPDATE t_sm_purrequest SET fbasestatus = ").append(7).append(this.sp).append(" WHERE fid in (").append(this.sp).append(" SELECT fid FROM (").append(this.sp).append(" SELECT fid,SUM(entryCount) entryCount,SUM(closeCount) closeCount FROM (").append(this.sp).append(" SELECT req.fid,count(req.fid) entryCount,0 closeCount ").append(this.sp).append(" FROM t_sm_purrequest req inner join t_sm_purrequestentry entry on req.fid = entry.fparentid ").append(this.sp).append(" WHERE req.fid in (").append(billIds).append(")").append(this.sp).append(" GROUP BY req.fid ").append(this.sp).append(" UNION ALL ").append(this.sp).append(" SELECT req.fid,0 entryCount,count(req.fid) closeCount ").append(this.sp).append(" FROM t_sm_purrequest req inner join t_sm_purrequestentry entry on req.fid = entry.fparentid ").append(this.sp).append(" WHERE req.fid in (").append(billIds).append(")").append(this.sp).append(" AND entry.fbasestatus = ").append(7).append(this.sp).append(" GROUP BY req.fid) AS TMP__").append(this.sp).append(" GROUP BY fid) AS TMP___").append(this.sp).append(" WHERE TMP___.entryCount = TMP___.closeCount)");
        this.executeUpdate(closeBill.toString(), null, ctx);
    }

    private void setSettingSqlStr(Context ctx, StringBuffer updateSqlBuf) throws Exception {
        try {
            RptRowSet totalSetting = this._executeQuery(ctx);
            if (totalSetting.next()) {
                if (totalSetting.getInt("FISREQUESTORG") == 1) {
                    updateSqlBuf.append(" and (t1.fstorageOrgUnitID = t2.fstorageOrgUnitID ").append(" or (t1.fstorageOrgUnitID is null ").append(" and t2.fstorageOrgUnitID is null ))");
                }
                if (totalSetting.getInt("FISSUPPLIER") == 1) {
                    updateSqlBuf.append(" and (t1.fsupplierid = t2.fsupplierid").append(" or (t1.fsupplierid is null ").append(" and t2.fsupplierid is null ))");
                }
                if (totalSetting.getInt("FISTRACKNO") == 1) {
                    updateSqlBuf.append(" and (t1.FTrackNoID = t2.FTrackNoID").append(" or (t1.FTrackNoID is null ").append(" and t2.FTrackNoID is null ))");
                }
                if (totalSetting.getInt("FISPROJECT") == 1) {
                    updateSqlBuf.append(" and (t1.fprojectID = t2.fprojectID").append(" or (t1.fprojectID is null ").append(" and t2.fprojectID is null ))");
                }
                if (totalSetting.getInt("FISASSISTANT") == 1) {
                    updateSqlBuf.append(" and (t1.fassistPropertyid = t2.fassistPropertyid").append(" or (t1.fassistPropertyid is null ").append(" and t2.fassistPropertyid is null ))");
                }
                if (totalSetting.getInt("FISPROPOSEDELIVERYDATA") == 1) {
                    updateSqlBuf.append(" and to_char(t1.fproposedeliverydate,'yyyy-MM-dd') = to_char(t2.fproposedeliverydate,'yyyy-MM-dd')");
                }
                if (totalSetting.getInt("FISROWTYPE") == 1) {
                    updateSqlBuf.append(" and t1.FRowTypeID = t2.FRowTypeID");
                }
                if (totalSetting.getInt("FISPURCHASEORG") == 1) {
                    updateSqlBuf.append(" and t1.FPurchaseOrgUnitID = t2.FPurchaseOrgUnitID");
                }
                if (totalSetting.getInt("FISRECIEVEORG") == 1) {
                    updateSqlBuf.append(" and (t1.FReceivedOrgUnitID = t2.FReceivedOrgUnitID").append(" or (t1.FReceivedOrgUnitID is null ").append(" and t2.FReceivedOrgUnitID is null ))");
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Override
    protected RptRowSet _getOnlyAvailableSupplier(Context ctx, RptRowSet param) throws BOSException, EASBizException {
        this.LNAME = this.getLoc(ctx);
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" SELECT distinct t1.FID,t1.FName_").append(this.LNAME).append(" FName,t1.FNumber ").append(this.sp).append(" FROM  T_BD_Supplier t1  ").append(this.sp).append(" INNER JOIN  T_BD_MaterialPurchasing t2  ON t2.FSupplier = t1.FID ").append(this.sp).append(" WHERE  t1.FUsedStatus = 1 ").append(this.sp).append(" AND t2.FOrgUnit = ? ").append(this.sp).append(" AND t2.FMaterialid = ? ").append(this.sp).append(" ORDER BY t1.FNumber ASC ");
        RptRowSet retRowSet = new RptRowSet(new String[]{"rowIndex", "supplier"}, new ArrayList());
        SqlParams sqlParams = new SqlParams();
        while (param.next()) {
            SupplierInfo supplier = null;
            sqlParams.clear();
            sqlParams.addString(param.getString("purOrgId"));
            sqlParams.addString(param.getString("materialId"));
            RptRowSet r1 = this.executeQuery(selectSql.toString(), sqlParams, ctx);
            if (r1.next() && r1.getRowCount() == 1) {
                supplier = new SupplierInfo();
                supplier.setId(BOSUuid.read((String)r1.getString("FID")));
                supplier.setNumber(r1.getString("FNumber"));
                supplier.setName(r1.getString("FName"));
            }
            retRowSet.addRow(new Object[]{param.getObject("rowIndex"), supplier});
        }
        return retRowSet;
    }

    @Override
    protected RptRowSet _executeQuery(Context ctx) throws BOSException, EASBizException {
        RptRowSet rowset = new RptRowSet();
        Connection conn = null;
        try {
            conn = QueryConnectionProvider.getConnection((Context)ctx);
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            String sql = "select * from T_SM_PURREQTOTALSET where fuserid='" + userInfo.getId().toString() + "' ";
            rowset = DBUtils.executeQuery((String)sql, (Connection)conn);
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new BOSException("sql Execute Error :", (Throwable)e);
            }
        }
        return rowset;
    }

    @Override
    protected boolean _executeSql(Context ctx, String sql, Map settingMap) throws BOSException, EASBizException {
        boolean state = true;
        Connection conn = null;
        String sqlStr = this.getSettingSql(ctx, settingMap);
        try {
            conn = QueryConnectionProvider.getConnection((Context)ctx);
            state = DBUtils.execute((String)sqlStr, (Connection)conn);
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new BOSException("sql Execute Error :", (Throwable)e);
            }
        }
        return state;
    }

    private String getSettingSql(Context ctx, Map totalSetting) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        RptRowSet rowSet = null;
        rowSet = this._executeQuery(ctx);
        if (rowSet.next()) {
            sql.append("update T_SM_PURREQTOTALSET set ");
            if (totalSetting.get("cb_requestOrg") != null && Boolean.valueOf(totalSetting.get("cb_requestOrg").toString()).booleanValue()) {
                sql.append(" FISREQUESTORG =1 ");
            } else {
                sql.append(" FISREQUESTORG =0 ");
            }
            if (totalSetting.get("cb_supplier") != null && Boolean.valueOf(totalSetting.get("cb_supplier").toString()).booleanValue()) {
                sql.append(", FISSUPPLIER =1 ");
            } else {
                sql.append(", FISSUPPLIER =0 ");
            }
            if (totalSetting.get("cb_trackno") != null && Boolean.valueOf(totalSetting.get("cb_trackno").toString()).booleanValue()) {
                sql.append(", FISTRACKNO =1 ");
            } else {
                sql.append(", FISTRACKNO =0 ");
            }
            if (totalSetting.get("cb_project") != null && Boolean.valueOf(totalSetting.get("cb_project").toString()).booleanValue()) {
                sql.append(", FISPROJECT =1 ");
            } else {
                sql.append(", FISPROJECT =0 ");
            }
            if (totalSetting.get("cb_assistant") != null && Boolean.valueOf(totalSetting.get("cb_assistant").toString()).booleanValue()) {
                sql.append(", FISASSISTANT =1 ");
            } else {
                sql.append(", FISASSISTANT =0 ");
            }
            if (totalSetting.get("cb_deliveryDate") != null && Boolean.valueOf(totalSetting.get("cb_deliveryDate").toString()).booleanValue()) {
                sql.append(", FISPROPOSEDELIVERYDATA =1 ");
            } else {
                sql.append(", FISPROPOSEDELIVERYDATA =0 ");
            }
            sql.append(", FLASTUPDATETIME = now()");
            sql.append(" where FUSERID='").append(userInfo.getId()).append("' ");
        } else {
            sql.append("insert into T_SM_PURREQTOTALSET values('").append(BOSUuid.create((String)"123456789").toString()).append("'");
            sql.append(",'").append(userInfo.getId().toString()).append("' ");
            if (totalSetting.get("cb_requestOrg") != null && Boolean.valueOf(totalSetting.get("cb_requestOrg").toString()).booleanValue()) {
                sql.append(",1");
            } else {
                sql.append(",0");
            }
            if (totalSetting.get("cb_supplier") != null && Boolean.valueOf(totalSetting.get("cb_supplier").toString()).booleanValue()) {
                sql.append(",1");
            } else {
                sql.append(",0");
            }
            if (totalSetting.get("cb_trackno") != null && Boolean.valueOf(totalSetting.get("cb_trackno").toString()).booleanValue()) {
                sql.append(",1");
            } else {
                sql.append(",0");
            }
            if (totalSetting.get("cb_project") != null && Boolean.valueOf(totalSetting.get("cb_project").toString()).booleanValue()) {
                sql.append(",1");
            } else {
                sql.append(",0");
            }
            if (totalSetting.get("cb_assistant") != null && Boolean.valueOf(totalSetting.get("cb_assistant").toString()).booleanValue()) {
                sql.append(",1");
            } else {
                sql.append(",0");
            }
            if (totalSetting.get("cb_deliveryDate") != null && Boolean.valueOf(totalSetting.get("cb_deliveryDate").toString()).booleanValue()) {
                sql.append(",1");
            } else {
                sql.append(",0");
            }
            sql.append(",1,1,1,1,1,1,now(),null)");
        }
        return sql.toString();
    }

    private void fetchPrice(Context ctx, PurRequestInfo requestBillInfo) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = this.getPriceParamCol(ctx, requestBillInfo);
        paramCol.setBillTypeId("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        PurPriceInfoCollection cols = PurServiceFacadeFactory.getLocalInstance(ctx).fetchPrice(paramCol);
        PurRequestEntryInfo entryInfo = null;
        PurPriceInfo priceInfo = null;
        int size = requestBillInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = requestBillInfo.getEntries().get(i);
            if (entryInfo.getMaterial() == null) continue;
            priceInfo = cols.getPurPriceInfoBySeq(entryInfo.getSeq());
            if (entryInfo.getSupplier() == null) {
                entryInfo.setSupplier(priceInfo.getSupplier());
            }
            if (priceInfo == null || priceInfo.getPrice() == null) continue;
            PurRequestCal purRequestCal = new PurRequestCal();
            purRequestCal.setInTax(priceInfo.isInTaxPrice());
            if (entryInfo.getTaxRate() == null || BigDecimal.ZERO.compareTo(entryInfo.getTaxRate()) == 0) {
                entryInfo.setTaxRate(priceInfo.getTaxRate());
            }
            if (priceInfo.getDiscountRate() != null) {
                entryInfo.setDiscountRate(priceInfo.getDiscountRate());
            }
            if (priceInfo.isInTaxPrice()) {
                entryInfo.setTaxPrice(priceInfo.getPrice());
                purRequestCal.calByEntryTaxPriceChange(requestBillInfo, entryInfo);
                continue;
            }
            entryInfo.setPrice(priceInfo.getPrice());
            purRequestCal.calByEntryPriceChange(requestBillInfo, entryInfo);
        }
        PurRequestCal.calcAmount(ctx, requestBillInfo);
    }

    private PurPriceParamCollection getPriceParamCol(Context ctx, PurRequestInfo requestBillInfo) {
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        paramCol.setPurchaseType(MaterialPurchaseTypeEnum.PURCHASE);
        paramCol.setBizTypeId(requestBillInfo.getBizType().getId().toString());
        PurPriceParam param = null;
        PurRequestEntryInfo entryInfo = null;
        int size = requestBillInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = requestBillInfo.getEntries().get(i);
            param = PurRequestCal.getPriceParam(entryInfo.getSeq(), requestBillInfo, entryInfo);
            paramCol.addPurPriceParam(param);
        }
        paramCol.addPurPriceParam(param);
        return paramCol;
    }

    class QuerySql {
        StringBuffer selectPart = new StringBuffer();
        StringBuffer fromPart = new StringBuffer();
        StringBuffer wherePart = new StringBuffer();
        StringBuffer orderByPart = new StringBuffer();
        StringBuffer groupPart = new StringBuffer();
        Set tables = new HashSet();
        String aliasName = "";

        QuerySql() {
        }

        String getSql() {
            return this.selectPart.toString() + PurRequestTotalWebFacadeControllerBean.this.sp + this.fromPart.toString() + PurRequestTotalWebFacadeControllerBean.this.sp + this.wherePart.toString() + PurRequestTotalWebFacadeControllerBean.this.sp + this.groupPart.toString() + PurRequestTotalWebFacadeControllerBean.this.sp + this.orderByPart.toString();
        }
    }
}

