/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.report.app.AbstractPurSupplierABCFacadeControllerBean;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurSupplierABCFacadeControllerBean
extends AbstractPurSupplierABCFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.PurSupplierABCFacadeControllerBean");
    private String orgIDs = null;
    private String sp = "\r\n";

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        pp.setObject("title", (Object)new Timestamp(System.currentTimeMillis()));
        return pp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String cuId = params.getString("cuId");
        Object[] companyOrg = (Object[])params.getObject("fullOrgUnit");
        this.orgIDs = this.getOrgIdList(ctx, companyOrg, "purSupplierABC_view");
        String precision = params.getString("currPrecision");
        this.dropTable(params.getString("tempTable"), ctx);
        String tempTable = this.getTempTableName(this.getStringRes("SupplierABCName", ctx), ctx);
        params.setString("tempTable", tempTable);
        params.getString("tempTable");
        StringBuffer sqlField = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        StringBuffer sqlCondition = new StringBuffer();
        StringBuffer sqlSon = new StringBuffer();
        StringBuffer sqlAll = new StringBuffer();
        if (params.getObject("dateBegin") != null) {
            sqlCondition.append(" PURORDER.FBizDate >=  ");
            sqlCondition.append(" {");
            sqlCondition.append(params.getString("dateBegin"));
            sqlCondition.append(" }");
            sqlCondition.append(" and ");
        }
        if (params.getObject("dateEnd") != null) {
            sqlCondition.append(" PURORDER.FBizDate <=  ");
            sqlCondition.append(" {");
            sqlCondition.append(params.getString("dateEnd"));
            sqlCondition.append(" }");
            sqlCondition.append(" and ");
        }
        if (params.getObject("prmtSupplierBegin") != null) {
            String[] numberArray = SCMUtil.getF7Numbers((Object)params.getObject("prmtSupplierBegin"));
            if (numberArray[1] != null) {
                sqlCondition.append(" SUPPLIER.FNumber in (");
                sqlCondition.append(numberArray[1]);
                sqlCondition.append(" )");
                sqlCondition.append(" and ");
            } else if (numberArray[0] != null) {
                sqlCondition.append(" SUPPLIER.FNumber >=  ");
                sqlCondition.append("'");
                sqlCondition.append(numberArray[0]);
                sqlCondition.append("'");
                sqlCondition.append(" and ");
            }
        }
        if (params.getString("prmtSupplierEnd") != null && params.getString("prmtSupplierEnd").trim().length() > 0) {
            sqlCondition.append(" SUPPLIER.FNumber <=  ");
            sqlCondition.append("'");
            sqlCondition.append(params.getString("prmtSupplierEnd"));
            sqlCondition.append("'");
            sqlCondition.append(" and ");
        }
        if (params.getString("prmtSupplierGroupBegin") != null && params.getString("prmtSupplierGroupBegin").trim().length() > 0) {
            sqlCondition.append(" SUPPLIERTYPE.FNumber >=  ");
            sqlCondition.append("'");
            sqlCondition.append(params.getString("prmtSupplierGroupBegin"));
            sqlCondition.append("'");
            sqlCondition.append(" and ");
        }
        if (params.getString("prmtSupplierGroupEnd") != null && params.getString("prmtSupplierGroupEnd").trim().length() > 0) {
            sqlCondition.append(" SUPPLIERTYPE.FNumber <=  ");
            sqlCondition.append("'");
            sqlCondition.append(params.getString("prmtSupplierGroupEnd"));
            sqlCondition.append("'");
            sqlCondition.append(" and ");
        }
        if (this.orgIDs.length() > 0) {
            sqlCondition.append(" PURCHASEORGUNIT.FID IN (").append(this.orgIDs).append(") ").append(" and ");
        } else {
            sqlCondition.append(" PURCHASEORGUNIT.FID IN ('') ").append(" and ");
        }
        if (params.getString("prmtCompanyOrgBegin") != null && params.getString("prmtCompanyOrgBegin").trim().length() > 0) {
            sqlCondition.append(" COMPANYORGUNIT.FNumber >=  ");
            sqlCondition.append("'");
            sqlCondition.append(params.getString("prmtCompanyOrgBegin"));
            sqlCondition.append("'");
            sqlCondition.append(" and ");
        }
        if (params.getString("prmtCompanyOrgEnd") != null && params.getString("prmtCompanyOrgEnd").trim().length() > 0) {
            sqlCondition.append(" COMPANYORGUNIT.FNumber <=  ");
            sqlCondition.append("'");
            sqlCondition.append(params.getString("prmtCompanyOrgEnd"));
            sqlCondition.append("'");
            sqlCondition.append(" and ");
        }
        if (!"-1".equals(params.getString("combStatus"))) {
            sqlCondition.append(" PurOrder.FBaseStatus =  ");
            sqlCondition.append(new Integer(params.getString("combStatus")));
        } else {
            int from = sqlCondition.lastIndexOf("and");
            sqlCondition.delete(from, from + 3);
        }
        if (sqlCondition.length() > 0) {
            sqlCondition.append(" and PurOrder.FBaseStatus<>-3 ");
        }
        sqlSon.append("SELECT sum(TO_DECIMAL(ENTRIES.FTaxAmount*PURORDER.FExchangeRate,17,").append(precision).append(")) AS ALLTOTALTAXAMOUNT");
        sqlSon.append(" FROM T_SM_PurOrder AS PURORDER");
        sqlSon.append(" Inner JOIN T_SM_PurOrderEntry AS ENTRIES ON PURORDER.FID = ENTRIES.FParentID");
        sqlSon.append(" INNER JOIN T_ORG_Purchase AS PURCHASEORGUNIT ON PURORDER.FPurchaseOrgUnitID = PURCHASEORGUNIT.FID");
        sqlSon.append(" INNER JOIN T_BD_Supplier AS SUPPLIER ON PURORDER.FSupplierID = SUPPLIER.FID");
        if (params.getString("prmtCompanyOrgEnd") != null && params.getString("prmtCompanyOrgEnd").trim().length() > 0 || params.getString("prmtCompanyOrgBegin") != null && params.getString("prmtCompanyOrgBegin").trim().length() > 0) {
            sqlSon.append(" INNER JOIN T_ORG_Company AS COMPANYORGUNIT ON ENTRIES.FCompanyOrgUnitID = COMPANYORGUNIT.FID ");
        }
        sqlSon.append(" INNER JOIN T_BD_csspgroup AS SUPPLIERTYPE on SUPPLIER.FBrowseGroupID = SUPPLIERTYPE.FID ");
        sqlSon.append(" where ");
        sqlSon.append(sqlCondition);
        BigDecimal total = new BigDecimal("0");
        try {
            RptRowSet ars = this.executeQuery(sqlSon.toString(), null, ctx);
            if (ars.next() && (total = ars.getBigDecimal(0)) != null) {
                total = total.setScale(4, 4);
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        sqlField.append("SELECT  SUPPLIER.FNumber AS FNumber, SUPPLIER.FName_").append(ctx.getLocale().getLanguage()).append(" AS FName,SUPPLIERTYPE.FNAME_").append(ctx.getLocale().getLanguage()).append(" as SupplierGroup,");
        sqlField.append(" sum(TO_DECIMAL(ENTRIES.FTaxAmount*PURORDER.FExchangeRate,17,").append(2).append(")) AS FTotalTaxAmount,");
        sqlField.append(" round(TO_DECIMAL(sum(TO_DECIMAL(ENTRIES.FTaxAmount*PURORDER.FExchangeRate,17,").append(precision).append(")),17,4)/");
        if (total == null || total.compareTo(new BigDecimal("0")) == 0) {
            sqlField.append("1.0 ,4) as FPercentSupplier");
        } else {
            sqlField.append(total.toString()).append(" ,4) as FPercentSupplier");
        }
        sqlField.append(" into ");
        sqlField.append(tempTable);
        sqlField.append(" FROM T_SM_PurOrder AS PURORDER");
        sqlField.append("  Inner JOIN T_SM_PurOrderEntry AS ENTRIES ON PURORDER.FID = ENTRIES.FParentID");
        sqlField.append(" INNER JOIN T_ORG_Purchase AS PURCHASEORGUNIT ON PURORDER.FPurchaseOrgUnitID = PURCHASEORGUNIT.FID");
        sqlField.append(" INNER JOIN T_BD_Supplier AS SUPPLIER ON PURORDER.FSupplierID = SUPPLIER.FID");
        sqlField.append(" INNER JOIN T_BD_csspgroup AS SUPPLIERTYPE on SUPPLIER.FBrowseGroupID = SUPPLIERTYPE.FID");
        if (params.getString("prmtCompanyOrgEnd") != null && params.getString("prmtCompanyOrgEnd").trim().length() > 0 || params.getString("prmtCompanyOrgBegin") != null && params.getString("prmtCompanyOrgBegin").trim().length() > 0) {
            sqlField.append(" INNER JOIN T_ORG_Company AS COMPANYORGUNIT ON ENTRIES.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        }
        sqlField.append(" where ");
        sqlField.append(sqlCondition);
        sqlOrder.append(" GROUP BY  FSupplierID,SUPPLIER.FName_").append(ctx.getLocale().getLanguage()).append(",SUPPLIER.FNumber,SUPPLIERTYPE.FNAME_").append(ctx.getLocale().getLanguage());
        sqlAll.append(sqlField);
        sqlAll.append(sqlOrder);
        String sqlQuey = sqlAll.toString();
        SqlParams sqlTest = new SqlParams();
        try {
            sqlTest.sql((Object)sqlQuey);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        DbUtil.execute((Context)ctx, (String)sqlQuey.toString());
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FNumber");
        col.setWidth(200);
        header.addColumn(col);
        col = new RptTableColumn("FName");
        col.setWidth(200);
        header.addColumn(col);
        col = new RptTableColumn("SupplierGroup");
        col.setWidth(200);
        header.addColumn(col);
        col = new RptTableColumn("FTotalTaxAmount");
        col.setWidth(200);
        col.setAligment(2);
        col.setFormatPattern(RptCellFormatter.getNumberFormat((int)2, (boolean)true));
        header.addColumn(col);
        col = new RptTableColumn("FPercentSupplier");
        col.setWidth(190);
        col.setAligment(2);
        col.setFormatPattern(RptCellFormatter.getNumberFormat((int)4, (boolean)true));
        header.addColumn(col);
        col = new RptTableColumn("FABC");
        col.setWidth(190);
        col.setAligment(2);
        col.setFormatPattern("@=?C:$_");
        header.addColumn(col);
        header.setLabels((Object[][])new Object[][]{{this.getHeaderResource("SupplierNumber", ctx), this.getHeaderResource("supplierNameABC", ctx), this.getHeaderResource("SupplierGroup", ctx), this.getHeaderResource("SupplierOrderAmunt", ctx), this.getHeaderResource("SupplierRate", ctx), this.getHeaderResource("SupplierABCClass", ctx)}});
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        return result;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)("select sum(FTotalTaxAmount) as FTotalOrderAmount from " + params.getString("tempTable")));
        RptRowSet rs = this.executeQuery("select FNumber ,FName,SupplierGroup , FTotalTaxAmount , FPercentSupplier  ,'' as FABC from " + params.getString("tempTable") + " order by FTotalTaxAmount DESC", null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        BigDecimal totalOrderAmount = BigDecimal.ZERO;
        try {
            if (rs2.next()) {
                totalOrderAmount = rs2.getBigDecimal("FTotalOrderAmount");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        pp.setObject("FTotalOrderAmount", (Object)totalOrderAmount);
        return pp;
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        return this._query(ctx, params, 0, -1);
    }

    protected Object _invoke(Context ctx, String method, Object parameter) throws BOSException, EASBizException {
        try {
            Method mm = this.getClass().getMethod(method, Object.class, Context.class);
            return mm.invoke((Object)this, parameter, ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, Context ctx) throws BOSException {
        return this.executeQuery(sql, parameters, 0, -1, ctx);
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, int from, int length, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql, (SqlParams)parameters, (int)from, (int)length, (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected int executeUpdate(String sql, SqlParams parameters, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            int n = DBUtil.executeUpdate((String)sql, (SqlParams)parameters, (Connection)con);
            return n;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected int[] executeBatchUpdate(Context ctx, String[] sqls) throws BOSException {
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.createStatement();
            int n = sqls.length;
            for (int i = 0; i < n; ++i) {
                ps.addBatch(sqls[i]);
            }
            int[] i = ps.executeBatch();
            this.close(con, ps);
            return i;
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("Execute batch update: " + ps));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                this.close(con, ps);
                throw throwable;
            }
        }
    }

    protected int executeCreateAsSelectInto(String sql, SqlParams parameters, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            int n = DBUtil.executeSelectInto((String)sql, (SqlParams)parameters, (Connection)con);
            return n;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected void dropTable(String tableName, Context ctx) throws BOSException {
        if (tableName == null) {
            return;
        }
        ITableManagerFacade manager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        manager.releaseTableName(tableName);
    }

    protected String getTempTableName(String desc, Context ctx) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(desc);
    }

    protected void close(Connection con) {
        this.close(con, null, null);
    }

    protected void close(Statement statement) {
        this.close(null, statement, null);
    }

    protected void close(ResultSet rs) {
        this.close(null, null, rs);
    }

    protected void close(Connection con, ResultSet rs) {
        this.close(con, null, rs);
    }

    protected void close(Connection con, Statement statement) {
        this.close(con, statement, null);
    }

    protected void close(Connection con, Statement statement, ResultSet rs) {
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    public String getStringRes(String key, Context ctx) {
        return this.getServeStringRes(key, ctx);
    }

    public String getHeaderResource(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)key, (Context)ctx);
    }

    public String getServeStringRes(String key, Context ctx) {
        return EASServerResource.getString((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)key, (Locale)ctx.getOriginLocale());
    }

    protected String getOrgIds(Object[] infos) {
        StringBuffer OrgunitId = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)infos[i]).get("isleaf");
            boolean fisleaf = isleaf != false;
            if (!fisleaf) continue;
            if (OrgunitId.length() > 1) {
                OrgunitId.append(",");
            }
            OrgunitId.append("'" + ((FullOrgUnitInfo)infos[i]).getId().toString() + "'");
        }
        return OrgunitId.toString();
    }

    private String getOrgIdList(Context ctx, Object[] fullOrg, String permissionName) throws BOSException {
        String orgIDlist = "";
        Set cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)permissionName);
        if (null == fullOrg || fullOrg.length == 0 || null == cuUnitSets) {
            orgIDlist = "'xxx_xxx'";
        } else {
            Set havePermOrgUnitSet = InvServerUtils.getSelAuthorUnit((Set)cuUnitSets, (Object[])fullOrg);
            fullOrg = havePermOrgUnitSet.toArray();
            orgIDlist = this.getOrgIds(fullOrg);
        }
        return orgIDlist;
    }
}

