/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArSysFacadeFactory;
import com.kingdee.eas.fi.ar.IArSysFacade;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.report.app.AbstractSupplierIntegrativeFacadeControllerBean;
import com.kingdee.util.StringUtils;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SupplierIntegrativeFacadeControllerBean
extends AbstractSupplierIntegrativeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.SupplierIntegrativeFacadeControllerBean");
    private String leafCompanyOrgUnit = "leafCompanyOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("TempResultTable"), ctx);
        this.dropTable(params.getString("CompanyTempTable"), ctx);
        String companyTB = this.getTempTableName(this.getServerResource("ORGUintTempTable", ctx), ctx);
        params.setString("CompanyTempTable", companyTB);
        this.buildCompanyOrgTable(ctx, companyTB, params);
        String curPurTB = this.getTempTableName(this.getServerResource("curPurDataTable", ctx), ctx);
        params.setString("curPurTable", curPurTB);
        String sql0 = this.buildCurPurTableSql(curPurTB);
        this.executeSQL(ctx, sql0);
        this.insertCurPurData(ctx, curPurTB, params);
        String lastPurTB = this.getTempTableName(this.getServerResource("ORGUintTempTable", ctx), ctx);
        params.setString("LastPurTable", lastPurTB);
        String sql1 = this.buildLastPurTableSql(lastPurTB);
        String lastPayTB = this.getTempTableName("LastPayTBName", ctx);
        params.setString("LastPayTable", lastPayTB);
        String sql2 = this.buildLastPayTableSql(lastPayTB);
        String payTB = this.getTempTableName("PayTBName", ctx);
        params.setString("PayTable", payTB);
        String sql3 = this.buildPayTableSql(payTB);
        String purchaseTB = this.getTempTableName("PurchaseTBName", ctx);
        params.setString("PurTable", purchaseTB);
        String sql4 = this.buildPurchaseTableSql(purchaseTB);
        String purInTB = this.getTempTableName("PurInWarehs", ctx);
        params.setString("PurInTable", purInTB);
        String sql5 = this.buildPurInTableSql(purInTB);
        String purTimesTB = this.getTempTableName("PurInWarehs", ctx);
        params.setString("PurTimesTable", purTimesTB);
        String sql6 = this.buildPurTimesTableSql(purTimesTB);
        String apBalanceTB = this.getTempTableName("ApBalanceTable", ctx);
        params.setString("ApBalanceTable", apBalanceTB);
        String sql7 = this.buildApBalanceTableSql(apBalanceTB);
        String resultTB = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        params.setString("TempResultTable", resultTB);
        String sql8 = this.buildLastResultDataTableSql(resultTB);
        String[] sql = new String[]{sql1, sql2, sql3, sql4, sql5, sql6, sql7, sql8};
        this.executeBatchUpdate(ctx, sql);
        this.insertLastPurData(ctx, lastPurTB, params);
        this.insertLastPayData(ctx, lastPayTB, params);
        this.insertPayData(ctx, payTB, params);
        this.insertPurData(ctx, purchaseTB, params);
        this.insertPurInData(ctx, purInTB, params);
        this.insertPurTimesData(ctx, purTimesTB, params);
        this.insertApBalanceData(ctx, apBalanceTB, params);
        this.insertResultData(ctx, params);
        this.totalByOrg(ctx, resultTB, companyTB, params);
        RptParams result = new RptParams();
        result.setString("tempTable", resultTB);
        result.setString("CompanyTempTable", companyTB);
        this.dropTable(params.getString("curPurTable"), ctx);
        return result;
    }

    private String getfromLastPaySQL(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer fromLastPayTB = new StringBuffer();
        fromLastPayTB.append(" select  ");
        fromLastPayTB.append("FSupplierID FSupplierID,FCompanyORGUnitID FCompanyORGUnitID");
        fromLastPayTB.append(",0 FApBalance");
        fromLastPayTB.append("\n ,0 FLastPurAmount");
        fromLastPayTB.append(",CONVERT(DATETIME,null) FLastPurDate");
        fromLastPayTB.append("\n ,FLastPayAmount FLastPayAmount");
        fromLastPayTB.append(",FLastPayDate FLastPayDate");
        fromLastPayTB.append("\n ,0 FPurAmount");
        fromLastPayTB.append(",0 FPurInAmount");
        fromLastPayTB.append(",0 FAPAmount");
        fromLastPayTB.append(",0 FPayAmount");
        fromLastPayTB.append(",0 FPurTimes");
        fromLastPayTB.append("\n ,0 FTatolPurAmount");
        fromLastPayTB.append(",0 FTatolPurInAmount");
        fromLastPayTB.append(",0 FTatolAPAmount");
        fromLastPayTB.append(",0 FTatolPayAmount");
        fromLastPayTB.append(",0 FTatolPurTimes");
        fromLastPayTB.append("\n from ");
        fromLastPayTB.append(params.getString("LastPayTable"));
        return fromLastPayTB.toString();
    }

    private String getfromLastPurSQL(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer fromLastPurTB = new StringBuffer();
        fromLastPurTB.append("select  ");
        fromLastPurTB.append("FSupplierID FSupplierID,FCompanyORGUnitID FCompanyORGUnitID");
        fromLastPurTB.append(",0 FApBalance");
        fromLastPurTB.append("\n ,FLastPurAmount FLastPurAmount");
        fromLastPurTB.append(",FLastPurDate FLastPurDate");
        fromLastPurTB.append("\n ,0 FLastPayAmount");
        fromLastPurTB.append(",CONVERT(DATETIME,null) FLastPayDate");
        fromLastPurTB.append("\n ,0 FPurAmount");
        fromLastPurTB.append(",0 FPurInAmount");
        fromLastPurTB.append(",0 FAPAmount");
        fromLastPurTB.append(",0 FPayAmount");
        fromLastPurTB.append(",0 FPurTimes");
        fromLastPurTB.append("\n ,0 FTatolPurAmount");
        fromLastPurTB.append(",0 FTatolPurInAmount");
        fromLastPurTB.append(",0 FTatolAPAmount");
        fromLastPurTB.append(",0 FTatolPayAmount");
        fromLastPurTB.append(",0 FTatolPurTimes");
        fromLastPurTB.append("\n from ");
        fromLastPurTB.append(params.getString("LastPurTable"));
        return fromLastPurTB.toString();
    }

    private String getfromApBalanceSQL(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer fromPayTB = new StringBuffer();
        fromPayTB.append(" select  ");
        fromPayTB.append("FSupplierID FSupplierID,FCompanyORGUnitID FCompanyORGUnitID");
        fromPayTB.append(",FApBalance FApBalance");
        fromPayTB.append("\n ,0 FLastPurAmount");
        fromPayTB.append(",CONVERT(DATETIME,null) FLastPurDate");
        fromPayTB.append("\n ,0 FLastPayAmount");
        fromPayTB.append(",CONVERT(DATETIME,null) FLastPayDate");
        fromPayTB.append("\n ,0 FPurAmount");
        fromPayTB.append(",0 FPurInAmount");
        fromPayTB.append(",0 FAPAmount");
        fromPayTB.append(",0 FPayAmount");
        fromPayTB.append(",0 FPurTimes");
        fromPayTB.append("\n ,0 FTatolPurAmount");
        fromPayTB.append(",0 FTatolPurInAmount");
        fromPayTB.append(",0 FTatolAPAmount");
        fromPayTB.append(",0 FTatolPayAmount");
        fromPayTB.append(",0 FTatolPurTimes");
        fromPayTB.append("\n from ");
        fromPayTB.append(params.getString("ApBalanceTable"));
        return fromPayTB.toString();
    }

    private String getfromPaySQL(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer fromPayTB = new StringBuffer();
        fromPayTB.append(" select  ");
        fromPayTB.append("FSupplierID FSupplierID,FCompanyORGUnitID FCompanyORGUnitID");
        fromPayTB.append(",0 FApBalance");
        fromPayTB.append("\n ,0 FLastPurAmount");
        fromPayTB.append(",CONVERT(DATETIME,null) FLastPurDate");
        fromPayTB.append("\n ,0 FLastPayAmount");
        fromPayTB.append(",CONVERT(DATETIME,null) FLastPayDate");
        fromPayTB.append("\n ,0 FPurAmount");
        fromPayTB.append(",0 FPurInAmount");
        fromPayTB.append(",0 FAPAmount");
        fromPayTB.append(",FPayAmount FPayAmount");
        fromPayTB.append(",0 FPurTimes");
        fromPayTB.append("\n ,0 FTatolPurAmount");
        fromPayTB.append(",0 FTatolPurInAmount");
        fromPayTB.append(",0 FTatolAPAmount");
        fromPayTB.append(",FTatolPayAmount FTatolPayAmount");
        fromPayTB.append(",0 FTatolPurTimes");
        fromPayTB.append("\n from ");
        fromPayTB.append(params.getString("PayTable"));
        return fromPayTB.toString();
    }

    private String getfromPurSQL(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer fromPurTB = new StringBuffer();
        fromPurTB.append(" select  ");
        fromPurTB.append("FSupplierID FSupplierID,FCompanyORGUnitID FCompanyORGUnitID");
        fromPurTB.append(",0 FApBalance");
        fromPurTB.append("\n ,0 FLastPurAmount");
        fromPurTB.append(",CONVERT(DATETIME,null) FLastPurDate");
        fromPurTB.append("\n ,0 FLastPayAmount");
        fromPurTB.append(",CONVERT(DATETIME,null) FLastPayDate");
        fromPurTB.append("\n ,FPurAmount FPurAmount");
        fromPurTB.append(",0 FPurInAmount");
        fromPurTB.append(",0 FAPAmount");
        fromPurTB.append(",0 FPayAmount");
        fromPurTB.append(",0 FPurTimes");
        fromPurTB.append("\n ,FTatolPurAmount ftatolpuramount");
        fromPurTB.append(",0 FTatolPurInAmount");
        fromPurTB.append(",0 FTatolAPAmount");
        fromPurTB.append(",0 FTatolPayAmount");
        fromPurTB.append(",0 FTatolPurTimes");
        fromPurTB.append("\n from ");
        fromPurTB.append(params.getString("PurTable"));
        return fromPurTB.toString();
    }

    private String getfromPurInSQL(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer fromPurInTB = new StringBuffer();
        fromPurInTB.append(" select  ");
        fromPurInTB.append("FSupplierID FSupplierID,FCompanyORGUnitID FCompanyORGUnitID");
        fromPurInTB.append(",0 FApBalance");
        fromPurInTB.append("\n ,0 FLastPurAmount");
        fromPurInTB.append(",CONVERT(DATETIME,null) FLastPurDate");
        fromPurInTB.append("\n ,0 FLastPayAmount");
        fromPurInTB.append(",CONVERT(DATETIME,null) FLastPayDate");
        fromPurInTB.append("\n ,0 FPurAmount");
        fromPurInTB.append(",FPurInAmount FPurInAmount");
        fromPurInTB.append(",0 FAPAmount");
        fromPurInTB.append(",0 FPayAmount");
        fromPurInTB.append(",0 FPurTimes");
        fromPurInTB.append("\n ,0 FTatolPurAmount");
        fromPurInTB.append(",FTatolPurInAmount FTatolPurInAmount");
        fromPurInTB.append(",0 FTatolAPAmount");
        fromPurInTB.append(",0 FTatolPayAmount");
        fromPurInTB.append(",0 FTatolPurTimes");
        fromPurInTB.append("\n from ");
        fromPurInTB.append(params.getString("PurInTable"));
        return fromPurInTB.toString();
    }

    private String getfromOtherSQL(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer fromOtherTB = new StringBuffer();
        fromOtherTB.append(this.getAPAmountSQL(ctx, params, 0));
        fromOtherTB.append("\n union all ");
        fromOtherTB.append(this.getAPAmountSQL(ctx, params, 1));
        return fromOtherTB.toString();
    }

    private String getfromPurTimesSQL(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer fromPurTimesTB = new StringBuffer();
        fromPurTimesTB.append(" select  ");
        fromPurTimesTB.append("FSupplierID FSupplierID,FCompanyORGUnitID FCompanyORGUnitID");
        fromPurTimesTB.append(",0 FApBalance");
        fromPurTimesTB.append("\n ,0 FLastPurAmount");
        fromPurTimesTB.append(",CONVERT(DATETIME,null) FLastPurDate");
        fromPurTimesTB.append("\n ,0 FLastPayAmount");
        fromPurTimesTB.append(",CONVERT(DATETIME,null) FLastPayDate");
        fromPurTimesTB.append("\n ,0 FPurAmount");
        fromPurTimesTB.append(",0 FPurInAmount");
        fromPurTimesTB.append(",0 FAPAmount");
        fromPurTimesTB.append(",0 FPayAmount");
        fromPurTimesTB.append(",FPurTimes FPurTimes");
        fromPurTimesTB.append("\n ,0 FTatolPurAmount");
        fromPurTimesTB.append(",0 FTatolPurInAmount");
        fromPurTimesTB.append(",0 FTatolAPAmount");
        fromPurTimesTB.append(",0 FTatolPayAmount");
        fromPurTimesTB.append(",FTatolPurTimes FTatolPurTimes");
        fromPurTimesTB.append("\n from ");
        fromPurTimesTB.append(params.getString("PurTimesTable"));
        return fromPurTimesTB.toString();
    }

    private String getResultDataSQL(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer resultfromTemSQL = new StringBuffer();
        resultfromTemSQL.append(" insert into ");
        resultfromTemSQL.append(params.getString("TempResultTable"));
        resultfromTemSQL.append("\n select ");
        resultfromTemSQL.append("\n temp.FSupplierID,temp.FCompanyORGUnitID");
        resultfromTemSQL.append("\n ,'NotTotal' FTotalFlag");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FApBalance),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FApBalance),28,10) END) FApBalance");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FLastPurAmount),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FLastPurAmount),28,10) END) FLastPurAmount");
        resultfromTemSQL.append("\n ,max(temp.FLastPurDate) FLastPurDate");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FLastPayAmount),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FLastPayAmount),28,10) END) FLastPayAmount");
        resultfromTemSQL.append("\n \n ,max(temp.FLastPayDate) FLastPayDate");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FPurAmount),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FPurAmount),28,10) END) FPurAmount");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FPurInAmount),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FPurInAmount),28,10) END) FPurInAmount");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FAPAmount),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FAPAmount),28,10) END) FAPAmount");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FPayAmount),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FPayAmount),28,10) END) FPayAmount");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FPurTimes),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FPurTimes),28,10) END) FPurTimes");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FTatolPurAmount),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FTatolPurAmount),28,10) END) FTatolPurAmount");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FTatolPurInAmount),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FTatolPurInAmount),28,10) END) FTatolPurInAmount");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FTatolAPAmount),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FTatolAPAmount),28,10) END) FTatolAPAmount");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FTatolPayAmount),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FTatolPayAmount),28,10) END) FTatolPayAmount");
        resultfromTemSQL.append("\n ,(CASE WHEN decimal(sum(temp.FTatolPurTimes),28,10) IS NULL THEN 0 ELSE decimal(sum(temp.FTatolPurTimes),28,10) END) FTatolPurTimes");
        resultfromTemSQL.append("\n from (");
        resultfromTemSQL.append(this.getfromLastPurSQL(ctx, params));
        resultfromTemSQL.append("\n union all ");
        resultfromTemSQL.append(this.getfromLastPaySQL(ctx, params));
        resultfromTemSQL.append("\n union all ");
        resultfromTemSQL.append(this.getfromPaySQL(ctx, params));
        resultfromTemSQL.append("\n union all ");
        resultfromTemSQL.append(this.getfromPurSQL(ctx, params));
        resultfromTemSQL.append("\n union all ");
        resultfromTemSQL.append(this.getfromPurInSQL(ctx, params));
        resultfromTemSQL.append("\n union all ");
        resultfromTemSQL.append(this.getfromOtherSQL(ctx, params));
        resultfromTemSQL.append("\n union all ");
        resultfromTemSQL.append(this.getfromPurTimesSQL(ctx, params));
        resultfromTemSQL.append("\n union all ");
        resultfromTemSQL.append(this.getfromApBalanceSQL(ctx, params));
        resultfromTemSQL.append(") temp ");
        resultfromTemSQL.append("\n group by ");
        resultfromTemSQL.append("\n temp.FSupplierID,temp.FCompanyORGUnitID");
        resultfromTemSQL.append("\n having");
        resultfromTemSQL.append("\n sum(temp.FLastPurAmount) > 0");
        resultfromTemSQL.append(" or sum(temp.FLastPayAmount)> 0");
        resultfromTemSQL.append(" or sum(temp.FPurAmount) > 0");
        resultfromTemSQL.append(" or sum(temp.FPurInAmount) > 0");
        resultfromTemSQL.append(" or sum(temp.FAPAmount) > 0");
        resultfromTemSQL.append(" or sum(temp.FPayAmount) > 0 ");
        resultfromTemSQL.append(" or sum(temp.FPurTimes) > 0");
        resultfromTemSQL.append(" or sum(temp.FTatolPurAmount) > 0");
        resultfromTemSQL.append(" or sum(temp.FTatolPurInAmount) > 0");
        resultfromTemSQL.append(" or sum(temp.FTatolAPAmount) > 0");
        resultfromTemSQL.append(" or sum(temp.FTatolPayAmount) > 0");
        resultfromTemSQL.append(" or sum(temp.FTatolPurTimes) > 0");
        return resultfromTemSQL.toString();
    }

    private void createTBAndInsertLastPayData(Context ctx, String lastPayTableName, RptParams params) throws BOSException, EASBizException {
        this.buildLastPayTable(ctx, lastPayTableName);
        String sql = this.getLastPaidMentSQL(ctx, params);
        SqlParams purTotalSqlParams = new SqlParams();
        this.setSupplierIntegraData(purTotalSqlParams, params, 2);
        this.executeUpdate(sql, purTotalSqlParams, ctx);
    }

    private void insertLastPayData(Context ctx, String lastPayTableName, RptParams params) throws BOSException, EASBizException {
        String sql = this.getLastPaidMentSQL(ctx, params);
        SqlParams purTotalSqlParams = new SqlParams();
        this.setSupplierIntegraData(purTotalSqlParams, params, 2);
        this.executeUpdate(sql, purTotalSqlParams, ctx);
    }

    private void insertLastPurData(Context ctx, String lastPayTableName, RptParams params) throws BOSException, EASBizException {
        String lastPurSql = this.getLastPurchaseSQL(ctx, params);
        SqlParams purTotalSqlParams = new SqlParams();
        this.executeUpdate(lastPurSql, purTotalSqlParams, ctx);
    }

    private void setSupplierIntegraData(SqlParams sqlParams, RptParams params, int n) {
        int count = sqlParams.size() + 1;
        for (int i = 1; i <= n; ++i) {
            if (params.getString("SupplierTo") == null) continue;
            sqlParams.setString(count++, params.getString("SupplierTo"));
        }
    }

    private void createTBAndInsertPayData(Context ctx, String payTableName, RptParams params) throws BOSException, EASBizException {
        String orgTableName = params.getString("CompanyTempTable");
        this.buildPayTable(ctx, payTableName);
        StringBuffer sqlBF = new StringBuffer();
        sqlBF.append(" insert into ");
        sqlBF.append(payTableName);
        sqlBF.append(this.getPaymentSQL(ctx, params, orgTableName, 0));
        sqlBF.append(" union all ");
        sqlBF.append(this.getPaymentSQL(ctx, params, orgTableName, 1));
        SqlParams purTotalSqlParams = new SqlParams();
        this.setSupplierIntegraData(purTotalSqlParams, params, 2);
        this.executeUpdate(sqlBF.toString(), purTotalSqlParams, ctx);
    }

    private void insertPayData(Context ctx, String payTableName, RptParams params) throws BOSException, EASBizException {
        String orgTableName = params.getString("CompanyTempTable");
        StringBuffer sqlBF = new StringBuffer();
        sqlBF.append(" insert into ");
        sqlBF.append(payTableName);
        sqlBF.append(this.getPaymentSQL(ctx, params, orgTableName, 0));
        SqlParams purTotalSqlParams = new SqlParams();
        this.setSupplierIntegraData(purTotalSqlParams, params, 1);
        Boolean isDispTotal = new Boolean(params.getString("IsShowAllPurchase"));
        if (isDispTotal.booleanValue()) {
            sqlBF.append(" union all ");
            sqlBF.append(this.getPaymentSQL(ctx, params, orgTableName, 1));
            this.setSupplierIntegraData(purTotalSqlParams, params, 1);
        }
        this.executeUpdate(sqlBF.toString(), purTotalSqlParams, ctx);
    }

    private void insertApBalanceData(Context ctx, String apBalanceTableName, RptParams params) throws BOSException, EASBizException {
        IArSysFacade arSysFacade = ArSysFacadeFactory.getLocalInstance((Context)ctx);
        arSysFacade.getApBalance(apBalanceTableName, params);
    }

    private void insertPurData(Context ctx, String purTableName, RptParams params) throws BOSException, EASBizException {
        String orgTableName = params.getString("CompanyTempTable");
        StringBuffer sqlBF = new StringBuffer();
        SqlParams purTotalSqlParams = new SqlParams();
        sqlBF.append(" insert into ");
        sqlBF.append(purTableName);
        sqlBF.append(this.getCurPurchaseAMTSQL(ctx, params, orgTableName, 0));
        Boolean isDispTotal = new Boolean(params.getString("IsShowAllPurchase"));
        if (isDispTotal.booleanValue()) {
            sqlBF.append(" union all ");
            sqlBF.append(this.getPurchaseAMTSQL(ctx, params, orgTableName, 1));
            purTotalSqlParams.clear();
            this.setSupplierIntegraData(purTotalSqlParams, params, 1);
        }
        this.executeUpdate(sqlBF.toString(), purTotalSqlParams, ctx);
    }

    private void insertCurPurData(Context ctx, String insertCurPurData, RptParams params) throws BOSException, EASBizException {
        StringBuffer sqlBF = new StringBuffer();
        SqlParams purTotalSqlParams = new SqlParams();
        sqlBF.append(" insert into ");
        sqlBF.append(insertCurPurData);
        sqlBF.append(this.getCurPurOrderDataSQL(ctx, params));
        this.setSupplierIntegraData(purTotalSqlParams, params, 1);
        this.executeUpdate(sqlBF.toString(), purTotalSqlParams, ctx);
    }

    private void createTBAndInsertPurInData(Context ctx, String PurInTableName, RptParams params) throws BOSException, EASBizException {
        String orgTableName = params.getString("CompanyTempTable");
        this.buildPurInTable(ctx, PurInTableName);
        StringBuffer purInSQL = new StringBuffer();
        purInSQL.append(" insert into ");
        purInSQL.append(PurInTableName);
        purInSQL.append(this.getPurInWarehsSQL(ctx, params, 0));
        purInSQL.append(" union all ");
        purInSQL.append(this.getPurInWarehsSQL(ctx, params, 1));
        SqlParams purTotalSqlParams = new SqlParams();
        this.setSupplierIntegraData(purTotalSqlParams, params, 2);
        this.executeUpdate(purInSQL.toString(), purTotalSqlParams, ctx);
    }

    private void insertPurInData(Context ctx, String PurInTableName, RptParams params) throws BOSException, EASBizException {
        StringBuffer purInSQL = new StringBuffer();
        purInSQL.append(" insert into ");
        purInSQL.append(PurInTableName);
        purInSQL.append(this.getPurInWarehsSQL(ctx, params, 0));
        SqlParams purTotalSqlParams = new SqlParams();
        this.setSupplierIntegraData(purTotalSqlParams, params, 1);
        Boolean isDispTotal = new Boolean(params.getString("IsShowAllPurchase"));
        if (isDispTotal.booleanValue()) {
            purInSQL.append(" union all ");
            purInSQL.append(this.getPurInWarehsSQL(ctx, params, 1));
            this.setSupplierIntegraData(purTotalSqlParams, params, 1);
        }
        this.executeUpdate(purInSQL.toString(), purTotalSqlParams, ctx);
    }

    private void insertPurTimesData(Context ctx, String purTimesTableName, RptParams params) throws BOSException, EASBizException {
        StringBuffer sqlBF = new StringBuffer();
        sqlBF.append(" insert into ");
        sqlBF.append(purTimesTableName);
        sqlBF.append("\n ");
        sqlBF.append(this.getPurchaseTimesSQL(ctx, params, 0));
        SqlParams purTotalSqlParams = new SqlParams();
        this.setSupplierIntegraData(purTotalSqlParams, params, 1);
        Boolean isDispTotal = new Boolean(params.getString("IsShowAllPurchase"));
        if (isDispTotal.booleanValue()) {
            sqlBF.append("\n union all ");
            sqlBF.append("\n ");
            sqlBF.append(this.getPurchaseTimesSQL(ctx, params, 1));
            this.setSupplierIntegraData(purTotalSqlParams, params, 1);
        }
        this.executeUpdate(sqlBF.toString(), purTotalSqlParams, ctx);
    }

    private String APBalance() {
        return "";
    }

    private void buildLastPayTable(Context ctx, String lsPayTB) throws BOSException {
        this.executeSQL(ctx, this.buildLastPayTableSql(lsPayTB));
    }

    private String buildLastPayTableSql(String lsPayTB) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + lsPayTB + " (");
        sqlbf.append(" \r\n fid varchar(44)");
        sqlbf.append(" \r\n ,FSupplierID Varchar(44)");
        sqlbf.append(" \r\n ,FCompanyORGUnitID Varchar(44)");
        sqlbf.append(" \r\n ,FLastPayAmount Decimal(28,10) not null default(0) ");
        sqlbf.append(" \r\n ,FLastPayDate DateTime");
        sqlbf.append(")");
        return sqlbf.toString();
    }

    private void buildLastPurTable(Context ctx, String lsPurTB) throws BOSException {
        this.executeSQL(ctx, this.buildLastPurTableSql(lsPurTB));
    }

    private String buildLastPurTableSql(String lsPurTB) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + lsPurTB + " (");
        sqlbf.append(" \r\n fid varchar(44)");
        sqlbf.append(" \r\n ,FSupplierID Varchar(44)");
        sqlbf.append(" \r\n ,FCompanyORGUnitID Varchar(44)");
        sqlbf.append(" \r\n ,FLastPurAmount Decimal(28,10) not null default(0) ");
        sqlbf.append(" \r\n ,FLastPurDate DateTime");
        sqlbf.append(")");
        return sqlbf.toString();
    }

    private void buildPayTable(Context ctx, String lsPayTB) throws BOSException {
        this.executeSQL(ctx, this.buildPayTableSql(lsPayTB));
    }

    private String buildPayTableSql(String lsPayTB) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + lsPayTB + " (");
        sqlbf.append(" \r\n fid varchar(44)");
        sqlbf.append(" \r\n ,FSupplierID Varchar(44)");
        sqlbf.append(" \r\n ,FCompanyORGUnitID Varchar(44)");
        sqlbf.append(" \r\n ,FPayAmount Decimal(28,10) not null default(0) ");
        sqlbf.append(" \r\n ,FTatolPayAmount Decimal(28,10) not null default(0) ");
        sqlbf.append(")");
        return sqlbf.toString();
    }

    private void buildApBalanceTable(Context ctx, String lsPayTB) throws BOSException {
        this.executeSQL(ctx, this.buildApBalanceTableSql(lsPayTB));
    }

    private String buildApBalanceTableSql(String lsPayTB) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + lsPayTB + " (");
        sqlbf.append(" \r\n fid varchar(44)");
        sqlbf.append(" \r\n ,FSupplierID Varchar(44)");
        sqlbf.append(" \r\n ,FCompanyORGUnitID Varchar(44)");
        sqlbf.append(" \r\n ,FDebit decimal(28, 10) NOT NULL DEFAULT 0");
        sqlbf.append(" \r\n ,FApBalance decimal(28, 10) NOT NULL DEFAULT 0");
        sqlbf.append(" \r\n ,FBalance Decimal(28,10) not null default(0)");
        sqlbf.append(" \r\n ,FIsFinal int default 0");
        sqlbf.append(")");
        return sqlbf.toString();
    }

    private void buildPurchaseTable(Context ctx, String lsPayTB) throws BOSException {
        this.executeSQL(ctx, this.buildPurchaseTableSql(lsPayTB));
    }

    private String buildPurchaseTableSql(String lsPayTB) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + lsPayTB + " (");
        sqlbf.append(" \r\n fid varchar(44)");
        sqlbf.append(" \r\n ,FSupplierID Varchar(44)");
        sqlbf.append(" \r\n ,FCompanyORGUnitID Varchar(44)");
        sqlbf.append(" \r\n ,FPurAmount Decimal(28,10) not null default(0) ");
        sqlbf.append(" \r\n ,FTatolPurAmount Decimal(28,10) not null default(0) ");
        sqlbf.append(")");
        return sqlbf.toString();
    }

    private String buildCurPurTableSql(String lsPayTB) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + lsPayTB + " (");
        sqlbf.append(" \r\n fid varchar(44)");
        sqlbf.append(" \r\n ,fpurorderid varchar(44)");
        sqlbf.append(" \r\n ,FSupplierID Varchar(44)");
        sqlbf.append(" \r\n ,FCompanyORGUnitID Varchar(44)");
        sqlbf.append(" \r\n ,FLocalTotalTaxAmount Decimal(28,10) not null default(0) ");
        sqlbf.append(" \r\n ,flocalTaxAmount Decimal(28,10) not null default(0) ");
        sqlbf.append(" \r\n ,FLevel int");
        sqlbf.append(" \r\n ,FBizDate DateTime");
        sqlbf.append(")");
        return sqlbf.toString();
    }

    private void buildPurInTable(Context ctx, String purInTB) throws BOSException {
        this.executeSQL(ctx, this.buildPurInTableSql(purInTB));
    }

    private String buildPurInTableSql(String purInTB) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + purInTB + " (");
        sqlbf.append(" \r\n fid varchar(44)");
        sqlbf.append(" \r\n ,FSupplierID Varchar(44)");
        sqlbf.append(" \r\n ,FCompanyORGUnitID Varchar(44)");
        sqlbf.append(" \r\n ,FPurInAmount");
        sqlbf.append(" Decimal(28,10) not null default(0)");
        sqlbf.append(" \r\n ,FTatolPurInAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append(")");
        return sqlbf.toString();
    }

    private void buildPurTimesTable(Context ctx, String purTimesTB) throws BOSException {
        this.executeSQL(ctx, this.buildPurTimesTableSql(purTimesTB));
    }

    private String buildPurTimesTableSql(String purTimesTB) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + purTimesTB + " (");
        sqlbf.append(" \r\n fid varchar(44)");
        sqlbf.append(" \r\n ,FSupplierID Varchar(44)");
        sqlbf.append(" \r\n ,FCompanyORGUnitID Varchar(44)");
        sqlbf.append(" \r\n ,FPurTimes int ");
        sqlbf.append(" \r\n ,FTatolPurTimes int");
        sqlbf.append(")");
        return sqlbf.toString();
    }

    private String getAPType(Context ctx, RptParams params, int type) {
        String DateStart = params.getString("DateStart");
        String DateEnd = params.getString("DateEnd");
        StringBuffer DateDuring = new StringBuffer();
        if (type == 0) {
            if (DateStart != null && DateEnd != null) {
                DateDuring.append("And FBillDate>='").append(DateStart).append("'").append(" AND FBillDate<='").append(DateEnd).append("' ");
            } else if (DateStart == null && DateEnd != null) {
                DateDuring.append("And FBillDate<='").append(DateEnd).append("' ");
            } else if (DateStart != null && DateEnd == null) {
                DateDuring.append("And FBillDate>='").append(DateStart).append("' ");
            }
        } else if (type == 1 && DateEnd != null) {
            DateDuring.append("And FBillDate<='").append(DateEnd).append("' ");
        }
        String OtherBill = "(select FAsstActID,FTotalTaxAmount AS FAmountLocal,FCompanyID from T_AP_OTHERBILL where FBillStatus=3 and FIsInitializeBill=0 and FBillType=202 " + DateDuring + ") AS OTHERBILL";
        String AP = "(select T_BD_Supplier.FID AS SupplierID,OTHERBILL.FCompanyID AS CID,SUM(OTHERBILL.FAmountLocal) AS APAmt from T_BD_Supplier LEFT JOIN  " + OtherBill + " ON T_BD_Supplier.FID=OTHERBILL.FAsstActID group by T_BD_Supplier.FID,OTHERBILL.FCompanyID) AS ";
        if (type == 1) {
            AP = AP + "TotalAP";
        }
        if (type == 0) {
            AP = AP + "DuringAP";
        }
        return AP;
    }

    private String getTotalAPAmtSQL(Context ctx, RptParams params, String OrgTable) {
        String totalAp = this.getAPType(ctx, params, 1);
        String SupplierOrg = this.SupplierAndCompany(ctx, params, OrgTable);
        String sql = "(select SupplierOrg.SupplierID AS SupplierID,SupplierOrg.OrgID AS CID,TotalAP.APAmt AS APAmt from " + SupplierOrg + " left join " + totalAp + " ON SupplierOrg.SupplierID=TotalAP.SupplierID  And SupplierOrg.OrgID=TotalAP.CID) AS ToTalAPAmt";
        return sql;
    }

    private String getDuringAPAmtSQL(Context ctx, RptParams params, String OrgTable) {
        String duringAp = this.getAPType(ctx, params, 0);
        String SupplierOrg = this.SupplierAndCompany(ctx, params, OrgTable);
        String sql = " select SupplierOrg.SupplierID AS SupplierID,SupplierOrg.OrgID AS CID,DuringAP.APAmt AS APAmt from " + SupplierOrg + " left join " + duringAp + " ON SupplierOrg.SupplierID=DuringAP.SupplierID  And SupplierOrg.OrgID=DuringAP.CID ";
        return sql;
    }

    private String getAPAmountSQL(Context ctx, RptParams params, int type) {
        String beginDate = params.getString("DateStart");
        String endDate = params.getString("DateEnd");
        StringBuffer queryStr = new StringBuffer();
        if (type == 0) {
            queryStr.append("otherBill.FBizDate  >= {" + beginDate + "} and otherBill.FBizDate <= {" + endDate + "}");
        } else {
            queryStr.append("otherBill.FBizDate <= {" + endDate + "}");
        }
        queryStr.append(" and (otherBill.FBillStatus =3 ");
        queryStr.append(" and otherBill.FIsInitializeBill=0 ");
        queryStr.append(" and otherBill.FBillType=202 )");
        queryStr.append(" and company.FIsleaf = 1 ");
        if (params.getObject("SupplierFrom") != null) {
            queryStr.append(this.getSupplierFromFilter(params.getObject("SupplierFrom"), "supplier"));
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and supplier.FNumber <= '");
            queryStr.append(params.getString("SupplierTo") + "'");
        }
        queryStr.append(" and otherBill.fBizTypeID = '").append("d8e80652-0106-1000-e000-04c5c0a812202407435C").append("'");
        StringBuffer payAmount = new StringBuffer();
        payAmount.append(" select supplier.fid FSupplierID,company.fid FCompanyORGUnitID");
        payAmount.append(",0 FApBalance");
        payAmount.append(",0 FLastPurAmount");
        payAmount.append(",CONVERT(DATETIME,null) FLastPurDate");
        payAmount.append(",0 FLastPayAmount");
        payAmount.append(",CONVERT(DATETIME,null) FLastPayDate");
        payAmount.append(",0 FPurAmount");
        payAmount.append(",0 FPurInAmount");
        if (type == 0) {
            payAmount.append(",otherBill.FAmount FApAmount");
        } else if (type == 1) {
            payAmount.append(",0 FApAmount");
        }
        payAmount.append(",0 FPayAmount");
        payAmount.append(",0 FPurTimes");
        payAmount.append(",0 FTatolPurAmount");
        payAmount.append(",0 FTatolPurInAmount");
        if (type == 0) {
            payAmount.append(",0 FTatolAPAmount");
        } else if (type == 1) {
            payAmount.append(",otherBill.FAmount FTatolAPAmount");
        }
        payAmount.append(",0 FTatolPayAmount");
        payAmount.append(",0 FTatolPurTimes");
        payAmount.append("\n from T_AP_OTHERBILL otherBill ");
        payAmount.append("\n inner join t_bd_supplier supplier ");
        payAmount.append(" on otherBill.FAsstActID = supplier.fid ");
        payAmount.append("\n inner join ");
        payAmount.append(params.getString("CompanyTempTable"));
        payAmount.append(" company on otherBill.FCompanyID=company.fid ");
        payAmount.append("\n where ");
        payAmount.append(queryStr.toString());
        return payAmount.toString();
    }

    private String getPurInWarehsSQL(Context ctx, RptParams params, int type) {
        String beginDate = params.getString("DateStart");
        String endDate = params.getString("DateEnd");
        String orgTableName = params.getString("CompanyTempTable");
        StringBuffer queryStr = new StringBuffer();
        if (type == 0) {
            queryStr.append("PurIn.FBizDate  >= {" + beginDate + "} and PurIn.FBizDate <= {" + endDate + "}");
        } else {
            queryStr.append("PurIn.FBizDate <= {" + endDate + "}");
        }
        queryStr.append(" and (PurIn.FBaseStatus =4 ");
        queryStr.append(" And PurIn.FIsInitBill=0 ) ");
        queryStr.append(" and company.FIsleaf = 1 ");
        if (params.getObject("SupplierFrom") != null) {
            queryStr.append(this.getSupplierFromFilter(params.getObject("SupplierFrom"), "supplier"));
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and supplier.FNumber <= ? ");
        }
        StringBuffer payAmount = new StringBuffer();
        payAmount.append(" select newbosid('88888888') FID,supplier.fid FsupplierID,company.fid FCompanyID");
        if (type == 0) {
            payAmount.append(",sum(PurEntry.FLocalTaxAmount) FPurAmt");
            payAmount.append(",0 FTatolPurAmt");
        } else {
            payAmount.append(",0 FpurAmt");
            payAmount.append(",sum(PurEntry.FLocalTaxAmount) FTatolpurAmt");
        }
        payAmount.append("\n from T_IM_PurInWarehsBill PurIn");
        payAmount.append("\n LEFT OUTER join T_ORG_Storage storage ");
        payAmount.append(" on purin.FStorageOrgUnitID = storage.fid");
        payAmount.append(" inner join T_ORG_UnitRelation r");
        payAmount.append(" on PurIn.FStorageOrgUnitID=r.FFromUnitID");
        payAmount.append(" inner join T_ORG_TypeRelation t");
        payAmount.append(" on  r.FTypeRelationID=t.FID ");
        payAmount.append(" and t.FFromType=4 and t.FToType=1");
        payAmount.append("  LEFT OUTER join ");
        payAmount.append(orgTableName);
        payAmount.append(" company on r.FToUnitID=company.fid");
        payAmount.append("\n inner join t_bd_supplier supplier ");
        payAmount.append(" on purin.fSupplierid = supplier.fid ");
        payAmount.append("\n inner join  T_IM_PurInWarehsentry PurEntry ");
        payAmount.append(" on  PurIn.fid =  PurEntry.fparentid ");
        payAmount.append("\n where ");
        payAmount.append(queryStr.toString());
        payAmount.append(" and PurIn.FPurchaseType = 0 ");
        payAmount.append("\n group by Supplier.fid,company.fid,company.FLevel");
        return payAmount.toString();
    }

    private String getCurPurchaseAMTSQL(Context ctx, RptParams params, String OrgTable, int type) {
        String curPurDataTable = params.getString("curPurTable");
        StringBuffer payAmount = new StringBuffer();
        payAmount.append(" select newbosid('88888888'),FSupplierID ,FCompanyOrgUnitID ");
        payAmount.append(",sum(flocalTaxAmount) FPurAmt");
        payAmount.append(",0 FTatolPurAmt");
        payAmount.append("\n from (select  fpurorderid fid,flocalTaxAmount flocalTaxAmount,  FSupplierID,FCompanyORGUnitID FCompanyOrgUnitID,FLevel FLevel");
        payAmount.append("\n from  ").append(curPurDataTable);
        payAmount.append("\n )temp ");
        payAmount.append("\n group by FSupplierID,FCompanyOrgUnitID,FLevel");
        payAmount.append("\n having sum(flocalTaxAmount) >0");
        return payAmount.toString();
    }

    private String getPurchaseTimesSQL(Context ctx, RptParams params, int type) {
        String company = params.getString("CompanyTempTable");
        String DateStart = params.getString("DateStart");
        String DateEnd = params.getString("DateEnd");
        StringBuffer queryStr = new StringBuffer();
        if (type == 0) {
            if (DateStart != null && DateEnd != null) {
                queryStr.append("  FBizDate>={").append(DateStart).append("}").append(" AND FBizDate<={").append(DateEnd).append("} ");
            } else if (DateStart == null && DateEnd != null) {
                queryStr.append(" FBizDate<={").append(DateEnd).append("} ");
            } else if (DateStart != null && DateEnd == null) {
                queryStr.append("  FBizDate>={").append(DateStart).append("} ");
            }
        } else if (type == 1 && DateEnd != null) {
            queryStr.append("  FBizDate<={").append(DateEnd).append("} ");
        }
        queryStr.append(" and purIn.FBaseStatus =4 ");
        queryStr.append(" and  (purIn.FIsReversed=0 or  purIn.FIsReversed is null ) ");
        if (params.getObject("SupplierFrom") != null) {
            queryStr.append(this.getSupplierFromFilter(params.getObject("SupplierFrom"), "supplier"));
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and supplier.FNumber <= ? ");
        }
        queryStr.append("and purIn.FTOTALAMOUNT > 0 ");
        queryStr.append("and purIn.fisSysBill = 0 ");
        StringBuffer purTimesSQL = new StringBuffer();
        purTimesSQL.append(" select newbosid('88888888')");
        purTimesSQL.append(",supplier.fid,company.fid");
        if (type == 0) {
            purTimesSQL.append(",count(*) FPurTimes");
            purTimesSQL.append(",0 FTatolPurTimes");
        } else if (type == 1) {
            purTimesSQL.append(",0 FPurTimes");
            purTimesSQL.append(",count(*) FTatolPurTimes");
        }
        purTimesSQL.append("\n from T_IM_PurInWarehsBill purIn ");
        purTimesSQL.append("\n inner join  t_scm_transactiontype transtype ");
        purTimesSQL.append("on purIn.ftransactiontypeid =  transtype.fid ");
        purTimesSQL.append("\n inner join t_bd_supplier supplier ");
        purTimesSQL.append("on purIn.fsupplierid = supplier.fid ");
        purTimesSQL.append("\n inner join T_ORG_Storage storage ");
        purTimesSQL.append("on purIn.FStorageOrgUnitID = storage.fid ");
        purTimesSQL.append("\n  inner join T_ORG_UnitRelation r ");
        purTimesSQL.append(" on purIn.FStorageOrgUnitID=r.FFromUnitID ");
        purTimesSQL.append("\n inner join T_ORG_TypeRelation t ");
        purTimesSQL.append(" on  r.FTypeRelationID=t.FID ");
        purTimesSQL.append(" and t.FFromType=4 and t.FToType=1 ");
        purTimesSQL.append("\n inner join ");
        purTimesSQL.append(params.getString("CompanyTempTable"));
        purTimesSQL.append(" company on r.FToUnitID=company.fid ");
        purTimesSQL.append("\n where ");
        purTimesSQL.append(queryStr.toString());
        purTimesSQL.append(" and PurIn.FPurchaseType = 0 ");
        purTimesSQL.append("\n group by supplier.fid");
        purTimesSQL.append(",company.fid,company.flevel ");
        return purTimesSQL.toString();
    }

    private String getLastPurchaseSQL(Context ctx, RptParams params) {
        String curPurTable = params.getString("curPurTable");
        String lastPurTableName = params.getString("LastPurTable");
        String lastPurchase = " insert into " + lastPurTableName + " select newbosid('88888888'),temp.supplierid supplierid,temp.companyid,sum(temp.FAmt) LastPurAmt,max(temp.purorderBizDate) LastPurDate\n  from( \n select purtable.FSupplierID supplierid,purtable.FCompanyORGUnitID companyid ,purtable.FLevel Flevel ,purtable.flocalTaxAmount FAmt,purtable.FBizDate purorderBizDate\n from  " + curPurTable + "\n purtable  \n inner join (select FSupplierID supplierid ,FLevel,FCompanyORGUnitID companyid,  max(TO_CHAR(FBizDate, 'YYYY-MM-DD HH24:MI:SS')) FMaxTime \n from " + curPurTable + "\n group by FSupplierID,FCompanyORGUnitID,FLevel) lastpur on  purtable.FSupplierID = lastpur.supplierid\tand  purtable.FCompanyORGUnitID = lastpur.companyid and purtable.FLevel =lastpur.FLevel  and (TO_CHAR(purtable.FBizDate, 'YYYY-MM-DD HH24:MI:SS')) = lastpur.FMaxTime \n )temp \n group by temp.supplierid,temp.companyid,temp.Flevel ";
        return lastPurchase;
    }

    private String getLastPaidMentSQL(Context ctx, RptParams params) {
        String orgTableName = params.getString("CompanyTempTable");
        String lastPayTableName = params.getString("LastPayTable");
        String beginDate = params.getString("DateStart");
        String endDate = params.getString("DateEnd");
        StringBuffer queryStr = new StringBuffer();
        queryStr.append("PaymentBill.FBizDate  >= {" + beginDate + "} and PaymentBill.FBizDate <= {" + endDate + "}").append(" AND PaymentBill.FBillStatus IN (12,15) ");
        queryStr.append(" and company.FIsleaf = 1 ");
        if (params.getObject("SupplierFrom") != null) {
            queryStr.append(this.getSupplierFromFilter(params.getObject("SupplierFrom"), "supplier"));
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and supplier.FNumber <= ? ");
        }
        String lastPaydAmount = "insert into " + lastPayTableName + " select newbosid('88888888'),temp.supplierid,temp.companyid ,sum(temp.FActPayLocAmt) FLastPayAmt,Max(temp.FBizDate) LastPayDate\n  from( \n select  supplier.fid supplierid ,company.fid companyid,'DEL' Fflag,company.FLevel Flevel ,0 as FActPayLocAmt,max(PaymentBill.FBizDate) FBizDate \n from T_CAS_PaymentBill PaymentBill \n inner join " + orgTableName + " company on PaymentBill.FCompanyID=company.fid  inner join T_CAS_PaymentBillType payBillType on PaymentBill.fpaybilltypeid = payBillType.FID  and ( payBillType.FNumber ='201'  or payBillType.FNumber ='202') \n inner join t_bd_supplier supplier on PaymentBill.FPayeeID = supplier.fid \n where " + queryStr.toString() + "\n group by supplier.fid,company.fid,company.FLevel \n union all \n select  supplier.fid supplierid,company.fid companyid,'DEL' Fflag,company.FLevel Flevel,PaymentBill.FActPayLocAmt FActPayLocAmt,null FBizDate\n from T_CAS_PaymentBill PaymentBill \n inner join " + orgTableName + " company on PaymentBill.FCompanyID=company.fid \n inner join t_bd_supplier supplier on PaymentBill.FPayeeID = supplier.fid \n inner join (select  supplier.fid supplierid ,company.fid companyid,  max(TO_CHAR(PaymentBill.FBizDate, 'YYYY-MM-DD HH24:MI:SS') || TO_CHAR(PaymentBill.FLastupdateTime, 'YYYY-MM-DD HH24:MI:SS')) FMaxTime \n from T_CAS_PaymentBill PaymentBill \n inner join " + orgTableName + " company on PaymentBill.FCompanyID=company.fid  inner join T_CAS_PaymentBillType payBillType on PaymentBill.FPayBillTypeID = payBillType.FID  and ( payBillType.FNumber ='201'  or payBillType.FNumber ='202') \n inner join t_bd_supplier supplier on PaymentBill.FPayeeID = supplier.fid \n where " + queryStr.toString() + "\n\tgroup by supplier.fid,company.fid) d on  supplier.fid = d.supplierid\tand  company.fid = d.companyid  and (TO_CHAR(PaymentBill.FBizDate, 'YYYY-MM-DD HH24:MI:SS') || TO_CHAR(PaymentBill.FLastupdateTime, 'YYYY-MM-DD HH24:MI:SS')) = d.FMaxTime \n ) temp \n group by temp.supplierid,temp.companyid,temp.Fflag,temp.Flevel ";
        return lastPaydAmount;
    }

    private String SupplierAndCompany(Context ctx, RptParams params, String OrgTable) {
        String language = ctx.getLocale().getLanguage();
        int MAXlevel = (Integer)params.getObject(this.maxLevelStr);
        Object supplierNoFrom = params.getObject("SupplierFrom");
        String supplierNoTo = params.getString("SupplierTo");
        StringBuffer SupplierNo = new StringBuffer();
        SupplierNo.append(" where 1=1 ");
        if (supplierNoFrom != null) {
            SupplierNo.append(this.getSupplierFromFilter(params.getObject("SupplierFrom"), "s"));
        }
        if (!StringUtils.isEmpty((String)supplierNoTo)) {
            SupplierNo.append(" and s.FNumber<='").append(supplierNoTo);
        }
        String str = "(select distinct s.FID AS SupplierID,o.FID AS OrgID,s.Fname_" + language + " AS SupplierName,s.FNumber AS SupplierNO from " + OrgTable + " o,T_BD_Supplier s " + SupplierNo + " and o.FLevel=" + MAXlevel + ") AS SupplierOrg";
        return str;
    }

    private String getPaymentSQL(Context ctx, RptParams params, String OrgTable, int type) {
        String DateStart = params.getString("DateStart");
        String DateEnd = params.getString("DateEnd");
        String beginDate = params.getString("DateStart");
        String endDate = params.getString("DateEnd");
        StringBuffer queryStr = new StringBuffer();
        if (type == 0) {
            queryStr.append("PaymentBill.FBizDate  >= {" + beginDate + "} and PaymentBill.FBizDate <= {" + endDate + "}");
        } else {
            queryStr.append("PaymentBill.FBizDate <= {" + endDate + "}");
        }
        queryStr.append(" AND PaymentBill.FBillStatus IN (12,15) ");
        queryStr.append(" and company.FIsleaf = 1 ");
        if (params.getObject("SupplierFrom") != null) {
            queryStr.append(this.getSupplierFromFilter(params.getObject("SupplierFrom"), "supplier"));
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and supplier.FNumber <= ? ");
        }
        StringBuffer payAmount = new StringBuffer();
        payAmount.append(" select newbosid('88888888'),supplier.fid,company.fid");
        if (type == 0) {
            payAmount.append(",sum(paymentBillEntry.FActualLocAmt) FPaymentAmt");
            payAmount.append(",0 FTatolPaymentAmt");
        } else {
            payAmount.append(",0 FPaymentAmt");
            payAmount.append(",sum(paymentBillEntry.FActualLocAmt) FTatolPaymentAmt");
        }
        payAmount.append("\n from T_cas_PaymentBill paymentBill ");
        payAmount.append("\n inner join T_CAS_PaymentBillEntry paymentBillEntry on paymentBillEntry.FPaymentBillID = paymentBill.fid ");
        payAmount.append("\n inner join T_SCM_BillType billType on paymentBillEntry.FCoreBillTypeId = billType.fid ");
        payAmount.append(" and billType.FNumber in ('101','103','210','220','240','250','260','270','271','200') ");
        payAmount.append("\n inner join t_bd_supplier supplier on paymentBill.FPayeeID = supplier.fid ");
        payAmount.append("\n inner join ");
        payAmount.append(params.getString("CompanyTempTable"));
        payAmount.append(" company on paymentBill.FCompanyID=company.fid ");
        payAmount.append("\n where ");
        payAmount.append(queryStr.toString());
        payAmount.append("\n group by supplier.fid,company.fid,company.FLevel");
        payAmount.append("\n having sum(paymentBill.FActPayLocAmt) >0");
        return payAmount.toString();
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        CurrencyInfo cc = this.getCurrencyInfo(ctx, params);
        String language = ctx.getLocale().getLanguage();
        StringBuffer sqlBuffer = this.getDisplaySQL(ctx, params);
        sqlBuffer.append(" org.flevel=1 ");
        sqlBuffer.append(" order by ");
        sqlBuffer.append(" temp.FSupplierID");
        sqlBuffer.append(",supplier.FNumber");
        sqlBuffer.append(",supplier.fname_" + language);
        sqlBuffer.append(",temp.FCompanyORGUnitID");
        sqlBuffer.append(",org.fparentid");
        sqlBuffer.append(",org.flevel");
        sqlBuffer.append(",org.fisleaf");
        sqlBuffer.append(",org.fNumber");
        sqlBuffer.append(",org.fname_" + language);
        RptRowSet rs = this.executeQuery(sqlBuffer.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("Currency", (Object)cc);
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCom = null;
        Object obj = null;
        Object[] infos = (Object[])params.getObject("fullCompanyOrgUnit");
        if (infos.length == 0) {
            return new CurrencyInfo();
        }
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)infos[i]).get("isleaf");
            boolean fisleaf = isleaf != false;
            if (!fisleaf) continue;
            obj = infos[i];
        }
        if (obj == null) {
            return null;
        }
        try {
            ICompanyOrgUnit ie = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            currCom = ie.getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(((FullOrgUnitInfo)obj).getId().toString()));
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        CurrencyInfo c = currCom.getBaseCurrency();
        if (currCom.getBaseCurrency() != null && currCom.getBaseCurrency().getId() != null && (currCom.getBaseCurrency().getName() == null || currCom.getBaseCurrency().getPrecision() <= 0)) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("name"));
            selectors.add(new SelectorItemInfo("precision"));
            ICurrency ie = null;
            ie = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
            c = ie.getCurrencyInfo((IObjectPK)new ObjectStringPK(currCom.getBaseCurrency().getId().toString()), selectors);
        }
        return c;
    }

    private void totalByOrg(Context ctx, String resultTable, String orgTable, RptParams params) throws BOSException {
        int level = (Integer)params.getObject(this.maxLevelStr);
        StringBuffer batchSql = new StringBuffer(1024);
        StringBuffer sql = new StringBuffer();
        for (int i = level; i > 1; --i) {
            sql.append(this.getInstLastPaySql(resultTable, orgTable, params, i));
            batchSql.append(sql.toString()).append(";");
            sql.setLength(0);
            sql.append(this.getInstLastPurSql(resultTable, orgTable, params, i));
            batchSql.append(sql.toString()).append(";");
            sql.setLength(0);
            String insertCusAndCompsql = this.getInsResultTBSql(resultTable, orgTable, params, i);
            batchSql.append(insertCusAndCompsql.toString()).append(";");
        }
        if (batchSql.length() > 0) {
            this.executeBatchUpdate(ctx, batchSql.toString().split(";"));
        }
    }

    private String getInsResultTBSql(String tempSumTable, String orgTable, RptParams params, int i) {
        StringBuffer insertCusAndCompsql = new StringBuffer();
        String lsPurTBName = params.getString("LastPurTable");
        String lsPayTBName = params.getString("LastPayTable");
        insertCusAndCompsql.append(" insert into " + tempSumTable);
        insertCusAndCompsql.append("  select temBaseData.FSupplierID");
        insertCusAndCompsql.append(",temBaseData.FCompanyORGUnitID");
        insertCusAndCompsql.append(",'IsTotal'");
        insertCusAndCompsql.append(",temBaseData.FApBalance");
        insertCusAndCompsql.append(",LsPurTB.FLastPurAmount");
        insertCusAndCompsql.append(",LsPurTB.FLastPurDate");
        insertCusAndCompsql.append(",lsPaytb.FLastPayAmount");
        insertCusAndCompsql.append(",lsPaytb.FLastPayDate");
        insertCusAndCompsql.append(",temBaseData.FPurAmount");
        insertCusAndCompsql.append(",temBaseData.FPurInAmount");
        insertCusAndCompsql.append(",temBaseData.FAPAmount");
        insertCusAndCompsql.append(",temBaseData.FPayAmount");
        insertCusAndCompsql.append(",temBaseData.FPurTimes");
        insertCusAndCompsql.append(",temBaseData.FTatolPurAmount");
        insertCusAndCompsql.append(",temBaseData.FTatolPurInAmount");
        insertCusAndCompsql.append(",temBaseData.FTatolAPAmount");
        insertCusAndCompsql.append(",temBaseData.FTatolPayAmount");
        insertCusAndCompsql.append(",temBaseData.FTatolPurTimes");
        insertCusAndCompsql.append(" from (");
        insertCusAndCompsql.append("  select a.FSupplierID FSupplierID");
        insertCusAndCompsql.append(",org.fparentid FCompanyORGUnitID");
        insertCusAndCompsql.append(",sum(a.FApBalance) FApBalance");
        insertCusAndCompsql.append(",sum(a.FPurAmount) FPurAmount");
        insertCusAndCompsql.append(",sum(a.FPurInAmount) FPurInAmount");
        insertCusAndCompsql.append(",sum(a.FAPAmount) FAPAmount");
        insertCusAndCompsql.append(",sum(a.FPayAmount) FPayAmount");
        insertCusAndCompsql.append(",sum(a.FPurTimes) FPurTimes");
        insertCusAndCompsql.append(",sum(a.FTatolPurAmount) FTatolPurAmount");
        insertCusAndCompsql.append(",sum(a.FTatolPurInAmount) FTatolPurInAmount");
        insertCusAndCompsql.append(",sum(a.FTatolAPAmount) FTatolAPAmount");
        insertCusAndCompsql.append(",sum(a.FTatolPayAmount) FTatolPayAmount");
        insertCusAndCompsql.append(",sum(a.FTatolPurTimes) FTatolPurTimes");
        insertCusAndCompsql.append(" from  " + tempSumTable + " a ");
        insertCusAndCompsql.append(" inner join  " + orgTable);
        insertCusAndCompsql.append(" org  on a.FCompanyORGUnitID = org.fid and org.flevel = " + i);
        insertCusAndCompsql.append(" group by a.FSupplierID,org.fparentid,org.flevel ");
        insertCusAndCompsql.append(" ) temBaseData ");
        insertCusAndCompsql.append(" inner join " + lsPurTBName + " LsPurTB ");
        insertCusAndCompsql.append(" on temBaseData.FSupplierID = LsPurTB.FSupplierID ");
        insertCusAndCompsql.append(" and temBaseData.FCompanyorgunitid = LsPurTB .FCompanyORGUnitID ");
        insertCusAndCompsql.append(" inner join " + lsPayTBName + " LsPayTB ");
        insertCusAndCompsql.append(" on temBaseData.FSupplierID = LsPayTB.FSupplierID ");
        insertCusAndCompsql.append(" and temBaseData.FCompanyorgunitid = LsPayTB.FCompanyORGUnitID ");
        return insertCusAndCompsql.toString();
    }

    private String getInstLastPurSql(String tempSumTable, String orgTable, RptParams params, int i) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into " + params.getString("LastPurTable"));
        insertSQL.append(" select newbosid('88888888'),t.FSupplierid FSupplierid,T.FCompanyORGUnitID ");
        insertSQL.append(" FCompanyORGUnitID,sum(t.FLastPurAmount) ");
        insertSQL.append(" FLastPurAmount,max(t.FLastPurDate) FLastPurDate ");
        insertSQL.append(" from ( ");
        insertSQL.append(" SELECT tempLsDate.FSupplierid FSupplierid,org.fparentid FCompanyORGUnitID");
        insertSQL.append(",0 FLastPurAmount, max(tempLsDate.FLastPurDate) FLastPurDate");
        insertSQL.append(" FROM " + tempSumTable + " tempLsDate ");
        insertSQL.append(" inner join " + orgTable + " org on tempLsDate.FCompanyORGUnitID=org.fid ");
        insertSQL.append(" WHERE  org.FLevel = " + i);
        insertSQL.append(" GROUP BY tempLsDate.FSupplierID,org.FParentID,org.FLevel");
        insertSQL.append(" union all ");
        insertSQL.append(" SELECT a.FSupplierid FSupplierid,d.FCompanyORGUnitID FCompanyORGUnitID");
        insertSQL.append(",a.FLastPurAmount FLastPurAmount ,CONVERT(DATETIME,null) FLastPurDate ");
        insertSQL.append(" from " + tempSumTable + " a ");
        insertSQL.append(" inner join " + orgTable + " org on a.FCompanyORGUnitID=org.fid");
        insertSQL.append(" inner join ( ");
        insertSQL.append(" SELECT tempLsDate.FSupplierid FSupplierid,org.FParentID FCompanyORGUnitID");
        insertSQL.append(" ,0 FLastPurAmount, max(tempLsDate.FLastPurDate) FLastPurDate");
        insertSQL.append(" FROM " + tempSumTable + " tempLsDate");
        insertSQL.append(" inner join " + orgTable + " org on tempLsDate.FCompanyORGUnitID=org.fid");
        insertSQL.append(" WHERE org.FLevel =" + i);
        insertSQL.append(" GROUP BY tempLsDate.FSupplierID,org.FParentID,org.FLevel");
        insertSQL.append(" ) d on d.FSupplierid =a.FSupplierID and d.FCompanyORGUnitID = org.FParentID");
        insertSQL.append(" and d.FLastPurDate = a.FLastPurDate ");
        insertSQL.append(" ) t group by t.FSupplierid,t.FCompanyORGUnitID ");
        return insertSQL.toString();
    }

    private String getInstLastPaySql(String tempSumTable, String orgTable, RptParams params, int i) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into " + params.getString("LastPayTable"));
        insertSQL.append(" select newbosid('88888888'),t.FSupplierID FSupplierID,T.FCompanyORGUnitID ");
        insertSQL.append(" FCompanyORGUnitID,sum(t.FLastPayAmount) ");
        insertSQL.append(" FLastPayAmount,max(t.FLastPayDate) FLastPayDate ");
        insertSQL.append(" from ( ");
        insertSQL.append(" SELECT tempLsDate.FSupplierID FSupplierID,org.fparentid FCompanyORGUnitID");
        insertSQL.append(",0 FLastPayAmount, max(tempLsDate.FLastPayDate) FLastPayDate");
        insertSQL.append(" FROM " + tempSumTable + " tempLsDate ");
        insertSQL.append(" inner join " + orgTable + " org on tempLsDate.FCompanyORGUnitID=org.fid ");
        insertSQL.append(" WHERE  org.FLevel = " + i);
        insertSQL.append(" GROUP BY tempLsDate.FSupplierID,org.FParentID,org.FLevel");
        insertSQL.append(" union all ");
        insertSQL.append(" SELECT a.FSupplierid FSupplierid,d.FCompanyORGUnitID FCompanyORGUnitID");
        insertSQL.append(",a.FLastPayAmount FLastPayAmount ,CONVERT(DATETIME,null) FLastPayDate ");
        insertSQL.append(" from " + tempSumTable + " a ");
        insertSQL.append(" inner join " + orgTable + " org on a.FCompanyORGUnitID=org.fid");
        insertSQL.append(" inner join ( ");
        insertSQL.append(" SELECT tempLsDate.FSupplierid FSupplierid,org.FParentID FCompanyORGUnitID");
        insertSQL.append(" ,max(tempLsDate.FLastPayDate) FLastPayDate2");
        insertSQL.append(" FROM " + tempSumTable + " tempLsDate");
        insertSQL.append(" inner join " + orgTable + " org on tempLsDate.FCompanyORGUnitID=org.fid");
        insertSQL.append(" WHERE org.FLevel =" + i);
        insertSQL.append(" GROUP BY tempLsDate.FSupplierID,org.FParentID ");
        insertSQL.append(" ) d on d.FSupplierid =a.FSupplierID and d.FCompanyORGUnitID = org.FParentID");
        insertSQL.append(" and d.FLastPayDate2 = a.FLastPayDate ");
        insertSQL.append(" ) t group by t.FSupplierid,t.FCompanyORGUnitID ");
        return insertSQL.toString();
    }

    private void buildCompanyOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fNumber varchar(100),");
        sqlbf.append("fname_");
        sqlbf.append(ctx.getLocale().getLanguage());
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        this.executeSQL(ctx, sqlbf.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] companyOrgUnit = (Object[])params.getObject("fullCompanyOrgUnit");
        companyOrgUnit = OrgUnitUtils.getPermissionOrg((Context)ctx, (Object[])companyOrgUnit, (String)"SupplierIntegrativeUI_view");
        String[] sql = new String[companyOrgUnit.length];
        int n = companyOrgUnit.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)companyOrgUnit[i]).get("id").toString();
            String fnumber = ((FullOrgUnitInfo)companyOrgUnit[i]).get("number").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)companyOrgUnit[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)companyOrgUnit[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)companyOrgUnit[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)companyOrgUnit[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + orgTempTable + "(");
            sqlbf.append("fid,fnumber,fname_");
            sqlbf.append(ctx.getLocale().getLanguage());
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "','" + fnumber + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafCompanyOrgUnit, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    private void createTBAndInsertResultData(Context ctx, RptParams params) throws BOSException, EASBizException {
        String temName = params.getString("TempResultTable");
        this.executeSQL(ctx, this.buildLastResultDataTableSql(temName));
        String insertSQL = this.getResultDataSQL(ctx, params);
        this.executeUpdate(insertSQL, null, ctx);
    }

    private void insertResultData(Context ctx, RptParams params) throws BOSException, EASBizException {
        String insertSQL = this.getResultDataSQL(ctx, params);
        this.executeUpdate(insertSQL, null, ctx);
    }

    private String buildLastResultDataTableSql(String tableName) {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + tableName + " (");
        sqlbf.append("\n FSupplierID varchar(44)");
        sqlbf.append("\n ,FCompanyORGUnitID varchar(44)");
        sqlbf.append("\n ,FTotalFlag varchar(44)");
        sqlbf.append("\n ,FApBalance ");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FLastPurAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FLastPurDate DateTime");
        sqlbf.append("\n ,FLastPayAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FLastPayDate DateTime");
        sqlbf.append("\n ,FPurAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FPurInAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FAPAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FPayAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FPurTimes");
        sqlbf.append(" int not null default(0) ");
        sqlbf.append("\n ,FTatolPurAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FTatolPurInAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FTatolAPAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FTatolPayAmount");
        sqlbf.append(" Decimal(28,10) not null default(0) ");
        sqlbf.append("\n ,FTatolPurTimes");
        sqlbf.append(" int not null default(0) )");
        return sqlbf.toString();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    protected RptParams _findData(Context ctx, RptParams params, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = this.getDisplaySQL(ctx, params);
        String SupplierId = params.getString("supplierId");
        String ParentId = params.getString("fparentId");
        sqlBuffer.append(" Temp.FSupplierID='");
        sqlBuffer.append(SupplierId + "' and org.fparentid='");
        sqlBuffer.append(ParentId + "'");
        RptRowSet rs = this.executeQuery(sqlBuffer.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private StringBuffer getDisplaySQL(Context ctx, RptParams params) {
        String language = ctx.getLocale().getLanguage();
        String TempTable = params.getString("tempTable");
        String OrgTable = params.getString("CompanyTempTable");
        StringBuffer selectSQLBF = new StringBuffer();
        selectSQLBF.append("SELECT temp.FSupplierID");
        selectSQLBF.append(",supplier.FNumber");
        selectSQLBF.append(" FsupplierNumber");
        selectSQLBF.append(",supplier.fname_" + language);
        selectSQLBF.append(" Fsuppliername");
        selectSQLBF.append(",temp.FCompanyORGUnitID");
        selectSQLBF.append(",org.fparentid");
        selectSQLBF.append(",org.flevel");
        selectSQLBF.append(",org.fisleaf");
        selectSQLBF.append(",org.fNumber");
        selectSQLBF.append(" FOrgNumber");
        selectSQLBF.append(",org.fname_" + language);
        selectSQLBF.append(" FOrgname");
        selectSQLBF.append(",temp.FApBalance");
        selectSQLBF.append(",temp.FLastPurAmount");
        selectSQLBF.append(",temp.FLastPurDate ");
        selectSQLBF.append(",temp.FLastPayAmount");
        selectSQLBF.append(",temp.FLastPayDate ");
        selectSQLBF.append(",temp.FPurAmount");
        selectSQLBF.append(",temp.FPurInAmount");
        selectSQLBF.append(",temp.FAPAmount");
        selectSQLBF.append(",temp.FPayAmount");
        selectSQLBF.append(",temp.FPurTimes");
        selectSQLBF.append(",temp.FTatolPurAmount");
        selectSQLBF.append(",temp.FTatolPurInAmount");
        selectSQLBF.append(",temp.FTatolAPAmount");
        selectSQLBF.append(",temp.FTatolPayAmount");
        selectSQLBF.append(",temp.FTatolPurTimes");
        String selectSQL = selectSQLBF.toString();
        StringBuffer fromSQLBF = new StringBuffer();
        fromSQLBF.append(" FROM ");
        fromSQLBF.append(TempTable + " temp ");
        fromSQLBF.append(" inner join " + OrgTable + " org ");
        fromSQLBF.append(" on temp.FCompanyORGUnitID=org.fid ");
        fromSQLBF.append(" inner join T_BD_supplier supplier");
        fromSQLBF.append(" on temp.FSupplierID=supplier.fid ");
        String fromSQL = fromSQLBF.toString();
        StringBuffer whereSQLBF = new StringBuffer();
        whereSQLBF.append("where ");
        String whereSQL = whereSQLBF.toString();
        StringBuffer displaySQL = new StringBuffer();
        displaySQL.append(selectSQL);
        displaySQL.append(fromSQL);
        displaySQL.append(whereSQL);
        return displaySQL;
    }

    private String getCurPurOrderDataSQL(Context ctx, RptParams params) {
        String beginDate = params.getString("DateStart");
        String endDate = params.getString("DateEnd");
        StringBuffer queryStr = new StringBuffer();
        queryStr.append("purorder.FBizDate  >= {" + beginDate + "} and purorder.FBizDate <= {" + endDate + "}");
        queryStr.append(" and (entry.FBaseStatus =4 or  entry.FBaseStatus =6 ");
        queryStr.append(" or entry.FBaseStatus =7 ) ");
        queryStr.append(" and company.FIsleaf = 1 ");
        if (params.getObject("SupplierFrom") != null) {
            queryStr.append(this.getSupplierFromFilter(params.getObject("SupplierFrom"), "supplier"));
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and supplier.FNumber <= ? ");
        }
        StringBuffer payAmount = new StringBuffer();
        payAmount.append("\n select distinct newbosid('88888888') ,purorder.fid ,supplier.fid,purorder.FCompanyOrgUnitID,purorder.FLocalTotalTaxAmount FLocalTotalTaxAmount,");
        payAmount.append("\n entry.flocalTaxAmount,company.FLevel FLevel,purorder.fbizDate ");
        payAmount.append("\n from t_sm_purorder purorder ");
        payAmount.append("\n inner join t_sm_purorderentry entry ");
        payAmount.append(" on purorder.FID = entry.FParentID ");
        payAmount.append("\n inner join t_bd_supplier supplier ");
        payAmount.append(" on purorder.fSupplierid = supplier.fid ");
        payAmount.append("\n inner join ");
        payAmount.append(params.getString("CompanyTempTable"));
        payAmount.append(" company on purorder.FCompanyOrgUnitID=company.fid ");
        payAmount.append("\n where ");
        payAmount.append(queryStr.toString());
        return payAmount.toString();
    }

    private String getPurchaseAMTSQL(Context ctx, RptParams params, String OrgTable, int type) {
        String beginDate = params.getString("DateStart");
        String endDate = params.getString("DateEnd");
        StringBuffer queryStr = new StringBuffer();
        if (type == 0) {
            queryStr.append("purorder.FBizDate  >= {" + beginDate + "} and purorder.FBizDate <= {" + endDate + "}");
        } else {
            queryStr.append("purorder.FBizDate <= {" + endDate + "}");
        }
        queryStr.append(" and (entry.FBaseStatus =4 or  entry.FBaseStatus =6 ");
        queryStr.append(" or entry.FBaseStatus =7 ) ");
        queryStr.append(" and company.FIsleaf = 1 ");
        if (params.getObject("SupplierFrom") != null) {
            queryStr.append(this.getSupplierFromFilter(params.getObject("SupplierFrom"), "supplier"));
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and supplier.FNumber <= ? ");
        }
        StringBuffer payAmount = new StringBuffer();
        payAmount.append(" select newbosid('88888888'),FSupplierID ,FCompanyOrgUnitID ");
        if (type == 0) {
            payAmount.append(",sum(FLocalTotalTaxAmount) FPurAmt");
            payAmount.append(",0 FTatolPurAmt");
        } else {
            payAmount.append(",0 FpurAmt");
            payAmount.append(",sum(FLocalTotalTaxAmount) FTatolpurAmt");
        }
        payAmount.append("\n from (select distinct purorder.fid ,purorder.FLocalTotalTaxAmount FLocalTotalTaxAmount, supplier.fid FSupplierID,company.fid FCompanyOrgUnitID,company.FLevel FLevel");
        payAmount.append("\n from t_sm_purorder purorder ");
        payAmount.append("\n inner join t_sm_purorderentry entry ");
        payAmount.append(" on purorder.FID = entry.FParentID ");
        payAmount.append("\n inner join t_bd_supplier supplier ");
        payAmount.append(" on purorder.fSupplierid = supplier.fid ");
        payAmount.append("\n inner join ");
        payAmount.append(params.getString("CompanyTempTable"));
        payAmount.append(" company on purorder.FCompanyOrgUnitID=company.fid ");
        payAmount.append("\n where ");
        payAmount.append(queryStr.toString());
        payAmount.append("\n )temp ");
        payAmount.append("\n group by FSupplierID,FCompanyOrgUnitID,FLevel");
        payAmount.append("\n having sum(FLocalTotalTaxAmount) >0");
        return payAmount.toString();
    }

    private StringBuffer getSupplierFromFilter(Object materialFrom, String tableAlias) {
        StringBuffer sql = new StringBuffer();
        if (materialFrom == null) {
            return sql;
        }
        String[] numArray = SCMUtil.getF7Numbers((Object)materialFrom);
        if (numArray[0] != null) {
            sql.append(" and ").append(tableAlias).append(".fnumber >= '" + numArray[0] + "' ");
        } else if (numArray[1] != null) {
            sql.append(" and ").append(tableAlias).append(".fnumber in (" + numArray[1] + ") ");
        }
        return sql;
    }
}

