/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.sc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.IEASBillHeadInfo;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.scm.common.app.util.SCMServerUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;

public class SubContractOrderDisposer
implements IPaymentDisposer {
    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        if (action.getDestBill() != null && action.getDestBill().getBOSType().toString().equals("40284E81") && action.getDestBill().getId() != null) {
            IEASBillHeadInfo paymentBillInfo = (IEASBillHeadInfo)action.getDestBill();
            String paymentBillId = paymentBillInfo.getId().toString();
            HashSet<String> subContractIdSet = new HashSet<String>();
            PaymentBillEntryCollection paymentEntryNum = (PaymentBillEntryCollection)paymentBillInfo.getEntries();
            if (paymentEntryNum != null && paymentEntryNum.size() > 0) {
                for (int i = 0; i < paymentEntryNum.size(); ++i) {
                    if (StringUtils.isEmpty((String)paymentEntryNum.get(i).getSourceBillId())) continue;
                    subContractIdSet.add(paymentEntryNum.get(i).getSourceBillId());
                }
            }
            if (!subContractIdSet.isEmpty()) {
                SCMServerUtil.addSQLLock((Context)ctx, subContractIdSet);
            }
            if (action.getActionType() != null) {
                boolean isParamPayCanGtOrder;
                if (action.getActionType().getValue() == 7) {
                    isParamPayCanGtOrder = this.isParamPayCanGtOrder(ctx, paymentBillInfo);
                    if (!isParamPayCanGtOrder) {
                        this.checkTotalPaid(ctx, paymentBillId, true);
                    }
                    this.checkUnPaid(ctx, paymentBillId, true);
                    this.writeBackOrder(ctx, paymentBillId, true);
                } else if (action.getActionType().getValue() == 8) {
                    isParamPayCanGtOrder = this.isParamPayCanGtOrder(ctx, paymentBillInfo);
                    if (!isParamPayCanGtOrder) {
                        this.checkTotalPaid(ctx, paymentBillId, false);
                    }
                    this.writeBackOrder(ctx, paymentBillId, false);
                }
            }
        }
    }

    private void checkTotalPaid(Context ctx, String paymentBillId, boolean isPay) throws EASBizException, BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select sco.FPrepaymentAmount-sco.FTotalPaidPrepayment-abs(pme.FAmount) as unPaidPrepayment");
            sql.append(" from (select t.fsourcebillid, ISNULL(sum(t.FAmount),0) as FAmount from T_CAS_PaymentBillEntry t");
            sql.append(" where t.fpaymentBillID='").append(paymentBillId).append("'");
            sql.append(" group by t.fsourcebillid");
            sql.append(" ) pme");
            sql.append(" inner join T_SM_SubContractOrder sco on sco.fid = pme.fsourcebillid");
            if (isPay) {
                sql.append(" where pme.FAmount>0");
            } else {
                sql.append(" where pme.FAmount<0");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            BigDecimal unPaidPrepayment = null;
            while (rs.next()) {
                unPaidPrepayment = rs.getBigDecimal(1);
                if (unPaidPrepayment == null || unPaidPrepayment.signum() != -1) continue;
                throw new PurOrderException(PurOrderException.PREPAID_CANNNOT_GREATER_THAN_PREPAYMENT);
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + exc);
        }
    }

    private void checkUnPaid(Context ctx, String paymentBillId, boolean isPay) throws EASBizException, BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select sco.FTotalPaidPrepayment-pme.FAmount as totalPaidPrepayment");
            sql.append(" from (select t.fsourcebillid, ISNULL(sum(t.FAmount),0) as FAmount from T_CAS_PaymentBillEntry t");
            sql.append(" where t.fpaymentBillID='").append(paymentBillId).append("'");
            sql.append(" group by t.fsourcebillid");
            sql.append(" ) pme");
            sql.append(" inner join T_SM_SubContractOrder sco on sco.fid = pme.fsourcebillid");
            sql.append(" where pme.FAmount<0");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            BigDecimal totalPaidPrepayment = null;
            while (rs.next()) {
                totalPaidPrepayment = rs.getBigDecimal(1);
                if (totalPaidPrepayment == null || totalPaidPrepayment.signum() != -1) continue;
                throw new PurOrderException(PurOrderException.AMOUNT_REFUND_NOTGREATER_BEENPAID);
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + exc);
        }
    }

    private boolean isParamPayCanGtOrder(Context ctx, IEASBillHeadInfo paymentBillInfo) throws EASBizException, BOSException {
        boolean isPayGtOrder = false;
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)paymentBillInfo.getObjectValue("company");
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(companyOrgUnitInfo.getId());
            String strParamValue = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "ORDERPAYMENT");
            isPayGtOrder = Boolean.valueOf(strParamValue);
        }
        return isPayGtOrder;
    }

    private void writeBackOrder(Context ctx, String paymentBillId, boolean isPay) throws BOSException {
        char add = '+';
        char diff = '-';
        if (!isPay) {
            add = '-';
            diff = '+';
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_SM_SubContractOrderEntry set (FPrepaidAmount, FUnPrepaidAmount) =");
        sql.append(" (select T_SM_SubContractOrderEntry.FPrepaidAmount ").append(add).append(" pme.FAmount as FPrepaidAmount,");
        sql.append(" T_SM_SubContractOrderEntry.FUnPrepaidAmount ").append(diff).append(" pme.FAmount as FUnPrepaidAmount");
        sql.append(" from (select t.fsourcebillentryid, ISNULL(sum(t.FAmount),0) as FAmount from T_CAS_PaymentBillEntry t");
        sql.append(" where t.fpaymentBillID='").append(paymentBillId).append("'");
        sql.append(" group by t.fsourcebillentryid");
        sql.append(" ) pme");
        sql.append(" where pme.fsourcebillentryid = T_SM_SubContractOrderEntry.fid");
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update T_SM_SubContractOrder set (FTotalPaidPrepayment)=");
        sql.append(" (select T_SM_SubContractOrder.FTotalPaidPrepayment ").append(add).append(" pme.FAmount as FTotalPaidPrepayment");
        sql.append(" from (select t.fsourcebillid, ISNULL(sum(t.FAmount),0) as FAmount from T_CAS_PaymentBillEntry t");
        sql.append(" where t.fpaymentBillID='").append(paymentBillId).append("'");
        sql.append(" group by t.fsourcebillid");
        sql.append(" ) pme");
        sql.append(" where pme.fsourcebillid=T_SM_SubContractOrder.fid");
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

