/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.sc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.planning.ReqPlanForSCMFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.processorbuilder.SCMBusinessProcessorBuilder4common;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.sc.ISubContractOrder;
import com.kingdee.eas.scm.sm.sc.SubContractOrderCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderException;
import com.kingdee.eas.scm.sm.sc.SubContractOrderFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.scm.sm.sc.app.AbstractSubContractOrderEntryControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SubContractOrderEntryControllerBean
extends AbstractSubContractOrderEntryControllerBean
implements IBatchExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.sc.app.SubContractOrderEntryControllerBean");

    @Override
    protected void _close(Context ctx, IObjectPK entryPK, IObjectValue reasonCode) throws BOSException, EASBizException {
        this._close(ctx, new IObjectPK[]{entryPK}, reasonCode);
    }

    @Override
    protected void _close(Context ctx, IObjectPK billId, IObjectPK entryPK, String reason) throws BOSException, EASBizException {
        this._close(ctx, new IObjectPK[]{entryPK}, reason);
    }

    @Override
    protected void _close(Context ctx, IObjectPK[] entryPKs, IObjectValue reasonCode) throws BOSException, EASBizException {
        String reason = null;
        if (reasonCode instanceof ReasonCodeInfo) {
            reason = ((ReasonCodeInfo)reasonCode).getName();
        }
        this._close(ctx, entryPKs, reason);
    }

    @Override
    protected void _close(Context ctx, IObjectPK[] entryPKs, String reason) throws BOSException, EASBizException {
        if (entryPKs == null || entryPKs.length == 0 || entryPKs[0] == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> parentIDSet = new HashSet<String>();
        for (IObjectPK pk : entryPKs) {
            SubContractOrderEntryInfo entryInfo = this.getSubContractOrderEntryInfo(ctx, pk);
            list.add(entryInfo.getParent().getId().toString());
            this.checkClose(ctx, entryInfo);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
            entryInfo.setReason(reason);
            this.innerUpdate(ctx, pk, (IObjectValue)entryInfo);
            parentIDSet.add(entryInfo.getParent().getId().toString());
        }
        if (parentIDSet.size() > 0) {
            String parentIDs = SCMUtils.getSqlFromHashSet(parentIDSet);
            StringBuffer sql = new StringBuffer();
            sql.append("update T_SM_SubContractOrder set FBaseStatus = 7");
            sql.append(" where FID in (").append(parentIDs).append(")");
            sql.append(" and FBaseStatus=4");
            sql.append(" and FID not in");
            sql.append(" (select distinct FParentID from T_SM_SubContractOrderEntry where FParentID in (").append(parentIDs).append(")");
            sql.append("    and FBaseStatus<>7");
            sql.append(" )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=", list, BizActionEnum.CLOSE);
    }

    protected void checkClose(Context ctx, SubContractOrderEntryInfo entryInfo) throws BOSException, EASBizException {
        int entryBaseStatusValue;
        if (entryInfo != null && entryInfo.getBaseStatus() != null && (entryBaseStatusValue = entryInfo.getBaseStatus().getValue()) != 4) {
            throw new SubContractOrderException(SubContractOrderException.ENTRY_CANNOT_CLOSE, new String[]{EntryBaseStatusEnum.AUDITED.getAlias()});
        }
    }

    @Override
    protected void _unclose(Context ctx, IObjectPK billId, IObjectPK entryPK) throws BOSException, EASBizException {
        this._unclose(ctx, new IObjectPK[]{entryPK});
    }

    @Override
    protected void _unclose(Context ctx, IObjectPK[] entryPKs) throws BOSException, EASBizException {
        if (entryPKs == null || entryPKs.length == 0 || entryPKs[0] == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> parentIDSet = new HashSet<String>();
        for (IObjectPK pk : entryPKs) {
            SubContractOrderEntryInfo entryInfo = this.getSubContractOrderEntryInfo(ctx, pk);
            list.add(entryInfo.getParent().getId().toString());
            this.checkUnclose(ctx, entryInfo);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            entryInfo.setReason(null);
            this.innerUpdate(ctx, pk, (IObjectValue)entryInfo);
            parentIDSet.add(entryInfo.getParent().getId().toString());
        }
        if (parentIDSet.size() > 0) {
            String parentIDs = SCMUtils.getSqlFromHashSet(parentIDSet);
            StringBuffer sql = new StringBuffer();
            sql.append("update T_SM_SubContractOrder set FBaseStatus = 4");
            sql.append(" where FID in (").append(parentIDs).append(")");
            sql.append(" and FBaseStatus=7");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=", list, BizActionEnum.CLOSE);
    }

    protected void checkUnclose(Context ctx, SubContractOrderEntryInfo entryInfo) throws BOSException, EASBizException {
        int baseStatusValue;
        if (entryInfo != null && entryInfo.getBaseStatus() != null && (baseStatusValue = entryInfo.getBaseStatus().getValue()) != 7) {
            throw new SubContractOrderException(SubContractOrderException.ENTRY_CANNOT_UNCLOSE, new String[]{EntryBaseStatusEnum.CLOSED.getAlias()});
        }
    }

    public BatchActionResults batchClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        String tableName;
        Map map;
        SubContractOrderEntryInfo entryInfo = null;
        SubContractOrderInfo info = null;
        SubContractOrderEntryCollection entryColl = null;
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> entryidSet = new HashSet<String>();
        BatchExecuteParamsEntry[] paramEntrys = this.cloneParamEntry(entries, true);
        BatchActionResults result = this.batchExecute(ctx, paramEntrys, BatchActionEnum.CLOSE);
        int n = entries.length;
        for (int i = 0; i < n; ++i) {
            entryidSet.add(entries[i].get(0).toString());
        }
        if (entryidSet.size() == 0) {
            return result;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryidSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("parent.id");
        view.setSelector(sic);
        SubContractOrderEntryCollection coll = this.getSubContractOrderEntryCollection(ctx, view);
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = coll.get(i);
                list.add(entryInfo.getParent().getId().toString());
            }
        }
        if ((map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)(tableName = "T_SM_SubContractOrderEntry"), entryidSet)).size() > 0) {
            HashSet set = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                set.add(entry.getValue());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            SubContractOrderCollection orderColl = SubContractOrderFactory.getLocalInstance(ctx).getSubContractOrderCollection(viewInfo);
            if (orderColl != null && orderColl.size() > 0) {
                int size = orderColl.size();
                for (int i = 0; i < size; ++i) {
                    info = orderColl.get(i);
                    entryColl = (SubContractOrderEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n2 = entryColl.size();
                    for (int j = 0; j < n2; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!map.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.CLOSE);
                }
            }
        }
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=", list, BizActionEnum.CLOSE);
        this.handleManualCloseOrUnClose(ctx, result, false);
        return result;
    }

    private BatchExecuteParamsEntry[] cloneParamEntry(BatchExecuteParamsEntry[] entries, boolean isClose) {
        BatchExecuteParamsEntry[] paramEntrys = new BatchExecuteParamsEntry[entries.length];
        Class[] parameterTypes = new Class[]{IObjectPK.class, String.class};
        for (int i = 0; i < entries.length; ++i) {
            BatchExecuteParamsEntry paramEntry;
            Object[] paramValues = isClose ? new Object[]{entries[i].get(1), entries[i].get(2)} : new Object[]{entries[i].get(1)};
            paramEntrys[i] = paramEntry = new BatchExecuteParamsEntry(parameterTypes, paramValues);
        }
        return paramEntrys;
    }

    public BatchActionResults batchUnclose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        String tableName;
        Map map;
        SubContractOrderEntryInfo entryInfo = null;
        SubContractOrderInfo info = null;
        SubContractOrderEntryCollection entryColl = null;
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> entryidSet = new HashSet<String>();
        BatchExecuteParamsEntry[] paramEntrys = this.cloneParamEntry(entries, false);
        BatchActionResults result = this.batchExecute(ctx, paramEntrys, BatchActionEnum.UNCLOSE);
        int n = entries.length;
        for (int i = 0; i < n; ++i) {
            entryidSet.add(entries[i].get(1).toString());
        }
        if (entryidSet.size() == 0) {
            return result;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryidSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("parent.id");
        view.setSelector(sic);
        SubContractOrderEntryCollection coll = this.getSubContractOrderEntryCollection(ctx, view);
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = coll.get(i);
                list.add(entryInfo.getParent().getId().toString());
            }
        }
        if ((map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)(tableName = "T_SM_SubContractOrderEntry"), entryidSet)).size() > 0) {
            HashSet set = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                set.add(entry.getValue());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            SubContractOrderCollection orderColl = SubContractOrderFactory.getLocalInstance(ctx).getSubContractOrderCollection(viewInfo);
            if (orderColl != null && orderColl.size() > 0) {
                int size = orderColl.size();
                for (int i = 0; i < size; ++i) {
                    info = orderColl.get(i);
                    entryColl = (SubContractOrderEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n2 = entryColl.size();
                    for (int j = 0; j < n2; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!map.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNCLOSE);
                }
            }
        }
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=", list, BizActionEnum.UNCLOSE);
        this.handleManualCloseOrUnClose(ctx, result, true);
        return result;
    }

    private void handleManualCloseOrUnClose(Context ctx, BatchActionResults results, boolean isUnClose) throws BOSException {
        List idList = results.getToDoIdsList();
        int size = idList.size();
        if (size > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("update t_sm_SubContractOrderEntry set FIsManualClose = ");
            if (isUnClose) {
                sql.append("0");
            } else {
                sql.append("1");
            }
            sql.append(" where fid in (");
            String id = null;
            for (int i = 0; i < size; ++i) {
                id = idList.get(i).toString();
                sql.append("'").append(id).append("',");
            }
            DbUtil.execute((Context)ctx, (String)(sql.substring(0, sql.length() - 1) + ")"));
        }
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK entryPK, IObjectValue reasonCode) throws BOSException, EASBizException {
        this._freeze(ctx, new IObjectPK[]{entryPK}, reasonCode);
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK entryPK, String reason) throws BOSException, EASBizException {
        this._freeze(ctx, new IObjectPK[]{entryPK}, reason);
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK[] entryPKs, IObjectValue reasonCode) throws BOSException, EASBizException {
        String reason = null;
        if (reasonCode instanceof ReasonCodeInfo) {
            reason = ((ReasonCodeInfo)reasonCode).getName();
        }
        this._freeze(ctx, entryPKs, reason);
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK[] entryPKs, String reason) throws BOSException, EASBizException {
        if (entryPKs == null || entryPKs.length == 0 || entryPKs[0] == null) {
            return;
        }
        HashSet<String> parentIDSet = new HashSet<String>();
        for (IObjectPK pk : entryPKs) {
            SubContractOrderEntryInfo entryInfo = this.getSubContractOrderEntryInfo(ctx, pk);
            this.checkFreeze(ctx, entryInfo);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.BLOCKED);
            entryInfo.setReason(reason);
            this.innerUpdate(ctx, pk, (IObjectValue)entryInfo);
            parentIDSet.add(entryInfo.getParent().getId().toString());
        }
        if (parentIDSet.size() > 0) {
            String parentIDs = SCMUtils.getSqlFromHashSet(parentIDSet);
            StringBuffer sql = new StringBuffer();
            sql.append("update T_SM_SubContractOrder set FBaseStatus = 6");
            sql.append(" where FID in (").append(parentIDs).append(")");
            sql.append(" and FBaseStatus=4");
            sql.append(" and FID not in");
            sql.append(" (select distinct FParentID from T_SM_SubContractOrderEntry where FParentID in (").append(parentIDs).append(")");
            sql.append("    and FBaseStatus<>6");
            sql.append(" )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    protected void checkFreeze(Context ctx, SubContractOrderEntryInfo entryInfo) throws BOSException, EASBizException {
        int entryBaseStatusValue;
        if (entryInfo != null && entryInfo.getBaseStatus() != null && (entryBaseStatusValue = entryInfo.getBaseStatus().getValue()) != 4) {
            throw new SubContractOrderException(SubContractOrderException.ENTRY_CANNOT_FREEZE, new String[]{EntryBaseStatusEnum.AUDITED.getAlias()});
        }
    }

    @Override
    protected void _unfreeze(Context ctx, IObjectPK entryPK) throws BOSException, EASBizException {
        this._unfreeze(ctx, new IObjectPK[]{entryPK});
    }

    @Override
    protected void _unfreeze(Context ctx, IObjectPK[] entryPKs) throws BOSException, EASBizException {
        if (entryPKs == null || entryPKs.length == 0 || entryPKs[0] == null) {
            return;
        }
        HashSet<String> parentIDSet = new HashSet<String>();
        for (IObjectPK pk : entryPKs) {
            SubContractOrderEntryInfo entryInfo = this.getSubContractOrderEntryInfo(ctx, pk);
            this.checkUnfreeze(ctx, entryInfo);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            entryInfo.setReason(null);
            this.innerUpdate(ctx, pk, (IObjectValue)entryInfo);
            parentIDSet.add(entryInfo.getParent().getId().toString());
        }
        if (parentIDSet.size() > 0) {
            String parentIDs = SCMUtils.getSqlFromHashSet(parentIDSet);
            StringBuffer sql = new StringBuffer();
            sql.append("update T_SM_SubContractOrder set FBaseStatus = 4");
            sql.append(" where FID in (").append(parentIDs).append(")");
            sql.append(" and FBaseStatus=6");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    protected void checkUnfreeze(Context ctx, SubContractOrderEntryInfo entryInfo) throws BOSException, EASBizException {
        int entryBaseStatusValue;
        if (entryInfo != null && entryInfo.getBaseStatus() != null && (entryBaseStatusValue = entryInfo.getBaseStatus().getValue()) != 6) {
            throw new SubContractOrderException(SubContractOrderException.ENTRY_CANNOT_UNFREEZE, new String[]{EntryBaseStatusEnum.BLOCKED.getAlias()});
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SubContractOrderEntryInfo entryInfo = this.getSubContractOrderEntryInfo(ctx, pk);
        ISubContractOrder subContractOrder = SubContractOrderFactory.getLocalInstance(ctx);
        ObjectUuidPK parentPK = new ObjectUuidPK(entryInfo.getParent().getId());
        SubContractOrderInfo parentInfo = subContractOrder.getSubContractOrderInfo((IObjectPK)parentPK);
        return parentInfo.getNumber() + "  " + entryInfo.getSeq();
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.scm.sm.sc.app.SubOrderEntryconfig";
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx) throws BOSException {
        try {
            return super._getCollection(ctx, svcCtx);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        try {
            return super._getCollection(ctx, svcCtx, view);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, String oql) throws BOSException {
        try {
            return super._getCollection(ctx, svcCtx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] ids;
        if (batchAction == BatchActionEnum.UNCLOSE && (ids = batchResults.getAllIDs()) != null && ids.length > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("parent.id"));
            SubContractOrderEntryInfo entryInfo = (SubContractOrderEntryInfo)SubContractOrderEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(ids[0]), sic);
            ObjectUuidPK pk = new ObjectUuidPK(entryInfo.getParent().getId());
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseStatus"));
            sic.add(new SelectorItemInfo("entries.baseStatus"));
            sic.add(new SelectorItemInfo("entries.id"));
            ISubContractOrder iSubContractOrder = SubContractOrderFactory.getLocalInstance(ctx);
            SubContractOrderInfo subContractOrderInfo = iSubContractOrder.getSubContractOrderInfo((IObjectPK)pk, sic);
            int size = subContractOrderInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entryInfo = subContractOrderInfo.getEntries().get(i);
                if (entryInfo == null || !EntryBaseStatusEnum.ALTERING.equals((Object)entryInfo.getBaseStatus())) continue;
                subContractOrderInfo.setBaseStatus(BillBaseStatusEnum.ALTERING);
                iSubContractOrder.update((IObjectPK)pk, subContractOrderInfo);
            }
        }
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessProcessor processor = this.buildProcessor(ctx, batchActionEnum);
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        return processor.execute(batchResults);
    }

    private IBusinessProcessor buildProcessor(Context ctx, BatchActionEnum batchActionEnum) throws BOSException, EASBizException {
        IBusinessProcessor processor;
        SCMBusinessProcessorBuilder4common builder = new SCMBusinessProcessorBuilder4common(batchActionEnum, this.getBOSType(), null);
        if (this.getXmlFileName(batchActionEnum) != null) {
            builder.pushXmlFile(this.getBOSType(), this.getXmlFileName(batchActionEnum));
        }
        if ((processor = builder.buildProcessor(ctx)) != null && this instanceof IBatchExecute) {
            processor.setBatchExecutor((IBatchExecute)this);
        }
        return processor;
    }
}

