/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.sc.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.sc.report.app.AbstractSubOrderScoutRptFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SubOrderScoutRptFacadeControllerBean
extends AbstractSubOrderScoutRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.sc.report.app.SubOrderScoutRptFacadeControllerBean");
    private String purChaseUnitTempTableStr = "PurChaseUnitTempTable";
    private String leafPurChaseOrgUnitStr = "leafPurChaseOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    boolean isReceivale = true;
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.dropTempTable(params.getString("PurChaseUnitTempTable"), ctx);
        this.buildStorageOrgTable(ctx, "purChaseUnitTempTable", params);
        this.createTempTableAndInsertData(ctx, "tempTable", params);
        String countSql = "select count(1) cc from " + params.getString("tempTable");
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setSubOrderRptHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", params.getString("tempTable"));
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString("purChaseUnitTempTable", params.getString("purChaseUnitTempTable"));
        return result;
    }

    private void buildStorageOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(locLan);
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sqlbf.toString());
            params.remove("purChaseUnitTempTable");
            params.setString("purChaseUnitTempTable", tableName);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] purChaseOrg = (Object[])params.getObject("fullOrgUnit");
        String[] sql = new String[purChaseOrg.length];
        int n = purChaseOrg.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)purChaseOrg[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)purChaseOrg[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)purChaseOrg[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)purChaseOrg[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)purChaseOrg[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + params.getString("purChaseUnitTempTable") + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(locLan);
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafPurChaseOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(tempTable, params);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sql.toString());
            params.remove("tempTable");
            params.setString("tempTable", tableName);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SqlParams sqlParams = new SqlParams();
        this.setRPTData(sqlParams, params);
        sql = this.getPurOrderRptSql(params, tempTable, ctx);
        this.executeUpdate(sql, sqlParams, ctx);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44) \r\n");
        sql.append(",FSuborderNumber Varchar(88) \r\n");
        sql.append(",FBIZTYPEID Varchar(44)\r\n");
        sql.append(",FSupplierID Varchar(44)\r\n");
        sql.append(",FPurChaseUnitID Varchar(44)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FBaseUnitID Varchar(44)\r\n");
        sql.append(",FBaseQty  Decimal(28,10)\r\n");
        if (!"true".equals(params.getObject("IsInWarehs").toString())) {
            sql.append(",FTotalReceiveBaseQty  Decimal(28,10)\r\n");
            sql.append(",FTotalNoReceiveBaseQty  Decimal(28,10)\r\n");
        } else {
            sql.append(",FTotalInWarehsBaseQty  Decimal(28,10)\r\n");
            sql.append(",FTotalNoInWarehsBaseQty  Decimal(28,10)\r\n");
        }
        sql.append(");\r\n");
        return sql.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int count = sqlParams.size() + 1;
        if (params.getString("materialFrom") != null) {
            sqlParams.setString(count++, params.getString("materialFrom"));
        }
        if (params.getString("materialTo") != null) {
            sqlParams.setString(count++, params.getString("materialTo"));
        }
        if (params.getString("SupplierFrom") != null) {
            sqlParams.setString(count++, params.getString("SupplierFrom"));
        }
        if (params.getString("SupplierTo") != null) {
            sqlParams.setString(count++, params.getString("SupplierTo"));
        }
        if (params.getString("BiztypeFrom") != null) {
            sqlParams.setString(count++, params.getString("BiztypeFrom"));
        }
        if (params.getString("BiztypeTo") != null) {
            sqlParams.setString(count++, params.getString("BiztypeTo"));
        }
    }

    private String getPurOrderRptSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        String sql = "";
        StringBuffer subOrderBuffer = new StringBuffer();
        StringBuffer selectStr = new StringBuffer();
        selectStr.append("INSERT INTO ");
        selectStr.append(params.getString("tempTable"));
        selectStr.append(" \r\n SELECT");
        selectStr.append(" \r\n  newbosid('88888888'),SUBORDER.FNumber,SUBORDER.FBizTypeID");
        selectStr.append(" \r\n ,SUBORDER.FSupplierID,ORG.FID");
        selectStr.append(" \r\n  ,ENTRIES.FMaterialID,ENTRIES.FBaseUnitID");
        selectStr.append(" \r\n  ,sum(ENTRIES.FBaseQty)");
        if (!"true".equals(params.getObject("IsInWarehs").toString())) {
            selectStr.append(" \r\n ,sum(ENTRIES.FTotalReceiveBaseQty )");
            selectStr.append(" \r\n ,0");
        } else {
            selectStr.append(" \r\n ,sum(ENTRIES.FTotalReceiptBaseQty)");
            selectStr.append(" \r\n ,0");
        }
        subOrderBuffer.append(selectStr);
        subOrderBuffer.append("\r\n FROM T_SM_SubContractOrder AS SUBORDER");
        subOrderBuffer.append("\r\n  INNER JOIN T_SM_SubContractOrderEntry AS ENTRIES");
        subOrderBuffer.append(" ON SUBORDER.FID = ENTRIES.FParentID");
        subOrderBuffer.append("\r\n  INNER JOIN ");
        subOrderBuffer.append(params.getString("purChaseUnitTempTable"));
        subOrderBuffer.append(" ORG");
        subOrderBuffer.append("  ON SUBORDER.FPurchaseOrgUnitID = ORG.FID");
        StringBuffer subOrderStr = new StringBuffer();
        subOrderStr.append(this.getQueryStr(params, "ENTRIES", subOrderBuffer, ctx));
        subOrderStr.append("\r\n group by SUBORDER.FNumber,SUBORDER.FBizTypeID ");
        subOrderStr.append("\r\n ,SUBORDER.FSupplierID,ORG.FID");
        subOrderStr.append("\r\n ,ENTRIES.FMaterialID,ENTRIES.FBaseUnitID");
        if (!"true".equals(params.getObject("IsInWarehs").toString())) {
            subOrderStr.append(" \r\n having sum(ENTRIES.FBaseQty)- sum(ENTRIES.FTotalReceiveBaseQty ) > 0");
        } else {
            subOrderStr.append(" \r\n having sum(ENTRIES.FBaseQty) - sum(ENTRIES.FTotalReceiptBaseQty ) > 0 ");
        }
        sql = subOrderBuffer + subOrderStr.toString();
        return sql;
    }

    private String getQueryStr(RptParams params, String subOrderEntryName, StringBuffer purBuffer, Context ctx) throws EASBizException, BOSException {
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        queryStr.append("\r\n where ");
        queryStr.append("\r\n  SUBORDER.FBaseStatus = 4 ");
        queryStr.append("\r\n and SUBORDER.FBizDate  >= to_date('" + bd + "') ");
        queryStr.append(" and SUBORDER.FBizDate <= to_date('" + ed + "')");
        if (params.getString("materialFrom") != null) {
            queryStr.append(" and material.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
            }
        }
        if (params.getString("materialTo") != null) {
            queryStr.append(" and material.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
            }
        }
        if (params.getString("SupplierFrom") != null) {
            queryStr.append(" and Supplier.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_BD_Supplier") == -1) {
                purBuffer.append("\r\n inner join T_BD_Supplier Supplier ");
                purBuffer.append(" on Supplier.fid = SUBORDER.FSupplierID ");
            }
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and Supplier.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Supplier") == -1) {
                purBuffer.append("\r\n inner join T_BD_Supplier Supplier ");
                purBuffer.append(" on Supplier.fid = SUBORDER.FSupplierID ");
            }
        }
        return queryStr.toString();
    }

    private RptTableHeader setSubOrderRptHead(RptTableHeader header, RptParams params, Context ctx) {
        String[] cols;
        Object[][] labels;
        String billNum = this.getServerResource("BillNumber", ctx);
        String bizType = this.getServerResource("BizType", ctx);
        String supplierName = this.getServerResource("supplierNameABC", ctx);
        String purChaseUnitName = this.getServerResource("PurchaseUnit", ctx);
        String materialNum = this.getServerResource("MaterialNumber", ctx);
        String materialName = this.getServerResource("MaterialName", ctx);
        String materialModel = this.getServerResource("MaterialModel", ctx);
        String baseUnit = this.getServerResource("Unit", ctx);
        String quatity = this.getServerResource("qty", ctx);
        String totalReceiveQty = this.getServerResource("TotalReceiveQty", ctx);
        String totalNoReceiveQty = this.getServerResource("TotalNoReceiveQty", ctx);
        String totalInwarehsQty = this.getServerResource("TotalInWarehsQty", ctx);
        String totalNoInWarehsQty = this.getServerResource("NoInWarehsQty", ctx);
        if (!"true".equals(params.getObject("IsInWarehs").toString())) {
            labels = new Object[1][14];
            cols = new String[14];
        } else {
            labels = new Object[1][14];
            cols = new String[14];
        }
        cols[0] = "ORDER_NUM";
        cols[1] = "BIZTYPE";
        cols[2] = "SUPPLIER_NAME";
        cols[3] = "PURCHASEORG_NAME";
        cols[4] = "MATERIAL_NUMBER";
        cols[5] = "MATERIAL_NAME";
        cols[6] = "MATERIAL_MODEL";
        cols[7] = "UNIT_NAME";
        cols[8] = "ORDER_QTY";
        if (!"true".equals(params.getObject("IsInWarehs").toString())) {
            cols[9] = "TOTALRECEIVE_QTY";
            cols[10] = "TOTALRECEIVE_QTY";
        } else {
            cols[9] = "TOTALINWAREHS_QTY";
            cols[10] = "TOTALNOINWAREHS_QTY";
        }
        cols[11] = "PURCHASEORG_FID";
        cols[12] = "MATERIAL_FID";
        cols[13] = "SUPPLIER_FID";
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = billNum;
        labels[0][1] = bizType;
        labels[0][2] = supplierName;
        labels[0][3] = purChaseUnitName;
        labels[0][4] = materialNum;
        labels[0][5] = materialName;
        labels[0][6] = materialModel;
        labels[0][7] = baseUnit;
        labels[0][8] = quatity;
        if (!"true".equals(params.getObject("IsInWarehs").toString())) {
            labels[0][9] = totalReceiveQty;
            labels[0][10] = totalNoInWarehsQty;
        } else {
            labels[0][9] = totalInwarehsQty;
            labels[0][10] = totalNoInWarehsQty;
        }
        labels[0][11] = "PURCHASEORG_FID";
        labels[0][12] = "MATERIAL_FID";
        labels[0][13] = "SUPPLIER_FID";
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        String qtyFormat = RptCellFormatter.getNumberFormat((int)4, (boolean)false);
        RptTableColumn col = null;
        int c = columns.length;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            col.setWidth(-1);
            if (i == 8 || i == 9 || i == 10) {
                col.setWidth(120);
                col.setAligment(2);
                col.setFormatPattern(qtyFormat);
            }
            if (i >= 11) {
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptRowSet rs = this.executeQuery(this.querySql(params, ctx) + " order by  temp.FSuborderNumber,temp.FBIZTYPEID,temp.FSUPPLIERID,temp.FPurChaseUnitID,temp.FMaterialID", null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private String querySql(RptParams params, Context ctx) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String purChaseUnitTempTable = params.getString("purChaseUnitTempTable");
        sql.append(" SELECT ");
        sql.append("\r\n temp.FSuborderNumber");
        sql.append("\r\n ,BIZTYPE.FName_").append(locLan);
        sql.append("\r\n ,SUPPLIER.FName_").append(locLan).append(" AS SUPPLIER_NAME");
        sql.append("\r\n ,org.fname_").append(locLan).append(" AS PURCHASEORG_NAME");
        sql.append("\r\n ,mat.FNumber AS MATERIAL_NUMBER");
        sql.append("\r\n ,mat.FName_").append(locLan).append(" AS MATERIAL_NAME");
        sql.append("\r\n ,mat.FModel AS MATERIAL_MODEL");
        sql.append("\r\n ,UNIT.FName_").append(locLan).append(" AS UNIT_NAME");
        sql.append("\r\n ,temp.FBaseQty QTY");
        if (!"true".equals(params.getObject("IsInWarehs").toString())) {
            sql.append("\r\n ,temp.FTotalReceiveBaseQty FTotalReceiveBaseQty");
            sql.append("\r\n ,(temp.FBaseQty -temp.FTotalReceiveBaseQty)   FTotalNoReceiveBaseQty");
        } else {
            sql.append("\r\n ,temp.FTotalInWarehsBaseQty FTotalInWarehsBaseQty");
            sql.append("\r\n ,(temp.FBaseQty  -temp.FTotalInWarehsBaseQty ) FTotalNoInWarehsBaseQty");
        }
        sql.append("\r\n ,temp.FPurChaseUnitID as PURCHASEORG_FID");
        sql.append("\r\n ,temp.FMaterialID AS MATERIAL_FID");
        sql.append("\r\n  FROM ").append(tempTable);
        sql.append("\r\n  temp INNER JOIN ");
        sql.append(purChaseUnitTempTable);
        sql.append("\r\n org ON temp.FPurChaseUnitID = org.FID ");
        sql.append("\r\n INNER JOIN T_BD_Material mat on temp.FMaterialID = mat.FID ");
        sql.append("\r\n INNER JOIN T_BD_Supplier AS SUPPLIER ON temp.FSupplierID = SUPPLIER.FID ");
        sql.append("\r\n INNER JOIN T_BD_MeasureUnit AS UNIT ON temp.FBaseUnitID = UNIT.FID ");
        sql.append(" \r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE\tON temp.FBIZTYPEID = BIZTYPE.FID ");
        return sql.toString();
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String rsList = "select  s.fid from " + param.getString("tempTable") + " s inner join " + param.getString("purChaseUnitTempTable") + " org  on s.FPurChaseUnitID = org.FID  order by s.FSuborderNumber,s.FBIZTYPEID,s.FSUPPLIERID,s.FPurChaseUnitID,s.FMaterialID";
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere;
        if (first) {
            subWhere = " ";
        } else {
            StringBuffer fid = new StringBuffer(" where temp.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.querySql(params, ctx));
        sql.append(subWhere);
        sql.append(" order by  temp.FSuborderNumber,temp.FBIZTYPEID,temp.FSUPPLIERID,temp.FPurChaseUnitID,temp.FMaterialID");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }
}

