/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.srm.supm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.srm.supm.EvalFormEntryFactory;
import com.kingdee.eas.scm.srm.supm.EvalFormInfo;
import com.kingdee.eas.scm.srm.supm.EvalTypeEnum;
import com.kingdee.eas.scm.srm.supm.IEvalFormEntry;
import com.kingdee.eas.scm.srm.supm.SrmException;
import com.kingdee.eas.scm.srm.supm.app.AbstractEvalFormControllerBean;
import com.kingdee.eas.scm.srm.supm.util.BOTPHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class EvalFormControllerBean
extends AbstractEvalFormControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.srm.supm.app.EvalFormControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EvalFormInfo info = (EvalFormInfo)model;
        IObjectPK pk = super._addnew(ctx, model);
        if (EvalTypeEnum.INPUTEVALUATE.equals((Object)info.getEvalType()) && info.getRecommForm() != null) {
            this.saveBotpRelation(ctx, info, pk);
        } else if ((EvalTypeEnum.MONITOREVALUATE.equals((Object)info.getEvalType()) || EvalTypeEnum.TIMEEVALUATE.equals((Object)info.getEvalType())) && info.getEvalProgram() != null) {
            this.saveBotpRelation(ctx, info, pk);
        }
        return pk;
    }

    private void saveBotpRelation(Context ctx, EvalFormInfo info, IObjectPK pk) throws BOSException {
        ArrayList<String> srcIdList = new ArrayList<String>();
        if (EvalTypeEnum.INPUTEVALUATE.equals((Object)info.getEvalType())) {
            srcIdList.add(info.getRecommForm().getId().toString());
        } else if (EvalTypeEnum.MONITOREVALUATE.equals((Object)info.getEvalType()) || EvalTypeEnum.TIMEEVALUATE.equals((Object)info.getEvalType())) {
            srcIdList.add(info.getEvalProgram().getId().toString());
        }
        BOTPHelper.saveBOTRelation(ctx, srcIdList, pk.toString());
    }

    private void deleteBotpRelation(Context ctx, EvalFormInfo info) throws BOSException {
        String srcID = "";
        String decID = info.getId().toString();
        if (EvalTypeEnum.INPUTEVALUATE.equals((Object)info.getEvalType()) && info.getRecommForm() != null) {
            srcID = info.getRecommForm().getId().toString();
        } else if ((EvalTypeEnum.MONITOREVALUATE.equals((Object)info.getEvalType()) || EvalTypeEnum.TIMEEVALUATE.equals((Object)info.getEvalType())) && info.getEvalProgram() != null) {
            srcID = info.getEvalProgram().getId().toString();
        }
        if (!StringUtil.isEmpty((String)srcID) && !StringUtil.isEmpty((String)decID)) {
            BOTPHelper.deleteBOTRelation(ctx, srcID, decID);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EvalFormInfo info = (EvalFormInfo)model;
        EvalFormInfo oldInfo = this.getEvalFormInfo(ctx, pk);
        if (EvalTypeEnum.INPUTEVALUATE.equals((Object)info.getEvalType())) {
            if (oldInfo.getRecommForm() != null) {
                this.deleteBotpRelation(ctx, oldInfo);
            }
            if (info.getRecommForm() != null) {
                this.saveBotpRelation(ctx, info, pk);
            }
        } else if (EvalTypeEnum.MONITOREVALUATE.equals((Object)info.getEvalType()) || EvalTypeEnum.TIMEEVALUATE.equals((Object)info.getEvalType())) {
            if (oldInfo.getEvalProgram() != null) {
                this.deleteBotpRelation(ctx, oldInfo);
            }
            if (info.getEvalProgram() != null) {
                this.saveBotpRelation(ctx, info, pk);
            }
        }
        super._update(ctx, pk, model);
    }

    private void updatePart(Context ctx, IObjectPK pk, IObjectValue model, boolean isWFMode) throws BOSException, EASBizException {
        EvalFormInfo info = (EvalFormInfo)model;
        IEvalFormEntry entryBiz = EvalFormEntryFactory.getLocalInstance(ctx);
        int n = info.getEntrys().size();
        for (int i = 0; i < n; ++i) {
            entryBiz.update((IObjectPK)new ObjectUuidPK(info.getEntrys().get(i).getId()), (CoreBaseInfo)info.getEntrys().get(i));
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        this._updatePartial(ctx, model, selector);
    }

    private boolean updateScoreState(Context ctx, IObjectPK pk) {
        if (ctx == null || pk == null) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_SRM_EvalForm set FIsAllScore = 1 \r\n");
        sql.append(" WHERE FID = ? \r\n");
        sql.append(" AND not exists \r\n");
        sql.append(" (SELECT fid FROM T_SRM_EvalFormEntry \r\n");
        sql.append(" WHERE FParentID = ?  \r\n");
        sql.append(" AND FIsScore = 0 )\r\n");
        SqlParams param = new SqlParams();
        param.addString(pk.toString());
        param.addString(pk.toString());
        try {
            int count = DBUtilx.executeUpdate((String)sql.toString(), (SqlParams)param, (Context)ctx);
            if (count > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return false;
    }

    @Override
    protected Set _getPermissionIdSet(Context ctx, IObjectPK pk, IObjectPK persionID) throws BOSException, EASBizException {
        if (pk == null || persionID == null) {
            return Collections.EMPTY_SET;
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append(" SELECT distinct entrys.FID FROM T_SRM_EvalForm form \r\n");
        sql.append(" RIGHT OUTER JOIN T_SRM_EvalFormEntry entrys \t\t\t\r\n");
        sql.append(" ON form.FID = entrys.FParentID             \t\t\t\r\n");
        sql.append(" RIGHT OUTER JOIN T_SRM_EvalGroupEntry groupentry    \r\n");
        sql.append(" on entrys.FEvalGroupID = groupentry.FParentID        \r\n");
        sql.append(" where form.FID = ? \r\n");
        sql.append(" and groupentry.FPersonID = ? \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString(), persionID.toString()});
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rs.next()) {
                idSet.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return idSet;
    }

    @Override
    protected void _caculateResult(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _doAudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EvalFormInfo info = (EvalFormInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SRM_EvalForm SET FBaseStatus = ");
        sql.append(4);
        sql.append(", FAuditorID = '");
        sql.append(this.getLoginUserInfo(ctx).getId());
        sql.append("', FAuditTime = getDate()");
        sql.append(", FEvalOpinion = '");
        sql.append(info.getEvalOpinion());
        sql.append("', FEvalClassID = '");
        sql.append(info.getEvalClass() == null ? "" : info.getEvalClass().getId().toString());
        sql.append("' WHERE FID = '");
        sql.append(info.getId());
        sql.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new SrmException(SrmException.FAILED_AUDIT);
        }
        if (EvalTypeEnum.INPUTEVALUATE.equals((Object)info.getEvalType())) {
            this.updateRecommForm(ctx, info);
        }
    }

    private void updateRecommForm(Context ctx, EvalFormInfo info) throws SrmException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SRM_RecommForm SET  FIsEaluated = 1 ");
        sql.append(", FIsPass = ");
        sql.append(info.isIsPass() ? 1 : 0);
        sql.append(", FEvalScore = ");
        sql.append(info.getEvalScore());
        sql.append(", FBaseStatus = ");
        sql.append(7);
        sql.append(", FEvalClassID = '");
        sql.append(info.getEvalClass().getId());
        sql.append("' ");
        sql.append(" WHERE FID = '");
        sql.append(info.getRecommForm().getId());
        sql.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new SrmException(SrmException.FAILED_UPDATERECOMMFORM);
        }
    }

    @Override
    protected void _doUnAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SRM_EvalForm SET FBaseStatus = ");
        sql.append(1);
        sql.append(", FAuditorID = null, FAuditTime = null");
        sql.append(" WHERE FID = '");
        sql.append(pk);
        sql.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new SrmException(SrmException.FAILED_UNAUDIT);
        }
        EvalFormInfo info = (EvalFormInfo)this.getValue(ctx, pk);
        this.updateUnRecommForm(ctx, info);
    }

    private void updateUnRecommForm(Context ctx, EvalFormInfo info) throws SrmException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SRM_RecommForm SET  FIsEaluated = 1 ");
        sql.append(", FIsPass = 0");
        sql.append(", FEvalScore = null");
        sql.append(", FBaseStatus = ");
        sql.append(2);
        sql.append(", FEvalClassID = null");
        sql.append(" WHERE FID = '");
        sql.append(info.getRecommForm().getId());
        sql.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new SrmException(SrmException.FAILED_UPDATERECOMMFORM);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }
}

