/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.srm.supm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.srm.supm.EvalClassFactory;
import com.kingdee.eas.scm.srm.supm.EvalClassInfo;
import com.kingdee.eas.scm.srm.supm.EvalMethodEntryCollection;
import com.kingdee.eas.scm.srm.supm.EvalMethodEntryInfo;
import com.kingdee.eas.scm.srm.supm.EvalMethodFactory;
import com.kingdee.eas.scm.srm.supm.EvalMethodInfo;
import com.kingdee.eas.scm.srm.supm.IEvalMethod;
import com.kingdee.eas.scm.srm.supm.UsedStatesEnum;
import com.kingdee.eas.scm.srm.supm.util.SupmHelper;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class EvalMethodDataTransmission
extends AbstractDataTransmission {
    private Map infoMap = new HashMap(100);
    private String lastKey;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EvalMethodFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        CoreBaseInfo info = null;
        try {
            info = this.getEvalMethodInfo(hsData, ctx);
        }
        catch (TaskExternalException e) {
            this.delete(ctx);
            throw e;
        }
        return info;
    }

    private CoreBaseInfo getEvalMethodInfo(Hashtable hsData, Context ctx) throws TaskExternalException {
        EvalMethodInfo head = new EvalMethodInfo();
        EvalMethodEntryInfo entry = null;
        String number = this.getStringFromhsData(hsData, "FNumber");
        if (this.lastKey == null) {
            this.lastKey = number;
        }
        if (!this.lastKey.equals(number)) {
            this.verifyEntry(ctx);
        }
        if (this.infoMap.containsKey(number)) {
            head = (EvalMethodInfo)this.infoMap.get(number);
        } else {
            this.parseHead(hsData, ctx, head);
            this.infoMap.put(number, head);
        }
        this.lastKey = number;
        entry = (EvalMethodEntryInfo)this.parseEntry(hsData, ctx);
        head.getEntrys().add(entry);
        return head;
    }

    private void verifyEntry(Context ctx) throws TaskExternalException {
        try {
            EvalMethodEntryInfo entry;
            int i;
            EvalMethodInfo info = EvalMethodFactory.getLocalInstance(ctx).getEvalMethodInfo("WHERE NUMBER = '" + this.lastKey + "'");
            EvalMethodEntryCollection entrys = info.getEntrys();
            BigDecimal startScoreTotal = SupmHelper.ZERO;
            BigDecimal endScoreTotal = SupmHelper.ZERO;
            BigDecimal maxNoPass = SupmHelper.ZERO;
            int passCount = 0;
            int notPassCount = 0;
            ArrayList<BigDecimal> startList = new ArrayList<BigDecimal>();
            ArrayList<BigDecimal> endList = new ArrayList<BigDecimal>();
            int count = entrys.size();
            for (i = 0; i < count; ++i) {
                entry = entrys.get(i);
                BigDecimal startScore = entry.getStartScore();
                BigDecimal endScore = entry.getEndScore();
                if (entry.isIsPass()) {
                    ++passCount;
                } else {
                    ++notPassCount;
                    maxNoPass = endScore;
                }
                startScoreTotal = startScoreTotal.add(startScore);
                endScoreTotal = endScoreTotal.add(endScore);
                startList.add(entry.getStartScore());
                endList.add(entry.getEndScore());
            }
            if (passCount == 0 || notPassCount == 0) {
                throw new TaskExternalException("\u5206\u5f55\u4e2d\u81f3\u5c11\u6709\u4e00\u884c\u5408\u683c\u548c\u4e0d\u5408\u683c\u8bb0\u5f55");
            }
            if (notPassCount > 1) {
                throw new TaskExternalException("\u53ea\u80fd\u6709\u4e00\u6761\u4e0d\u5408\u683c\u8bb0\u5f55");
            }
            if (endScoreTotal.subtract(startScoreTotal).compareTo(SupmHelper.HUNDRED) != 0) {
                throw new TaskExternalException("\u5206\u5f55\u5206\u503c\u586b\u5199\u9519\u8bef");
            }
            for (i = 0; i < endList.size(); ++i) {
                if (startList.contains(endList.get(i)) || ((BigDecimal)endList.get(i)).compareTo(SupmHelper.HUNDRED) == 0) continue;
                throw new TaskExternalException("\u5404\u884c\u4e4b\u95f4\u7684\u8303\u56f4\u5305\u542b\u5173\u7cfb\u4e0d\u80fd\u7a7f\u63d2");
            }
            for (i = 0; i < count; ++i) {
                entry = entrys.get(i);
                if (!entry.isIsPass()) continue;
                if (entry.getStartScore().compareTo(maxNoPass) < 0) {
                    throw new TaskExternalException("\u4ece\u7b2c\u4e00\u4e2a\u4e0d\u5408\u683c\u7684\u5206\u6570\u4ece\u5f00\u59cb\u4e0b\u9762\u7684\u5fc5\u987b\u90fd\u662f\u4e0d\u5408\u683c");
                }
                if (entry.getEvalClass() != null) continue;
                throw new TaskExternalException("\u5408\u683c\u9879\u4f9b\u5e94\u5546\u7b49\u7ea7\u5fc5\u586b");
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException("\u5bfc\u5165\u6570\u636e\u51fa\u9519");
        }
        catch (BOSException e) {
            throw new TaskExternalException("\u5bfc\u5165\u6570\u636e\u51fa\u9519");
        }
    }

    private void delete(Context ctx) throws TaskExternalException {
        try {
            EvalMethodFactory.getLocalInstance(ctx).delete("WHERE NUMBER = '" + this.lastKey + "'");
        }
        catch (EASBizException e1) {
            throw new TaskExternalException("\u5bfc\u5165\u6570\u636e\u51fa\u9519");
        }
        catch (BOSException e1) {
            throw new TaskExternalException("\u5bfc\u5165\u6570\u636e\u51fa\u9519");
        }
    }

    private CoreBaseInfo parseEntry(Hashtable hsData, Context ctx) throws TaskExternalException {
        EvalClassInfo evalClass;
        EvalMethodEntryInfo info = new EvalMethodEntryInfo();
        String isPass = this.getStringFromhsData(hsData, "FIsPass");
        BigDecimal startScore = new BigDecimal(this.getStringFromhsData(hsData, "FStartScore"));
        BigDecimal endScore = new BigDecimal(this.getStringFromhsData(hsData, "FEndScore"));
        String evalClassName = this.getStringFromhsData(hsData, "FEvalClass");
        try {
            evalClass = EvalClassFactory.getLocalInstance(ctx).getEvalClassInfo("WHERE name = '" + evalClassName + "'");
        }
        catch (EASBizException e) {
            throw new TaskExternalException("\u4f9b\u5e94\u5546\u7b49\u7ea7\u4e0d\u5b58\u5728");
        }
        catch (BOSException e) {
            throw new TaskExternalException("\u4f9b\u5e94\u5546\u7b49\u7ea7\u4e0d\u5b58\u5728");
        }
        String description = this.getStringFromhsData(hsData, "FDescription_L2");
        if (description.length() > 80) {
            throw new TaskExternalException("\u7b49\u7ea7\u63cf\u8ff0\u5b57\u7b26\u592a\u957f");
        }
        if (isPass.equals("\u662f")) {
            info.setIsPass(true);
        } else if (isPass.equals("\u5426")) {
            info.setIsPass(false);
        } else {
            throw new TaskExternalException("\u662f\u5426\u5408\u683c\u5217\u53ea\u80fd\u4e3a '\u662f' \u548c '\u5426'");
        }
        info.setStartScore(startScore);
        info.setEndScore(endScore);
        info.setDescription(description);
        info.setEvalClass(evalClass);
        return info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx, EvalMethodInfo info) throws TaskExternalException {
        String number = this.getStringFromhsData(hsData, "FNumber");
        if (StringUtils.isEmpty((String)number)) throw new TaskExternalException("number not found!");
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                IEvalMethod iEvalMethod = (IEvalMethod)this.getController(ctx);
                EvalMethodInfo evalItem = iEvalMethod.getEvalMethodInfo("select * where number = '" + number + "'");
                if (evalItem != null) {
                    info.setId(evalItem.getId());
                }
            }
            catch (Exception e) {
                throw new TaskExternalException("BOSException: getCurrencyCollection", (Throwable)e);
            }
        }
        String name_l1 = this.getStringFromhsData(hsData, "FName_L1");
        String name_l2 = this.getStringFromhsData(hsData, "FName_L2");
        String name_l3 = this.getStringFromhsData(hsData, "FName_L3");
        String state = this.getStringFromhsData(hsData, "FUsedState");
        String canModifyResult = this.getStringFromhsData(hsData, "FCanModifyResult");
        if (StringUtils.isEmpty((String)name_l1) && StringUtils.isEmpty((String)name_l2) && StringUtils.isEmpty((String)name_l3)) {
            throw new TaskExternalException("\u7b49\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (name_l1.length() > 80 || name_l2.length() > 80 || name_l2.length() > 80) {
            throw new TaskExternalException("\u7b49\u7ea7\u540d\u79f0\u5b57\u7b26\u592a\u957f");
        }
        if (state.equals("\u6838\u51c6")) {
            info.setUsedState(UsedStatesEnum.APPROVED);
        } else {
            if (!state.equals("\u4fdd\u5b58")) throw new TaskExternalException("\u72b6\u6001\u53ea\u80fd\u4e3a\u6838\u51c6\u548c\u4fdd\u5b58!");
            info.setUsedState(UsedStatesEnum.SAVE);
        }
        info.setName(name_l2);
        if (canModifyResult.equals("\u662f")) {
            info.setCanModifyResult(true);
            return info;
        } else {
            if (!canModifyResult.equals("\u5426")) throw new TaskExternalException("\u662f\u5426\u5141\u8bb8\u4fee\u6539\u7ed3\u679c\u53ea\u80fd\u4e3a '\u662f'\u548c '\u5426'!");
            info.setCanModifyResult(false);
        }
        return info;
    }

    private String getStringFromhsData(Hashtable hsData, String key) {
        return (String)((DataToken)hsData.get((Object)key)).data;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String description;
            String canModifyResult;
            String evalClass;
            String endScore;
            String startScore;
            result.put("FNumber", rs.getString("number"));
            String name = rs.getString("name");
            if (!StringUtils.isEmpty((String)name)) {
                if (LocaleUtils.getLocale((String)"l1").equals(ctx.getLocale())) {
                    result.put("FName_L1", name);
                }
                if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale())) {
                    result.put("FName_L2", name);
                }
                if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale())) {
                    result.put("FName_L3", name);
                }
            }
            if (rs.getString("entrys.isPass") != null) {
                result.put("FIsPass", rs.getString("entrys.isPass").equals("true") ? "\u662f" : "\u5426");
            }
            if ((startScore = rs.getString("entrys.startScore")) != null) {
                result.put("FStartScore", new BigDecimal(startScore).setScale(2).toString());
            }
            if ((endScore = rs.getString("entrys.endScore")) != null) {
                result.put("FEndScore", new BigDecimal(endScore).setScale(2).toString());
            }
            if ((evalClass = rs.getString("entrys.evalClass.name")) != null) {
                result.put("FEvalClass", evalClass);
            }
            if ((canModifyResult = rs.getString("canModifyResult")) != null) {
                result.put("FCanModifyResult", canModifyResult.equals("true") ? "\u662f" : "\u5426");
            }
            if (rs.getString("usedState") != null) {
                result.put("FUsedState", rs.getString("usedState").equals("0") ? "\u4fdd\u5b58" : "\u6838\u51c6");
            }
            if (!StringUtils.isEmpty((String)(description = rs.getString("entrys.description")))) {
                if (LocaleUtils.getLocale((String)"l1").equals(ctx.getLocale())) {
                    result.put("FDescription_L1", description);
                }
                if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale())) {
                    result.put("FDescription_L2", description);
                }
                if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale())) {
                    result.put("FDescription_L3", description);
                }
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        return result;
    }
}

