/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.srm.supm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.srm.supm.RecommFormFactory;
import com.kingdee.eas.scm.srm.supm.RecommFormInfo;
import com.kingdee.eas.scm.srm.supm.SrmException;
import com.kingdee.eas.scm.srm.supm.app.AbstractRecommFormControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class RecommFormControllerBean
extends AbstractRecommFormControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.srm.supm.app.RecommFormControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecommFormInfo info = (RecommFormInfo)model;
        if (!info.isIsInterCompany()) {
            info.setInternalCompany(null);
        }
        return super._addnew(ctx, model);
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RecommFormInfo model = RecommFormFactory.getLocalInstance(ctx).getRecommFormInfo(pk);
        if (!this.isCanAudit(model)) {
            throw new SrmException(SrmException.CAN_NOT_AUDIT);
        }
        this.doAudit(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.isReferenced(ctx, pk);
        super._delete(ctx, pk);
    }

    private boolean isCanAudit(RecommFormInfo model) {
        return BillBaseStatusEnum.SUBMITED.equals((Object)model.getBaseStatus());
    }

    private void doAudit(Context ctx, RecommFormInfo model) throws SrmException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SRM_RecommForm SET FBaseStatus = ");
        sql.append(4);
        sql.append(", FAuditorID = '");
        sql.append(this.getLoginUserInfo(ctx).getId());
        sql.append("', FAuditTime = getDate()");
        sql.append(" WHERE FID = '");
        sql.append(model.getId());
        sql.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new SrmException(SrmException.FAILED_AUDIT);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RecommFormInfo model = RecommFormFactory.getLocalInstance(ctx).getRecommFormInfo(pk);
        if (!this.isNotCanAudit(model)) {
            throw new SrmException(SrmException.CAN_NOT_UNAUDIT);
        }
        this.doUnAudit(ctx, model);
    }

    private void doUnAudit(Context ctx, RecommFormInfo model) throws SrmException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SRM_RecommForm SET FBaseStatus = ");
        sql.append(1);
        sql.append(", FAuditorID = null, FAuditTime = null ");
        sql.append("WHERE FID = '");
        sql.append(model.getId());
        sql.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new SrmException(SrmException.FAILED_UNAUDIT);
        }
    }

    private boolean isNotCanAudit(RecommFormInfo model) {
        return BillBaseStatusEnum.AUDITED.equals((Object)model.getBaseStatus());
    }

    @Override
    protected void _cancellation(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RecommFormInfo model = RecommFormFactory.getLocalInstance(ctx).getRecommFormInfo(pk);
        if (!this.beforeCancellation(model)) {
            throw new SrmException(SrmException.CAN_NOT_CANCELLATION);
        }
        this.doCancellation(ctx, model);
    }

    private boolean beforeCancellation(RecommFormInfo model) {
        return BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)model.getBaseStatus());
    }

    private void doCancellation(Context ctx, RecommFormInfo model) throws SrmException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SRM_RecommForm SET FBaseStatus = ");
        sql.append(3);
        sql.append(" WHERE FID = '");
        sql.append(model.getId());
        sql.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new SrmException(SrmException.FAILED_CANCELLATION);
        }
    }
}

