/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app;

import com.google.gson.JsonParseException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.ws.app.AbstractWarehouseWebServiceFacadeControllerBean;
import com.kingdee.eas.scm.ws.app.importbill.BillResultInfo;
import com.kingdee.eas.scm.ws.app.importbill.ResultInfo;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.eas.scm.ws.app.json.JSONUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WarehouseWebServiceFacadeControllerBean
extends AbstractWarehouseWebServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.ws.app.WarehouseWebServiceFacadeControllerBean");
    private static final String RESOURCE_FILE = "com.kingdee.eas.scm.ws.app.WarehouseWSResource";
    private static final String NOT_JSON_ARRAY_INPUT = "NOT_JSON_ARRAY_INPUT";
    private static final String STORAGEORG_IS_NULL = "STORAGEORG_IS_NULL";
    private static final String WH_NUMBER_IS_NULL = "WH_NUMBER_IS_NULL";
    private static final String WH_NUMBER_NOT_EXISTS = "WH_NUMBER_NOT_EXISTS";
    private static final String WH_NAME_NOT_NULL = "WH_NAME_NOT_NULL";
    private static final String WH_NAME_IS_DUP = "WH_NAME_IS_DUP";
    private static final String REGION_IS_NULL = "REGION_IS_NULL";
    private static final String STORAGEORG_NOT_BIZUNIT = "STORAGEORG_NOT_BIZUNIT";

    @Override
    protected String _importData(Context ctx, String dataJSON) throws BOSException, EASBizException {
        ResultInfo resultInfo = new ResultInfo();
        WarehouseCollection warehouseCollection = null;
        try {
            warehouseCollection = (WarehouseCollection)JSONUtils.convertJsonToObject(ctx, dataJSON, WarehouseCollection.class);
        }
        catch (Exception exp) {
            resultInfo.setStatus(1);
            if (exp.getCause() instanceof JsonParseException) {
                resultInfo.setMsg(exp.getCause().getMessage());
            } else {
                resultInfo.setMsg(exp.getMessage());
            }
            return JSONUtils.convertObjectToJson(ctx, resultInfo);
        }
        if (warehouseCollection == null || warehouseCollection.size() <= 0) {
            resultInfo.setStatus(1);
            resultInfo.setMsg(this.getResource(NOT_JSON_ARRAY_INPUT, ctx, new Object[0]));
            return JSONUtils.convertObjectToJson(ctx, resultInfo);
        }
        List<BillResultInfo> billErrors = null;
        int size = warehouseCollection.size();
        billErrors = this.saveWithVerify(ctx, (AbstractObjectCollection)warehouseCollection);
        if (!billErrors.isEmpty()) {
            resultInfo.setBillErrors(billErrors);
            if (billErrors.size() == size) {
                resultInfo.setStatus(1);
            } else {
                resultInfo.setStatus(2);
            }
        } else {
            resultInfo.setStatus(0);
            billErrors.clear();
        }
        return JSONUtils.convertObjectToJson(ctx, resultInfo);
    }

    private List<BillResultInfo> saveWithVerify(Context ctx, AbstractObjectCollection col) throws BOSException, EASBizException {
        WarehouseInfo info;
        ArrayList<BillResultInfo> results = new ArrayList<BillResultInfo>();
        if (col == null || col.isEmpty()) {
            return results;
        }
        Iterator iterator = col.iterator();
        ArrayList<String> errorMsg = null;
        while (iterator.hasNext()) {
            errorMsg = new ArrayList<String>();
            info = (WarehouseInfo)iterator.next();
            ScmbillImportUtils.setDataInfoByNumber(ctx, (CoreBaseInfo)info, errorMsg);
            this.verifyData(ctx, info, errorMsg);
            this.setDefaultData(info);
            if (errorMsg.isEmpty()) continue;
            BillResultInfo result = new BillResultInfo();
            result.setErrorMsgs(errorMsg);
            result.setNumber(info.getNumber());
            result.setStatus(1);
            results.add(result);
            iterator.remove();
        }
        Class[] batchMethod = new Class[]{CoreBaseInfo.class};
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[col.size()];
        BatchExecuteResult result = null;
        BatchExecuteParamsEntry entry = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = new BatchExecuteParamsEntry(new Class[]{CoreBaseInfo.class});
            entry.add((Object)col.getObject(i));
            paramEntries[i] = entry;
        }
        try {
            if (paramEntries.length > 0) {
                result = this.getInterface(ctx).batchExecute("submit", batchMethod, paramEntries);
                Object[] returnValues = result.getReturnValues();
                int size2 = returnValues.length;
                for (int i = 0; i < size2; ++i) {
                    info = (WarehouseInfo)col.getObject(i);
                    errorMsg = new ArrayList();
                    if (result.getException(i) == null) continue;
                    BillResultInfo resultInfo = new BillResultInfo();
                    resultInfo.setNumber(info.getNumber());
                    errorMsg.add(result.getException(i).getMessage());
                    resultInfo.setErrorMsgs(errorMsg);
                    resultInfo.setStatus(1);
                    results.add(resultInfo);
                }
            }
        }
        catch (BaseException e) {
            throw new BOSException((Throwable)e);
        }
        return results;
    }

    private void verifyData(Context ctx, WarehouseInfo info, List<String> errorMsg) throws BOSException, EASBizException {
        if (info.getStorageOrg() == null) {
            errorMsg.add(this.getResource(STORAGEORG_IS_NULL, ctx, new Object[0]));
        } else if (!info.getStorageOrg().isIsBizUnit()) {
            errorMsg.add(this.getResource(STORAGEORG_NOT_BIZUNIT, ctx, new Object[0]));
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            errorMsg.add(this.getResource(WH_NUMBER_IS_NULL, ctx, new Object[0]));
        } else if (this.numberIsDup(ctx, info.getNumber())) {
            errorMsg.add(this.getResource(WH_NUMBER_NOT_EXISTS, ctx, info.getNumber()));
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            errorMsg.add(this.getResource(WH_NAME_NOT_NULL, ctx, new Object[0]));
        } else if (this.nameIsDup(ctx, info.getName(), info.getStorageOrg())) {
            errorMsg.add(this.getResource(WH_NAME_IS_DUP, ctx, info.getName()));
        }
        if (info.getRegion() == null) {
            errorMsg.add(this.getResource(REGION_IS_NULL, ctx, new Object[0]));
        }
    }

    protected void setDefaultData(WarehouseInfo info) throws BOSException, EASBizException {
        if (!info.isHasLocation()) {
            info.setHasLocationLevel(false);
        }
        info.setWhState(WHStateEnum.SAVED);
    }

    protected boolean nameIsDup(Context ctx, String name, StorageOrgUnitInfo storageOrgUnit) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        if (storageOrgUnit != null && storageOrgUnit.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)storageOrgUnit.getId().toString()));
        }
        return WarehouseFactory.getLocalInstance((Context)ctx).exists(filter);
    }

    protected boolean numberIsDup(Context ctx, String number) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        CtrlUnitInfo ctrlUnitInfo = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        if (ctrlUnitInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)ctrlUnitInfo.getId().toString()));
        }
        return WarehouseFactory.getLocalInstance((Context)ctx).exists(filter);
    }

    protected String getResource(String key, Context ctx, Object ... params) {
        return ResourceBase.getString((String)RESOURCE_FILE, (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }

    protected IWarehouse getInterface(Context ctx) throws BOSException {
        return WarehouseFactory.getLocalInstance((Context)ctx);
    }
}

