/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.InventoryInitBillCollection;
import com.kingdee.eas.scm.im.inv.InventoryInitBillFactory;
import com.kingdee.eas.scm.im.inv.InventoryInitBillInfo;
import com.kingdee.eas.scm.im.inv.InventoryInitEntryInfo;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import java.util.List;

public class InventoryInitBillSupport
extends ScmBillSupport {
    @Override
    public Class getInfoClass() {
        return InventoryInitBillCollection.class;
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return InventoryInitBillFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo info, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void dealWithHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void dealWithEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void verifyHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        InventoryInitBillInfo info = (InventoryInitBillInfo)model;
        this.verifyNumber(info.getNumber(), errorMsg);
        this.verifyDataInfo((DataBaseInfo)info.getStorageOrgUnit(), errorMsg, "STORAGEORG_IS_NULL", new Object[0]);
        if (info.getBizDate() == null) {
            errorMsg.add(this.getResource("BIZ_DATE_IS_NULL", this.getContext(), new Object[0]));
        }
    }

    @Override
    protected void verifyEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        InventoryInitEntryInfo info = (InventoryInitEntryInfo)entryModel;
        this.verifyDataInfo((DataBaseInfo)info.getMaterial(), errorMsg, "MATERIAL_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getUnit(), errorMsg, "MEASURE_UNIT_IS_NULL", new Object[0]);
        this.verifyDecimal(info.getQty(), errorMsg, "QTY_IS_NULL", null);
        this.verifyDecimal(info.getPrice(), errorMsg, "PRICE_IS_NULL", null);
        this.verifyDecimal(info.getAmount(), errorMsg, "AMOUNT_IS_NULL", null);
        this.verifyDataInfo((DataBaseInfo)info.getStoreType(), errorMsg, "STORE_TYPE_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getStoreStatus(), errorMsg, "STORE_STATUS_IS_NULL", new Object[0]);
        this.verifyDecimal(info.getDiffAmount(), errorMsg, "DIFF_AMOUNT_IS_NULL", null);
        this.verifyDecimal(info.getYearReceiptQty(), errorMsg, "YEAR_RECEIPTQTY_IS_NULL", null);
        this.verifyDecimal(info.getYearReceiptAmount(), errorMsg, "YEAR_RECEIPT_AMOUNT_IS_NULL", null);
        this.verifyDecimal(info.getYearIssueQty(), errorMsg, "YEAR_ISSUEQTY_IS_NULL", null);
        this.verifyDecimal(info.getYearIssueAmount(), errorMsg, "YEAR_ISSUE_AMOUNT_IS_NULL", null);
        this.verifyDecimal(info.getYearIssueCostDiff(), errorMsg, "YEAR_ISSUE_COSTDIFF_IS_NULL", null);
        this.verifyDecimal(info.getYearReceiptCostDiff(), errorMsg, "YEAR_RECEIPT_COSTDIFF_IS_NULL", null);
    }
}

