/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.List;

public class MoveInWarehsBillSupport
extends ScmBillSupport {
    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return super.getBatchExecuteResult(paramEntries, batchMethod, methodPK);
    }

    @Override
    public Class<MoveInWarehsBillCollection> getInfoClass() {
        return MoveInWarehsBillCollection.class;
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return MoveInWarehsBillFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    protected void setDefaultData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        MoveInWarehsBillInfo info = (MoveInWarehsBillInfo)model;
        super.setDefaultData((SCMBillBaseInfo)info, errorMsg);
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultHeadData(model, errorMsg);
        MoveInWarehsBillInfo info = (MoveInWarehsBillInfo)model;
        info.setIsSysBill(false);
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0172c0a812fd463ED552"));
        info.setBillType(billtype);
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        MoveInWarehsBillEntryInfo entryInfo = (MoveInWarehsBillEntryInfo)entryModel;
        MoveInWarehsBillInfo info = (MoveInWarehsBillInfo)model;
        entryInfo.setStorageOrgUnit(info.getStorageOrgUnit());
        if (entryInfo.getMaterial() != null) {
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            this.setBaseQty(entryInfo, errorMsg);
        }
    }

    private void setBaseQty(MoveInWarehsBillEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseunit = entryInfo.getBaseUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MultiMeasureUnitInfo basemmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, baseunit, errorMsg);
        BigDecimal qty = entryInfo.getQty();
        BigDecimal baseQty = this.zero;
        if (qty == null) {
            qty = this.zero;
        }
        if (mmu != null && basemmu != null) {
            qty = qty.setScale(mmu.getQtyPrecision(), 4);
            baseQty = qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4);
        }
        entryInfo.setQty(qty);
        entryInfo.setBaseQty(baseQty);
        entryInfo.setAssociateQty(qty);
        entryInfo.setAssociateQty(qty);
        MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
        if (assistUnit != null) {
            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)this.getContext(), (MeasureUnitInfo)unit, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)material, (BigDecimal)qty);
            entryInfo.setAssistQty(assisqtyQty);
        }
    }
}

