/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SaleOrderBillSupport
extends ScmBillSupport {
    private Map<String, CompanyOrgUnitInfo> entryCompanyMap = new HashMap<String, CompanyOrgUnitInfo>();

    @Override
    public Class<SaleOrderCollection> getInfoClass() {
        return SaleOrderCollection.class;
    }

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return super.getBatchExecuteResult(paramEntries, batchMethod, methodPK);
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return SaleOrderFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    protected void setDefaultData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultData(model, errorMsg);
        SaleOrderInfo info = (SaleOrderInfo)model;
        this.setTotalAmount(info);
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        SaleOrderInfo info = (SaleOrderInfo)model;
        super.setDefaultHeadData((SCMBillBaseInfo)info, errorMsg);
        CompanyOrgUnitInfo cou = ScmbillImportUtils.getCompanyInfo(this.getContext(), (OrgUnitInfo)info.getSaleOrgUnit(), 2);
        info.setCompanyOrgUnit(cou);
        if (info.getSaleOrgUnit() != null && info.getSaleGroup() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getSaleGroup().getNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("saleOrg", (Object)info.getSaleOrgUnit().getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            viewInfo.setSelector(sic);
            SaleGroupCollection coll = SaleGroupFactory.getLocalInstance((Context)this.getContext()).getSaleGroupCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                info.setSaleGroup(coll.get(0));
            }
        }
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(info.getCurrency().getId());
        ObjectUuidPK destCurrPK = new ObjectUuidPK(cou.getBaseCurrency().getId());
        ExchangeRateInfo exchangeRate = SCMServerUtils.getExchangeRate((Context)this.getContext(), (CompanyOrgUnitInfo)cou, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
        if (exchangeRate != null) {
            if (info.getExchangeRate() == null) {
                info.setExchangeRate(exchangeRate.getConvertRate());
            }
            info.setConvertMode(exchangeRate.getConvertMode());
        } else {
            if (info.getExchangeRate() == null) {
                info.setExchangeRate(new BigDecimal("1.00"));
            }
            info.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        }
        info.setIsSysBill(false);
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0113c0a812fd463ED552"));
        info.setBillType(billtype);
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        SaleOrderEntryInfo entryInfo = (SaleOrderEntryInfo)entryModel;
        SaleOrderInfo info = (SaleOrderInfo)model;
        entryInfo.setSaleOrgUnit(info.getSaleOrgUnit().getId().toString());
        String deliveryOrgId = entryInfo.getStorageOrgUnit().getId().toString();
        CompanyOrgUnitInfo cou = this.entryCompanyMap.get(deliveryOrgId);
        if (cou == null) {
            cou = ScmbillImportUtils.getCompanyInfo(this.getContext(), (OrgUnitInfo)entryInfo.getStorageOrgUnit(), 4);
            if (cou == null) {
                cou = info.getCompany();
            }
            this.entryCompanyMap.put(deliveryOrgId, cou);
        }
        entryInfo.setCompanyOrgUnit(cou);
        entryInfo.setBizDate(info.getBizDate());
        if (entryInfo.getMaterial() != null) {
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            this.setBaseQty(entryInfo, errorMsg);
        }
        entryInfo.setIsLocked(false);
        this.setLoclePrice(entryInfo, info);
        this.setInvoice(entryInfo);
    }

    private void setLoclePrice(SaleOrderEntryInfo entryInfo, SaleOrderInfo info) {
        BigDecimal amount = this.zero;
        BigDecimal locleAmount = this.zero;
        BigDecimal locleTax = this.zero;
        BigDecimal exchangeRate = info.getExchangeRate();
        int scale = 4;
        if (info.getCurrency() != null) {
            scale = info.getCurrency().getPrecision();
        }
        if (exchangeRate == null) {
            exchangeRate = new BigDecimal("1.00");
        }
        if (entryInfo.getAmount() != null) {
            amount = entryInfo.getAmount();
            locleAmount = amount.multiply(exchangeRate).setScale(scale, 4);
            entryInfo.setLocalAmount(locleAmount);
        }
        if (entryInfo.getTax() != null) {
            locleTax = entryInfo.getTax().multiply(exchangeRate).setScale(scale, 4);
            entryInfo.setLocalTax(locleTax);
        }
        entryInfo.setLocalTaxAmount(locleTax.add(locleAmount));
    }

    private void setTotalAmount(SaleOrderInfo info) {
        SaleOrderEntryCollection entries = info.getEntries();
        BigDecimal totalAmount = this.zero;
        BigDecimal totalTax = this.zero;
        BigDecimal totalTaxAmount = this.zero;
        BigDecimal totalLocleAmount = this.zero;
        BigDecimal localTotalTaxAmount = this.zero;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            SaleOrderEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getAmount() != null) {
                totalAmount = totalAmount.add(entryInfo.getAmount());
            }
            if (entryInfo.getLocalAmount() != null) {
                totalLocleAmount = totalLocleAmount.add(entryInfo.getLocalAmount());
            }
            if (entryInfo.getTax() != null) {
                totalTax = totalTax.add(entryInfo.getTax());
            }
            if (entryInfo.getTaxAmount() != null) {
                totalTaxAmount = totalTaxAmount.add(entryInfo.getTaxAmount());
            }
            if (entryInfo.getLocalTaxAmount() == null) continue;
            localTotalTaxAmount = localTotalTaxAmount.add(entryInfo.getLocalTaxAmount());
        }
        info.setTotalAmount(totalAmount);
        info.setLocalTotalAmount(totalLocleAmount);
        info.setLocalTotalTaxAmount(localTotalTaxAmount);
        info.setTotalTax(totalTax);
        info.setTotalTaxAmount(totalTaxAmount);
    }

    private void setBaseQty(SaleOrderEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseunit = entryInfo.getBaseUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MultiMeasureUnitInfo basemmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, baseunit, errorMsg);
        BigDecimal qty = entryInfo.getQty();
        BigDecimal baseQty = this.zero;
        if (qty == null) {
            qty = this.zero;
        }
        if (mmu != null && basemmu != null) {
            qty = qty.setScale(mmu.getQtyPrecision(), 4);
            baseQty = qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4);
        }
        entryInfo.setQty(qty);
        entryInfo.setBaseQty(baseQty);
        entryInfo.setAssociateQty(qty);
        entryInfo.setTotalUnIssueBaseQty(baseQty);
        entryInfo.setTotalUnIssueQty(qty);
        entryInfo.setUnOrderedQty(qty);
        MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
        if (assistUnit != null) {
            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)this.getContext(), (MeasureUnitInfo)unit, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)material, (BigDecimal)qty);
            entryInfo.setAssistQty(assisqtyQty);
        }
    }

    private void setInvoice(SaleOrderEntryInfo entryInfo) {
        entryInfo.setUnInvoiceReqAmount(entryInfo.getTaxAmount());
        entryInfo.setUnInvoiceReqAmountLocal(entryInfo.getLocalTaxAmount());
        entryInfo.setUnInvoiceReqQty(entryInfo.getQty());
        entryInfo.setUnInvoiceReqBaseQty(entryInfo.getBaseQty());
    }
}

