/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarFactory;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.ws.app.importbill.BillResultInfo;
import com.kingdee.eas.scm.ws.app.importbill.IBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ScmBillSupport
implements IBillSupport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport");
    protected BigDecimal zero = new BigDecimal("0.00");
    public static String FIELD_ISINTAX = "isInTax";
    public static String FIELD_TRANSLEADTIME = "transLeadTime";
    private Context ctx;
    protected Map<String, MaterialInventoryInfo> materialInventoryInfoMap = new HashMap<String, MaterialInventoryInfo>();

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    @Override
    public Class getInfoClass() {
        return null;
    }

    private List<String> setData(Context ctx, SCMBillBaseInfo info) throws BOSException, EASBizException {
        ArrayList<String> errorMsg = new ArrayList<String>();
        this.dealWithData(ctx, info, errorMsg);
        this.setDefaultData(info, errorMsg);
        this.verifyData(info, errorMsg);
        return errorMsg;
    }

    protected void setDefaultData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        this.setDefaultHeadData(model, errorMsg);
        IObjectCollection entries = model.getEntries();
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)model.get("storageOrgUnit");
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
            this.setDefaultEntryData(entryInfo, model, errorMsg);
            this.setLot(entryInfo, sou);
        }
    }

    protected void setLot(SCMBillEntryBaseInfo entryInfo, StorageOrgUnitInfo sou) throws EASBizException, BOSException {
        MaterialInfo materialInfo = (MaterialInfo)entryInfo.get("material");
        if (null != materialInfo && null != sou) {
            MaterialInventoryInfo materialInventoryInfo;
            String materialId = materialInfo.getId().toString();
            String souId = sou.getId().toString();
            String key = materialId + "-" + souId;
            if (this.materialInventoryInfoMap.get(key) == null) {
                materialInventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)this.getContext()).getInventoryInfo(materialId, souId);
                this.materialInventoryInfoMap.put(key, materialInventoryInfo);
            } else {
                materialInventoryInfo = this.materialInventoryInfoMap.get(key);
            }
            if (null != materialInventoryInfo && !materialInventoryInfo.isIsLotNumber()) {
                entryInfo.put("lot", null);
            }
        }
        if (null != entryInfo.get("lot")) {
            entryInfo.put("lot", (Object)((String)entryInfo.get("lot")).trim());
        }
    }

    protected void setDefaultHeadData(SCMBillBaseInfo info, List<String> errorMsg) throws BOSException, EASBizException {
        if (info.getBizDate() == null) {
            info.setBizDate(new Date());
        }
    }

    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void dealWithData(Context ctx, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        this.dealWithHeadData(model, errorMsg);
        IObjectCollection entries = model.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
            this.dealWithEntryData(entryInfo, model, errorMsg);
        }
        ScmbillImportUtils.setInfoByNumber(ctx, (CoreBaseInfo)model, errorMsg);
    }

    protected void dealWithHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void dealWithEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void verifyData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        this.verifyHeadData(model, errorMsg);
        IObjectCollection entries = model.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
            this.verifyEntryData(entryInfo, model, errorMsg);
        }
        this.verifyMaterialLot(model);
        this.verifyProjectTrack(model);
    }

    private void verifyProjectTrack(SCMBillBaseInfo bill) throws BOSException, EASBizException {
        int i;
        if (!(bill instanceof InvBillBaseInfo) || ((InvBillBaseInfo)bill).getStorageOrgUnit() == null) {
            return;
        }
        IObjectCollection entries = bill.getEntries();
        HashSet<String> projectIdSet = new HashSet<String>();
        HashSet<String> trackIdSet = new HashSet<String>();
        for (int i2 = 0; i2 < entries.size(); ++i2) {
            ProjectInfo project = (ProjectInfo)entries.getObject(i2).getObjectValue("project");
            TrackNumberInfo trackInfo = (TrackNumberInfo)entries.getObject(i2).getObjectValue("tracknumber");
            if (project == null || project.getId() == null || trackInfo == null || trackInfo.getId() == null) continue;
            projectIdSet.add(project.getId().toString());
            trackIdSet.add(trackInfo.getId().toString());
        }
        if (projectIdSet.size() == 0) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("project.id", projectIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", trackIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        ProjectCarCollection coll = ProjectCarFactory.getLocalInstance((Context)this.getContext()).getProjectCarCollection(viewInfo);
        HashMap projectMap = new HashMap();
        List<String> list = null;
        for (i = 0; i < coll.size(); ++i) {
            ProjectCarInfo projectCarInfo = coll.get(i);
            String projectId = projectCarInfo.getProject().getId().toString();
            if (projectMap.containsKey(projectId)) {
                list = (List)projectMap.get(projectId);
            } else {
                list = new ArrayList();
                projectMap.put(projectId, list);
            }
            list.add(projectCarInfo.getTrackNumber().getId().toString());
        }
        for (i = 0; i < entries.size(); ++i) {
            ProjectInfo project = (ProjectInfo)entries.getObject(i).getObjectValue("project");
            TrackNumberInfo trackInfo = (TrackNumberInfo)entries.getObject(i).getObjectValue("trackNumber");
            if (project == null || project.getId() == null || trackInfo == null || trackInfo.getId() == null || (list = (List)projectMap.get(project.getId().toString())) != null && list.contains(trackInfo.getId().toString())) continue;
            throw new SCMBillException(SCMBillException.TRACK_ERROR, (Object[])new String[]{bill.getNumber(), trackInfo.getNumber()});
        }
    }

    protected void verifyMaterialLot(SCMBillBaseInfo bill) throws BOSException, EASBizException {
        int i;
        if (!(bill instanceof InvBillBaseInfo) || !this.needCheckLot(bill) || ((InvBillBaseInfo)bill).getStorageOrgUnit() == null) {
            return;
        }
        IObjectCollection entries = bill.getEntries();
        HashSet<String> notLotMatIdSet = new HashSet<String>();
        HashSet<String> matIdSet = new HashSet<String>();
        for (int i2 = 0; i2 < entries.size(); ++i2) {
            MaterialInfo material = (MaterialInfo)entries.getObject(i2).getObjectValue("material");
            if (material == null || material.getId() == null) continue;
            matIdSet.add(material.getId().toString());
        }
        if (matIdSet.size() == 0) {
            return;
        }
        IMaterialInventory instance = MaterialInventoryFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)((InvBillBaseInfo)bill).getStorageOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material.id", matIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isLotNumber", (Object)0));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("material.id"));
        view.setSelector(sic);
        view.setFilter(filter);
        MaterialInventoryCollection inventoryCollection = instance.getMaterialInventoryCollection(view);
        if (inventoryCollection.size() > 0) {
            for (i = 0; i < inventoryCollection.size(); ++i) {
                notLotMatIdSet.add(inventoryCollection.get(i).getMaterial().getId().toString());
            }
        }
        if (notLotMatIdSet.size() == 0) {
            return;
        }
        for (i = 0; i < entries.size(); ++i) {
            MaterialInfo materialInfo = (MaterialInfo)entries.getObject(i).getObjectValue("material");
            String lot = entries.getObject(i).getString("lot");
            if (StringUtil.isEmpty((String)lot) || materialInfo == null || materialInfo.getId() == null || !notLotMatIdSet.contains(materialInfo.getId().toString())) continue;
            throw new SCMBillException(SCMBillException.MAT_NOT_LOT, (Object[])new String[]{bill.getNumber(), materialInfo.getNumber()});
        }
    }

    protected boolean needCheckLot(SCMBillBaseInfo bill) {
        boolean b = false;
        if ("15F2BD83".equals(bill.getBOSType().toString()) || SCMConstant.BOSTYPE_PURINWAREHS.equals(bill.getBOSType().toString()) || "FA1292B4".equals(bill.getBOSType().toString()) || "E3DAFF63".equals(bill.getBOSType().toString()) || "A4D04D23".equals(bill.getBOSType().toString()) || SCMConstant.BOSTYPE_SALEISSUE.equals(bill.getBOSType().toString()) || "A4D04D24".equals(bill.getBOSType().toString()) || "71D272F1".equals(bill.getBOSType().toString())) {
            b = true;
        }
        return b;
    }

    protected void verifyHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void verifyEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    public List<BillResultInfo> audit(List<BillResultInfo> results) throws EASBizException, BOSException {
        BatchExecuteResult result = null;
        ArrayList<BatchExecuteParamsEntry> paramEntriesList = new ArrayList<BatchExecuteParamsEntry>();
        BatchExecuteParamsEntry entry = null;
        boolean count = false;
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < results.size(); ++i) {
            BillResultInfo resultInfo = results.get(i);
            if (resultInfo == null || resultInfo.getStatus() != 0) continue;
            String billid = resultInfo.getId();
            ObjectStringPK pk = new ObjectStringPK(billid);
            SCMBillBaseInfo billInfo = this.getInterface().getSCMBillBaseInfo((IObjectPK)pk);
            if (BillBaseStatusEnum.AUDITED.equals((Object)billInfo.getBaseStatus())) continue;
            entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
            entry.add((Object)new ObjectUuidPK(billid));
            paramEntriesList.add(entry);
            indexMap.put(i, paramEntriesList.size() - 1);
        }
        if (paramEntriesList.size() == 0) {
            return results;
        }
        BatchExecuteParamsEntry[] paramEntries = paramEntriesList.toArray(new BatchExecuteParamsEntry[paramEntriesList.size()]);
        Class[] batchMethod = new Class[]{IObjectPK.class};
        String methodPK = "audit";
        result = this.getBatchExecuteResult(false, paramEntries, batchMethod, methodPK);
        Iterator iterator = indexMap.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (null == indexMap.get(i)) continue;
            BillResultInfo resultInfo = results.get(i);
            int resultIndex = (Integer)indexMap.get(i);
            if (result.getException(resultIndex) == null) {
                resultInfo.setStatus(0);
                continue;
            }
            ArrayList<String> errorMsg = new ArrayList<String>();
            errorMsg.add(result.getException(resultIndex).getMessage());
            resultInfo.setErrorMsgs(errorMsg);
            resultInfo.setStatus(1);
        }
        return results;
    }

    @Override
    public List<BillResultInfo> save(AbstractObjectCollection col) throws EASBizException, BOSException {
        List<BillResultInfo> results = this.saveOrSubmitData(col, true);
        return results;
    }

    @Override
    public List<BillResultInfo> submit(AbstractObjectCollection col) throws EASBizException, BOSException {
        List<BillResultInfo> results = this.saveOrSubmitData(col, false);
        return results;
    }

    private List<BillResultInfo> saveOrSubmitData(AbstractObjectCollection col, boolean isSave) throws BOSException, EASBizException {
        List<String> errorMsg;
        ArrayList<BillResultInfo> results = new ArrayList<BillResultInfo>();
        SCMBillBaseInfo info = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = (SCMBillBaseInfo)col.getObject(i);
            errorMsg = this.setData(this.ctx, info);
            if (errorMsg == null || errorMsg.size() <= 0) continue;
            BillResultInfo result = new BillResultInfo();
            result.setErrorMsgs(errorMsg);
            result.setNumber(info.getNumber());
            result.setStatus(1);
            results.add(result);
            col.removeObject(i);
            --i;
            --size;
        }
        if (col != null && col.size() > 0) {
            BatchExecuteResult result = null;
            BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[col.size()];
            BatchExecuteParamsEntry entry = null;
            int size2 = col.size();
            for (int i = 0; i < size2; ++i) {
                entry = new BatchExecuteParamsEntry(new Class[]{CoreBaseInfo.class});
                entry.add((Object)col.getObject(i));
                paramEntries[i] = entry;
            }
            Class[] batchMethod = new Class[]{CoreBaseInfo.class};
            String methodPK = "submit";
            if (isSave) {
                methodPK = "save";
            }
            result = this.getBatchExecuteResult(isSave, paramEntries, batchMethod, methodPK);
            Object[] objs = result.getReturnValues();
            int size3 = objs.length;
            for (int i = 0; i < size3; ++i) {
                info = (SCMBillBaseInfo)col.getObject(i);
                errorMsg = new ArrayList<String>();
                BillResultInfo resultInfo = new BillResultInfo();
                resultInfo.setNumber(info.getNumber());
                if (result.getException(i) == null) {
                    resultInfo.setId(result.getReturnValue(i).toString());
                    resultInfo.setStatus(0);
                } else {
                    errorMsg.add(result.getException(i).getMessage());
                    resultInfo.setErrorMsgs(errorMsg);
                    resultInfo.setStatus(1);
                }
                results.add(resultInfo);
            }
        }
        return results;
    }

    public BatchExecuteResult getBatchExecuteResult(boolean isSave, BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BOSException {
        BatchExecuteResult result;
        try {
            if (!isSave) {
                this.ctx.put((Object)"CONTEXT_KEY_ISBATCHACTION", (Object)Boolean.FALSE);
            }
            Method method = this.getClass().getDeclaredMethod("getBatchExecuteResult", BatchExecuteParamsEntry[].class, Class[].class, String.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)this);
            result = (BatchExecuteResult)txInvoker.invoke(method, new Object[]{paramEntries, batchMethod, methodPK}, 4);
            if (!isSave) {
                this.ctx.put((Object)"CONTEXT_KEY_ISBATCHACTION", null);
            }
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new BOSException(e);
        }
        return result;
    }

    protected BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return this.getInterface().batchExecute(methodPK, batchMethod, paramEntries);
    }

    public abstract ISCMBillBase getInterface() throws BOSException;

    protected void verifyDecimal(BigDecimal decimal, List<String> errorMsg, String nullSourceName, String zeroSourceName) {
        if (decimal == null) {
            if (nullSourceName != null) {
                errorMsg.add(this.getResource(nullSourceName, this.getContext(), new Object[0]));
            }
        } else if (zeroSourceName != null && BigDecimal.ZERO.compareTo(decimal) == 0) {
            errorMsg.add(this.getResource(zeroSourceName, this.getContext(), new Object[0]));
        }
    }

    protected void verifyNumber(String number, List<String> errorMsg) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number)) {
            errorMsg.add(this.getResource("NUMBER_IS_NULL", this.getContext(), new Object[0]));
        } else {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.put("number", (Object)number);
            boolean exists = this.getInterface().exists(filterInfo);
            if (exists) {
                errorMsg.add(this.getResource("NUMBER_IS_DUP", this.getContext(), number));
            }
        }
    }

    protected void verifyDataInfo(DataBaseInfo info, List<String> errorMsg, String errorSourceName, Object ... params) {
        if (info == null || StringUtils.isEmpty((String)info.getNumber())) {
            errorMsg.add(this.getResource(errorSourceName, this.getContext(), params));
        }
    }

    protected void verifyDataInfo(CoreBaseInfo info, List<String> errorMsg, String errorSourceName, Object ... params) {
        if (info == null || StringUtils.isEmpty((String)info.getString("number"))) {
            errorMsg.add(this.getResource(errorSourceName, this.getContext(), params));
        }
    }

    protected String getResource(String key, Context ctx, Object ... params) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.ws.app.SCMWSResource", (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }

    protected Date today() {
        Calendar calendar = Calendar.getInstance(this.getContext().getLocale());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

