/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.scm.sm.sc.SubMaterialListCollection;
import com.kingdee.eas.scm.sm.sc.SubMaterialListInfo;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class SubContractOrderBillSupport
extends ScmBillSupport {
    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return SubContractOrderFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public Class getInfoClass() {
        return SubContractOrderCollection.class;
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo info, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void dealWithHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        PaymentTypeInfo paymentType;
        CurrencyInfo currency;
        BizTypeInfo bizType;
        SubContractOrderInfo info = (SubContractOrderInfo)model;
        Date bizDate = info.getBizDate();
        if (bizDate == null) {
            Calendar calendar = Calendar.getInstance(this.getContext().getLocale());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            info.setBizDate(calendar.getTime());
        }
        if ((bizType = info.getBizType()) == null) {
            bizType = new BizTypeInfo();
            bizType.setNumber("130");
            info.setBizType(bizType);
        }
        if ((currency = info.getCurrency()) == null) {
            currency = new CurrencyInfo();
            currency.setNumber("BB01");
            info.setCurrency(currency);
        }
        if ((paymentType = info.getPaymentType()) == null) {
            paymentType = new PaymentTypeInfo();
            paymentType.setNumber("004");
            info.setPaymentType(paymentType);
        }
    }

    @Override
    protected void dealWithEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        SubContractOrderEntryInfo info = (SubContractOrderEntryInfo)entryModel;
        if (info.getAmount() != null && info.getTax() != null) {
            BigDecimal amount = info.getAmount();
            BigDecimal tax = info.getTax();
            info.setTaxAmount(amount.add(tax));
        }
    }

    @Override
    protected void verifyHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        SubContractOrderInfo info = (SubContractOrderInfo)model;
        this.verifyDataInfo((DataBaseInfo)info.getPurchaseOrgUnit(), errorMsg, "PURORG_IS_NULL", new Object[0]);
    }

    @Override
    protected void verifyEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        SubContractOrderEntryInfo info = (SubContractOrderEntryInfo)entryModel;
        this.verifyDataInfo((DataBaseInfo)info.getMaterial(), errorMsg, "MATERIAL_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getUnit(), errorMsg, "MEASURE_UNIT_IS_NULL", new Object[0]);
        this.verifyDecimal(info.getQty(), errorMsg, null, "QTY_IS_ZERO");
        this.verifyDecimal(info.getPrice(), errorMsg, null, "PRICE_IS_ZERO");
        this.verifyDecimal(info.getTaxPrice(), errorMsg, null, "TAXPRICE_IS_ZERO");
        SubMaterialListCollection entries1 = info.getEntries1();
        if (entries1 == null || entries1.isEmpty()) {
            errorMsg.add(this.getResource("SUB_MATERIAL_LIST_IS_NULL", this.getContext(), new Object[0]));
        } else {
            for (SubMaterialListInfo listInfo : entries1) {
                this.verifyDataInfo((DataBaseInfo)listInfo.getMaterial(), errorMsg, "SUB_MATERIAL_LIST_MATERIAL_IS_NULL", new Object[0]);
                this.verifyDataInfo((DataBaseInfo)listInfo.getUnit(), errorMsg, "SUB_MATERIAL_LIST_UNIT_IS_NULL", new Object[0]);
                this.verifyDecimal(listInfo.getQty(), errorMsg, null, "SUB_MATERIAL_LIST_QTY_IS_ZERO");
            }
        }
    }
}

