/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.atsContrl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsNounCommonResEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.atsContrl.AtsDepOTLimitAdjustBillEntryInfo;
import com.kingdee.eas.hr.atsContrl.AtsDepOTLimitAdjustBillFactory;
import com.kingdee.eas.hr.atsContrl.AtsDepOTLimitAdjustBillInfo;
import com.kingdee.eas.hr.atsContrl.AtsHistoryDepOTLimitFactory;
import com.kingdee.eas.hr.atsContrl.AtsHistoryDepOTLimitInfo;
import com.kingdee.eas.hr.atsContrl.AttenceDepOTLimitFactory;
import com.kingdee.eas.hr.atsContrl.AttenceDepOTLimitInfo;
import com.kingdee.eas.hr.atsContrl.app.AbstractAtsDepOTLimitAdjustBillControllerBean;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class AtsDepOTLimitAdjustBillControllerBean
extends AbstractAtsDepOTLimitAdjustBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.atsContrl.app.AtsDepOTLimitAdjustBillControllerBean");

    @Override
    protected void _setPassState_atsDepAdjustBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        try {
            this._setState(ctx, billId, HRBillStateEnum.AUDITED);
            AtsDepOTLimitAdjustBillInfo billInfo = null;
            billInfo = AtsDepOTLimitAdjustBillFactory.getLocalInstance(ctx).getAtsDepOTLimitAdjustBillInfo("where id='" + billId.toString() + "'");
            AttenceDepOTLimitInfo preLimitInfo = this.getExistLimitInfoBybillId(billInfo, ctx);
            this.addModifyLimitRecord(preLimitInfo, billInfo, ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AttenceDepOTLimitInfo getExistLimitInfoBybillId(AtsDepOTLimitAdjustBillInfo billInfo, Context ctx) {
        AttenceDepOTLimitInfo limitInfo = null;
        AtsDepOTLimitAdjustBillEntryInfo entryInfo = billInfo.getEntries().get(0);
        String cycleName = entryInfo.getDateValueStr();
        String controlType = billInfo.getControlType().getValue();
        String adminId = entryInfo.getAdjustAdminOrg().getId().toString();
        String oql = " where controlTimeRag ='" + cycleName + "' and controlType = '" + controlType + "' and adminOrgUnit.id ='" + adminId + "'";
        try {
            ctx.getUserName();
            limitInfo = AttenceDepOTLimitFactory.getLocalInstance(ctx).getAttenceDepOTLimitInfo(oql);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return limitInfo;
    }

    public void addModifyLimitRecord(AttenceDepOTLimitInfo perlimitInfo, AtsDepOTLimitAdjustBillInfo currentInfo, Context ctx) {
        AtsDepOTLimitAdjustBillEntryInfo entryInfo = currentInfo.getEntries().get(0);
        String adjustReason = MLUtile.getRes((ResourceEnum)AtsBillResEnum.ModifyBill, (Context)ctx);
        if (null != currentInfo.getAdjustReason()) {
            adjustReason = currentInfo.getAdjustReason();
        }
        BigDecimal OTfreeVal = entryInfo.getOTfreeAdjustVal();
        BigDecimal WorkTimeVal = entryInfo.getWorkTimeAdjustVal();
        BigDecimal preOTfreeValBig = entryInfo.getOTfreeVal();
        BigDecimal preWorkTimeValBig = entryInfo.getWorkTimeVal();
        BigDecimal OTfreeValAdjustsub = new BigDecimal(0);
        BigDecimal WorkTimeValAdjustsub = new BigDecimal(0);
        String OTfreeValAdjustPercentStr = "";
        String WorkTimeValAdjustPercentStr = "";
        if (preOTfreeValBig.compareTo(OTfreeVal) < 0) {
            OTfreeValAdjustsub = OTfreeVal.subtract(preOTfreeValBig);
            OTfreeValAdjustPercentStr = MLUtile.getRes((ResourceEnum)AtsNounCommonResEnum.UpRegulation, (Context)ctx);
        } else if (preOTfreeValBig.compareTo(OTfreeVal) > 0) {
            OTfreeValAdjustsub = preOTfreeValBig.subtract(OTfreeVal);
            OTfreeValAdjustPercentStr = MLUtile.getRes((ResourceEnum)AtsNounCommonResEnum.DownRegulation, (Context)ctx);
        }
        BigDecimal limitValAdjustPercent = OTfreeValAdjustsub.divide(preOTfreeValBig, 2, 2).multiply(new BigDecimal(100));
        OTfreeValAdjustPercentStr = OTfreeValAdjustPercentStr + limitValAdjustPercent.toString() + "%";
        if (preWorkTimeValBig.compareTo(WorkTimeVal) < 0) {
            WorkTimeValAdjustsub = WorkTimeVal.subtract(preWorkTimeValBig);
            WorkTimeValAdjustPercentStr = MLUtile.getRes((ResourceEnum)AtsNounCommonResEnum.UpRegulation, (Context)ctx);
        } else if (preWorkTimeValBig.compareTo(WorkTimeVal) > 0) {
            WorkTimeValAdjustsub = preWorkTimeValBig.subtract(WorkTimeVal);
            WorkTimeValAdjustPercentStr = MLUtile.getRes((ResourceEnum)AtsNounCommonResEnum.DownRegulation, (Context)ctx);
        }
        BigDecimal warnValAdjustPercent = WorkTimeValAdjustsub.divide(preWorkTimeValBig, 2, 2).multiply(new BigDecimal(100));
        WorkTimeValAdjustPercentStr = WorkTimeValAdjustPercentStr + warnValAdjustPercent.toString() + "%";
        AtsHistoryDepOTLimitInfo atsHistoryDepOTLimitInfo = new AtsHistoryDepOTLimitInfo();
        PersonInfo personInfo = SHRBillServerUtil.getCurrPersonInfo((Context)ctx);
        atsHistoryDepOTLimitInfo.setName(perlimitInfo.getName());
        atsHistoryDepOTLimitInfo.setAdminOrgUnit(perlimitInfo.getAdminOrgUnit());
        atsHistoryDepOTLimitInfo.setProposer(personInfo);
        atsHistoryDepOTLimitInfo.setPreOTfreeVal(preOTfreeValBig);
        atsHistoryDepOTLimitInfo.setPreWorkTimeVal(preWorkTimeValBig);
        atsHistoryDepOTLimitInfo.setOTfreeValAdjustPercent(OTfreeValAdjustPercentStr);
        atsHistoryDepOTLimitInfo.setWorkTimeAdjustPercent(WorkTimeValAdjustPercentStr);
        atsHistoryDepOTLimitInfo.setOTfreeVal(OTfreeVal);
        atsHistoryDepOTLimitInfo.setWorkTimeVal(WorkTimeVal);
        atsHistoryDepOTLimitInfo.setUsedOTfreeVal(perlimitInfo.getUsedfreeVal());
        atsHistoryDepOTLimitInfo.setUsedWorkTimeVal(perlimitInfo.getUsedTimeVal());
        atsHistoryDepOTLimitInfo.setCycleDateType(perlimitInfo.getAttenceOTCycle());
        atsHistoryDepOTLimitInfo.setOTControlType(perlimitInfo.getControlType());
        atsHistoryDepOTLimitInfo.setStartDate(perlimitInfo.getBeginDate());
        atsHistoryDepOTLimitInfo.setEndDate(perlimitInfo.getEndDate());
        atsHistoryDepOTLimitInfo.setAttenceCycleName(perlimitInfo.getControlTimeRag());
        atsHistoryDepOTLimitInfo.setAdjustReason(adjustReason);
        atsHistoryDepOTLimitInfo.setRelatedRecord(perlimitInfo);
        BigDecimal ramainOTfree = OTfreeVal.subtract(perlimitInfo.getUsedfreeVal());
        BigDecimal remainWork = WorkTimeVal.subtract(perlimitInfo.getUsedTimeVal());
        atsHistoryDepOTLimitInfo.setRemainOTfreeVal(ramainOTfree);
        atsHistoryDepOTLimitInfo.setRemainWorkTimeVal(remainWork);
        BigDecimal workDay = perlimitInfo.getWorkDay();
        perlimitInfo.setOTfreeVal(OTfreeVal);
        perlimitInfo.setWorkTimeVal(WorkTimeVal);
        perlimitInfo.setWorkTimeAvgVal(WorkTimeVal.divide(workDay, DecimalPlaceUtil.getDecimalPlaceSystem((Context)ctx), 4));
        perlimitInfo.setOTfreeAvgVal(OTfreeVal.divide(workDay, DecimalPlaceUtil.getDecimalPlaceSystem((Context)ctx), 4));
        perlimitInfo.setRemainfreeVal(ramainOTfree);
        perlimitInfo.setRemainTimeVal(remainWork);
        try {
            AtsHistoryDepOTLimitFactory.getLocalInstance(ctx).save((CoreBaseInfo)atsHistoryDepOTLimitInfo);
            ObjectUuidPK pk = new ObjectUuidPK(perlimitInfo.getId().toString());
            AttenceDepOTLimitFactory.getLocalInstance(ctx).update((IObjectPK)pk, perlimitInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

