/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.shr.baseconfig.QueryConfigCollection;
import com.kingdee.shr.baseconfig.QueryConfigFactory;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.StructureConfigSchemeCollection;
import com.kingdee.shr.baseconfig.StructureConfigSchemeFactory;
import com.kingdee.shr.baseconfig.StructureConfigSchemeInfo;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class StructureConfigConvertHelper {
    private static Logger logger = Logger.getLogger(StructureConfigConvertHelper.class);
    private Context ctx;
    private static final String CACHE_TYPE = "shr.structureAndQueryConfigcache";
    public static final int SCHEME_INFO = 0;
    public static final int SCHEME_NUMBER_STRUCTURECONFIG_ID_MAP = 2;
    public static final int SCHEME_NUMBER_STRUCTURECONFIG_NUMBER_MAP = 3;
    public static final int SCHEME_NUMBER_QUERYFIELD_MAP = 5;
    public static final int SCHEME_NUMBER_STRUCTURE_ROOE = 6;
    public static final String STRUCTURE_CONFIG = "structureConfig";
    public static final String STRUCTURE_CONFIG_ID = "ID";
    public static final String STRUCTURE_CONFIG_NUMBER = "NUMBER";

    public StructureConfigConvertHelper(Context ctx) {
        this.ctx = ctx;
    }

    private static StructureConfigSchemeCollection getStructureConfigSchemeCollectionFromDB(Context ctx) throws BOSException {
        return StructureConfigSchemeFactory.getLocalInstance(ctx).getStructureConfigSchemeCollection();
    }

    private static StructureConfigCollection getStructureConfigCollectionFromDB(Context ctx, String scheme) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(StructureConfigConvertHelper.getSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("scheme.number", (Object)scheme, CompareType.EQUALS));
        view.setFilter(filter);
        return StructureConfigFactory.getLocalInstance(ctx).getStructureConfigCollection(view);
    }

    private static QueryConfigCollection getQueryConfigCollectionFromDB(Context ctx, String scheme) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(StructureConfigConvertHelper.getQuerySelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("scheme.number", (Object)scheme));
        entityViewInfo.setFilter(filter);
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("number"));
        entityViewInfo.setSorter(sorters);
        return QueryConfigFactory.getLocalInstance(ctx).getQueryConfigCollection(entityViewInfo);
    }

    public static StructureConfigInfo getMain(Context ctx, String scheme) throws BOSException {
        String key = StructureConfigConvertHelper.getSchemeRootKey(scheme);
        StructureConfigInfo structureConfigInfo = (StructureConfigInfo)StructureConfigConvertHelper.getValueFromCache(key);
        if (null == structureConfigInfo) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(StructureConfigConvertHelper.getSelector());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("scheme.number", (Object)scheme, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
            view.setFilter(filter);
            StructureConfigCollection coll = StructureConfigFactory.getLocalInstance(ctx).getStructureConfigCollection(view);
            if (coll.size() > 0) {
                structureConfigInfo = coll.get(0);
                StructureConfigConvertHelper.setValueToCache(key, structureConfigInfo);
            }
        }
        return structureConfigInfo;
    }

    private static String getSchemeRootKey(String schemeNumber) {
        return MessageFormat.format("{0}_{1}", 6, schemeNumber);
    }

    public StructureConfigInfo getMain(String scheme) throws BOSException {
        return StructureConfigConvertHelper.getMain(this.ctx, scheme);
    }

    public static StructureConfigSchemeInfo getScheme(Context ctx, String scheme) throws BOSException {
        String key = StructureConfigConvertHelper.getSchemeKey(scheme);
        StructureConfigSchemeInfo structureConfigSchemeInfo = (StructureConfigSchemeInfo)StructureConfigConvertHelper.getValueFromCache(key);
        if (null == structureConfigSchemeInfo) {
            String saveKey = null;
            StructureConfigSchemeCollection coll = StructureConfigConvertHelper.getStructureConfigSchemeCollectionFromDB(ctx);
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                saveKey = StructureConfigConvertHelper.getSchemeKey(coll.get(i).getNumber());
                StructureConfigConvertHelper.setValueToCache(saveKey, coll.get(i));
                if (!saveKey.equals(key)) continue;
                structureConfigSchemeInfo = coll.get(i);
            }
        }
        return structureConfigSchemeInfo;
    }

    private static String getSchemeKey(String schemeNumber) {
        return MessageFormat.format("{0}_{1}", 0, schemeNumber);
    }

    public static StructureConfigCollection getStructureConfigCollection(Context ctx, String scheme) throws BOSException {
        long begin = System.currentTimeMillis();
        StructureConfigCollection coll = StructureConfigConvertHelper.getStructureConfigCollectionFromDB(ctx, scheme);
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("getStructureConfigCollection query cost:{0} ms,{1} s", end - begin, (double)(end - begin) * 1.0 / 1000.0));
        }
        return coll;
    }

    public static StructureConfigInfo getStructureConfigByID(Context ctx, String id, String scheme) throws BOSException {
        String key = StructureConfigConvertHelper.getStructureConfigKey(id, scheme, STRUCTURE_CONFIG_ID);
        StructureConfigInfo structureConfigInfo = (StructureConfigInfo)StructureConfigConvertHelper.getValueFromCache(key);
        if (null == structureConfigInfo) {
            String saveKey = null;
            String numberkey = null;
            StructureConfigCollection coll = StructureConfigConvertHelper.getStructureConfigCollection(ctx, scheme);
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                saveKey = StructureConfigConvertHelper.getStructureConfigKey(coll.get(i).getId().toString(), scheme, STRUCTURE_CONFIG_ID);
                numberkey = StructureConfigConvertHelper.getStructureConfigKey(coll.get(i).getClientNumber().toUpperCase(), scheme, STRUCTURE_CONFIG_NUMBER);
                StructureConfigConvertHelper.setValueToCache(saveKey, coll.get(i));
                StructureConfigConvertHelper.setValueToCache(numberkey, coll.get(i));
                if (!saveKey.equals(key)) continue;
                structureConfigInfo = coll.get(i);
            }
        }
        return structureConfigInfo;
    }

    public StructureConfigInfo getStructureConfigByID(String id, String scheme) throws BOSException {
        return StructureConfigConvertHelper.getStructureConfigByID(this.ctx, id, scheme);
    }

    private static String getStructureConfigKey(String key, String scheme, String type) {
        return MessageFormat.format("{0}_{1}_{2}_{3}", 2, type, scheme, key);
    }

    public static StructureConfigInfo getStructureConfigByNumber(Context ctx, String number, String scheme) throws BOSException {
        String key = StructureConfigConvertHelper.getStructureConfigKey(number.toUpperCase(), scheme, STRUCTURE_CONFIG_NUMBER);
        StructureConfigInfo structureConfigInfo = (StructureConfigInfo)StructureConfigConvertHelper.getValueFromCache(key);
        if (null == structureConfigInfo) {
            String saveKey = null;
            StructureConfigCollection structureConfigCollection = StructureConfigConvertHelper.getStructureConfigCollection(ctx, scheme);
            String idKey = null;
            int total = structureConfigCollection.size();
            for (int i = 0; i < total; ++i) {
                saveKey = StructureConfigConvertHelper.getStructureConfigKey(structureConfigCollection.get(i).getClientNumber().toUpperCase(), scheme, STRUCTURE_CONFIG_NUMBER);
                idKey = StructureConfigConvertHelper.getStructureConfigKey(structureConfigCollection.get(i).getId().toString(), scheme, STRUCTURE_CONFIG_ID);
                StructureConfigConvertHelper.setValueToCache(saveKey, structureConfigCollection.get(i));
                StructureConfigConvertHelper.setValueToCache(idKey, structureConfigCollection.get(i));
                if (!saveKey.equals(key)) continue;
                structureConfigInfo = structureConfigCollection.get(i);
            }
        }
        return structureConfigInfo;
    }

    public StructureConfigInfo getStructureConfigByKey(String key, String scheme) throws BOSException {
        return StructureConfigConvertHelper.getStructureConfigByKey(this.ctx, key, scheme);
    }

    public static StructureConfigInfo getStructureConfigByKey(Context ctx, String key, String scheme) throws BOSException {
        String number = null;
        if (key.startsWith("UPPER(")) {
            String pName = key.substring(key.indexOf("(") + 1, key.length() - 1);
            String[] keys = pName.split("\\.");
            number = keys[0].toUpperCase();
        } else {
            String[] keys = key.split("\\.");
            number = keys[0].toUpperCase();
        }
        return StructureConfigConvertHelper.getStructureConfigByNumber(ctx, number, scheme);
    }

    public static QueryConfigCollection getQueryConfigCollection(Context ctx, String scheme) throws BOSException {
        long begin = System.currentTimeMillis();
        QueryConfigCollection coll = StructureConfigConvertHelper.getQueryConfigCollectionFromDB(ctx, scheme);
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("getQueryConfigCollection query cost:{0} ms,{1} s", end - begin, (double)(end - begin) * 1.0 / 1000.0));
        }
        return coll;
    }

    public QueryConfigCollection getQueryConfigCollection(String scheme) throws BOSException {
        return StructureConfigConvertHelper.getQueryConfigCollection(this.ctx, scheme);
    }

    public static QueryConfigFieldInfo getQueryFieldByKey(Context ctx, String scheme, String property) throws BOSException {
        String key = StructureConfigConvertHelper.getQueryConfigFieldInfoKey(scheme, property.toUpperCase());
        QueryConfigFieldInfo queryConfigFieldInfo = (QueryConfigFieldInfo)StructureConfigConvertHelper.getValueFromCache(key);
        if (null == queryConfigFieldInfo) {
            QueryConfigCollection queryConfigCollection = StructureConfigConvertHelper.getQueryConfigCollection(ctx, scheme);
            String saveKeyByProperty = null;
            String saveKeyById = null;
            int total = queryConfigCollection.size();
            for (int i = 0; i < total; ++i) {
                if (null == queryConfigCollection.get(i) || null == queryConfigCollection.get(i).getFields()) continue;
                int kTotal = queryConfigCollection.get(i).getFields().size();
                for (int k = 0; k < kTotal; ++k) {
                    if (null == queryConfigCollection.get(i).getFields() || null == queryConfigCollection.get(i).getFields().get(k) || null == queryConfigCollection.get(i).getFields().get(k).getFactField() || null == queryConfigCollection.get(i).getFields().get(k).getFactField().getStructureConfig() || null == queryConfigCollection.get(i).getFields().get(k).getFactField().getStructureConfig().getClientNumber() || null == queryConfigCollection.get(i).getFields().get(k).getFactField().getNumber()) continue;
                    String realKey = queryConfigCollection.get(i).getFields().get(k).getFactField().getStructureConfig().getClientNumber() + "." + queryConfigCollection.get(i).getFields().get(k).getFactField().getNumber();
                    saveKeyByProperty = StructureConfigConvertHelper.getQueryConfigFieldInfoKey(scheme, realKey.toUpperCase());
                    saveKeyById = StructureConfigConvertHelper.getQueryConfigFieldInfoKey(scheme, queryConfigCollection.get(i).getFields().get(k).getId().toString());
                    StructureConfigConvertHelper.setValueToCache(saveKeyByProperty, queryConfigCollection.get(i).getFields().get(k));
                    StructureConfigConvertHelper.setValueToCache(saveKeyById, queryConfigCollection.get(i).getFields().get(k));
                    if (!saveKeyByProperty.equals(key)) continue;
                    queryConfigFieldInfo = queryConfigCollection.get(i).getFields().get(k);
                }
            }
        }
        return queryConfigFieldInfo;
    }

    public static QueryConfigFieldInfo getQueryFieldById(Context ctx, String scheme, String id) throws BOSException {
        String keyId = StructureConfigConvertHelper.getQueryConfigFieldInfoKey(scheme, id);
        QueryConfigFieldInfo queryConfigFieldInfo = (QueryConfigFieldInfo)StructureConfigConvertHelper.getValueFromCache(keyId);
        if (null == queryConfigFieldInfo) {
            QueryConfigCollection queryConfigCollection = StructureConfigConvertHelper.getQueryConfigCollection(ctx, scheme);
            String saveKeyById = null;
            String saveKeyByProperty = null;
            int total = queryConfigCollection.size();
            for (int i = 0; i < total; ++i) {
                if (null == queryConfigCollection.get(i) || null == queryConfigCollection.get(i).getFields()) continue;
                int kTotal = queryConfigCollection.get(i).getFields().size();
                for (int k = 0; k < kTotal; ++k) {
                    if (null == queryConfigCollection.get(i).getFields() || null == queryConfigCollection.get(i).getFields().get(k) || null == queryConfigCollection.get(i).getFields().get(k).getFactField() || null == queryConfigCollection.get(i).getFields().get(k).getFactField().getStructureConfig() || null == queryConfigCollection.get(i).getFields().get(k).getFactField().getStructureConfig().getClientNumber() || null == queryConfigCollection.get(i).getFields().get(k).getFactField().getNumber()) continue;
                    String realKey = queryConfigCollection.get(i).getFields().get(k).getFactField().getStructureConfig().getClientNumber() + "." + queryConfigCollection.get(i).getFields().get(k).getFactField().getNumber();
                    saveKeyByProperty = StructureConfigConvertHelper.getQueryConfigFieldInfoKey(scheme, realKey.toUpperCase());
                    saveKeyById = StructureConfigConvertHelper.getQueryConfigFieldInfoKey(scheme, queryConfigCollection.get(i).getFields().get(k).getId().toString());
                    StructureConfigConvertHelper.setValueToCache(saveKeyByProperty, queryConfigCollection.get(i).getFields().get(k));
                    StructureConfigConvertHelper.setValueToCache(saveKeyById, queryConfigCollection.get(i).getFields().get(k));
                    if (!saveKeyById.equals(keyId)) continue;
                    queryConfigFieldInfo = queryConfigCollection.get(i).getFields().get(k);
                }
            }
        }
        return queryConfigFieldInfo;
    }

    public QueryConfigFieldInfo getQueryFieldByKey(String scheme, String property) throws BOSException {
        return StructureConfigConvertHelper.getQueryFieldByKey(this.ctx, scheme, property);
    }

    private static String getQueryConfigFieldInfoKey(String scheme, String property) {
        return MessageFormat.format("{0}_{1}_{2}", 5, scheme, property);
    }

    public static SelectorItemCollection getQuerySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("structure.*"));
        sic.add(new SelectorItemInfo("fields.uipk"));
        sic.add(new SelectorItemInfo("fields.fieldName"));
        sic.add(new SelectorItemInfo("fields.alias"));
        sic.add(new SelectorItemInfo("fields.parent.id"));
        sic.add(new SelectorItemInfo("fields.parent.name"));
        sic.add(new SelectorItemInfo("fields.index"));
        sic.add(new SelectorItemInfo("fields.factField.name"));
        sic.add(new SelectorItemInfo("fields.factField.number"));
        sic.add(new SelectorItemInfo("fields.factField.index"));
        sic.add(new SelectorItemInfo("fields.factField.dataType"));
        sic.add(new SelectorItemInfo("fields.factField.enumSource"));
        sic.add(new SelectorItemInfo("fields.factField.specialExtend"));
        sic.add(new SelectorItemInfo("fields.factField.param"));
        sic.add(new SelectorItemInfo("fields.factField.extendOptions"));
        sic.add(new SelectorItemInfo("fields.factField.isPreset"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.clientNumber"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.EntityName"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.baseData"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.scheme.number"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.parent.*"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.multiRow"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.singleFields"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.alias"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.name"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.FilterColumn.parentColumn"));
        sic.add(new SelectorItemInfo("fields.factField.structureConfig.FilterColumn.clientColumn"));
        return sic;
    }

    public static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("EntityName"));
        sic.add(new SelectorItemInfo("tableName"));
        sic.add(new SelectorItemInfo("moltiAlias"));
        sic.add(new SelectorItemInfo("alias"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("clientNumber"));
        sic.add(new SelectorItemInfo("history"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.EntityName"));
        sic.add(new SelectorItemInfo("parent.moltiAlias"));
        sic.add(new SelectorItemInfo("parent.singleCondition"));
        sic.add(new SelectorItemInfo("parent.clientNumber"));
        sic.add(new SelectorItemInfo("parent.nowDateFilter"));
        sic.add(new SelectorItemInfo("parent.isPreset"));
        sic.add(new SelectorItemInfo("parent.linkType"));
        sic.add(new SelectorItemInfo("multiRow"));
        sic.add(new SelectorItemInfo("supportSingleView"));
        sic.add(new SelectorItemInfo("singleCondition"));
        sic.add(new SelectorItemInfo("nowDateFilter"));
        sic.add(new SelectorItemInfo("singleFields"));
        sic.add(new SelectorItemInfo("isPreset"));
        sic.add(new SelectorItemInfo("linkType"));
        sic.add(new SelectorItemInfo("FilterColumn.id"));
        sic.add(new SelectorItemInfo("FilterColumn.parentColumn"));
        sic.add(new SelectorItemInfo("FilterColumn.parentColumnAlias"));
        sic.add(new SelectorItemInfo("FilterColumn.clientColumn"));
        sic.add(new SelectorItemInfo("FilterColumn.clientColumnAlias"));
        sic.add(new SelectorItemInfo("FilterColumn.fixValue"));
        sic.add(new SelectorItemInfo("FilterColumn.compareType"));
        sic.add(new SelectorItemInfo("FilterColumn.isPreset"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("scheme.id"));
        sic.add(new SelectorItemInfo("scheme.number"));
        sic.add(new SelectorItemInfo("scheme.name"));
        sic.add(new SelectorItemInfo("columns.id"));
        sic.add(new SelectorItemInfo("columns.name"));
        sic.add(new SelectorItemInfo("columns.number"));
        sic.add(new SelectorItemInfo("columns.index"));
        sic.add(new SelectorItemInfo("columns.dataType"));
        sic.add(new SelectorItemInfo("columns.enumSource"));
        sic.add(new SelectorItemInfo("columns.specialExtend"));
        sic.add(new SelectorItemInfo("columns.param"));
        sic.add(new SelectorItemInfo("columns.extendOptions"));
        sic.add(new SelectorItemInfo("columns.isPreset"));
        return sic;
    }

    public static void removeAll() {
        try {
            CacheService.getInstance().removeAll(CACHE_TYPE);
            StructureConfigConvertHelper.clearCompensationCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void clearCompensationCache() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz = MsfClassLoaderFactory.forName((String)"com.kingdee.shr.compensation.calculate.helper.CallculateCacheTool");
        Method method = ReflectionUtils.findMethod((Class)clazz, (String)"removeAll");
        Object object = ReflectionUtils.invokeMethod((Method)method, clazz.newInstance());
    }

    private static Object getValueFromCache(String key) {
        return CacheService.getInstance().get(CACHE_TYPE, key);
    }

    private static void setValueToCache(String key, Object obj) {
        long begin = System.currentTimeMillis();
        CacheService.getInstance().put(CACHE_TYPE, key, obj);
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("setValueToCache key:{0},value:{1},cost:{2} ms", key, obj, end - begin));
        }
    }

    public static QueryConfigFieldInfo getQueryConfigFieldInfo(QueryConfigCollection qcc, String combineName) {
        int total = qcc.size();
        for (int i = 0; i < total; ++i) {
            if (null == qcc.get(i) || null == qcc.get(i).getFields()) continue;
            int kTotal = qcc.get(i).getFields().size();
            for (int k = 0; k < kTotal; ++k) {
                String realKey;
                if (null == qcc.get(i).getFields() || null == qcc.get(i).getFields().get(k) || null == qcc.get(i).getFields().get(k).getFactField() || null == qcc.get(i).getFields().get(k).getFactField().getStructureConfig() || null == qcc.get(i).getFields().get(k).getFactField().getStructureConfig().getClientNumber() || null == qcc.get(i).getFields().get(k).getFactField().getNumber() || !combineName.equalsIgnoreCase(realKey = qcc.get(i).getFields().get(k).getFactField().getStructureConfig().getClientNumber() + "." + qcc.get(i).getFields().get(k).getFactField().getNumber())) continue;
                return qcc.get(i).getFields().get(k);
            }
        }
        return null;
    }
}

