/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.certificationservice.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.SensitiveConfigCollection;
import com.kingdee.shr.base.permission.SensitiveConfigEntryCollection;
import com.kingdee.shr.base.permission.SensitiveConfigEntryFactory;
import com.kingdee.shr.base.permission.SensitiveConfigEntryInfo;
import com.kingdee.shr.base.permission.SensitiveConfigFactory;
import com.kingdee.shr.base.permission.SensitiveConfigInfo;
import com.kingdee.shr.base.permission.SensitiveRuleFactory;
import com.kingdee.shr.base.permission.SensitiveRuleInfo;
import com.kingdee.shr.base.syssetting.sensitive.rule.SensitiveRuleBuilderFactory;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.baseconfig.QueryConfigFieldFactory;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigColumnsFactory;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.certificationservice.CertificationException;
import com.kingdee.shr.certificationservice.CertificationTempletInfo;
import com.kingdee.shr.certificationservice.HRCertificationBillFactory;
import com.kingdee.shr.certificationservice.HRCertificationBillInfo;
import com.kingdee.shr.certificationservice.util.FieldValueRelationUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.FieldValueRelationCollection;
import com.kingdee.shr.shareservice.FieldValueRelationFactory;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSCCertificationUtil {
    private static final Logger logger = LoggerFactory.getLogger(SSCCertificationUtil.class);
    public static final String NO_VALUE = "/";
    public static String CMP_OSF = "getCmpItemCalInfoService";
    public static String CMP_FIX_OSF = "getSalaryItemInfoService";

    public static Map packageOsfParams(List<String> templateIds, String templateNo, List<Map<String, String>> osfContractDataList) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("contractNo", templateNo);
        dataMap.put("templates", templateIds);
        dataMap.put("templateData", osfContractDataList);
        return dataMap;
    }

    public static Map packageOsfParamsSign(Map<String, Object> params) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("contractNo", params.get("contractNo"));
        dataMap.put("templates", params.get("templates"));
        dataMap.put("templateData", params.get("templateData"));
        dataMap.put("labContractFirstPartyInfoId", params.get("labContractFirstPartyInfoId"));
        dataMap.put("billId", params.get("billId"));
        if (params.containsKey("otherParam") && params.get("otherParam") != null) {
            dataMap.put("otherParam", params.get("otherParam"));
        }
        return dataMap;
    }

    public static String getLabContractFirstParty(Context ctx, String billId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)billId)) {
            return null;
        }
        HRCertificationBillInfo certificationBillInfo = HRCertificationBillFactory.getLocalInstance(ctx).getHRCertificationBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billId)));
        PersonInfo person = certificationBillInfo.getPerson();
        if (person == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("employee", (Object)person.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("labContractFirstParty"));
        EmployeeContractCollection contractColl = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(view);
        String labContractFirstPartyId = null;
        if (contractColl.size() <= 0) {
            return null;
        }
        labContractFirstPartyId = contractColl.get(0).getLabContractFirstParty().getId().toString();
        return labContractFirstPartyId;
    }

    public static Map<String, String> assembleInfoMap(Context ctx, String hrCertificationBillId, CertificationTempletInfo certificationTempletInfo) throws BOSException, EASBizException {
        int i;
        HashMap<String, String> infoMap = new HashMap<String, String>();
        HashMap<String, JSONObject> mulMap1 = null;
        HashMap<String, JSONObject> mulMap2 = null;
        HashMap<String, JSONObject> mulMap3 = null;
        String querySql = "";
        String configStr = null;
        String isSensitive = "";
        JSONArray configList = new JSONArray();
        if (StringUtils.isEmpty((String)certificationTempletInfo.getConfig())) {
            throw new CertificationException(CertificationException.CONFIG_NOT_MATCH);
        }
        configStr = certificationTempletInfo.getConfig();
        configList = JSONArray.parseArray((String)configStr);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("selectorFields", configList);
        querySql = SSCCertificationUtil.generateSQL(ctx, params, "010SSC", hrCertificationBillId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
        try {
            String shortCode = LocaleUtils.getShortCode((Locale)ctx.getLocale());
            String format = "";
            String isMul = "false";
            if (rs.next()) {
                for (i = 0; i < configList.size(); ++i) {
                    JSONObject config = configList.getJSONObject(i);
                    String key = config.getString("key");
                    String metaField = config.getString("metafield");
                    String metaid = config.getString("metaid");
                    if (config.containsKey((Object)"format")) {
                        format = config.getString("format");
                    }
                    if (config.containsKey((Object)"isMul")) {
                        isMul = config.getString("isMul");
                    }
                    if (config.containsKey((Object)"isSensitive")) {
                        isSensitive = config.getString("isSensitive");
                    }
                    if (StringUtils.isEmpty((String)metaField)) continue;
                    String metaFieldValue = rs.getString(metaField);
                    metaFieldValue = SSCCertificationUtil.decideFieldValue(ctx, metaField, metaFieldValue, format);
                    if ("true".equals(isSensitive)) {
                        metaFieldValue = SSCCertificationUtil.getEncryFieldValue(ctx, metaid, metaFieldValue);
                    }
                    infoMap.put(key, metaFieldValue);
                    if (!"true".equals(isMul)) continue;
                    if ("l1".equalsIgnoreCase(format)) {
                        if (mulMap1 == null) {
                            mulMap1 = new HashMap<String, JSONObject>();
                        }
                        mulMap1.put(metaField, config);
                        continue;
                    }
                    if ("l2".equalsIgnoreCase(format)) {
                        if (mulMap2 == null) {
                            mulMap2 = new HashMap<String, JSONObject>();
                        }
                        mulMap2.put(metaField, config);
                        continue;
                    }
                    if (!"l3".equalsIgnoreCase(format)) continue;
                    if (mulMap3 == null) {
                        mulMap3 = new HashMap<String, JSONObject>();
                    }
                    mulMap3.put(metaField, config);
                }
            }
            SSCCertificationUtil.processMulFieldData(ctx, infoMap, mulMap1, mulMap2, mulMap3, querySql, shortCode);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        FieldValueRelationCollection coll = FieldValueRelationFactory.getLocalInstance((Context)ctx).getFieldValueRelationCollection("where bill = '" + hrCertificationBillId + "'");
        if (coll.size() > 0) {
            String value = null;
            String newVal = null;
            for (i = 0; i < coll.size(); ++i) {
                String field = coll.get(i).getField();
                value = coll.get(i).getValue();
                if (StringUtils.isEmpty((String)value)) {
                    infoMap.put(field, NO_VALUE);
                } else {
                    for (int j = 0; j < configList.size(); ++j) {
                        JSONObject config = configList.getJSONObject(j);
                        String key = config.getString("key");
                        if (!field.equals(key)) continue;
                        newVal = config.containsKey((Object)"isSensitive") && "true".equals(config.getString("isSensitive")) ? SSCCertificationUtil.getEncryFieldValue(ctx, null, value) : value;
                    }
                }
                infoMap.put(field, newVal);
            }
        }
        return infoMap;
    }

    public static void assembleBizClassField(Context ctx, String configStr, String hrCertificationBillId, List<Map<String, String>> infoList) throws EASBizException, BOSException {
        HRCertificationBillInfo certificationBillInfo = HRCertificationBillFactory.getLocalInstance(ctx).getHRCertificationBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)hrCertificationBillId)));
        if (certificationBillInfo.getPerson() != null) {
            String personId = certificationBillInfo.getPerson().getId().toString();
            JSONArray jsonArray = JSONArray.parseArray((String)configStr);
            int index = 1;
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject config = jsonArray.getJSONObject(i);
                String key = config.getString("key");
                String metaField = config.getString("metafield");
                String fieldConfigId = config.getString("fieldConfig");
                if (StringUtils.isEmpty((String)fieldConfigId)) continue;
                String osfValue = null;
                osfValue = FieldValueRelationUtil.getConfigValue(ctx, personId, fieldConfigId);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("key", metaField);
                map.put("value", osfValue);
                map.put("oldValue", osfValue);
                map.put("name", key);
                map.put("number", index + "");
                ++index;
                infoList.add(map);
            }
        }
    }

    public static String decideFieldValue(Context ctx, String fieldName, String fieldValue, String format) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)fieldValue)) {
            fieldValue = NO_VALUE;
        } else if (fieldName.indexOf(".") > 0) {
            String structureKey = fieldName.split("\\.")[0];
            String structureField = fieldName.split("\\.")[1];
            StructureConfigInfo structureInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)ctx, (String)structureKey, (String)"010SSC");
            if (structureInfo != null) {
                EntityObjectInfo entityInfo;
                String entityName = structureInfo.getEntityName();
                try {
                    entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return fieldValue;
                }
                PropertyInfo property = entityInfo.getPropertyByName(structureField);
                if (property != null) {
                    if (property instanceof OwnPropertyInfo) {
                        OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)property;
                        DataType dateType = ownPropertyInfo.getDataType();
                        if (DataType.DATE.equals((Object)dateType) || DataType.TIME.equals((Object)dateType) || DataType.TIMESTAMP.equals((Object)dateType)) {
                            String dateFormat = "yyyy-MM-dd";
                            String dateFormat1 = "yyyy-MM-dd";
                            if (!StringUtils.isEmpty((String)format)) {
                                dateFormat1 = format;
                            }
                            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                            SimpleDateFormat formatter1 = new SimpleDateFormat(dateFormat1);
                            if ("MM dd,yyyy".equals(dateFormat1)) {
                                formatter1 = new SimpleDateFormat("MMMM dd,yyyy", Locale.ENGLISH);
                            }
                            try {
                                fieldValue = formatter1.format(formatter.parse(fieldValue));
                            }
                            catch (Exception e) {
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                        } else if (DataType.ENUM.equals((Object)dateType)) {
                            fieldValue = SSCCertificationUtil.decideFieldValueIfEnum(ctx, ownPropertyInfo, fieldValue);
                        } else if (DataType.BOOLEAN.equals((Object)dateType)) {
                            String label138_1 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShareServiceResource", (String)"label138_1", (Context)ctx);
                            String label139 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShareServiceResource", (String)"label139", (Context)ctx);
                            fieldValue = "0".equals(fieldValue) ? label138_1 : label139;
                        } else if (DataType.DECIMAL.equals((Object)dateType)) {
                            if (fieldValue.indexOf(".") > 0) {
                                fieldValue = fieldValue.replaceAll("0+?$", "");
                                fieldValue = fieldValue.replaceAll("[.]$", "");
                            }
                        } else if (DataType.DOUBLE.equals((Object)dateType)) {
                            if (fieldValue.indexOf(".") > 0) {
                                fieldValue = fieldValue.replaceAll("0+?$", "");
                                fieldValue = fieldValue.replaceAll("[.]$", "");
                            }
                        } else {
                            fieldValue = String.valueOf(fieldValue);
                        }
                    } else if (property instanceof LinkPropertyInfo) {
                        LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)property;
                        RelationshipInfo relationshipInfo = linkPropertyInfo.getRelationship();
                    }
                }
            }
        }
        return fieldValue;
    }

    public static void processMulFieldData(Context ctx, Map<String, String> infoMap, Map<String, JSONObject> mulMap1, Map<String, JSONObject> mulMap2, Map<String, JSONObject> mulMap3, String querySql, String shortCode) throws BOSException, SQLException {
        String key;
        JSONObject config;
        String metaFieldValue;
        String metaField;
        IRowSet rs;
        String mulSQl;
        String format;
        if (mulMap1 != null) {
            format = "l1";
            mulSQl = querySql.replaceAll("_" + shortCode + "\\b", "_" + format);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCCertificationUtil processMulFieldData shortCode is:" + shortCode + ",format is:" + format + ",mulSQl is:" + mulSQl);
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)mulSQl)).next()) {
                for (Map.Entry<String, JSONObject> entry : mulMap1.entrySet()) {
                    metaField = entry.getKey();
                    metaFieldValue = rs.getString(metaField);
                    config = entry.getValue();
                    key = config.getString("key");
                    infoMap.put(key, metaFieldValue);
                }
            }
        }
        if (mulMap2 != null) {
            format = "l2";
            mulSQl = querySql.replaceAll("_" + shortCode + "\\b", "_" + format);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCCertificationUtil processMulFieldData shortCode is:" + shortCode + ",format is:" + format + ",mulSQl is:" + mulSQl);
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)mulSQl)).next()) {
                for (Map.Entry<String, JSONObject> entry : mulMap2.entrySet()) {
                    metaField = entry.getKey();
                    metaFieldValue = rs.getString(metaField);
                    config = entry.getValue();
                    key = config.getString("key");
                    infoMap.put(key, metaFieldValue);
                }
            }
        }
        if (mulMap3 != null) {
            format = "l3";
            mulSQl = querySql.replaceAll("_" + shortCode + "\\b", "_" + format);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCCertificationUtil processMulFieldData shortCode is:" + shortCode + ",format is:" + format + ",mulSQl is:" + mulSQl);
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)mulSQl)).next()) {
                for (Map.Entry<String, JSONObject> entry : mulMap3.entrySet()) {
                    metaField = entry.getKey();
                    metaFieldValue = rs.getString(metaField);
                    config = entry.getValue();
                    key = config.getString("key");
                    infoMap.put(key, metaFieldValue);
                }
            }
        }
    }

    private static String decideFieldValueIfEnum(Context ctx, OwnPropertyInfo ownPropertyInfo, String fieldValue) {
        String enumRefName = ownPropertyInfo.getMetaDataRef();
        if (!StringUtils.isEmpty((String)enumRefName)) {
            try {
                MetaDataPK metaPk = MetaDataPK.create((String)enumRefName);
                BizEnumInfo bizEnum = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)metaPk);
                IntEnum enumValie = null;
                if (bizEnum.getDataType() == BizEnumValueType.INTEGER) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (int)Integer.parseInt(fieldValue));
                    fieldValue = enumValie == null ? "" : enumValie.getAlias();
                } else if (bizEnum.getDataType() == BizEnumValueType.STRING) {
                    enumValie = EnumUtils.getEnumByValue(Class.forName(enumRefName), (String)fieldValue.toString());
                    fieldValue = enumValie == null ? "" : enumValie.getAlias();
                } else if (bizEnum.getDataType() == BizEnumValueType.LONG) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (long)Long.parseLong(fieldValue));
                    fieldValue = enumValie == null ? "" : enumValie.getAlias();
                } else if (bizEnum.getDataType() == BizEnumValueType.FLOAT) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (float)Float.parseFloat(fieldValue));
                    fieldValue = enumValie == null ? "" : enumValie.getAlias();
                } else if (bizEnum.getDataType() == BizEnumValueType.DOUBLE) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (double)Double.parseDouble(fieldValue));
                    fieldValue = enumValie == null ? "" : enumValie.getAlias();
                }
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return fieldValue;
    }

    public static String generateSQL(Context ctx, Map<String, Object> params, String schemeNum, String hrCertificationBillId) throws EASBizException, BOSException {
        String querySql = "";
        SqlParam sqlParam = new SqlParam();
        JSONArray selector = (JSONArray)params.get("selectorFields");
        sqlParam.setSelectMapping(SSCCertificationUtil.assembleSelector(selector));
        sqlParam.setScheme(schemeNum);
        sqlParam.setNeedDistinct(false);
        sqlParam.setHistoryMode(false);
        sqlParam.setNewSearch(true);
        sqlParam.setFilterInfo(SSCCertificationUtil.assembleFilterInfo(ctx, hrCertificationBillId));
        querySql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
        return querySql;
    }

    public static FilterInfo assembleFilterInfo(Context ctx, String hrCertificationBillId) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(SSCCertificationUtil.getFilterString(ctx), (Object)hrCertificationBillId);
        filterInfo.getFilterItems().add(item);
        return filterInfo;
    }

    public static Map<String, String> assembleSelector(JSONArray selector) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (selector == null || selector.size() <= 0) {
            return map;
        }
        int length = selector.size();
        for (int i = 0; i < length; ++i) {
            JSONObject config = selector.getJSONObject(i);
            map.put(config.getString("metafield"), config.getString("metafield"));
        }
        return map;
    }

    public static String getFilterString(Context ctx) {
        String filterStr = null;
        try {
            StructureConfigCollection structureColl = StructureConfigConvertHelper.getStructureConfigCollection((Context)ctx, (String)"010SSC");
            if (structureColl != null && structureColl.size() > 0) {
                int size = structureColl.size();
                for (int index = 0; index < size; ++index) {
                    StructureConfigInfo info = structureColl.get(index);
                    if (info.getParent() != null || !"com.kingdee.shr.certificationservice.app.HRCertificationBill".equals(info.getEntityName())) continue;
                    filterStr = info.getClientNumber();
                }
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        filterStr = StringUtils.isEmpty(filterStr) ? "hRCertificationBill.id" : filterStr + ".id";
        return filterStr;
    }

    public static String getEncryFieldValue(Context ctx, String queryConfigFieldId, String metaFieldValue) throws EASBizException, BOSException, UuidException {
        String ruleName = "default";
        String newValue = "";
        if (queryConfigFieldId != null) {
            QueryConfigFieldInfo queryConfigFieldInfo = QueryConfigFieldFactory.getLocalInstance((Context)ctx).getQueryConfigFieldInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)queryConfigFieldId)));
            StructureConfigColumnsInfo columnInfo = StructureConfigColumnsFactory.getLocalInstance((Context)ctx).getStructureConfigColumnsInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)queryConfigFieldInfo.getFactField().getId().toString())));
            String fieldName = columnInfo.getNumber();
            StructureConfigInfo configInfo = StructureConfigFactory.getLocalInstance((Context)ctx).getStructureConfigInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)columnInfo.getStructureConfig().getId().toString())));
            String entityName = configInfo.getEntityName();
            SensitiveConfigInfo sensitiveConfigInfo = null;
            SensitiveConfigCollection sensitiveConfigColl = SensitiveConfigFactory.getLocalInstance((Context)ctx).getSensitiveConfigCollection("where fullName = '" + entityName + "'");
            if (sensitiveConfigColl.size() > 0) {
                sensitiveConfigInfo = sensitiveConfigColl.get(0);
                SensitiveConfigEntryCollection sensitiveConfigEntryColl = SensitiveConfigEntryFactory.getLocalInstance((Context)ctx).getSensitiveConfigEntryCollection("where bill.id = '" + sensitiveConfigInfo.getId().toString() + "' and property = '" + fieldName + "'");
                if (sensitiveConfigEntryColl.size() > 0) {
                    SensitiveConfigEntryInfo senConfigEntryInfo = sensitiveConfigEntryColl.get(0);
                    SensitiveRuleInfo ruleInfo = SensitiveRuleFactory.getLocalInstance((Context)ctx).getSensitiveRuleInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)senConfigEntryInfo.getSRule().getId().toString())));
                    ruleName = ruleInfo.getNumber();
                }
            }
        }
        newValue = SensitiveRuleBuilderFactory.getRuleValue((Context)ctx, (String)ruleName, (Object)metaFieldValue);
        return newValue;
    }
}

