/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.DomainFilterFacadeFactory;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CalFormulaCollection;
import com.kingdee.shr.compensation.CalFormulaFactory;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.CalSchemeCollection;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalSchemeItemCollection;
import com.kingdee.shr.compensation.CalSchemeItemFactory;
import com.kingdee.shr.compensation.CalSchemeItemInfo;
import com.kingdee.shr.compensation.CalSchemeVerificationRuleCollection;
import com.kingdee.shr.compensation.CalSchemeVerificationRuleFactory;
import com.kingdee.shr.compensation.CalSchemeVerificationRuleInfo;
import com.kingdee.shr.compensation.CalSchemeVerificationRuleNodeRelCollection;
import com.kingdee.shr.compensation.CalSchemeVerificationRuleNodeRelFactory;
import com.kingdee.shr.compensation.CalSchemeVerificationRuleNodeRelInfo;
import com.kingdee.shr.compensation.CalState;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.ICalFormula;
import com.kingdee.shr.compensation.ICalSchemeItem;
import com.kingdee.shr.compensation.ICalSchemeVerificationRule;
import com.kingdee.shr.compensation.ReissueState;
import com.kingdee.shr.compensation.ReverseCheckOut;
import com.kingdee.shr.compensation.SynState;
import com.kingdee.shr.compensation.app.AbstractCalSchemeFacadeControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemInfo;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetCmpRelCollection;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetCmpRelFactory;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetCmpRelInfo;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigCollection;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigFactory;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigInfo;
import com.kingdee.shr.compensation.app.cmpBudget.IBudgetDeductionConfig;
import com.kingdee.shr.compensation.app.tax.CalSchemeAnnu;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanShemeRelCollection;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanShemeRelInfo;
import com.kingdee.shr.compensation.permission.CalSchemePermAPI;
import com.kingdee.shr.compensation.util.CmpCalUtil;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.BusinessRelationConfigCollection;
import com.kingdee.shr.validaterule.BusinessRelationConfigFactory;
import com.kingdee.shr.validaterule.BusinessRelationConfigInfo;
import com.kingdee.shr.validaterule.VerificationRuleInfo;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CalSchemeFacadeControllerBean
extends AbstractCalSchemeFacadeControllerBean {
    private static Logger logger = Logger.getLogger(CalSchemeFacadeControllerBean.class);

    @Override
    protected boolean _checkHrValid(Context ctx, Map param) throws BOSException {
        CalSchemeInfo calSchemeInfo = (CalSchemeInfo)param.get("calSchemeInfo");
        String hrOrgUnit = calSchemeInfo.getHrOrgUnit() == null ? "" : calSchemeInfo.getHrOrgUnit().getId().toString();
        Map<String, Set<String>> itemHrMap = this.getItemHrMap(ctx);
        CalSchemeItemCollection calSchemeItemCollection = CalSchemeItemFactory.getLocalInstance(ctx).getCalSchemeItemCollection();
        int size = calSchemeItemCollection.size();
        for (int i = 0; i < size; ++i) {
            CalSchemeItemInfo schemeItemInfo = calSchemeItemCollection.get(i);
            String cmpItemId = schemeItemInfo.getCmpItem().getId().toString();
            Set<String> hrs = itemHrMap.get(cmpItemId);
            if (hrs != null && hrs.contains(hrOrgUnit)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Set<String>> getItemHrMap(Context ctx) throws BOSException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String sb = " select distinct relRef.* from T_HR_SCmpItemRelHR relRef  left join t_hr_scmpitem item on item.fid = relRef.FBaseInfoId order by relRef.fbaseinfoid ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb);
        try {
            while (rs.next()) {
                String cmpItemId = rs.getString("FBaseInfoId");
                String hrOrgUseId = rs.getString("FHrOrgUseId");
                HashSet<String> hrOrgIds = (HashSet<String>)map.get(cmpItemId);
                if (hrOrgIds == null) {
                    hrOrgIds = new HashSet<String>();
                }
                hrOrgIds.add(hrOrgUseId);
                map.put(cmpItemId, hrOrgIds);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    protected void _synchAllItem(Context ctx, List list, String srcId) throws BOSException, EASBizException {
        String srcOql = "where calScheme = '" + srcId + "'";
        ICalSchemeVerificationRule iCalSchemeVerificationRule = CalSchemeVerificationRuleFactory.getLocalInstance(ctx);
        CalSchemeItemCollection schemeItems = CalSchemeItemFactory.getLocalInstance(ctx).getCalSchemeItemCollection(srcOql);
        CalFormulaCollection formulas = CalFormulaFactory.getLocalInstance(ctx).getCalFormulaCollection(srcOql);
        CalSchemeVerificationRuleCollection vrrules = iCalSchemeVerificationRule.getCalSchemeVerificationRuleCollection(srcOql);
        CalSchemeInfo sourceCalSchemeInfo = CalSchemePermAPI.getCalSchemeInfo(ctx, srcId);
        Map<String, List<String>> calFormulaMap = this.getCalFormulaMap(ctx);
        Map<String, List<String>> calSchemeItemMap = this.getCalSchemeItemMap(ctx);
        Map<String, List<String>> calSchemeVeriRuleMap = this.getCalSchemeVeriRuleMap(ctx, list);
        for (Object o : list) {
            String calSchemeId = o.toString();
            CalSchemeInfo calSchemeInfo = CalSchemePermAPI.getCalSchemeInfo(ctx, calSchemeId);
            boolean srcAndChildSchemeSameTemp = this.checkSourceAndChildrenSchemeSameTemp(sourceCalSchemeInfo, calSchemeInfo);
            List<String> formulaList = calFormulaMap.get(calSchemeId);
            List<String> cmpItemList = calSchemeItemMap.get(calSchemeId);
            List<String> calSchemeVRRuleList = calSchemeVeriRuleMap.get(calSchemeId);
            boolean approveFlag = calSchemeInfo.getCalState().getValue() >= 6;
            String copyOql = "where calScheme='" + calSchemeId + "' and srcSchemeId='" + srcId + "'";
            CalSchemeItemFactory.getLocalInstance(ctx).delete(copyOql);
            CalFormulaFactory.getLocalInstance(ctx).delete(copyOql);
            copyOql = copyOql + " and type = " + 10;
            iCalSchemeVerificationRule.delete(copyOql);
            if (!approveFlag) {
                String copyOqlQuota = "where calScheme='" + calSchemeId + "' and type = " + 20;
                if (srcAndChildSchemeSameTemp) {
                    copyOqlQuota = copyOqlQuota + " and srcSchemeId='" + srcId + "'";
                }
                iCalSchemeVerificationRule.delete(copyOqlQuota);
            }
            CoreBaseCollection colls = new CoreBaseCollection();
            int itemSize = schemeItems.size();
            for (int j = 0; j < itemSize; ++j) {
                CalSchemeItemInfo item = schemeItems.get(j);
                String itemId = item.getCmpItem().getId().toString();
                if (cmpItemList != null && cmpItemList.contains(itemId)) continue;
                item.setId(null);
                item.setSrcSchemeId(srcId);
                item.setCalScheme(calSchemeInfo);
                colls.add((CoreBaseInfo)item);
            }
            CalSchemeItemFactory.getLocalInstance(ctx).save(colls);
            colls = new CoreBaseCollection();
            int forSize = formulas.size();
            for (int k = 0; k < forSize; ++k) {
                CalFormulaInfo formula = formulas.get(k);
                String formulaName = formula.getName();
                if (formulaList != null && formulaList.contains(formulaName)) continue;
                formula.setId(null);
                formula.setSrcSchemeId(srcId);
                formula.setCalScheme(calSchemeInfo);
                colls.add((CoreBaseInfo)formula);
            }
            CalFormulaFactory.getLocalInstance(ctx).save(colls);
            colls = new CoreBaseCollection();
            for (int i = 0; i < vrrules.size(); ++i) {
                boolean quataFlag;
                CalSchemeVerificationRuleInfo calSchemeVerificationRuleInfo = vrrules.get(i);
                boolean bl = quataFlag = calSchemeVerificationRuleInfo.getType() != null && calSchemeVerificationRuleInfo.getType().getValue() == 20;
                if (approveFlag && quataFlag) continue;
                String vrid = calSchemeVerificationRuleInfo.getVerificationRule().getId().toString();
                if (quataFlag ? srcAndChildSchemeSameTemp && calSchemeVRRuleList != null && calSchemeVRRuleList.contains(vrid) : calSchemeVRRuleList != null && calSchemeVRRuleList.contains(vrid)) continue;
                BOSUuid bosUuid = BOSUuid.create((BOSObjectType)calSchemeVerificationRuleInfo.getBOSType());
                calSchemeVerificationRuleInfo.setId(bosUuid);
                calSchemeVerificationRuleInfo.setSrcSchemeId(srcId);
                calSchemeVerificationRuleInfo.setCalScheme(calSchemeInfo);
                colls.add((CoreBaseInfo)calSchemeVerificationRuleInfo);
                CalSchemeVerificationRuleNodeRelCollection verificationRuleNode = calSchemeVerificationRuleInfo.getVerificationRuleNode();
                for (int j = 0; j < verificationRuleNode.size(); ++j) {
                    CalSchemeVerificationRuleNodeRelInfo calSchemeVerificationRuleNodeRelInfo = verificationRuleNode.get(j);
                    calSchemeVerificationRuleNodeRelInfo.setCalSchemeVerificationRule(calSchemeVerificationRuleInfo);
                    calSchemeVerificationRuleNodeRelInfo.setId(BOSUuid.create((BOSObjectType)calSchemeVerificationRuleNodeRelInfo.getBOSType()));
                }
            }
            iCalSchemeVerificationRule.addnewBatchData(colls);
            if (approveFlag) continue;
            this.updateBudgetTemplate(ctx, sourceCalSchemeInfo, calSchemeInfo);
            this.deleteBudgetDeductionConfig(ctx, calSchemeId, srcId, srcAndChildSchemeSameTemp);
            Map<String, String> cmpBudgetItemIdAndDeductionConfigIdMap = this.getCmpBudgetItemIdAndDeductionConfigIdMap(ctx, calSchemeId);
            this.copyBudgetDeductionConfig(ctx, srcId, calSchemeInfo, cmpBudgetItemIdAndDeductionConfigIdMap);
            this.updateCalSchemeVeriResultExecuteStatus(ctx, calSchemeInfo);
        }
    }

    private boolean checkSourceAndChildrenSchemeSameTemp(CalSchemeInfo sourceCalSchemeInfo, CalSchemeInfo calSchemeInfo) {
        if (sourceCalSchemeInfo == null || sourceCalSchemeInfo.getBudgetTemplate() == null || sourceCalSchemeInfo.getBudgetTemplate().getId() == null) {
            return false;
        }
        if (calSchemeInfo == null || calSchemeInfo.getBudgetTemplate() == null || calSchemeInfo.getBudgetTemplate().getId() == null) {
            return false;
        }
        return sourceCalSchemeInfo.getBudgetTemplate().getId().toString().equals(calSchemeInfo.getBudgetTemplate().getId().toString());
    }

    protected void updateCalSchemeVeriResultExecuteStatus(Context ctx, CalSchemeInfo scheme) throws BOSException {
        if (scheme == null || scheme.getId() == null) {
            return;
        }
        CalState state = scheme.getCalState();
        if (2 == state.getValue() || 4 == state.getValue()) {
            int periodYear = scheme.getPeriodYear();
            int periodMonth = scheme.getPeriodMonth();
            int calTime = scheme.getCalTime();
            String schemeId = scheme.getId().toString();
            String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
            String sqlDate = CmpDateUtil.toKSqlDate(new Date());
            StringBuilder bd = new StringBuilder();
            bd.append(" update T_HR_CalSchemeVeriResult set FExecuteStatus = ").append(2);
            bd.append(" , FLastUpdateTime = ").append(sqlDate).append(" , FLastUpdateUserID = '").append(userId).append("' ");
            bd.append(" where FCalSchemeID = '").append(schemeId).append("' and FperiodYear = ").append(periodYear);
            bd.append(" and FperiodMonth = ").append(periodMonth).append(" and FcalTime = ").append(calTime);
            bd.append(" and FexecuteStatus in (").append(1);
            bd.append(",").append(3).append(")");
            DbUtil.execute((Context)ctx, (String)bd.toString());
        }
    }

    private Map<String, String> getCmpBudgetItemIdAndDeductionConfigIdMap(Context ctx, String calSchemeId) throws BOSException {
        HashMap map = Maps.newHashMap();
        String oql = "select id, cmpBudgetItemRel.cmpBudgetItem.id where calScheme.id = '" + calSchemeId + "'";
        BudgetDeductionConfigCollection coll = BudgetDeductionConfigFactory.getLocalInstance(ctx).getBudgetDeductionConfigCollection(oql);
        for (int i = 0; i < coll.size(); ++i) {
            BudgetDeductionConfigInfo info = coll.get(i);
            if (info.getCmpBudgetItemRel() == null || info.getCmpBudgetItemRel().getCmpBudgetItem() == null) continue;
            map.put(info.getCmpBudgetItemRel().getCmpBudgetItem().getId().toString(), info.getId().toString());
        }
        return map;
    }

    private void updateBudgetTemplate(Context ctx, CalSchemeInfo sourceCalSchemeInfo, CalSchemeInfo calSchemeInfo) throws EASBizException, BOSException {
        calSchemeInfo.setBudgetTemplate(sourceCalSchemeInfo.getBudgetTemplate());
        calSchemeInfo.setBudgetOffset(sourceCalSchemeInfo.getBudgetOffset());
        calSchemeInfo.setCostType(sourceCalSchemeInfo.getCostType());
        CalSchemeFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(calSchemeInfo.getId()), calSchemeInfo);
    }

    private Map<String, List<String>> getCalFormulaMap(Context ctx) throws BOSException {
        String oql;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ICalFormula calFormula = CalFormulaFactory.getLocalInstance(ctx);
        CalFormulaCollection coll = calFormula.getCalFormulaCollection(oql = "where srcSchemeId is null");
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                CalFormulaInfo calFormulaInfo = coll.get(i);
                CalSchemeInfo calScheme = calFormulaInfo.getCalScheme();
                String schemeId = calScheme.getId().toString();
                String formulaName = calFormulaInfo.getName();
                ArrayList<String> list = (ArrayList<String>)map.get(schemeId);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(formulaName);
                map.put(schemeId, list);
            }
        }
        return map;
    }

    private Map<String, List<String>> getCalSchemeItemMap(Context ctx) throws BOSException {
        String oql;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ICalSchemeItem calSchemeItem = CalSchemeItemFactory.getLocalInstance(ctx);
        CalSchemeItemCollection coll = calSchemeItem.getCalSchemeItemCollection(oql = "where srcSchemeId is null");
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                CalSchemeItemInfo calSchemeItemInfo = coll.get(i);
                CalSchemeInfo calScheme = calSchemeItemInfo.getCalScheme();
                CmpItemInfo cmpItem = calSchemeItemInfo.getCmpItem();
                String schemeId = calScheme.getId().toString();
                String itemId = cmpItem.getId().toString();
                ArrayList<String> list = (ArrayList<String>)map.get(schemeId);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(itemId);
                map.put(schemeId, list);
            }
        }
        return map;
    }

    protected Map<String, List<String>> getCalSchemeVeriRuleMap(Context ctx, List list) throws BOSException {
        HashMap map = Maps.newHashMap();
        ICalSchemeVerificationRule iCalSchemeVerificationRule = CalSchemeVerificationRuleFactory.getLocalInstance(ctx);
        String oql = "where srcSchemeId is null and calScheme.id in (" + CmpStrUtil.convertListToString(list) + ")";
        CalSchemeVerificationRuleCollection coll = iCalSchemeVerificationRule.getCalSchemeVerificationRuleCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            CalSchemeVerificationRuleInfo calSchemeVerificationRuleInfo = coll.get(i);
            CalSchemeInfo calScheme = calSchemeVerificationRuleInfo.getCalScheme();
            VerificationRuleInfo verificationRule = calSchemeVerificationRuleInfo.getVerificationRule();
            String schemeId = calScheme.getId().toString();
            String vrId = verificationRule.getId().toString();
            List vrs = (List)map.get(schemeId);
            if (null == vrs) {
                vrs = Lists.newArrayList();
            }
            vrs.add(vrId);
            map.put(schemeId, vrs);
        }
        return map;
    }

    @Override
    protected void _setCalState(Context ctx, String calSchemeId, String permItemId) throws BOSException {
        CalSchemeCollection calSchemeCollection = new CalSchemeCollection();
        if (StringUtils.isEmpty((CharSequence)calSchemeId)) {
            FilterInfo filter = new FilterInfo();
            FilterInfo adminOrgfilter = DomainFilterFacadeFactory.getLocalInstance((Context)ctx).getFilter("UserAdminRangeFilter", "adminOrgUnit.id", null);
            FilterInfo noAdminOrgfilter = new FilterInfo();
            noAdminOrgfilter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", null, CompareType.EQUALS));
            adminOrgfilter.mergeFilter(noAdminOrgfilter, "OR");
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            adminOrgfilter.mergeFilter(filter, "AND");
            filter = adminOrgfilter;
            String oql = "select id,name,number,cmpPeriodType,beginDate,endDate,calTime,calState,periodYear,periodMonth,taxtOrg,taxUnit where " + filter.toSql();
            calSchemeCollection = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection(oql);
        } else {
            calSchemeCollection.add(CalSchemePermAPI.getCalSchemeInfo(ctx, calSchemeId));
        }
        int size = calSchemeCollection.size();
        for (int j = 0; j < size; ++j) {
            CalSchemeInfo info = calSchemeCollection.get(j);
            if (info == null || info.getBeginDate() == null || info.getEndDate() == null || info.getCalState() == null || info.getPeriodYear() == 0 || info.getPeriodMonth() == 0) continue;
            calSchemeId = info.getId().toString();
            CmpCalUtil.updateNewCalSchemeState(ctx, calSchemeId);
        }
    }

    @Override
    protected String _copyScheme(Context ctx, Map param) throws BOSException, EASBizException {
        String canEdit = (String)param.get("canEdit");
        String calSchemeId = (String)param.get("calSchemeId");
        boolean isCanEditCopy = "1".equals(canEdit);
        SimpleDateFormat sdf = new SimpleDateFormat("ddHHmmss");
        String random = sdf.format(new Date());
        CalSchemeInfo calScheme = CalSchemePermAPI.getCalSchemeInfo(ctx, calSchemeId);
        String name = calScheme.getName();
        calScheme.setId(null);
        calScheme.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        calScheme.setCalTime(1);
        calScheme.setBusinessNum(null);
        calScheme.setBusinessName(null);
        calScheme.setAnnu(CalSchemeAnnu.not);
        calScheme.setBeginMonth(0);
        calScheme.setName(name + "_" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalFacadeResource", (String)"label0", (Locale)ctx.getLocale()) + random, LocaleUtils.locale_l1);
        calScheme.setName(name + "_" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalFacadeResource", (String)"label0", (Locale)ctx.getLocale()) + random, LocaleUtils.locale_l2);
        calScheme.setName(name + "_" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalFacadeResource", (String)"label0", (Locale)ctx.getLocale()) + random, LocaleUtils.locale_l3);
        calScheme.setNumber(calScheme.getNumber() + "_copy" + random);
        calScheme.setCalState(CalState.NOCAL);
        calScheme.setIsReverseCheckOut(ReverseCheckOut.NOTROLLBACK);
        calScheme.setSrcSchemeID(calSchemeId);
        calScheme.setIsCanUpdateCopy(isCanEditCopy);
        calScheme.setChargePer(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        calScheme.setSynState(SynState.NOTSYN);
        calScheme.getIsReissue();
        calScheme.setIsReissue(ReissueState.NOTREISSUE);
        if (calScheme.getState() == StateEnum.ENABLE) {
            calScheme.setEnableDate(new Timestamp(System.currentTimeMillis()));
        }
        calScheme.setDisableDate(null);
        calScheme.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        calScheme.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        calScheme.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        calScheme.setCreateTime(new Timestamp(System.currentTimeMillis()));
        TaxItemPlanShemeRelCollection taxItemPlanShemeRelCollection = calScheme.getTaxItemPlanList();
        if (null != taxItemPlanShemeRelCollection && !taxItemPlanShemeRelCollection.isEmpty()) {
            for (int i = 0; i < taxItemPlanShemeRelCollection.size(); ++i) {
                TaxItemPlanShemeRelInfo rel = taxItemPlanShemeRelCollection.get(i);
                rel.setId(null);
            }
        }
        IObjectPK newId = CalSchemeFactory.getLocalInstance(ctx).save((CoreBaseInfo)calScheme);
        String condition = "where calScheme.id = '" + calSchemeId + "'";
        CalSchemeItemCollection items = CalSchemeItemFactory.getLocalInstance(ctx).getCalSchemeItemCollection(condition);
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < items.size(); ++i) {
            CalSchemeItemInfo item = items.get(i);
            item.setId(null);
            item.setSrcSchemeId(calSchemeId);
            item.setCalScheme(calScheme);
            colls.add((CoreBaseInfo)item);
        }
        CalSchemeItemFactory.getLocalInstance(ctx).addnewBatchData(colls);
        CalFormulaCollection formulas = CalFormulaFactory.getLocalInstance(ctx).getCalFormulaCollection(condition);
        colls = new CoreBaseCollection();
        for (int i = 0; i < formulas.size(); ++i) {
            CalFormulaInfo formula = formulas.get(i);
            formula.setId(null);
            formula.setSrcSchemeId(calSchemeId);
            formula.setCalScheme(calScheme);
            colls.add((CoreBaseInfo)formula);
        }
        CalFormulaFactory.getLocalInstance(ctx).addnewBatchData(colls);
        ICalSchemeVerificationRule iCalSchemeVerificationRule = CalSchemeVerificationRuleFactory.getLocalInstance(ctx);
        CalSchemeVerificationRuleCollection calSchemeVerificationRuleCollection = iCalSchemeVerificationRule.getCalSchemeVerificationRuleCollection(condition);
        colls = new CoreBaseCollection();
        for (int i = 0; i < calSchemeVerificationRuleCollection.size(); ++i) {
            CalSchemeVerificationRuleInfo calSchemeVerificationRuleInfo = calSchemeVerificationRuleCollection.get(i);
            BOSUuid bosUuid = BOSUuid.create((BOSObjectType)calSchemeVerificationRuleInfo.getBOSType());
            calSchemeVerificationRuleInfo.setId(bosUuid);
            calSchemeVerificationRuleInfo.setSrcSchemeId(calSchemeId);
            calSchemeVerificationRuleInfo.setCalScheme(calScheme);
            colls.add((CoreBaseInfo)calSchemeVerificationRuleInfo);
            CalSchemeVerificationRuleNodeRelCollection verificationRuleNode = calSchemeVerificationRuleInfo.getVerificationRuleNode();
            for (int j = 0; j < verificationRuleNode.size(); ++j) {
                CalSchemeVerificationRuleNodeRelInfo calSchemeVerificationRuleNodeRelInfo = verificationRuleNode.get(j);
                calSchemeVerificationRuleNodeRelInfo.setCalSchemeVerificationRule(calSchemeVerificationRuleInfo);
                calSchemeVerificationRuleNodeRelInfo.setId(BOSUuid.create((BOSObjectType)calSchemeVerificationRuleNodeRelInfo.getBOSType()));
            }
        }
        iCalSchemeVerificationRule.addnewBatchData(colls);
        this.copyBudgetDeductionConfig(ctx, calSchemeId, calScheme, Maps.newHashMap());
        return newId.toString();
    }

    protected void copyBudgetDeductionConfig(Context ctx, String calSchemeId, CalSchemeInfo calScheme, Map<String, String> cmpBudgetItemIdAndDeductionConfigIdMap) throws BOSException, EASBizException {
        String whereCalSchemeId = "select id,cmpBudgetItemRel.*,deduNode,rollBackNode,offsetNode,cmpItemRel.*,calScheme.id,cmpFormula,srcSchemeId,costType.id,name,number,description,simpleName,creator.id,createTime,lastUpdateUser.id,lastUpdateTime where calScheme = '" + calSchemeId + "'";
        IBudgetDeductionConfig iDeductionConfig = BudgetDeductionConfigFactory.getLocalInstance(ctx);
        BudgetDeductionConfigCollection deductionConfigColl = iDeductionConfig.getBudgetDeductionConfigCollection(whereCalSchemeId);
        CoreBaseCollection baseDeductionConfigColls = new CoreBaseCollection();
        HashMap oldAndNewDeductionConfigIdMap = Maps.newHashMap();
        for (int i = 0; i < deductionConfigColl.size(); ++i) {
            BudgetDeductionConfigInfo deductionConfigInfo = deductionConfigColl.get(i);
            BudgetTemplateSTBItemInfo stbItemInfo = deductionConfigInfo.getCmpBudgetItemRel();
            if (stbItemInfo != null && stbItemInfo.getCmpBudgetItem() != null && cmpBudgetItemIdAndDeductionConfigIdMap.containsKey(stbItemInfo.getCmpBudgetItem().getId().toString())) continue;
            BudgetCmpRelCollection cmpRelColl = deductionConfigInfo.getCmpItemRel();
            for (int j = 0; j < cmpRelColl.size(); ++j) {
                BudgetCmpRelInfo relInfo = cmpRelColl.get(j);
                relInfo.setBudgetDeduction(deductionConfigInfo);
                relInfo.setId(BOSUuid.create((BOSObjectType)relInfo.getBOSType()));
            }
            BOSUuid bosUuid = BOSUuid.create((BOSObjectType)deductionConfigInfo.getBOSType());
            oldAndNewDeductionConfigIdMap.put(deductionConfigInfo.getId(), bosUuid);
            deductionConfigInfo.setId(bosUuid);
            deductionConfigInfo.setSrcSchemeId(calSchemeId);
            deductionConfigInfo.setCalScheme(calScheme);
            baseDeductionConfigColls.add((CoreBaseInfo)deductionConfigInfo);
        }
        CoreBaseCollection baseFormulaColls = new CoreBaseCollection();
        String businessRelConfigIDSql = " select Fid from T_HR_SBudgetDeductionConfig where FCalSchemeID = '" + calSchemeId + "'";
        CoreBaseCollection baseBusinessRelationColls = new CoreBaseCollection();
        BusinessRelationConfigCollection businessRelationColl = BusinessRelationConfigFactory.getLocalInstance((Context)ctx).getBusinessRelationConfigCollection(" select businessId,type,formulas.*,id where businessId in (" + businessRelConfigIDSql + ")");
        for (int i = 0; i < businessRelationColl.size(); ++i) {
            BusinessRelationConfigInfo businessInfo = businessRelationColl.get(i);
            BOSUuid bosUuid = BOSUuid.create((BOSObjectType)businessInfo.getBOSType());
            businessInfo.setId(bosUuid);
            if (!oldAndNewDeductionConfigIdMap.containsKey(businessInfo.getBusinessId())) continue;
            businessInfo.setBusinessId((BOSUuid)oldAndNewDeductionConfigIdMap.get(businessInfo.getBusinessId()));
            baseBusinessRelationColls.add((CoreBaseInfo)businessInfo);
            BaseFormulaCollection baseFormulaColl = businessInfo.getFormulas();
            for (int j = 0; j < baseFormulaColl.size(); ++j) {
                BaseFormulaInfo info = baseFormulaColl.get(j);
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                info.setBusinessRelationConfig(businessInfo);
                baseFormulaColls.add((CoreBaseInfo)info);
            }
        }
        BaseFormulaFactory.getLocalInstance((Context)ctx).addnewBatchData(baseFormulaColls);
        BusinessRelationConfigFactory.getLocalInstance((Context)ctx).addnewBatchData(baseBusinessRelationColls);
        iDeductionConfig.addnewBatchData(baseDeductionConfigColls);
    }

    @Override
    protected void _deleteBudgetRules(Context ctx, String calSchemeId) throws BOSException {
        try {
            CalSchemeVerificationRuleNodeRelFactory.getLocalInstance(ctx).delete(" where calSchemeVerificationRule.calScheme = '" + calSchemeId + "' and calSchemeVerificationRule.type = " + 20);
            CalSchemeVerificationRuleFactory.getLocalInstance(ctx).delete(" where calScheme = '" + calSchemeId + "' and type = " + 20);
            this.deleteBudgetDeductionConfig(ctx, calSchemeId, "", false);
        }
        catch (EASBizException e) {
            logger.error((Object)"CalSchemeFacadeControllerBean _deleteBudgetRules error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    protected void deleteBudgetDeductionConfig(Context ctx, String calSchemeId, String srcSchemeId, boolean srcAndChildSchemeSameTemp) throws BOSException {
        String businessRelConfigIDSql = " select Fid from T_HR_SBudgetDeductionConfig where FCalSchemeID = '" + calSchemeId + "'";
        if (StringUtils.isNotBlank((CharSequence)srcSchemeId) && srcAndChildSchemeSameTemp) {
            businessRelConfigIDSql = businessRelConfigIDSql + " and FSrcSchemeId = '" + srcSchemeId + "'";
        }
        try {
            BaseFormulaFactory.getLocalInstance((Context)ctx).delete(" where businessRelationConfig.businessId in (" + businessRelConfigIDSql + ")");
            BusinessRelationConfigFactory.getLocalInstance((Context)ctx).delete(" where businessId in (" + businessRelConfigIDSql + ")");
            BudgetCmpRelFactory.getLocalInstance(ctx).delete(" where budgetDeduction.id in (" + businessRelConfigIDSql + ")");
            BudgetDeductionConfigFactory.getLocalInstance(ctx).delete(" where id in (" + businessRelConfigIDSql + ")");
        }
        catch (EASBizException e) {
            logger.error((Object)"CalSchemeFacadeControllerBean deleteBudgetDeductionConfig error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }
}

