/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.ISHRBasicItem;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.compensation.CalFormulaCollection;
import com.kingdee.shr.compensation.CalFormulaFactory;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.FormulaTmpTableCollection;
import com.kingdee.shr.compensation.FormulaTmpTableFactory;
import com.kingdee.shr.compensation.FormulaTmpTableInfo;
import com.kingdee.shr.compensation.LaborCostTypeInfo;
import com.kingdee.shr.compensation.app.AbstractCmpItemControllerBean;
import com.kingdee.shr.compensation.exception.CmpItemException;
import com.kingdee.shr.compensation.segment.CmpSegmentColumn;
import com.kingdee.shr.compensation.segment.CmpSegmentColumnForItem;
import com.kingdee.shr.compensation.util.CmpItemUtil;
import com.kingdee.shr.compensation.util.FunUtils;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CmpItemControllerBean
extends AbstractCmpItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CmpItemControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.saveOrUpdate(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteCalItem(ctx, pk);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        return new Timestamp(d.getTime().getTime());
    }

    private void deleteCalItem(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String column = "";
        int count = 0;
        CmpItemInfo cmpInfo = CmpItemFactory.getLocalInstance(ctx).getCmpItemInfo(pk);
        try {
            String colSql = "select max('S'||to_char(FieldSn)) as field from t_hr_scmpItem where fid = '" + pk.toString() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)colSql);
            while (rowSet.next()) {
                column = rowSet.getString("field");
            }
            String columnSql = "select KSQL_COL_NAME col from KSQL_USERCOLUMNS where KSQL_COL_TABNAME='T_HR_SCmpCalTable' and KSQL_COL_NAME = '" + column + "'";
            IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)columnSql);
            if (rowSet2.size() < 1) {
                throw new CmpItemException(CmpItemException.NOTINLISTDATA, new Object[]{column});
            }
            String cntSql = "select count(*) as count from T_HR_SCMPCALTABLE where " + column + " is not null";
            IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)cntSql);
            while (rowSet1.next()) {
                count = rowSet1.getInt("count");
            }
            if (count > 0) {
                throw new CmpItemException(CmpItemException.NODELETE);
            }
            super._delete(ctx, pk);
            ArrayList<String> tableList = new ArrayList<String>();
            ArrayList<String> columnList = new ArrayList<String>();
            tableList.add("T_HR_SCmpCalTable");
            tableList.add("T_HR_SCMPSTOPCAL");
            tableList.add("T_HR_SCmpCalTableRep");
            columnList.add(column);
            CmpItemUtil.deleteItemColumns(ctx, columnList, tableList);
            CmpSegmentColumnForItem cmpSegmentColumn = new CmpSegmentColumnForItem();
            ((CmpSegmentColumn)cmpSegmentColumn).dropColumns(ctx, pk.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectPK[] _beforeDeleteOperation(Context ctx, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        SHRBaseItemInfo model = (SHRBaseItemInfo)shrBaseItem;
        if (null == model) {
            throw new CmpItemException(CmpItemException.NOBASE);
        }
        IObjectPK[] baseInfoOrgRefPK = null;
        if (BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new CmpItemException(CmpItemException.ISUSED, new Object[]{model.getNumber()});
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)model.getState())) {
            // empty if block
        }
        return baseInfoOrgRefPK;
    }

    private IObjectPK addNewItemAndColumns(Context ctx, CmpItemInfo item, int fieldSn) throws BOSException, EASBizException {
        IObjectPK idPk;
        SHRBasicItemInfo shrBasicItemInfo;
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        String name = item.getName();
        String number = item.getNumber();
        String oql = "select * where (number = '" + number + "')";
        try {
            shrBasicItemInfo = this.getShrBasicItemInfo(ctx);
            boolean exists = CmpItemFactory.getLocalInstance(ctx).exists(oql);
            if (exists) {
                throw new CmpItemException(CmpItemException.REPEAT, new Object[]{number, name});
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        this.checkNameDup(ctx, (DataBaseInfo)item);
        item.setFieldSn(fieldSn + 1);
        item.setIsSysPreset(false);
        item.setShrBasicItem(shrBasicItemInfo);
        if (item.getCU() == null) {
            item.setCU(this.getCU(ctx, (ObjectBaseInfo)item));
        }
        if (item.getCreator() == null) {
            item.setCreator(userInfo);
        }
        Timestamp createtime = this.getTime();
        if (item.getCreateTime() == null) {
            item.setCreateTime(createtime);
        }
        item.setLastUpdateUser(userInfo);
        item.setLastUpdateTime(createtime);
        item.setState(BaseItemStateEnum.NEW);
        if (!BaseItemStateEnum.NEW.equals((Object)item.getState())) {
            IObjectPK baseInfoChangePK = this._beforeSaveOperation(ctx, (IObjectValue)item);
            idPk = super.innerAddnew(ctx, (IObjectValue)item);
            if (null != baseInfoChangePK) {
                this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
            } else {
                baseInfoChangePK = this._afterSaveOperation(ctx, idPk.toString(), (IObjectValue)item);
                if (null != baseInfoChangePK) {
                    this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
                }
            }
        } else {
            idPk = super.innerAddnew(ctx, (IObjectValue)item);
        }
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("T_HR_SCmpCalTable");
        tableList.add("T_HR_SCMPSTOPCAL");
        tableList.add("T_HR_SCmpCalTableRep");
        CmpItemCollection cmpItemCollection = new CmpItemCollection();
        cmpItemCollection.add(item);
        CmpItemUtil.addItemColumns(ctx, (Object)cmpItemCollection, tableList);
        item.setId(BOSUuid.read((String)idPk.toString()));
        this.addSegmentColumn(ctx, item);
        this._writeReviseLog(ctx, (IObjectValue)this.getValue(ctx, idPk));
        return idPk;
    }

    private IObjectPK updateItem(Context ctx, CmpItemInfo item) throws BOSException, EASBizException {
        String name = item.getName();
        String number = item.getNumber();
        String itemid = item.getId().toString();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        String oql = "select * where ( number = '" + number + "') and id <> '" + itemid + "'";
        try {
            boolean exists = CmpItemFactory.getLocalInstance(ctx).exists(oql);
            if (exists) {
                throw new CmpItemException(CmpItemException.REPEAT, new Object[]{number, name});
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        this.checkNameDup(ctx, (DataBaseInfo)item);
        this.syncCalFOrmula(ctx, item);
        this.syncBaseFormula(ctx, item);
        SHRBasicItemInfo shrBasicItemInfo = this.getShrBasicItemInfo(ctx);
        CmpItemInfo cmpItemInfo = new CmpItemInfo();
        MetaDataPK entityPk = MetaDataPK.create((String)"com.kingdee.shr.compensation.app.CmpItem");
        EntityObjectInfo entityObject = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)entityPk);
        PropertyCollection propertiesRuntime = entityObject.getPropertiesRuntime();
        HashSet<String> expectSet = new HashSet<String>();
        expectSet.add("creator");
        expectSet.add("createTime");
        expectSet.add("CU");
        int size = propertiesRuntime.size();
        for (int i = 0; i < size; ++i) {
            OwnPropertyInfo ownp;
            PropertyInfo propertyInfo = propertiesRuntime.get(i);
            String propertyName = propertyInfo.getName();
            if (expectSet.contains(propertyName)) continue;
            if (propertyInfo instanceof OwnPropertyInfo && (ownp = (OwnPropertyInfo)propertyInfo).isMultilingual()) {
                cmpItemInfo.put(propertyName, item.get(propertyName, LocaleUtils.locale_L1), LocaleUtils.locale_L1);
                cmpItemInfo.put(propertyName, item.get(propertyName, LocaleUtils.locale_L2), LocaleUtils.locale_L2);
                cmpItemInfo.put(propertyName, item.get(propertyName, LocaleUtils.locale_L3), LocaleUtils.locale_L3);
                continue;
            }
            cmpItemInfo.put(propertyName, item.get(propertyName));
        }
        cmpItemInfo.setLastUpdateUser(userInfo);
        cmpItemInfo.setLastUpdateTime(this.getTime());
        cmpItemInfo.setShrBasicItem(shrBasicItemInfo);
        if (item.getFieldSn() <= 0) {
            String sql = "select FieldSn from T_HR_SCmpItem where fid='" + item.getId().toString() + "'";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rowset.next()) {
                    int fieldSn = rowset.getInt(1);
                    cmpItemInfo.setFieldSn(fieldSn);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            cmpItemInfo.setFieldSn(item.getFieldSn());
        }
        ObjectUuidPK idPk = new ObjectUuidPK(itemid);
        IObjectPK baseInfoChangePK = null;
        baseInfoChangePK = this._beforeSaveOperation(ctx, (IObjectValue)item);
        super.innerUpdate(ctx, (IObjectPK)idPk, (IObjectValue)cmpItemInfo);
        if (null != baseInfoChangePK) {
            this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
        } else {
            baseInfoChangePK = this._afterSaveOperation(ctx, idPk.toString(), (IObjectValue)item);
            if (null != baseInfoChangePK) {
                this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
            }
        }
        this.addSegmentColumn(ctx, cmpItemInfo);
        this._writeReviseLog(ctx, (IObjectValue)this.getValue(ctx, (IObjectPK)idPk));
        return idPk;
    }

    private void syncCalFOrmula(Context ctx, CmpItemInfo item) throws BOSException {
        String newName;
        String oldName = newName = item.getName();
        boolean isSync = false;
        String fieldSn = "";
        try {
            CmpItemInfo cmpItemInfo = CmpItemFactory.getLocalInstance(ctx).getCmpItemInfo((IObjectPK)new ObjectUuidPK(item.getId().toString()));
            oldName = cmpItemInfo.getName();
            fieldSn = "S" + cmpItemInfo.getFieldSn();
            if (!newName.equals(oldName)) {
                isSync = true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        if (!isSync) {
            return;
        }
        String oqlStr = "select * where content like '%" + oldName + "%' and calScheme in (select FCalSchemeID from T_HR_SCalSchemeItem where FCmpItemID = '" + item.getId().toString() + "')";
        CalFormulaCollection calFormulaCollection = CalFormulaFactory.getLocalInstance(ctx).getCalFormulaCollection(oqlStr);
        if (null == calFormulaCollection || calFormulaCollection.size() < 1) {
            return;
        }
        CoreBaseCollection updateCalFormulaCol = new CoreBaseCollection();
        int size = calFormulaCollection.size();
        for (int i = 0; i < size; ++i) {
            boolean isUpdate = false;
            CalFormulaInfo calFormulaInfo = calFormulaCollection.get(i);
            String content = calFormulaInfo.getContent();
            String express = calFormulaInfo.getExpress();
            String name = calFormulaInfo.getName();
            if (content.contains(oldName)) {
                content = content.replaceAll(">" + oldName + "<", ">" + newName + "<");
                content = content.replaceAll("&quot;" + oldName + "&quot;", "&quot;" + newName + "&quot;");
                content = content.replaceAll("]" + oldName + "<", "]" + newName + "<");
                isUpdate = true;
            }
            if (express.contains(oldName)) {
                express = express.replaceAll("\"" + oldName + "\"", "\"" + newName + "\"");
                isUpdate = true;
            }
            if (name.equals(oldName)) {
                name = newName;
                isUpdate = true;
            }
            if (!isUpdate) continue;
            calFormulaInfo.setContent(content);
            calFormulaInfo.setExpress(express);
            calFormulaInfo.setName(name);
            updateCalFormulaCol.add((CoreBaseInfo)calFormulaInfo);
        }
        if (updateCalFormulaCol.size() > 0) {
            try {
                CalFormulaFactory.getLocalInstance(ctx).update(updateCalFormulaCol);
            }
            catch (EASBizException e) {
                logger.error((Object)("updateCalFormula:" + e.getMessage()));
            }
        }
        CoreBaseCollection updateTmpTableCol = new CoreBaseCollection();
        FormulaTmpTableCollection formulaTmpTableCollection = FormulaTmpTableFactory.getLocalInstance(ctx).getFormulaTmpTableCollection("select * where paramDefines like '%" + fieldSn + "%'");
        if (null == formulaTmpTableCollection || formulaTmpTableCollection.size() < 1) {
            return;
        }
        int size2 = formulaTmpTableCollection.size();
        for (int i = 0; i < size2; ++i) {
            FormulaTmpTableInfo formulaTmpTableInfo = formulaTmpTableCollection.get(i);
            String paramNames = formulaTmpTableInfo.getParamNames();
            paramNames = paramNames.replaceAll("\\s", "").replaceAll(oldName, newName);
            formulaTmpTableInfo.setParamNames(paramNames);
            updateTmpTableCol.add((CoreBaseInfo)formulaTmpTableInfo);
        }
        if (updateTmpTableCol.size() > 0) {
            try {
                FormulaTmpTableFactory.getLocalInstance(ctx).update(updateTmpTableCol);
            }
            catch (EASBizException e) {
                logger.error((Object)("updateCalTmpTable:" + e.getMessage()));
            }
        }
    }

    private void syncBaseFormula(Context ctx, CmpItemInfo item) throws BOSException {
        String newName;
        String oldName = newName = item.getName();
        boolean isSync = false;
        try {
            CmpItemInfo cmpItemInfo = CmpItemFactory.getLocalInstance(ctx).getCmpItemInfo((IObjectPK)new ObjectUuidPK(item.getId().toString()));
            oldName = cmpItemInfo.getName();
            if (!newName.equals(oldName)) {
                isSync = true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        if (!isSync) {
            return;
        }
        String oqlStr = "select * where id in (select FBaseFormulaId from T_HR_SCmpItemBformulaRel where FCmpItemId = '" + item.getId().toString() + "')";
        BaseFormulaCollection baseFormulaCollection = BaseFormulaFactory.getLocalInstance((Context)ctx).getBaseFormulaCollection(oqlStr);
        if (null == baseFormulaCollection || baseFormulaCollection.size() < 1) {
            return;
        }
        CoreBaseCollection updateBaseFormulaCol = new CoreBaseCollection();
        int size = baseFormulaCollection.size();
        for (int i = 0; i < size; ++i) {
            boolean isUpdate = false;
            BaseFormulaInfo baseFormulaInfo = baseFormulaCollection.get(i);
            String htmlContent = baseFormulaInfo.getHtmlContent();
            String express = baseFormulaInfo.getExpress();
            String name = baseFormulaInfo.getName();
            if (htmlContent.contains(oldName)) {
                htmlContent = htmlContent.replaceAll(">\\{" + oldName + "\\}<", ">\\{" + newName + "\\}<");
                isUpdate = true;
            }
            if (express.contains(oldName)) {
                express = express.replaceAll("\"\\{" + oldName + "\\}\"", "\"\\{" + newName + "\\}\"");
                isUpdate = true;
            }
            if (!isUpdate) continue;
            baseFormulaInfo.setHtmlContent(htmlContent);
            baseFormulaInfo.setExpress(express);
            baseFormulaInfo.setName(name);
            updateBaseFormulaCol.add((CoreBaseInfo)baseFormulaInfo);
        }
        if (updateBaseFormulaCol.size() > 0) {
            try {
                BaseFormulaFactory.getLocalInstance((Context)ctx).update(updateBaseFormulaCol);
            }
            catch (EASBizException e) {
                logger.error((Object)("updateBaseFormula:" + e.getMessage()));
            }
        }
    }

    private IObjectPK saveOrUpdate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FunUtils.clearSessionMap();
        CmpItemInfo item = (CmpItemInfo)model;
        String name = item.getName();
        String name_l1 = item.getName(LocaleUtils.locale_L1);
        String name_l2 = item.getName(LocaleUtils.locale_L2);
        String name_l3 = item.getName(LocaleUtils.locale_L3);
        if (!StringUtils.isEmpty((String)name) && (StringUtils.isEmpty((String)name_l1) || StringUtils.isEmpty((String)name_l2) || StringUtils.isEmpty((String)name_l3))) {
            name_l1 = StringUtils.isEmpty((String)name_l1) ? name : name_l1;
            name_l2 = StringUtils.isEmpty((String)name_l2) ? name : name_l2;
            String string = name_l3 = StringUtils.isEmpty((String)name_l3) ? name : name_l3;
        }
        if (StringUtils.isEmpty((String)name_l1) || StringUtils.isEmpty((String)name_l2) || StringUtils.isEmpty((String)name_l3) || StringUtils.isEmpty((String)item.getNumber())) {
            throw new CmpItemException(CmpItemException.NOTEMPTY);
        }
        String reg = "^[\u4e00-\u9fa5a-zA-Z_0-9]+[\u4e00-\u9fa5a-zA-Z_0-9\uff08\uff09\\s()&-/\\\\.?]*$";
        if (!(name_l1.matches(reg) && name_l2.matches(reg) && name_l3.matches(reg) && item.getNumber().matches(reg))) {
            throw new CmpItemException(CmpItemException.NOESP_NEW);
        }
        String ifstr = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"if", (Locale)ctx.getLocale());
        String contain = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"contain", (Locale)ctx.getLocale());
        String that = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"that", (Locale)ctx.getLocale());
        String Refiltration = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"Refiltration", (Locale)ctx.getLocale());
        String Rest = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"Rest", (Locale)ctx.getLocale());
        String also = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"also", (Locale)ctx.getLocale());
        String elsestr = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"else", (Locale)ctx.getLocale());
        String[] arr = new String[]{ifstr, contain, that, Refiltration, Rest, also, elsestr};
        for (int i = 0; i < arr.length; ++i) {
            if (!name_l1.contains(arr[i]) && !name_l2.contains(arr[i]) && !name_l3.contains(arr[i]) && !item.getNumber().contains(arr[i])) continue;
            throw new CmpItemException(CmpItemException.NOESP_NEW);
        }
        int fieldSn = 60;
        String sql = "select max(FieldSn) from T_HR_SCmpItem";
        IRowSet list = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (list.next()) {
                if (list.getInt(1) <= fieldSn) continue;
                fieldSn = list.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        boolean isNewOp = false;
        int orgFieldSn = item.getFieldSn();
        if (orgFieldSn == -1 || orgFieldSn == 0) {
            isNewOp = true;
        }
        if (item.getId() != null && !StringUtils.isEmpty((String)item.getId().toString())) {
            isNewOp = false;
        }
        if (isNewOp) {
            return this.addNewItemAndColumns(ctx, item, fieldSn);
        }
        return this.updateItem(ctx, item);
    }

    private SHRBasicItemInfo getShrBasicItemInfo(Context ctx) throws BOSException, EASBizException {
        String entityName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType()).getFullName();
        ISHRBasicItem shrBasicItem = SHRBasicItemFactory.getLocalInstance((Context)ctx);
        String oql = "where entityName='" + entityName + "'";
        return shrBasicItem.getSHRBasicItemInfo(oql);
    }

    private void addSegmentColumn(Context ctx, CmpItemInfo item) throws BOSException, EASBizException {
        LaborCostTypeInfo laborCostType = item.getLaborCostType();
        if (null == laborCostType) {
            return;
        }
        String laborId = laborCostType.getId().toString();
        CmpSegmentColumnForItem cmpSegmentColumn = new CmpSegmentColumnForItem();
        ((CmpSegmentColumn)cmpSegmentColumn).createColumn(ctx, laborId, (CoreBaseInfo)item);
    }
}

