/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalState;
import com.kingdee.shr.compensation.CmpCalTableWFRecordCollection;
import com.kingdee.shr.compensation.CmpCalTableWFRecordFactory;
import com.kingdee.shr.compensation.CmpWFPerDetailGridConfCollection;
import com.kingdee.shr.compensation.CmpWFPerDetailGridConfFactory;
import com.kingdee.shr.compensation.CmpWorkFlowMainBillFactory;
import com.kingdee.shr.compensation.CmpWorkFlowMainBillInfo;
import com.kingdee.shr.compensation.ICmpWorkFlowMainBill;
import com.kingdee.shr.compensation.app.AbstractCmpWorkFlowMainBillControllerBean;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionFacadeFactory;
import com.kingdee.shr.compensation.app.cmpBudget.DeduNodeEnum;
import com.kingdee.shr.compensation.app.cmpBudget.RollBackNodeEnum;
import com.kingdee.shr.compensation.app.payPush.PayslipPushUtils;
import com.kingdee.shr.compensation.cmpBudget.CmpBudgetFacadeService;
import com.kingdee.shr.compensation.helper.CalSchemeBizUtil;
import com.kingdee.shr.compensation.util.CmpCalUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.filter.CmpPermFilter;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpWorkFlowMainBillControllerBean
extends AbstractCmpWorkFlowMainBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CmpWorkFlowMainBillControllerBean");

    @Override
    public void setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateCacluteTableAuditStateAndBillState(ctx, billID, HRBillStateEnum.SUBMITED);
    }

    @Override
    public void setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateCacluteTableAuditStateAndBillState(ctx, billID, HRBillStateEnum.AUDITED);
        String permItemId = "db3beec5-6995-4cc6-bee9-263b082e0c4cPERMITEM";
        String billId = billID.toString();
        String sendBillTableName = this.getCmpWorkFlowBillTableName();
        this.workFlowBudgetExecute(ctx, permItemId, sendBillTableName, billId);
    }

    @Override
    public void setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateCacluteTableAuditStateAndBillState(ctx, billID, HRBillStateEnum.AUDITING);
    }

    @Override
    public void setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateCacluteTableAuditStateAndBillState(ctx, billID, HRBillStateEnum.AUDITEND);
    }

    private void updateCacluteTableAuditStateAndBillState(Context ctx, BOSUuid billID, HRBillStateEnum billState) throws EASBizException, BOSException {
        String permItemId = "db3beec5-6995-4cc6-bee9-263b082e0c4cPERMITEM";
        String billId = billID.toString();
        String sendBillTableName = this.getCmpWorkFlowBillTableName();
        int stateVale = billState.getValue();
        this.setBillState(ctx, billId, sendBillTableName, billState);
        this.setCalTableCalState(ctx, permItemId, sendBillTableName, billId, billState);
        this.setCalSchemeState(ctx, billId, billState);
        this.pushForPerson(ctx, permItemId, sendBillTableName, billId, billState);
    }

    private void workFlowBudgetExecute(Context ctx, String permItemId, String sendBillTableName, String billID) throws BOSException {
        try {
            String oql = "select calScheme.id, calScheme.budgetTemplate.id where id = '" + billID + "'";
            CmpWorkFlowMainBillInfo billInfo = CmpWorkFlowMainBillFactory.getLocalInstance(ctx).getCmpWorkFlowMainBillInfo(oql);
            CalSchemeInfo calSchemeInfo = billInfo.getCalScheme();
            if (calSchemeInfo != null && calSchemeInfo.getBudgetTemplate() != null) {
                String executeSql = this.getSendBillCalTableIdSql(ctx, permItemId, billID, sendBillTableName);
                this.budgetExecute(ctx, calSchemeInfo.getId().toString(), executeSql);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void budgetExecute(Context ctx, String cmpschemeid, String executeSql) throws Exception {
        HashMap<String, String> calParams = new HashMap<String, String>();
        calParams.put("deduNode", String.valueOf(200));
        calParams.put("calSchemeID", cmpschemeid);
        calParams.put("mainTable", "T_HR_SCmpCalTable");
        calParams.put("condition", executeSql);
        Map calculate = BudgetDeductionFacadeFactory.getLocalInstance(ctx).calculate(calParams);
    }

    protected void pushForPerson(Context ctx, String permItemId, String sendBillTableName, String billId, HRBillStateEnum billState) {
        CalState calScate = this.convert2CalcluteTableStateString(billState);
        logger.debug((Object)("CmpWorkFlowMainBillControllerBean calScate: " + calScate.getValue()));
        if (!CalState.HASGIVE.equals((Object)calScate)) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("calScheme.id"));
        CmpWorkFlowMainBillInfo info = null;
        try {
            info = CmpWorkFlowMainBillFactory.getLocalInstance(ctx).getCmpWorkFlowMainBillInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (null == info) {
            return;
        }
        String calSchemeId = info.getCalScheme() == null || info.getCalScheme().getId() == null ? "" : info.getCalScheme().getId().toString();
        String filterSql = " calTab.fid in (" + this.getSendBillCalTableIdSql(ctx, permItemId, billId, sendBillTableName) + " and fcalstate <> " + 20 + ")";
        PayslipPushUtils.pushForPerson(ctx, CalState.HASGIVE, calSchemeId, filterSql);
    }

    private void setBillState(Context ctx, String billID, String sendBillTableName, HRBillStateEnum billState) throws BOSException, EASBizException {
        String updateSql = "update " + sendBillTableName + " set FBILLSTATE =" + billState.getValue() + " where fid = '" + billID + "'";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void setCalTableCalState(Context ctx, String permItemId, String sendBillTableName, String billID, HRBillStateEnum billState) throws BOSException {
        CalState calScate = this.convert2CalcluteTableStateString(billState);
        this.doUpadateCalTableCalStateNoCheckOut(ctx, permItemId, billID, sendBillTableName, calScate);
    }

    private void setCalSchemeState(Context ctx, String billID, HRBillStateEnum billState) throws BOSException {
        CmpWorkFlowMainBillControllerBean.doUpadateCalSchemeCalState(ctx, billID, this.convert2CalcluteTableStateString(billState));
    }

    public static void doUpadateCalSchemeCalState(Context ctx, String billId, CalState calState) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("calScheme.id"));
        CmpWorkFlowMainBillInfo info = null;
        try {
            info = CmpWorkFlowMainBillFactory.getLocalInstance(ctx).getCmpWorkFlowMainBillInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (null == info) {
            return;
        }
        CmpCalUtil.updateNewCalSchemeState(ctx, info.getCalScheme().getId().toString());
    }

    private void doUpadateCalTableCalStateNoCheckOut(Context ctx, String permItemId, String billId, String billTable, CalState calState) {
        String filter = " and fcalstate <> 20";
        this.doUpadateCalTableCalState(ctx, permItemId, billId, billTable, calState, filter);
    }

    private void doUpadateCalTableCalState(Context ctx, String permItemId, String billId, String billTable, CalState calState, String filter) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" update T_HR_SCMPCALTABLE set fcalstate = " + calState.getValue() + "");
        buffer.append(" where fid in(");
        buffer.append(this.getSendBillCalTableIdSql(ctx, permItemId, billId, billTable));
        buffer.append(")");
        if (!StringUtils.isEmpty((String)filter)) {
            buffer.append(filter);
        }
        try {
            DbUtil.execute((Context)ctx, (String)buffer.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private String getSendBillCalTableIdSql(Context ctx, String permItemId, String billId, String billTable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" select cmpCalTable.fid  as fid from t_hr_scmpcaltable as cmpCalTable ");
        buffer.append(" inner join T_HR_SCmpCalTableWFRecord as wfrecord  on wfrecord.FCalTableId = cmpCalTable.fid");
        buffer.append(" inner join ").append(billTable).append(" as billtable on billtable.fid = wfrecord.FCmpSendBillId and billtable.FCalSchemeID = cmpCalTable.FCalSchemeID");
        buffer.append(" where billtable.fid ='" + billId + "'");
        return buffer.toString();
    }

    private String getCalTableFilter(Context ctx, String permItemId, String calTableAlias) {
        String userAdminRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String calSchemeDataPermSql = "";
        try {
            calSchemeDataPermSql = CmpSchemeFilter.getPersonCalSchemePerm(ctx, permItemId, false);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        String entryFilter = calTableAlias + ".FUseDefault=1 and " + calTableAlias + ".FAdminOrgUnitID in (" + userAdminRangeSql + ") or " + calTableAlias + ".FUseDefault=0";
        String personCmpPermSql = CmpPermFilter.getPermSQL(ctx, "002", permItemId, true);
        StringBuffer personFilter = new StringBuffer();
        if (!StringUtils.isEmpty((String)calSchemeDataPermSql)) {
            personFilter.append(" and (").append(entryFilter).append(")");
        }
        if (CmpStrUtil.isNotEmpty(personCmpPermSql)) {
            personFilter.append(" and " + calTableAlias + ".FPersonID in (" + personCmpPermSql + ")");
        }
        return personFilter.toString();
    }

    private CalState convert2CalcluteTableStateString(HRBillStateEnum billState) {
        CalState calScate = CalState.NOCAL;
        if (0 == billState.getValue()) {
            calScate = CalState.NOAUDIT;
        } else if (1 == billState.getValue()) {
            calScate = CalState.NOGIVE;
        } else if (2 == billState.getValue()) {
            calScate = CalState.ATGIVE;
        } else if (3 == billState.getValue()) {
            calScate = CalState.HASGIVE;
        } else if (4 == billState.getValue()) {
            calScate = CalState.BANGIVE;
        }
        return calScate;
    }

    @Override
    public String getCmpWorkFlowBillTableName() throws BOSException {
        return "T_HR_SCmpWorkFlowMainBill";
    }

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            ICmpWorkFlowMainBill iCmpWorkFlowMainBill = CmpWorkFlowMainBillFactory.getLocalInstance(ctx);
            CmpWorkFlowMainBillInfo billInfo = iCmpWorkFlowMainBill.getCmpWorkFlowMainBillInfo((IObjectPK)new ObjectUuidPK(billId));
            if (null == billInfo) {
                logger.error((Object)MessageFormat.format(" when CmpWorkFlowMainBillControllerBean._abortBizBill invocked, getCmpWorkFlowMainBillInfo is null ! billId:{0}", billId));
                return;
            }
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                SelectorItemCollection selector = new SelectorItemCollection();
                billInfo.setBillState(HRBillStateEnum.SAVED);
                selector.add(new SelectorItemInfo("billState"));
                iCmpWorkFlowMainBill.updatePartial((CoreBaseInfo)billInfo, selector);
                this.updateCalState(ctx, billId);
                CmpCalUtil.updateNewCalSchemeState(ctx, billInfo.getCalScheme().getId().toString());
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, billInfo);
            } else {
                logger.error((Object)MessageFormat.format("billInfo,id: {0}", String.valueOf(billInfo.getId())));
            }
        } else {
            logger.error((Object)" when CmpWorkFlowMainBillControllerBean._abortBizBill invocked, param billId is empty! please check param ");
        }
    }

    private void updateCalSchemeState(Context ctx, String billId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_HR_SCalScheme set fcalstate = ").append(8);
        sql.append(" where fid in(");
        sql.append(" select cmpCalTable.FCalSchemeID from T_HR_SCMPCALTABLE cmpCalTable ");
        sql.append("  inner join T_HR_SCmpCalTableWFRecord as wfrecord  on wfrecord.FCalTableId = cmpCalTable.fid ");
        sql.append("  where wfrecord.FcmpSendBillId = '").append(billId).append("'");
        sql.append(") and fcalstate <> ").append(20);
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)("when CmpWorkFlowMainBillControllerBean.updateCalState invocked ,error execute sql +  " + e.getMessage()), (Throwable)e);
        }
    }

    private void updateCalState(Context ctx, String billId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_HR_SCMPCALTABLE set fcalstate = ").append(8);
        sql.append(" where fid in(");
        sql.append(" select cmpCalTable.fid from T_HR_SCMPCALTABLE cmpCalTable ");
        sql.append("  inner join T_HR_SCmpCalTableWFRecord as wfrecord  on wfrecord.FCalTableId = cmpCalTable.fid ");
        sql.append("  where wfrecord.FcmpSendBillId = '").append(billId).append("'");
        sql.append(") and fcalstate not in (1, 4, 20) ");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)("when CmpWorkFlowMainBillControllerBean.updateCalState invocked ,error execute sql " + e.getMessage()), (Throwable)e);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CmpWFPerDetailGridConfCollection cmpWFPerDetailGridConfCollection;
        CmpWorkFlowMainBillInfo billInfo = (CmpWorkFlowMainBillInfo)model;
        String billId = billInfo.getId().toString();
        CmpCalTableWFRecordCollection calTableWFRecordCollection = billInfo.getCalTableRecord();
        if (null == calTableWFRecordCollection || calTableWFRecordCollection.size() == 0) {
            calTableWFRecordCollection = CmpCalTableWFRecordFactory.getLocalInstance(ctx).getCmpCalTableWFRecordCollection("where cmpSendBill = '" + billId + "'");
            billInfo.getCalTableRecord().addCollection(calTableWFRecordCollection);
        }
        if (null == (cmpWFPerDetailGridConfCollection = billInfo.getPersonDetailGridConf()) || cmpWFPerDetailGridConfCollection.size() == 0) {
            cmpWFPerDetailGridConfCollection = CmpWFPerDetailGridConfFactory.getLocalInstance(ctx).getCmpWFPerDetailGridConfCollection("where billId = '" + billId + "'");
            billInfo.getPersonDetailGridConf().addCollection(cmpWFPerDetailGridConfCollection);
        }
        super._update(ctx, pk, (IObjectValue)billInfo);
    }

    @Override
    protected void _reApprovalBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            ICmpWorkFlowMainBill iCmpWorkFlowMainBill = CmpWorkFlowMainBillFactory.getLocalInstance(ctx);
            CmpWorkFlowMainBillInfo billInfo = iCmpWorkFlowMainBill.getCmpWorkFlowMainBillInfo((IObjectPK)new ObjectUuidPK(billId));
            if (null == billInfo) {
                logger.error((Object)MessageFormat.format(" when CmpWorkFlowMainBillControllerBean._reApprovalBill invocked, getCmpWorkFlowMainBillInfo is null ! billId:{0}", billId));
                return;
            }
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.AUDITED.equals((Object)billState)) {
                SelectorItemCollection selector = new SelectorItemCollection();
                billInfo.setBillState(HRBillStateEnum.SAVED);
                selector.add(new SelectorItemInfo("billState"));
                iCmpWorkFlowMainBill.updatePartial((CoreBaseInfo)billInfo, selector);
                this.updateCalState(ctx, billId);
                CmpCalUtil.updateNewCalSchemeState(ctx, billInfo.getCalScheme().getId().toString());
                this.revokeBudgetExecute(ctx, billInfo.getCalScheme().getId().toString(), billId);
            } else {
                logger.error((Object)MessageFormat.format("billInfo,id: {0}", String.valueOf(billInfo.getId())));
            }
        } else {
            logger.error((Object)" when CmpWorkFlowMainBillControllerBean._reApprovalBill invocked, param billId is empty! please check param ");
        }
    }

    private void revokeBudgetExecute(Context ctx, String cmpschemeid, String billId) throws BOSException, EASBizException {
        CalSchemeInfo calSchemeInfo = CalSchemeBizUtil.getCalSchemeInfo(ctx, cmpschemeid);
        if (calSchemeInfo != null && calSchemeInfo.getBudgetTemplate() != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select cmpCalTable.fid from T_HR_SCMPCALTABLE cmpCalTable ");
            sql.append(" inner join T_HR_SCmpCalTableWFRecord as wfrecord  on wfrecord.FCalTableId = cmpCalTable.fid ");
            sql.append(" where wfrecord.FcmpSendBillId = '").append(billId).append("'");
            sql.append(" and fcalstate not in (1, 4, 20) ");
            CmpBudgetFacadeService service = new CmpBudgetFacadeService();
            service.rollbackBudget(ctx, cmpschemeid, sql.toString(), RollBackNodeEnum.REVERTAPPROVE, DeduNodeEnum.APPROVE);
        }
    }

    protected void _setSaved(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        String billId = billID.toString();
        if (!StringUtils.isEmpty((String)billId)) {
            ICmpWorkFlowMainBill iCmpWorkFlowMainBill = CmpWorkFlowMainBillFactory.getLocalInstance(ctx);
            CmpWorkFlowMainBillInfo billInfo = iCmpWorkFlowMainBill.getCmpWorkFlowMainBillInfo((IObjectPK)new ObjectUuidPK(billId));
            if (null == billInfo) {
                logger.error((Object)MessageFormat.format(" when CmpWorkFlowMainBillControllerBean._setSaved invocked, getCmpWorkFlowMainBillInfo is null ! billId:{0}", billId));
                return;
            }
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                SelectorItemCollection selector = new SelectorItemCollection();
                billInfo.setBillState(HRBillStateEnum.SAVED);
                selector.add(new SelectorItemInfo("billState"));
                iCmpWorkFlowMainBill.updatePartial((CoreBaseInfo)billInfo, selector);
                this.updateCalState(ctx, billId);
                CmpCalUtil.updateNewCalSchemeState(ctx, billInfo.getCalScheme().getId().toString());
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, billInfo);
            } else {
                logger.error((Object)MessageFormat.format("billInfo,id: {0}", String.valueOf(billInfo.getId())));
            }
        } else {
            logger.error((Object)" when CmpWorkFlowMainBillControllerBean._setSaved invocked, param billId is empty! please check param ");
        }
    }
}

