/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractHRCmpItemTopFewFacadeControllerBean;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRCmpItemTopFewFacadeControllerBean
extends AbstractHRCmpItemTopFewFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.compensation.app.HRCmpItemTopFewFacadeControllerBean");

    @Override
    protected Map _getCmpItemTopFew(Context ctx, String topFew) throws BOSException, EASBizException {
        int num = 1;
        try {
            num = topFew == null ? 3 : Integer.parseInt(topFew);
        }
        catch (Exception e) {
            num = 3;
        }
        Map<String, Object> topFewMap = this.getCmpItemTopFewData(ctx, num);
        return topFewMap;
    }

    private Map<String, Object> getCmpItemTopFewData(Context ctx, int num) {
        HashMap<String, Object> cmpItemTopFewData = new HashMap<String, Object>();
        int periodYear = 0;
        int periodMonth = 0;
        periodYear = this.getCmpSalaryMaxPeriodYear(ctx);
        if (periodYear != 0) {
            periodMonth = this.getCmpSalaryMaxPeriodMonthByPeriodYear(ctx, periodYear);
            List<Map<String, Object>> cmpItemRateData = this.getCmpItemRateData(ctx, periodYear, periodMonth, num);
            cmpItemTopFewData.put("periodYear", periodYear);
            cmpItemTopFewData.put("periodMonth", periodMonth);
            cmpItemTopFewData.put("cmpItemRateData", cmpItemRateData);
        } else {
            cmpItemTopFewData.put("periodYear", "");
            cmpItemTopFewData.put("periodMonth", "");
            ArrayList cmpItemRateData = new ArrayList();
            cmpItemTopFewData.put("cmpItemRateData", cmpItemRateData.toArray());
        }
        return cmpItemTopFewData;
    }

    private List<Map<String, Object>> getCmpItemRateData(Context ctx, int periodYear, int periodMonth, int num) {
        List<Map<String, Object>> cmpItemRateData = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> cmpItemData = new HashMap<String, Object>();
        Map<String, Object> cmpItemMap = this.getCmpItemMap(ctx, periodYear, periodMonth);
        ArrayList<String> fieldSnLabels = new ArrayList<String>();
        String sql = HRCmpReportUtil.getCmpItemDataByPeriodYear(ctx, periodYear, cmpItemMap, fieldSnLabels);
        try {
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sql);
            while (rowSet.next()) {
                int rsYear = rowSet.getInt("periodYear");
                int rsMonth = rowSet.getInt("periodMonth");
                HashMap<String, Double> map = new HashMap<String, Double>();
                for (int i = 0; i < fieldSnLabels.size(); ++i) {
                    String fieldSnLabel = (String)fieldSnLabels.get(i);
                    double value = rowSet.getDouble(fieldSnLabel);
                    map.put(fieldSnLabel, value);
                }
                cmpItemData.put(rsYear + "-" + rsMonth, map);
            }
            cmpItemRateData = this.calculationRateData(fieldSnLabels, cmpItemData, cmpItemMap, periodYear, periodMonth, num);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return cmpItemRateData;
    }

    private List<Map<String, Object>> calculationRateData(List<String> fieldSnLabels, Map<String, Object> cmpItemData, Map<String, Object> cmpItemMap, int periodYear, int periodMonth, int num) {
        ArrayList<Map<String, Object>> cmpItemRateDataList = new ArrayList<Map<String, Object>>();
        String currLabel = periodYear + "-" + periodMonth;
        String lastLabel = periodYear + "-" + (periodMonth - 1);
        if (periodMonth == 1) {
            lastLabel = periodYear - 1 + "-12";
        }
        Map currMap = (Map)cmpItemData.get(currLabel);
        Map lastMap = (Map)cmpItemData.get(lastLabel);
        if (lastMap != null && lastMap.size() > 0) {
            TreeMap<String, Double> cmpItemRateDataMap = new TreeMap<String, Double>();
            for (int i = 0; i < fieldSnLabels.size(); ++i) {
                String label = fieldSnLabels.get(i);
                String name = (String)cmpItemMap.get(label);
                double currValue = (Double)currMap.get(label);
                double lastValue = (Double)lastMap.get(label);
                double rate = 0.0;
                if (lastValue != 0.0) {
                    rate = HRCmpReportUtil.formatDouble((currValue - lastValue) / lastValue);
                } else if (lastValue == 0.0 && currValue != 0.0) {
                    rate = HRCmpReportUtil.formatDouble(1.0);
                } else if (lastValue == 0.0 && currValue == 0.0) {
                    rate = HRCmpReportUtil.formatDouble(0.0);
                }
                cmpItemRateDataMap.put(name, rate);
            }
            ArrayList cmpItemRateList = new ArrayList(cmpItemRateDataMap.entrySet());
            Collections.sort(cmpItemRateList, (Comparator)new Comparator<Map.Entry<String, Double>>(){

                @Override
                public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                    Double val1 = Math.abs(o1.getValue());
                    Double val2 = Math.abs(o2.getValue());
                    return val2.compareTo(val1);
                }
            });
            for (int i = 0; i < cmpItemRateList.size() && (cmpItemRateDataList.size() < num || num == -1); ++i) {
                HashMap<String, Object> cmpItemRateData = new HashMap<String, Object>();
                Map.Entry entry = (Map.Entry)cmpItemRateList.get(i);
                String key = (String)entry.getKey();
                double value = (Double)entry.getValue();
                int status = 1;
                if (value == 0.0) continue;
                if (value < 0.0) {
                    status = 0;
                }
                cmpItemRateData.put("name", key);
                cmpItemRateData.put("rate", Math.abs(Math.round(value * 100.0)) + "%");
                cmpItemRateData.put("status", status);
                cmpItemRateDataList.add(cmpItemRateData);
            }
        }
        return cmpItemRateDataList;
    }

    private Map<String, Object> getCmpItemMap(Context ctx, int periodYear, int periodMonth) {
        HashMap<String, Object> cmpItemMap = new HashMap<String, Object>();
        String sql = HRCmpReportUtil.getCmpItemWitchDataTypeIsNumber(ctx, periodYear, periodMonth);
        try {
            String name;
            String fieldSn;
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sql);
            while (rowSet.next()) {
                fieldSn = "S" + rowSet.getString("fieldSn");
                name = rowSet.getString("name");
                if (StringUtils.isEmpty((CharSequence)name)) continue;
                cmpItemMap.put(fieldSn, name);
            }
            if (periodMonth == 1) {
                sql = HRCmpReportUtil.getCmpItemWitchDataTypeIsNumber(ctx, periodYear - 1, 12);
                rowSet = SqlUtil.executeQuery(ctx, sql);
                while (rowSet.next()) {
                    fieldSn = "S" + rowSet.getString("fieldSn");
                    name = rowSet.getString("name");
                    if (StringUtils.isEmpty((CharSequence)name)) continue;
                    cmpItemMap.put(fieldSn, name);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return cmpItemMap;
    }

    private int getCmpSalaryMaxPeriodYear(Context ctx) {
        int periodYear = 0;
        String sql = HRCmpReportUtil.getCmpSalaryMaxPeriodYear(ctx);
        try {
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sql);
            if (rowSet.next()) {
                periodYear = rowSet.getInt("periodYear");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return periodYear;
    }

    private int getCmpSalaryMaxPeriodMonthByPeriodYear(Context ctx, int periodYear) {
        int periodMonth = 0;
        String sql = HRCmpReportUtil.getCmpSalaryMaxPeriodMonthByPeriodYear(ctx, periodYear);
        try {
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sql);
            if (rowSet.next()) {
                periodMonth = rowSet.getInt("periodMonth");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return periodMonth;
    }
}

