/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.shr.compensation.LaborCostTypeInfo;
import com.kingdee.shr.compensation.app.AbstractLaborCostTypeControllerBean;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LaborCostTypeControllerBean
extends AbstractLaborCostTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.LaborCostTypeControllerBean");
    private final int startlevel = 1;
    private static final Locale locale_L1 = LocaleUtils.locale_L1;
    private static final Locale localeChina = LocaleUtils.locale_L2;
    private static final Locale locale_L3 = LocaleUtils.locale_L3;

    @Override
    protected void _sort(Context ctx, String[] ids, int[] orders) throws BOSException, EASBizException {
        IMetaDataLoader metaData = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String tableName = metaData.getEntity(this.getBOSType()).getTable().getName();
        String sql = "UPDATE " + tableName + " SET FIndex=? WHERE FID=?";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            for (int i = 0; i < ids.length; ++i) {
                pstmt.setInt(1, orders[i]);
                pstmt.setString(2, ids[i]);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LaborCostTypeInfo laborCostTypeInfo = (LaborCostTypeInfo)model;
        if (laborCostTypeInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        this._checkNumberDup(ctx, (IObjectValue)laborCostTypeInfo);
        LaborCostTypeInfo parent = this.getFullParent(ctx, (IObjectValue)laborCostTypeInfo);
        laborCostTypeInfo.setIsLeaf(true);
        if (parent == null || parent.getId().equals((Object)laborCostTypeInfo.getId())) {
            laborCostTypeInfo.setLevel(1);
            laborCostTypeInfo.setLongNumber(laborCostTypeInfo.getNumber());
            this.checkLongNumberLen(ctx, laborCostTypeInfo);
            laborCostTypeInfo.setDisplayName(laborCostTypeInfo.getName());
        } else {
            laborCostTypeInfo.setLevel(parent.getLevel() + 1);
            laborCostTypeInfo.setLongNumber(parent.getLongNumber() + "!" + laborCostTypeInfo.getNumber());
            this.checkLongNumberLen(ctx, laborCostTypeInfo);
            this.LinkDisplayName((DataBaseInfo)parent, laborCostTypeInfo, null);
            this.limitDisplayNameLength(laborCostTypeInfo);
            this.LinkDisplayName((DataBaseInfo)parent, laborCostTypeInfo, locale_L1);
            this.limitDisplayNameLength(laborCostTypeInfo, locale_L1);
            this.LinkDisplayName((DataBaseInfo)parent, laborCostTypeInfo, localeChina);
            this.limitDisplayNameLength(laborCostTypeInfo, localeChina);
            this.LinkDisplayName((DataBaseInfo)parent, laborCostTypeInfo, locale_L3);
            this.limitDisplayNameLength(laborCostTypeInfo, locale_L3);
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (IObjectValue)parent);
            }
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)laborCostTypeInfo);
        return pk;
    }

    private LaborCostTypeInfo getFullParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LaborCostTypeInfo treeBaseInfo = (LaborCostTypeInfo)model;
        LaborCostTypeInfo parent = treeBaseInfo.getParent();
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            return null;
        }
        parent = this.lazyLoad(ctx, (IObjectValue)parent);
        treeBaseInfo.setParent(parent);
        return parent;
    }

    private LaborCostTypeInfo lazyLoad(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LaborCostTypeInfo treeBaseInfo = (LaborCostTypeInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        LaborCostTypeInfo result = (LaborCostTypeInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()), selector);
        return result;
    }

    private void checkLongNumberLen(Context ctx, LaborCostTypeInfo info) throws EASBizException, BOSException {
        String propertyAlias = null;
        int maxLen = 0;
        propertyAlias = this.getPropertyAlias(ctx, (CoreBaseInfo)info, "longNumber", ctx.getOriginLocale());
        int len = null == info.getLongNumber() ? -1 : info.getLongNumber().length();
        if (len > (maxLen = this.getLongNumberLen(ctx, info))) {
            throw new TreeBaseException(TreeBaseException.CHECKLONGNUMBERLEN, new Object[]{propertyAlias, String.valueOf(maxLen)});
        }
    }

    private String getPropertyAlias(Context ctx, CoreBaseInfo info, String propertyName, Locale locale) {
        String alias = null;
        PropertyInfo property = this.getProperty(ctx, info, propertyName);
        if (property != null) {
            alias = property.getAlias(locale);
        }
        return alias;
    }

    private PropertyInfo getProperty(Context ctx, CoreBaseInfo info, String propertyName) {
        EntityObjectInfo entity = this.getBOSEntity(ctx, info);
        PropertyInfo property = null;
        property = entity.getPropertyByNameRuntime(propertyName);
        return property;
    }

    protected int getLongNumberLen(Context ctx, LaborCostTypeInfo info) throws EASBizException, BOSException {
        int maxLen = 0;
        String longNumberParam = null;
        longNumberParam = ParamManager.getParamValue((Context)ctx, null, (String)"TreeLongNumberlen");
        if (!StringUtils.isEmpty((String)longNumberParam)) {
            maxLen = Integer.parseInt(longNumberParam);
        }
        return maxLen;
    }

    private void limitDisplayNameLength(LaborCostTypeInfo tree, Locale locale) {
        String displayName = tree.getDisplayName(locale);
        String[] displayNameVar = StringUtils.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1 && displayName.length() > this.getDisplayNameLength()) {
            int len = displayName.indexOf("_");
            displayName = displayName.substring(len + 1);
            tree.setDisplayName(displayName, locale);
            this.limitDisplayNameLength(tree, locale);
        }
    }

    protected int getDisplayNameLength() {
        return 80;
    }

    private void LinkDisplayName(DataBaseInfo parent, LaborCostTypeInfo info, Locale locale) {
        String disPlayName = null;
        String parentDisplayName = parent.getDisplayName(locale);
        disPlayName = parentDisplayName != null ? parentDisplayName + "_" + info.getName(locale) : info.getName(locale);
        info.setDisplayName(disPlayName, locale);
    }

    private void limitDisplayNameLength(LaborCostTypeInfo laborCostTypeInfo) {
        String displayName = laborCostTypeInfo.getDisplayName();
        String[] displayNameVar = StringUtils.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1 && displayName.length() > this.getDisplayNameLength()) {
            int len = displayName.indexOf("_");
            displayName = displayName.substring(len + 1);
            laborCostTypeInfo.setDisplayName(displayName);
            this.limitDisplayNameLength(laborCostTypeInfo);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LaborCostTypeInfo treeBaseInfo = (LaborCostTypeInfo)model;
        DataBaseInfo oldDataBaseInfo = this.getDataBaseInfo(ctx, pk);
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        LaborCostTypeInfo oldInfo = (LaborCostTypeInfo)this._getValue(ctx, pk);
        String oldDisplayName = oldInfo.getDisplayName();
        String oldDisplayName_L1 = oldInfo.getDisplayName(locale_L1);
        String oldDisplayName_L2 = oldInfo.getDisplayName(localeChina);
        String oldDisplayName_L3 = oldInfo.getDisplayName(locale_L3);
        String oldLongNumber = oldInfo.getLongNumber();
        if (treeBaseInfo.getDisplayName() == null) {
            treeBaseInfo.setDisplayName(oldDisplayName);
            treeBaseInfo.setDisplayName(oldDisplayName_L1, locale_L1);
            treeBaseInfo.setDisplayName(oldDisplayName_L2, localeChina);
            treeBaseInfo.setDisplayName(oldDisplayName_L3, locale_L3);
        }
        if (treeBaseInfo.getLongNumber() == null) {
            treeBaseInfo.setLongNumber(oldLongNumber);
            this.checkLongNumberLen(ctx, treeBaseInfo);
        }
        if (oldLongNumber == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        if (treeBaseInfo.containsKey("number") && oldLongNumber != null) {
            String longNumber = "";
            String number = "";
            longNumber = oldLongNumber;
            number = treeBaseInfo.getNumber();
            LaborCostTypeInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
            if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
                treeBaseInfo.setLongNumber(treeBaseInfo.getNumber());
                this.checkLongNumberLen(ctx, treeBaseInfo);
                treeBaseInfo.setDisplayName(treeBaseInfo.getName());
                treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L1), locale_L1);
                treeBaseInfo.setDisplayName(treeBaseInfo.getName(localeChina), localeChina);
                treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L3), locale_L3);
            } else {
                treeBaseInfo.setLongNumber(parent.getLongNumber() + "!" + treeBaseInfo.getNumber());
                this.checkLongNumberLen(ctx, treeBaseInfo);
                this.LinkDisplayName((DataBaseInfo)parent, treeBaseInfo, null);
                this.LinkDisplayName((DataBaseInfo)parent, treeBaseInfo, locale_L1);
                this.LinkDisplayName((DataBaseInfo)parent, treeBaseInfo, localeChina);
                this.LinkDisplayName((DataBaseInfo)parent, treeBaseInfo, locale_L3);
            }
            this.checkLNForTree(ctx, treeBaseInfo);
            int level = treeBaseInfo.getLongNumber().split("!").length;
            treeBaseInfo.setLevel(level);
            if (longNumber != null && !longNumber.equals(treeBaseInfo.getLongNumber())) {
                this.updateChildrenByNumberUpdated(ctx, (IObjectValue)treeBaseInfo, longNumber);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName, longNumber);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L1, longNumber, locale_L1);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L2, longNumber, localeChina);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L3, longNumber, locale_L3);
            }
            if (!(longNumber = treeBaseInfo.getLongNumber()).substring(longNumber.lastIndexOf("!") + 1).equals(number)) {
                this._checkNumberDup(ctx, (IObjectValue)treeBaseInfo);
                treeBaseInfo.setLongNumber(longNumber.substring(0, longNumber.lastIndexOf("!") + 1) + treeBaseInfo.getNumber());
                this.checkLongNumberLen(ctx, treeBaseInfo);
                this.updateChildrenByNumberUpdated(ctx, (IObjectValue)treeBaseInfo, longNumber);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName, longNumber);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L1, longNumber, locale_L1);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L2, longNumber, localeChina);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L3, longNumber, locale_L3);
            }
            if (oldDisplayName != null && !oldDisplayName.equals(treeBaseInfo.getDisplayName())) {
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName, longNumber);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L1, longNumber, locale_L1);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L2, longNumber, localeChina);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L3, longNumber, locale_L3);
            }
        }
        this.limitDisplayNameLength(treeBaseInfo);
        this.limitDisplayNameLength(treeBaseInfo, locale_L1);
        this.limitDisplayNameLength(treeBaseInfo, localeChina);
        this.limitDisplayNameLength(treeBaseInfo, locale_L3);
        super._update(ctx, pk, (IObjectValue)treeBaseInfo);
        this.syncParentIsLeafStatus(ctx, (DataBaseInfo)oldDataBaseInfo.get("parent"), (DataBaseInfo)treeBaseInfo.getParent());
    }

    private void syncParentIsLeafStatus(Context ctx, DataBaseInfo oldParentInfo, DataBaseInfo parentInfo) throws EASBizException, BOSException {
        if (oldParentInfo != null && oldParentInfo.getId() != null && parentInfo != null && parentInfo.getId() != null && oldParentInfo.getId().toString().equals(parentInfo.getId().toString())) {
            return;
        }
        if (oldParentInfo != null && oldParentInfo.getId() != null) {
            this.updateIsLeafState(ctx, oldParentInfo.getId().toString());
        }
        if (parentInfo != null && parentInfo.getId() != null) {
            this.updateIsLeafState(ctx, parentInfo.getId().toString());
        }
    }

    private void updateIsLeafState(Context ctx, String id) throws BOSException, EASBizException {
        boolean isLeaf = this.isLeaf(ctx, id);
        if (isLeaf) {
            this.updateIsLeafState(ctx, id, true);
        } else {
            this.updateIsLeafState(ctx, id, false);
        }
    }

    private void updateIsLeafState(Context ctx, String id, boolean isLeaf) throws EASBizException, BOSException {
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(id))) {
            LaborCostTypeInfo baseInfo = this.getLaborCostTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
            baseInfo.setIsLeaf(isLeaf);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isLeaf"));
            this.updatePartial(ctx, (CoreBaseInfo)baseInfo, selector);
        }
    }

    private boolean isLeaf(Context ctx, String id) throws BOSException {
        boolean isLeaf = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id));
        viewInfo.setFilter(filter);
        DataBaseCollection coll = this.getDataBaseCollection(ctx, viewInfo);
        isLeaf = coll.size() <= 0;
        return isLeaf;
    }

    protected void checkLNForTree(Context ctx, LaborCostTypeInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
        FilterInfo lNfilter = new FilterInfo();
        lNfilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber()));
        lNfilter.getFilterItems().add(new FilterItemInfo("id", (Object)treeBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        lNfilter.setMaskString("#0 AND #1");
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            lNfilter.mergeFilter(filterCU, "AND");
        }
        if (this.exists(ctx, lNfilter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeBaseInfo.getNumber()});
        }
    }

    private void updateChildrenByNumberUpdated(Context ctx, IObjectValue model, String oldLongNumber) throws BOSException, EASBizException {
        LaborCostTypeInfo treeBaseInfo = (LaborCostTypeInfo)model;
        String longNumber = treeBaseInfo.getLongNumber();
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(oldLongNumber + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            filter.mergeFilter(filterCU, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        DataBaseCollection collection = this.getDataBaseCollection(ctx, view);
        LaborCostTypeInfo temp2 = null;
        for (LaborCostTypeInfo temp2 : collection) {
            String temps = StringUtility.castRegular((String)oldLongNumber);
            temp2.setLongNumber(temp2.getLongNumber().replaceFirst(temps, longNumber));
            this.checkLongNumberLen(ctx, temp2);
            int level = temp2.getLongNumber().split("!").length;
            temp2.setLevel(level);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp2.getId()), (IObjectValue)temp2);
        }
    }

    private void updateChildrenByNameUpdated(Context ctx, IObjectValue model, String oldDisplayName, String oldLongNumber) throws BOSException, EASBizException {
        LaborCostTypeInfo treeBaseInfo = (LaborCostTypeInfo)model;
        String displayName = treeBaseInfo.getDisplayName();
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            view.getFilter().mergeFilter(filterCU, "AND");
        }
        DataBaseCollection collection = this.getDataBaseCollection(ctx, view);
        LaborCostTypeInfo temp2 = null;
        for (LaborCostTypeInfo temp2 : collection) {
            if (oldDisplayName != null) {
                if (temp2.getDisplayName() != null) {
                    if (temp2.getDisplayName().indexOf(oldDisplayName) > 1) {
                        return;
                    }
                    String temps = StringUtility.castRegular((String)oldDisplayName);
                    temp2.setDisplayName(temp2.getDisplayName().replaceFirst(temps + "_", displayName + "_"));
                } else {
                    temp2.setDisplayName(displayName);
                }
            } else {
                temp2.setDisplayName(displayName);
            }
            this.limitDisplayNameLength(temp2);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp2.getId()), (IObjectValue)temp2);
        }
    }

    private void updateChildrenByNameUpdated(Context ctx, IObjectValue model, String oldDisplayName, String oldLongNumber, Locale locale) throws BOSException, EASBizException {
        LaborCostTypeInfo treeBaseInfo = (LaborCostTypeInfo)model;
        String displayName = treeBaseInfo.getDisplayName(locale);
        if (displayName == null) {
            return;
        }
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            view.getFilter().mergeFilter(filterCU, "AND");
        }
        DataBaseCollection collection = this.getDataBaseCollection(ctx, view);
        LaborCostTypeInfo temp2 = null;
        for (LaborCostTypeInfo temp2 : collection) {
            if (oldDisplayName != null) {
                if (temp2.getDisplayName(locale) != null) {
                    if (temp2.getDisplayName(locale).indexOf(oldDisplayName) > 1) {
                        return;
                    }
                    String temps = StringUtility.castRegular((String)oldDisplayName);
                    if (!displayName.startsWith(temps)) {
                        temp2.setDisplayName(temp2.getDisplayName(locale).replaceFirst(temps + "_", displayName + "_"), locale);
                    }
                } else {
                    temp2.setDisplayName(displayName, locale);
                }
            } else {
                temp2.setDisplayName(displayName, locale);
            }
            this.limitDisplayNameLength(temp2);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp2.getId()), (IObjectValue)temp2);
        }
    }
}

