/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.CmpAgentPayBillFactory;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpBillStatusXKQJEnum;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.XKQJAgentPayBillInfo;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XKQJAgentPayBillSubmitTask {
    private static final Logger logger = LoggerFactory.getLogger(XKQJAgentPayBillSubmitTask.class);
    private Context ctx;
    private List<String> idList;
    private final List<XKQJAgentPayBillInfo> xkqjBillList;

    public XKQJAgentPayBillSubmitTask(Context ctx, List<String> idList, List<XKQJAgentPayBillInfo> xkqjBillList) {
        this.ctx = ctx;
        this.idList = idList;
        this.xkqjBillList = xkqjBillList;
    }

    public void execute() {
        try {
            this.beforeSubmitBill(this.ctx, this.idList);
            this.doSubmitBill(this.ctx, this.xkqjBillList);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void beforeSubmitBill(Context ctx, List<String> idList) throws BOSException {
        this.updateBillStateXKQJ(ctx, idList, CmpBillStatusXKQJEnum.SUBMITING);
    }

    protected void doSubmitBill(Context ctx, List<XKQJAgentPayBillInfo> xkqjBillList) throws BOSException, EASBizException {
        HashMap param = Maps.newHashMap();
        for (XKQJAgentPayBillInfo dto : xkqjBillList) {
            param.put("billInfo", dto);
            CmpAgentPayBillFactory.getLocalInstance(ctx).submitXKQJ(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBillStateXKQJ(Context ctx, List<String> idList, CmpBillStatusXKQJEnum stateXKQJ) throws BOSException {
        CmpInSql<String> inSql = CmpInSqlFactory.getInstance();
        try {
            String sql = "update T_HR_SCmpAgentPayBill set FStateXKQJ = " + stateXKQJ.getValue() + " where fid in " + inSql.createInSqlBaseOnFId(ctx, idList);
            DbUtil.execute((Context)ctx, (String)sql);
        }
        finally {
            inSql.release(ctx);
        }
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public List<String> getIdList() {
        return this.idList;
    }

    public void setIdList(List<String> idList) {
        this.idList = idList;
    }
}

