/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.AbstractCmpBudgetSchemeControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillFactory;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CmpBudgetSchemeControllerBean
extends AbstractCmpBudgetSchemeControllerBean {
    private static final Logger logger = Logger.getLogger(CmpBudgetSchemeControllerBean.class);

    protected void _enable(Context ctx, String id) throws BOSException {
        super._enable(ctx, id);
        try {
            CmpBudgetSchemeCollection budgetSchemeCollection = this.getCmpBudgetSchemeCollection(ctx, " where id = '" + id + "'");
            CmpBudgetSchemeInfo schemeInfo = budgetSchemeCollection.get(0);
            schemeInfo.setEnableDate(new Timestamp(System.currentTimeMillis()));
            this.update(ctx, (IObjectPK)new ObjectUuidPK(id), schemeInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    protected void _disable(Context ctx, String id) throws BOSException {
        super._disable(ctx, id);
        try {
            CmpBudgetSchemeCollection budgetSchemeCollection = this.getCmpBudgetSchemeCollection(ctx, " where id = '" + id + "'");
            CmpBudgetSchemeInfo schemeInfo = budgetSchemeCollection.get(0);
            schemeInfo.setDisableDate(new Timestamp(System.currentTimeMillis()));
            this.update(ctx, (IObjectPK)new ObjectUuidPK(id), schemeInfo);
            this.updateBudgetManageState(ctx, id);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    protected void updateBudgetManageState(Context ctx, String id) throws BOSException {
        String sql = "update T_HR_SBudgetManage set fState = 2 where fState = 1 and FBudgetSchemeID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            this.checkBeforeDelete(ctx, pk);
            super._delete(ctx, pk);
        }
    }

    protected void checkBeforeDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CmpBudgetSchemeInfo budgetSchemeInfo;
        String schemeId = pk.toString();
        String oql = "select id,name,state,isPreset,budgetYear where id = '" + schemeId + "'";
        CmpBudgetSchemeCollection cmpBudgetSchemeCollection = this.getCmpBudgetSchemeCollection(ctx, oql);
        if (!cmpBudgetSchemeCollection.isEmpty() && (budgetSchemeInfo = cmpBudgetSchemeCollection.get(0)) != null) {
            if (budgetSchemeInfo.getIsPreset() != null && 1 == budgetSchemeInfo.getIsPreset().getValue()) {
                String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"CANNOT_DELELE"), budgetSchemeInfo.getName(), ctx.getLocale());
                throw new EASBizException(new NumericExceptionSubItem("022", msg));
            }
            StateEnum state = budgetSchemeInfo.getState();
            if (state != null && 2 != state.getValue()) {
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label9", (Locale)ctx.getLocale())));
            }
            String sql = "select top 1 FID FROM T_HR_SBudgetManage where FBudgetYear = " + budgetSchemeInfo.getBudgetYear() + " and FBudgetSchemeID = '" + schemeId + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                boolean next = rowSet.next();
                if (next) {
                    throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label10", (Locale)ctx.getLocale())));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            oql = "select id where budgetScheme.id = '" + schemeId + "'";
            BudgetAdjustBillCollection budgetAdjustBillCollection = BudgetAdjustBillFactory.getLocalInstance(ctx).getBudgetAdjustBillCollection(oql);
            if (!budgetAdjustBillCollection.isEmpty()) {
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label60", (Locale)ctx.getLocale())));
            }
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    protected IObjectPK saveOrUpdate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ObjectUuidPK idPk;
        CmpBudgetSchemeInfo info = (CmpBudgetSchemeInfo)model;
        if (info.getId() == null || StringUtils.isEmpty((String)info.getId().toString())) {
            BudgetTemplateInfo template = info.getTemplate();
            if (template == null || template.getId() == null) {
                String label56 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label56", (Locale)ctx.getLocale());
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{label56});
            }
            this.addInfoBaseContent(ctx, info);
            idPk = super.innerAddnew(ctx, (IObjectValue)info);
            info.setId(BOSUuid.read((String)idPk.toString()));
        } else {
            this.updateSubDate(ctx, model);
            idPk = new ObjectUuidPK(info.getId());
            UserInfo userInfo = this.getUserInfo(ctx);
            Timestamp createTimeStamp = this.getTime();
            info.setLastUpdateUser(userInfo);
            info.setLastUpdateTime(createTimeStamp);
            super.innerUpdate(ctx, (IObjectPK)idPk, (IObjectValue)info);
        }
        return idPk;
    }

    protected void updateSubDate(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CmpBudgetSchemeInfo schemeInfo = (CmpBudgetSchemeInfo)model;
        java.util.Date effectDateNew = schemeInfo.getEffectDate();
        if (null == effectDateNew) {
            return;
        }
        String id = schemeInfo.getId().toString();
        CmpBudgetSchemeInfo cmpBudgetSchemeInfoOld = CmpBudgetSchemeFactory.getLocalInstance(ctx).getCmpBudgetSchemeInfo("select id,effectDate,budgetPeriod,budgetYear where id ='" + id + "'");
        java.util.Date effectDateOld = cmpBudgetSchemeInfoOld.getEffectDate();
        if (null == effectDateOld) {
            return;
        }
        if (effectDateNew.compareTo(effectDateOld) == 0) {
            return;
        }
        BudgetPeriodEnum budgetPeriod = cmpBudgetSchemeInfoOld.getBudgetPeriod();
        if (BudgetPeriodEnum.YEAR == budgetPeriod) {
            return;
        }
        int budgetYear = cmpBudgetSchemeInfoOld.getBudgetYear();
        int loopTime = 0;
        int addMonth = 0;
        String periodPrefix = "";
        switch (budgetPeriod.getValue()) {
            case 1: {
                loopTime = 2;
                periodPrefix = "H";
                addMonth = 6;
                break;
            }
            case 2: {
                loopTime = 4;
                periodPrefix = "Q";
                addMonth = 3;
                break;
            }
            case 3: {
                loopTime = 12;
                periodPrefix = "M";
                addMonth = 1;
                break;
            }
        }
        String idRange = "select fid from T_HR_SBudgetManage where FBudgetSchemeID = ?";
        String updateSql = " update T_HR_SSubBudgetQuery set FEffectDate = ?,FExpiryDate = ? where FBudgetManageID in (" + idRange + ") and FPeriod = ?";
        Calendar calendar = Calendar.getInstance();
        java.util.Date tempEffectDate = effectDateNew;
        java.util.Date expiryDate = schemeInfo.getExpiryDate();
        for (int i = 1; i <= loopTime; ++i) {
            calendar.setTime(tempEffectDate);
            calendar.add(2, addMonth);
            calendar.add(5, -1);
            Date effctDateSql = CmpDateUtil.toSqlDate(tempEffectDate);
            Date expiryDateSql = i == loopTime ? CmpDateUtil.toSqlDate(expiryDate) : CmpDateUtil.toSqlDate(calendar.getTime());
            String periodCondition = budgetYear + periodPrefix + (i < 10 ? "0" + i : i + "");
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{effctDateSql, expiryDateSql, id, periodCondition});
            calendar.add(5, 1);
            tempEffectDate = calendar.getTime();
        }
    }

    private void addInfoBaseContent(Context ctx, CmpBudgetSchemeInfo info) {
        if (info.getCU() == null || info.getCU().getId() == null) {
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
            info.setCU(cu);
        }
        UserInfo userInfo = this.getUserInfo(ctx);
        if (info.getCreator() == null) {
            info.setCreator(userInfo);
        }
        Timestamp createTimeStamp = this.getTime();
        if (info.getCreateTime() == null) {
            info.setCreateTime(createTimeStamp);
        }
        if (info.getLastUpdateUser() == null) {
            info.setLastUpdateUser(userInfo);
        }
        info.setLastUpdateTime(createTimeStamp);
    }

    private UserInfo getUserInfo(Context ctx) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    private Timestamp getTime() {
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        return new Timestamp(d.getTime().getTime());
    }
}

