/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate.submitPeriod;

import com.kingdee.eas.hr.compensation.util.CmpDateUtils;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodChangeSourceEnum;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodInfo;
import com.kingdee.shr.compensation.app.integrate.submitPeriod.AbstractSubmitPeriodGenetor;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import java.util.Date;

public class SubmitPeriodHalfMonthGenetor
extends AbstractSubmitPeriodGenetor {
    private static int MONTH_COUNT_OF_MONTH = 1;
    private static int MONTH_LENGTH = 12;

    @Override
    public SubmitPeriodDetailCollection generate(Date baseStartDate, Date baseEndDate, SubmitPeriodInfo submitPeriod, SubmitPeriodChangeSourceEnum changeSource) {
        int monthMaxDays;
        SubmitPeriodDetailCollection firstPeriodDetailCols = new SubmitPeriodDetailCollection();
        firstPeriodDetailCols = super.generate(baseStartDate, baseEndDate, submitPeriod, changeSource);
        int monthLength = CmpDateUtils.subTwoDate((Date)baseEndDate, (Date)baseStartDate) + 1;
        if (monthLength < (monthMaxDays = CmpDateUtil.getDay(CmpDateUtil.getMonthEndDate(baseStartDate)))) {
            SubmitPeriodDetailInfo firstDetail = firstPeriodDetailCols.get(0);
            Date nextPeriodStartDate = CmpDateUtil.getAddDate(firstDetail.getEndDate(), 1);
            Date nextPeriodEndDate = CmpDateUtil.getAddDate(CmpDateUtil.getAddMonth(firstDetail.getStartDate(), 1), -1);
            if (submitPeriod.getEntry() != null && submitPeriod.getEntry().size() > 0) {
                SubmitPeriodDetailCollection originSubmitPeriodDetailCols = submitPeriod.getEntry();
                originSubmitPeriodDetailCols.sort("startDate");
                Date tailEndDate = this.getTailEndDateByAsc(originSubmitPeriodDetailCols);
                Date previoisPeriodStartDate = CmpDateUtil.getAddMonth(nextPeriodStartDate, -1);
                if (previoisPeriodStartDate.compareTo(tailEndDate) > 0) {
                    nextPeriodStartDate = previoisPeriodStartDate;
                    nextPeriodEndDate = CmpDateUtil.getAddDate(firstDetail.getStartDate(), -1);
                }
            }
            firstPeriodDetailCols.addCollection(this.generate(submitPeriod, nextPeriodStartDate, nextPeriodEndDate, false, false, changeSource));
            firstPeriodDetailCols.sort("startDate");
            this.checkAndCorrectOverlapPeriod(firstPeriodDetailCols);
        }
        return firstPeriodDetailCols;
    }

    private void checkAndCorrectOverlapPeriod(SubmitPeriodDetailCollection cos) {
        if (cos == null || cos.size() == 0) {
            return;
        }
        SubmitPeriodDetailInfo previousDetail = cos.get(0);
        SubmitPeriodDetailInfo currentDetail = null;
        for (int i = 1; i < cos.size(); ++i) {
            currentDetail = cos.get(i);
            if (currentDetail.getStartDate().compareTo(previousDetail.getEndDate()) <= 0) {
                previousDetail.setEndDate(CmpDateUtil.getAddDate(currentDetail.getStartDate(), -1));
            }
            if (CmpDateUtils.subTwoDate((Date)currentDetail.getStartDate(), (Date)previousDetail.getEndDate()) > 1) {
                previousDetail.setEndDate(CmpDateUtil.getAddDate(currentDetail.getStartDate(), -1));
            }
            previousDetail = currentDetail;
        }
        if (currentDetail != null) {
            SubmitPeriodDetailInfo secondLastDetail = cos.get(cos.size() - 2);
            currentDetail.setEndDate(CmpDateUtil.getAddDate(CmpDateUtil.getAddMonth(secondLastDetail.getStartDate(), 1), -1));
        }
    }

    @Override
    protected int getPeriodInterval() {
        return MONTH_COUNT_OF_MONTH;
    }

    @Override
    protected int getPeriodLength() {
        return MONTH_LENGTH;
    }
}

