/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.payPush;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.DirectSenderAgent;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.shr.base.syssetting.CloudHubMessageFacadeFactory;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.base.syssetting.util.CloudHubUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalState;
import com.kingdee.shr.compensation.app.payPush.PayslipPushTotalCollection;
import com.kingdee.shr.compensation.app.payPush.PayslipPushTotalFactory;
import com.kingdee.shr.compensation.app.payPush.PayslipPushTotalInfo;
import com.kingdee.shr.compensation.app.paySet.PaysetSchemeCollection;
import com.kingdee.shr.compensation.app.paySet.PaysetSchemeFactory;
import com.kingdee.shr.compensation.app.paySet.PaysetSchemeInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayslipPushUtils {
    private static Logger logger = Logger.getLogger(PayslipPushUtils.class);
    public static final String VISIT_PATH = "shr/dynamic.do?uipk=shr.compensation.payTotal&serviceId=R6NOgMN2StKGCBqMFib2i%2FI9KRA%3D&inFrame=true";
    private static final String SHR_WEB_WAR_NAME = "shr_web.war";
    private static final String EAS_EAR_ROOT = SHRSyssettingUtil.getEasWebWarPath();
    private static final String PROPERTIESPATH = EAS_EAR_ROOT + File.separator + "shr_web.war" + File.separator + "addon/compensation/web/resource";
    private static final String USER_PAY_PROPERTIES_PATH = PROPERTIESPATH + File.separator + "CloudHubMessageUserPayConfig.properties";
    private static final String PROPERTIES_URL = "userPayOptimize.cloudHub.url";
    private static final String PUBACC_NAME = "pubaccName";
    private static final String APPID = "appId";
    private static final String ISPRIVATE = "isPrivate";
    private static final String EID = "eid";
    private static long LASTMODIFIED_TIME;
    private static Properties instance;

    private static File getPropertiesFile() {
        String fileName = USER_PAY_PROPERTIES_PATH;
        return new File(fileName);
    }

    public static String getProperty(String key) {
        if (instance != null) {
            return instance.getProperty(key);
        }
        return null;
    }

    public static void pushForPerson(Context ctx, CalState calState, String calSchemeId, String filter) {
        if (StringUtils.isEmpty((String)calSchemeId) || StringUtils.isEmpty((String)filter)) {
            return;
        }
        try {
            Map<String, String> sentMsgMap;
            String status;
            CalSchemeInfo calScheme = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeInfo((IObjectPK)new ObjectUuidPK(calSchemeId));
            if (calScheme == null || calScheme.getHrOrgUnit() == null || calScheme.getHrOrgUnit().getId() == null) {
                return;
            }
            PayslipPushUtils.addPersonPush(ctx, calSchemeId, calScheme.getPeriodYear(), calScheme.getPeriodMonth(), calScheme.getCalTime());
            boolean isPush = false;
            int showPeriodVal = 0;
            boolean isAutoConfirm = false;
            Double autoConfirmDate = null;
            PaysetSchemeCollection calSchemepaySetColl = PaysetSchemeFactory.getLocalInstance(ctx).getPaysetSchemeCollection("select push,showPeriod,autoConfirm,autoConfirmDay where calScheme.id = '" + calSchemeId + "' and state = 1");
            if (calSchemepaySetColl.isEmpty()) {
                logger.error((Object)"No set calScheme paySchemeSet");
                String hrOrgId = calScheme.getHrOrgUnit() == null || calScheme.getHrOrgUnit().getId() == null ? "" : calScheme.getHrOrgUnit().getId().toString();
                String orgMappingSql = " select paySet.FPush isPush,paySet.FShowPeriod showPeriod,paySet.FAutoConfirm autoConfirm,paySet.FAutoConfirmDay autoConfirmDay from T_HR_SOrgPaysetMapping orgMapping left join T_HR_SPaysetScheme paySet on paySet.fid = orgMapping.fpaysetid where orgMapping.fhrorgid = ?";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)orgMappingSql, (Object[])new Object[]{hrOrgId});
                while (rowSet.next()) {
                    isPush = rowSet.getBoolean("ispush");
                    showPeriodVal = rowSet.getInt("showPeriod");
                    isAutoConfirm = rowSet.getBoolean("autoConfirm");
                    autoConfirmDate = rowSet.getDouble("autoConfirmDay");
                }
            } else {
                PaysetSchemeInfo paySet = calSchemepaySetColl.get(0);
                isPush = paySet.isPush();
                showPeriodVal = paySet.getShowPeriod().getValue();
                isAutoConfirm = paySet.isAutoConfirm();
                autoConfirmDate = paySet.getAutoConfirmDay();
            }
            if (!isPush) {
                logger.error((Object)"Auto push not enabled");
                return;
            }
            if (calState.getValue() != showPeriodVal) {
                logger.error((Object)"The push node of salary slip configuration is inconsistent with the current node");
                return;
            }
            String messageText = PayslipPushUtils.getPushTemplateConfig(ctx, "0");
            if (StringUtils.isEmpty((String)messageText)) {
                logger.error((Object)"The push message template is empty and cannot be pushed. Please set the push message first!");
                return;
            }
            String userFilter = "select calTab.FpersonId from T_HR_SCmpCalTable calTab inner join T_HR_SPayslipPush payPush on payPush.fcaltableid=calTab.fid where (" + filter.toString() + ") and payPush.FPushState=0 and payPush.FEmpConfirmState=0";
            UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id in (" + userFilter + ")");
            if (userColl == null || userColl.isEmpty()) {
                logger.error((Object)"No one needs to push");
                return;
            }
            StringBuilder easUserFilter = new StringBuilder();
            easUserFilter.append("select p.FPersonId  from t_pm_easxtusermap p ").append(" inner join t_bd_person n on n.fid = p.FPersonId").append(" where exists (select 1 from T_HR_SCmpCalTable calTab where (").append(filter).append(") and calTab.fpersonId = p.FPersonId )");
            UserCollection userCollNew = new UserCollection();
            String notInEasxtuserMsg = PayslipPushUtils.getNotInEasxtuserMsg(ctx, userColl, userCollNew, easUserFilter.toString());
            if (!StringUtils.isEmpty((String)notInEasxtuserMsg)) {
                logger.error((Object)("Unbound CloudHub: " + notInEasxtuserMsg));
            }
            if (!userCollNew.isEmpty() && "notSet".equalsIgnoreCase(status = (sentMsgMap = PayslipPushUtils.sentMessageForSubscription(ctx, messageText, userColl)).get("status"))) {
                logger.error((Object)("Failed to push message to official account: " + sentMsgMap.get("message")));
            }
            StringBuilder receiverIds = new StringBuilder();
            for (int i = 0; i < userColl.size(); ++i) {
                UserInfo user = userColl.get(i);
                String userId = user.getId() == null ? "" : user.getId().toString();
                receiverIds.append(userId).append(";");
            }
            receiverIds.setLength(receiverIds.length() - 1);
            PayslipPushUtils.sendMessage(ctx, messageText, messageText, VISIT_PATH, receiverIds.toString());
            Date sysConfirmDate = null;
            if (autoConfirmDate != null) {
                sysConfirmDate = PayslipPushUtils.getSysConfirmDate(new Date(), autoConfirmDate);
            }
            String calTableFilter = "select calTab.fid fid from T_HR_SCmpCalTable calTab where " + filter;
            PayslipPushUtils.updatePushedState(ctx, calTableFilter, sysConfirmDate, isAutoConfirm, false, false);
        }
        catch (BOSException | EASBizException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public static void addPersonPushByTotal(Context ctx, Set<String> payPushTotalIds) throws BOSException, EASBizException {
        if (payPushTotalIds == null || payPushTotalIds.isEmpty()) {
            return;
        }
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String idFilterSql = cmpInSql.createInSql(ctx, payPushTotalIds, "T_HR_SPayslipPushTotal", "fid");
        StringBuilder inserSql = new StringBuilder();
        inserSql.append("insert into T_HR_SPayslipPush (FID,FPushState, FEmpConfirmState,FIsAutoConfirm,FCalTableID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FPayTotalID) ").append(" select newbosid('307A7F34'),0,0,0,calTable.fid,calTable.FCreatorID,now(),calTable.FLastUpdateUserID,now(), payTotal.fid").append(" from t_hr_scmpCalTable calTable ").append(" left join T_HR_SPayslipPushTotal payTotal on calTable.fcalSchemeId=payTotal.fcalSchemeId ").append(" and calTable.FPeriodYear=payTotal.FPeriodYear and calTable.FPeriodMonth=payTotal.FPeriodMonth").append(" and calTable.FCalTime=payTotal.FCalTime").append(" where payTotal.fid in ").append(idFilterSql).append(" and not exists (select 1 from T_HR_SPayslipPush payPush where payPush.fcalTableId=calTable.fid) ");
        DbUtil.execute((Context)ctx, (String)inserSql.toString());
    }

    public static void addPersonPush(Context ctx, String calSchemeId, Integer periodYear, Integer periodMonth, Integer calTime) throws BOSException, EASBizException {
        String oql = "select id where calScheme.id='" + calSchemeId + "' and periodYear=" + periodYear + " and periodMonth=" + periodMonth + " and calTime=" + calTime;
        PayslipPushTotalCollection toTalColl = PayslipPushTotalFactory.getLocalInstance(ctx).getPayslipPushTotalCollection(oql);
        String payTotalId = "";
        boolean isAddNew = false;
        if (toTalColl == null || toTalColl.isEmpty()) {
            payTotalId = PayslipPushUtils.addNewPayTotalInfo(ctx, calSchemeId, periodYear, periodMonth, calTime);
            isAddNew = true;
        } else {
            String string = payTotalId = toTalColl.get(0).getId() == null ? "" : toTalColl.get(0).getId().toString();
        }
        if (isAddNew) {
            StringBuilder selPayTotalIdSql = new StringBuilder();
            selPayTotalIdSql.append("select payTotal.fid payTotalId from T_HR_SPayslipPushTotal payTotal").append(" inner join T_HR_SPayslipPush payPush on payPush.FPayTotalID = payTotal.fid").append(" inner join t_hr_scmpCalTable calTab on payPush.FCalTableID = calTab.fid").append(" where calTab.FCalSchemeId = ? and calTab.FPeriodYear = ? and calTab.FPeriodMonth = ? and calTab.FCalTime = ?");
            Object[] selParams = new Object[]{calSchemeId, periodYear, periodMonth, calTime};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selPayTotalIdSql.toString(), (Object[])selParams);
            try {
                if (rowSet.next()) {
                    String oldPayTotalId = rowSet.getString("payTotalId");
                    StringBuilder delPushDetailSql = new StringBuilder();
                    delPushDetailSql.append("delete from T_HR_SPayslipPush where FPayTotalId = ?");
                    Object[] delPushParams = new Object[]{oldPayTotalId};
                    DbUtil.execute((Context)ctx, (String)delPushDetailSql.toString(), (Object[])delPushParams);
                    StringBuilder delPushTotalSql = new StringBuilder();
                    delPushTotalSql.append("delete from T_HR_SPayslipPushTotal ").append(" where fid = ? ");
                    Object[] delPushTotalParams = new Object[]{oldPayTotalId};
                    DbUtil.execute((Context)ctx, (String)delPushTotalSql.toString(), (Object[])delPushTotalParams);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        StringBuilder inserSql = new StringBuilder();
        inserSql.append("insert into T_HR_SPayslipPush (FID,FPushState, FEmpConfirmState,FIsAutoConfirm,FCalTableID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FPayTotalID) ").append(" select newbosid('307A7F34'),0,0,0,calTable.fid,calTable.FCreatorID,now(),calTable.FLastUpdateUserID,now(), ? ").append(" from t_hr_scmpCalTable calTable ").append(" where calTable.FCalSchemeId = ? and calTable.FPeriodYear= ? and calTable.FPeriodMonth= ? and calTable.FCalTime= ? ").append(" and not exists (select 1 from T_HR_SPayslipPush payPush where payPush.fcalTableId=calTable.fid) ");
        Object[] insertParam = new Object[]{payTotalId, calSchemeId, periodYear, periodMonth, calTime};
        DbUtil.execute((Context)ctx, (String)inserSql.toString(), (Object[])insertParam);
    }

    protected static String addNewPayTotalInfo(Context ctx, String calSchemeId, Integer periodYear, Integer periodMonth, Integer calTime) throws EASBizException, BOSException {
        Timestamp time = new Timestamp(new Date().getTime());
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)userId));
        CalSchemeInfo calScheme = new CalSchemeInfo();
        calScheme.setId(BOSUuid.read((String)calSchemeId));
        PayslipPushTotalInfo payTotal = new PayslipPushTotalInfo();
        payTotal.setCalScheme(calScheme);
        payTotal.setPeriodYear(periodYear);
        payTotal.setPeriodMonth(periodMonth);
        payTotal.setCalTime(calTime);
        payTotal.setCreator(user);
        payTotal.setCreateTime(time);
        payTotal.setLastUpdateUser(user);
        payTotal.setLastUpdateTime(time);
        IObjectPK totalId = PayslipPushTotalFactory.getLocalInstance(ctx).addnew(payTotal);
        return totalId.toString();
    }

    protected static Map<String, Object> getCloudHubProperty(String propertiesUrl, String propertiesAllPath) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        File file = new File(propertiesAllPath);
        if (file.exists() && file.lastModified() != LASTMODIFIED_TIME || PayslipPushUtils.getProperty(propertiesUrl) == null) {
            PayslipPushUtils.load(file);
        }
        boolean isPrivate = Boolean.parseBoolean(PayslipPushUtils.getProperty(ISPRIVATE));
        String pubaccName = PayslipPushUtils.getProperty(PUBACC_NAME);
        String appId = PayslipPushUtils.getProperty(APPID);
        String eid = PayslipPushUtils.getProperty(EID);
        String url = PayslipPushUtils.getProperty(PROPERTIES_URL);
        if (!StringUtils.isEmpty((String)appId) && !StringUtils.isEmpty((String)eid)) {
            url = MessageFormat.format(url, appId, eid);
        }
        map.put(ISPRIVATE, isPrivate);
        map.put(PUBACC_NAME, pubaccName);
        map.put(APPID, appId);
        map.put(EID, eid);
        map.put("url", url);
        return map;
    }

    private static void load(File file) {
        if (file.exists()) {
            try (FileReader fileReader = new FileReader(file);
                 BufferedReader bufferedReader = new BufferedReader(fileReader);){
                instance = new Properties();
                instance.load(bufferedReader);
                LASTMODIFIED_TIME = file.lastModified();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        logger.error((Object)("cann't find the config file " + file.getAbsolutePath()));
    }

    public static Map<String, Double> getConfirmDayByCalScheme(Context ctx, Set<String> calSchemeIdSet) throws BOSException {
        HashMap<String, Double> calSchemeMap = new HashMap<String, Double>();
        if (calSchemeIdSet == null || calSchemeIdSet.isEmpty()) {
            return calSchemeMap;
        }
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        try {
            String calSchemeInSql = cmpInSql.createInSqlBaseOnFId(ctx, calSchemeIdSet);
            PaysetSchemeCollection calSchemepaySetColl = PaysetSchemeFactory.getLocalInstance(ctx).getPaysetSchemeCollection("select autoConfirm,autoConfirmDay,calScheme.id where calScheme.id in " + calSchemeInSql + " and state = 1");
            if (!calSchemepaySetColl.isEmpty()) {
                for (int i = 0; i < calSchemepaySetColl.size(); ++i) {
                    PaysetSchemeInfo paysetInfo = calSchemepaySetColl.get(i);
                    if (paysetInfo.getCalScheme() == null || paysetInfo.getCalScheme().getId() == null) continue;
                    calSchemeIdSet.remove(paysetInfo.getCalScheme().getId().toString());
                    if (!paysetInfo.isAutoConfirm()) continue;
                    calSchemeMap.put(paysetInfo.getCalScheme().getId().toString(), paysetInfo.getAutoConfirmDay());
                }
            }
            if (calSchemeIdSet.isEmpty()) {
                HashMap<String, Double> i = calSchemeMap;
                return i;
            }
            String newCalSchemeInSql = cmpInSql.createInSqlBaseOnFId(ctx, calSchemeIdSet);
            String selectSql = "select calScheme.fid calSchemeId, payScheme.FAutoConfirmDay autoConfirmDay from T_HR_SCalScheme calScheme  inner join T_HR_SOrgPaysetMapping orgMapping on orgMapping.fhrorgid = calScheme.fhrOrgUnitId inner join T_HR_SPaysetScheme payScheme on payScheme.fid=orgMapping.fpaysetid  where calScheme.fid in " + newCalSchemeInSql + " and payScheme.FAutoConfirm =1";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            while (rowSet.next()) {
                String calSchemeId = rowSet.getString("calSchemeId");
                Double confirmDay = rowSet.getDouble("autoConfirmDay");
                calSchemeMap.put(calSchemeId, confirmDay);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            cmpInSql.release(ctx);
        }
        return calSchemeMap;
    }

    public static void updatePushedState(Context ctx, String calTableIdFilterSql, Date sysConfirmDate, boolean needConfirmDate, boolean needConfirmed, boolean needPushed) throws BOSException {
        if (StringUtils.isEmpty((String)calTableIdFilterSql) || needConfirmDate && sysConfirmDate == null) {
            return;
        }
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update T_HR_SPayslipPush set fpushState=").append(1).append(",").append(" FPushTime=now(),").append(" fempConfirmState=").append(0).append(",").append(" fisAutoConfirm = 0,").append(" fconfirmTime = null");
        if (needConfirmDate) {
            String nowDate = CmpDateUtil.toKSqlDate(sysConfirmDate);
            updateSql.append(",fsysAutoConfirmTime= ").append(nowDate);
        }
        updateSql.append(" where fcalTableId in (").append(calTableIdFilterSql).append(")");
        if (!needPushed) {
            updateSql.append(" and fpushState = ").append(0);
        }
        if (!needConfirmed) {
            updateSql.append(" and fempConfirmState = ").append(0);
        }
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    public static String getPushTemplateConfig(Context ctx, String pushConfigType) throws BOSException {
        String templateConfig = null;
        String language = ctx.getLocale().getLanguage();
        try {
            String sql = " select FTemplateContent_" + language + " templateContent from T_HR_SCommonPushConfig where FModuleType = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pushConfigType});
            while (rowSet.next()) {
                templateConfig = rowSet.getString("templateContent");
            }
        }
        catch (BOSException | SQLException e) {
            throw new BOSException(e.getMessage(), e);
        }
        return templateConfig;
    }

    public static Map<String, String> sentMessageForSubscription(Context ctx, String msgContent, UserCollection userColl) {
        HashMap<String, String> sentResult = new HashMap<String, String>();
        String msg = SHRServerResource.getString((String)"com.kingdee.shr.compensation.resource.PayslipPushResource", (String)"label7", (Locale)ctx.getLocale());
        String pushState = "success";
        if (userColl == null || userColl.isEmpty()) {
            msg = SHRServerResource.getString((String)"com.kingdee.shr.compensation.resource.PayslipPushResource", (String)"label6", (Locale)ctx.getLocale());
            logger.error((Object)"sentMessageForSubscription : notPerson");
            sentResult.put("status", pushState);
            sentResult.put("message", msg);
            return sentResult;
        }
        HttpResultVo result = null;
        Map<String, Object> propertyMap = PayslipPushUtils.getCloudHubProperty(USER_PAY_PROPERTIES_PATH, PROPERTIES_URL);
        String appId = (String)propertyMap.get(APPID);
        String pubaccName = (String)propertyMap.get(PUBACC_NAME);
        String url = (String)propertyMap.get("url");
        Boolean isPrivate = (Boolean)propertyMap.get(ISPRIVATE);
        try {
            String eid = CloudHubUtil.getIntegrationEid((Context)ctx);
            XTServiceConfig xtServiceConfig = XTServiceConfig.getInstance();
            xtServiceConfig.getPubEnabled(eid, pubaccName);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            msg = SHRServerResource.getString((String)"com.kingdee.shr.compensation.resource.PayslipPushResource", (String)"label5", (Locale)ctx.getLocale());
            sentResult.put("status", "fail");
            sentResult.put("message", msg);
            return sentResult;
        }
        try {
            result = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextLinkMessageToUser(msgContent, appId, url, userColl, pubaccName, isPrivate.booleanValue());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            msg = SHRServerResource.getString((String)"com.kingdee.shr.compensation.resource.PayslipPushResource", (String)"label5", (Locale)ctx.getLocale());
            if (e.getMessage().indexOf("Exception") == -1) {
                msg = e.getMessage();
            }
            sentResult.put("status", "fail");
            sentResult.put("message", msg);
            return sentResult;
        }
        int status = result.getStatus();
        if (status != 200) {
            pushState = "fail";
            msg = SHRServerResource.getString((String)"com.kingdee.shr.compensation.resource.PayslipPushResource", (String)"label4", (Locale)ctx.getLocale()) + result.getData();
        }
        sentResult.put("status", pushState);
        sentResult.put("message", msg);
        return sentResult;
    }

    public static void sendMessage(Context ctx, String titile, String msgContent, String visitPath, String receiverIds) {
        if (StringUtils.isEmpty((String)receiverIds)) {
            logger.error((Object)"No one needs to push official account");
            return;
        }
        String userId = ctx.getCaller().toString();
        Message message = MessageFactory.newMessage();
        message.setLocaleStringHeader("title", titile, LocaleUtils.locale_l1);
        message.setLocaleStringHeader("title", titile, LocaleUtils.locale_l2);
        message.setLocaleStringHeader("title", titile, LocaleUtils.locale_l3);
        message.setLocaleStringHeader("body", msgContent, LocaleUtils.locale_l1);
        message.setLocaleStringHeader("body", msgContent, LocaleUtils.locale_l2);
        message.setLocaleStringHeader("body", msgContent, LocaleUtils.locale_l3);
        String sysAutoSendl1 = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l1);
        String sysAutoSendl2 = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l2);
        String sysAutoSendl3 = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l3);
        message.setLocaleStringHeader("sender", sysAutoSendl1, LocaleUtils.locale_l1);
        message.setLocaleStringHeader("sender", sysAutoSendl2, LocaleUtils.locale_l2);
        message.setLocaleStringHeader("sender", sysAutoSendl3, LocaleUtils.locale_l3);
        message.setLocaleStringHeader("initiatorName", sysAutoSendl1, LocaleUtils.locale_l1);
        message.setLocaleStringHeader("initiatorName", sysAutoSendl2, LocaleUtils.locale_l2);
        message.setLocaleStringHeader("initiatorName", sysAutoSendl3, LocaleUtils.locale_l3);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 20);
        message.setIntHeader("priority", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("receiver", receiverIds);
        message.setStringHeader("senderId", userId);
        if (visitPath != null && visitPath.trim().length() != 0) {
            message.setStringHeader("url", visitPath);
        }
        DirectSenderAgent.getSenderAgent().sendMessage(message);
    }

    public static Date timeAddMinute(Date date, int addMinute) {
        Calendar newTime = Calendar.getInstance();
        newTime.setTime(date);
        newTime.add(12, addMinute);
        return newTime.getTime();
    }

    public static Date getSysConfirmDate(Date date, Double confirmDay) {
        int addMinute = (int)(confirmDay * 24.0 * 60.0 + 0.5);
        return PayslipPushUtils.timeAddMinute(date, addMinute);
    }

    public static void updatePushedStateByPayTotal(Context ctx, PayslipPushTotalCollection payTotalColl, Map<String, Double> calSchemeEmpConfirmMap) throws BOSException {
        if (payTotalColl == null || payTotalColl.isEmpty()) {
            return;
        }
        Date curDate = new Date();
        ArrayList<Object[]> listParam = new ArrayList<Object[]>();
        for (int i = 0; i < payTotalColl.size(); ++i) {
            PayslipPushTotalInfo payTotal = payTotalColl.get(i);
            String payTotalId = payTotal.getId() == null ? "" : payTotal.getId().toString();
            String calSchemeId = payTotal.getCalScheme() == null || payTotal.getCalScheme().getId() == null ? "" : payTotal.getCalScheme().getId().toString();
            Date sysConfirmDate = null;
            if (calSchemeEmpConfirmMap.containsKey(calSchemeId)) {
                Double confirmDay = calSchemeEmpConfirmMap.get(calSchemeId);
                sysConfirmDate = PayslipPushUtils.getSysConfirmDate(curDate, confirmDay);
            }
            Object[] param = new Object[]{sysConfirmDate == null ? null : CmpDateUtil.toSqlDate(sysConfirmDate), payTotalId};
            listParam.add(param);
        }
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update T_HR_SPayslipPush payPush ").append(" set fpushState=").append(1).append(",").append(" FPushTime=now(),").append(" fempConfirmState=").append(0).append(",").append(" fisAutoConfirm = 0,").append(" fconfirmTime = null,").append(" fsysAutoConfirmTime=?").append(" where paypush.FPayTotalID = ? and exists (select 1 from T_HR_SCmpCalTable calTable where payPush.fcalTableId=calTable.fid and calTable.FCalState >=8)");
        DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), listParam);
    }

    public static HashSet<String> getOpenIdByUserId(Context ctx, String sql) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        try {
            String checkSql = "select * from KSQL_USERTABLES where KSQL_TABNAME='t_pm_easxtusermap'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            if (!rs.next()) {
                logger.error((Object)"\u53d1\u9001\u5931\u8d25,\u6240\u9009\u5458\u5de5\u672a\u8fdb\u884c\u4e91\u4e4b\u5bb6\u7528\u6237\u7ed1\u5b9a");
                return set;
            }
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs2.next()) {
                set.add(rs2.getString("FPersonId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return set;
    }

    public static String getNotInEasxtuserMsg(Context ctx, UserCollection userColl, UserCollection userNewColl, String sql) throws BOSException {
        StringBuilder msg = new StringBuilder();
        if (userColl == null || userColl.isEmpty()) {
            return msg.toString();
        }
        HashSet<String> setPerson = PayslipPushUtils.getOpenIdByUserId(ctx, sql);
        HashSet<String> nameSet = new HashSet<String>();
        boolean maxTur = false;
        for (int i = 0; i < userColl.size(); ++i) {
            UserInfo user = userColl.get(i);
            if (!setPerson.contains(user.getPerson().getId().toString())) {
                if (!maxTur && nameSet.size() < 10) {
                    nameSet.add(user.getPerson().getName());
                    continue;
                }
                if (maxTur || nameSet.size() < 10) continue;
                maxTur = true;
                continue;
            }
            userNewColl.add(user);
        }
        if (nameSet.isEmpty()) {
            return msg.toString();
        }
        msg.append(SHRServerResource.getString((String)"com.kingdee.shr.compensation.resource.PayslipPushResource", (String)"label9", (Locale)ctx.getLocale()));
        for (String s : nameSet) {
            msg.append(s).append(",");
        }
        msg.deleteCharAt(msg.length() - 1);
        if (nameSet.size() == 10 && maxTur) {
            msg.append("...");
        } else {
            msg.append(".");
        }
        return msg.toString();
    }

    static {
        PayslipPushUtils.load(PayslipPushUtils.getPropertiesFile());
    }
}

