/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.SalayCalculatorMgr;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.app.formula.tax.Salary2TaxCalculatorProxy;
import com.kingdee.shr.compensation.app.incomeTax.ReductionSummaryFacadeFactory;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanFactory;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanInfo;
import com.kingdee.shr.compensation.app.taxCal.AbstractCmpCalTaxCalExchangeFacadeControllerBean;
import com.kingdee.shr.compensation.app.taxCal.vo.Cmp2TaxItemMapper;
import com.kingdee.shr.compensation.app.taxCal.vo.InitDetailSubmitVO;
import com.kingdee.shr.compensation.helper.CalSchemeBizHelper;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CmpCalTaxCalExchangeFacadeControllerBean
extends AbstractCmpCalTaxCalExchangeFacadeControllerBean {
    private static Logger logger = Logger.getLogger(CmpCalTaxCalExchangeFacadeControllerBean.class);

    private void setLastUpdatePerson(Context ctx, Date taxPeriodBegin, List<String> succList, Map<String, String> secondSubSendCAL) throws BOSException {
        if (!succList.isEmpty()) {
            StringBuilder str = new StringBuilder();
            str.append(" SELECT CAL.FID CALID,DETAIL.FSTATE DETAILSTATE, DETAIL.FLASTUPDATEUSERID ");
            str.append(" FROM T_HR_SCMPCALTABLE CAL ");
            str.append(" INNER JOIN T_BD_PERSON PERSON ON CAL.FPERSONID = PERSON.FID ");
            str.append(" INNER JOIN T_HR_TAXUNIT TAXUNIT ON CAL.FTAXUNITID = TAXUNIT.FID ");
            str.append(" INNER JOIN T_HR_STAXCALINITDETAIL DETAIL ON DETAIL.FCMPCALTABLEID = CAL.FID ");
            str.append(" WHERE CAL.FPERSONID IN  ( SELECT A.FPERSONID FROM T_HR_SCMPCALTABLE A WHERE A.FTAXUNITID = DETAIL.FTAXUNITID AND A.FID IN (").append(CmpStrUtil.convertListToString(succList)).append(")) ");
            str.append(" AND DETAIL.FPERIODBEGIN  =  ").append(CmpDateUtil.toKSqlDate(taxPeriodBegin));
            str.append(" AND DETAIL.FDATASTATE  =  10");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    if (10 == rowSet.getInt("DETAILSTATE")) continue;
                    secondSubSendCAL.put(rowSet.getString("CALID"), rowSet.getString("FLASTUPDATEUSERID"));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected Map _submitData(Context ctx, HashMap mapParam) throws BOSException {
        boolean isCal;
        String cmpSchemeId = (String)mapParam.get("cmpschemeid");
        String cmpCalIds = (String)mapParam.get("cmpcalid");
        String uid = (String)mapParam.get("uid");
        String taxPeriodDate = (String)mapParam.get("taxPeriodDate");
        try {
            isCal = HRParamUtil.getParamOfHR((Context)ctx, (String)"shr_cmp_026", null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, cmpSchemeId);
        String hrOrgUnitID = calSchemeInfo.getHrOrgUnit().getId().toString();
        Map<String, Object> taxItemPlanMap = this.getTaxItemPlanMap(ctx, cmpCalIds, cmpSchemeId, true);
        Map taxItemPlanTaxUnitMap = (Map)taxItemPlanMap.get("taxItemPlanTaxUnitMap");
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            Date parseDate = simpleDateFormat.parse(taxPeriodDate);
            calendar.setTime(parseDate);
        }
        catch (ParseException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        calendar.set(5, 1);
        Date taxPeriodBegin = calendar.getTime();
        Salary2TaxCalculatorProxy calculator = new Salary2TaxCalculatorProxy(uid, true);
        calculator.setTaxPeriodBegin(Tools.getStringDate(taxPeriodBegin));
        int actualMaximum = calendar.getActualMaximum(5);
        calendar.set(5, actualMaximum);
        calculator.setTaxPeriodEnd(Tools.getStringDate(calendar.getTime()));
        HashMap<String, String> secondSubSendCAL = new HashMap<String, String>();
        ArrayList<String> succList = new ArrayList<String>();
        HashMap<String, Integer> calIdIndex = new HashMap<String, Integer>();
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        Set<String> failedSet = this.beforeSubmit(ctx, isCal, cmpCalIds, cmpSchemeId, taxPeriodBegin, header, succList, calIdIndex, secondSubSendCAL);
        HashMap<String, Object> calVal = new HashMap<String, Object>();
        calVal.put("header", header);
        if (succList.isEmpty()) {
            SalayCalculatorMgr.removeTask(uid, "");
            calVal.put("UID", calculator.getUID());
            return calVal;
        }
        cmpCalIds = "select FID from T_HR_SCmpCalTable where FID in (" + CmpStrUtil.convertListToString(succList) + ")";
        calculator.setMainTableName("T_HR_SCmpCalTable");
        calculator.setPrecision(2);
        calculator.setSchemeID(cmpSchemeId);
        calculator.setCtx(ctx);
        calculator.setFailedSet(failedSet);
        Tools.getInstance().setCtx(ctx);
        this.checkNeededCalSchemeInfo(ctx, calSchemeInfo);
        calculator.setHrOrgUnitID(hrOrgUnitID);
        calculator.setCalFromDate(Tools.getStringDate(calSchemeInfo.getBeginDate()));
        calculator.setCalToDate(Tools.getStringDate(calSchemeInfo.getEndDate()));
        if (mapParam.get("temporaryTableName") != null) {
            calculator.setTempTable((String)mapParam.get("temporaryTableName"));
        }
        this.submit(ctx, calculator, header, succList, taxItemPlanTaxUnitMap, calIdIndex, secondSubSendCAL, cmpCalIds, taxPeriodBegin);
        HashSet<String> taxUnitIds = new HashSet<String>();
        for (Set taxUnitIdSet : taxItemPlanTaxUnitMap.values()) {
            taxUnitIds.addAll(taxUnitIdSet);
        }
        this.afterSubmit(ctx, isCal, succList, secondSubSendCAL, taxUnitIds, taxPeriodBegin);
        calVal.put("succList", succList);
        calVal.put("UID", calculator.getUID());
        return calVal;
    }

    private Set<String> beforeSubmit(Context ctx, boolean isCal, String cmpCalIds, String cmpSchemeId, Date taxPeriodBegin, BatchMessageTipsHeader header, List<String> succList, Map<String, Integer> calIdIndex, Map<String, String> secondSubSendCAL) throws BOSException {
        IRowSet rowSet;
        int success = 0;
        int fail = 0;
        ArrayList<String> allIdList = new ArrayList<String>();
        StringBuilder str = new StringBuilder();
        HashSet<String> waitingPersonSet = new HashSet<String>();
        HashSet<String> detailCmpCalSet = new HashSet<String>();
        HashSet<String> successSet = new HashSet<String>();
        HashSet<String> failedSet = new HashSet<String>();
        String incomeItemIds = "select tip.fIncomeItemId from T_HR_STaxItemPlanShemeRel tpr, T_HR_STaxItemPlan tip, t_hr_sTaxIncomeItem ti where tpr.FCalSchemeId='" + cmpSchemeId + "' and tpr.FTaxItemPlanId = tip.fid and tip.fIncomeItemId = ti.fid and ti.fTaxCalMethod = " + 10;
        if (isCal) {
            try {
                str.append(" SELECT Detail.FPERSONID,Detail.FTAXUNITID,Detail.fIncomeItemId FROM T_HR_STAXCALINITDETAIL Detail");
                str.append(" where Detail.FCMPCALTABLEID not in (").append(cmpCalIds).append(") ");
                str.append(" and Detail.FPERSONID IN  (SELECT A.FPERSONID FROM T_HR_SCMPCALTABLE A WHERE DETAIL.FTAXUNITID = A.FTAXUNITID AND A.FID IN (").append(cmpCalIds).append(")) ");
                str.append(" and Detail.FINCOMEITEMID in (").append(incomeItemIds).append(")");
                str.append(" and Detail.FPERIODBEGIN  =  ").append(CmpDateUtil.toKSqlDate(taxPeriodBegin));
                str.append(" and Detail.FSTATE = ").append(20);
                str.append(" and Detail.FDATASTATE = ").append(10);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    String personID = rowSet.getString("FPERSONID");
                    String taxUnitID = rowSet.getString("FTAXUNITID");
                    String incomeItemId = rowSet.getString("fIncomeItemId");
                    waitingPersonSet.add(taxUnitID + "_" + personID + "_" + incomeItemId);
                }
                str = new StringBuilder();
                str.append(" SELECT FCMPCALTABLEID FROM T_HR_STAXCALINITDETAIL WHERE FCMPCALTABLEID IN (").append(cmpCalIds).append(") and FSTATE <> ").append(10);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    String calId = rowSet.getString("FCMPCALTABLEID");
                    detailCmpCalSet.add(calId);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        str = new StringBuilder();
        str.append("/*dialect*/ SELECT DETAIL.FID DETAILID, DETAIL.FSTATE, calInfo.FID FCMPCALTABLEID, calInfo.incomeItemName,");
        str.append(" taxUnit.FID taxUnitID, taxUnit.FNAME_L2 TAXUNITNAME, CONFIG.FSTATE CONFIGSTATE, ");
        str.append(" calInfo.FCALSTATE ,PERSON.FID PERSONID, calInfo.fIncomeItemId,calInfo.planName,");
        str.append(" PERSON.FNAME_L2 PERSONNAME, PERSON.FNUMBER PERNUMBER, CONFIG.FID CONFIGID, CONFIG.FISLAST ");
        str.append(" FROM (").append(this.getSQLFromHierarchy(cmpCalIds, cmpSchemeId)).append(") calInfo");
        str.append(" INNER JOIN T_BD_PERSON PERSON ON calInfo.FPERSONID = PERSON.FID ");
        str.append(" LEFT JOIN T_HR_TaxUnit taxUnit ON calInfo.FTaxUnitID = taxUnit.FID ");
        str.append(" LEFT JOIN T_HR_STAXCALINITDETAIL DETAIL ON DETAIL.FCMPCALTABLEID = calInfo.FID and DETAIL.fIncomeItemId = calInfo.fIncomeItemId ");
        str.append(" LEFT JOIN T_HR_STAXCALCONFIGDETAIL CONFIG ON CONFIG.FCMPCALTABLEID = calInfo.FID and CONFIG.fIncomeItemId = calInfo.fIncomeItemId ");
        str.append(" ORDER BY PERSON.FINDEX,PERSON.FNUMBER ");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            int index = 0;
            List<InitDetailSubmitVO> list = this.convertRowData(rowSet);
            for (InitDetailSubmitVO vo : list) {
                String key;
                boolean isSuccess = true;
                String msg = "";
                String calId = vo.getCmpCalTableId();
                String taxUnitID = vo.getTaxUnitId();
                String personID = vo.getPersonId();
                String incomeItemId = vo.getIncomeItemId();
                String incomeItemName = vo.getIncomeItemName();
                String planName = vo.getPlanName();
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                body.setId(calId);
                if (vo.getCalState() != 4) {
                    isSuccess = false;
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label36", (Locale)ctx.getLocale());
                }
                if (isCal) {
                    if (20 == vo.getConfigState()) {
                        isSuccess = false;
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label37", (Locale)ctx.getLocale());
                    } else if (30 == vo.getState()) {
                        isSuccess = false;
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label38", (Locale)ctx.getLocale());
                    } else if (!(StringUtils.isEmpty((CharSequence)vo.getConfigId()) || vo.isLast() || 40 != vo.getState() && 20 != vo.getState())) {
                        isSuccess = false;
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label39", (Locale)ctx.getLocale());
                    } else if (waitingPersonSet.contains(taxUnitID + "_" + personID + "_" + incomeItemId) && detailCmpCalSet.contains(calId)) {
                        isSuccess = false;
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label40", (Locale)ctx.getLocale());
                    }
                } else if (20 == vo.getConfigState()) {
                    isSuccess = false;
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label41", (Locale)ctx.getLocale());
                }
                if (StringUtils.isEmpty((CharSequence)taxUnitID)) {
                    isSuccess = false;
                    msg = "\u63d0\u4ea4\u5931\u8d25\uff0c\u8be5\u6838\u7b97\u6570\u636e\u7684\u7eb3\u7a0e\u5355\u4f4d\u672a\u8bbe\u7f6e\u4e2a\u7a0e\u9879\u76ee\u65b9\u6848";
                }
                if (isSuccess) {
                    key = this.getMessageKey(calId, incomeItemName);
                    ++success;
                    successSet.add(calId);
                    calIdIndex.put(key, index);
                } else {
                    key = this.getMessageKey(calId, incomeItemId);
                    failedSet.add(key);
                    ++fail;
                }
                body.setMuitTipsState(isSuccess);
                body.setMuitTipsMessage(msg);
                ArrayList<String> messageListExt = new ArrayList<String>();
                messageListExt.add(vo.getPersonNumber());
                messageListExt.add(vo.getPersonName());
                messageListExt.add(planName);
                messageListExt.add(incomeItemName);
                body.addMessageListExt(messageListExt);
                header.addResult(body);
                allIdList.add(calId);
                ++index;
            }
            header.setBillId(CmpStrUtil.convertListToString(allIdList));
            header.setFailureCount(fail);
            header.setSuccessCount(success);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (!successSet.isEmpty()) {
            succList.addAll(successSet);
        }
        this.setLastUpdatePerson(ctx, taxPeriodBegin, succList, secondSubSendCAL);
        return failedSet;
    }

    private String getSQLFromHierarchy(String cmpCalIds, String cmpSchemeId) {
        return "SELECT t.* FROM (SELECT tn.* ,row_number() over(partition by tn.FID,tn.FCALSTATE,tn.FTaxUnitID,tn.fIncomeItemId order by tn.fLevel) rn from (select cal.FID, cal.FCALSTATE, cal.FPERSONID, tur.FTaxUnitID, ti.fName_l2 incomeItemName,tip.fIncomeItemId,tip.fName_l2 planName, tpr.fLevel, cal.FCALTAXDATASTATE from T_HR_SCmpCalTable cal left join T_HR_STaxItemPlanRel tpr on cal.fHrOrgUnitId = tpr.fHrOrgUnitId and cal.FID IN (" + cmpCalIds + ") inner join T_HR_STaxItemPlanShemeRel tips on tpr.fTaxItemPlanId = tips.fTaxItemPlanId and tips.fCalSchemeId = '" + cmpSchemeId + "' left join T_HR_STaxUnitRecord tur on tpr.fTaxItemPlanId = tur.fTaxItemPlanId and cal.fTaxUnitId =tur.fTaxUnitId left join T_HR_STaxItemPlan tip on tpr.fTaxItemPlanId = tip.fid left join T_HR_STaxIncomeItem ti on tip.FIncomeItemId=ti.fid ) tn) t where t.rn = 1 ";
    }

    private List<InitDetailSubmitVO> convertRowData(IRowSet rowSet) throws SQLException {
        ArrayList<InitDetailSubmitVO> list = new ArrayList<InitDetailSubmitVO>();
        while (rowSet.next()) {
            InitDetailSubmitVO vo = new InitDetailSubmitVO();
            vo.setCmpCalTableId(rowSet.getString("FCMPCALTABLEID"));
            vo.setTaxUnitId(rowSet.getString("taxUnitID"));
            vo.setPersonId(rowSet.getString("PERSONID"));
            vo.setIncomeItemId(rowSet.getString("fIncomeItemId"));
            vo.setIncomeItemName(rowSet.getString("incomeItemName"));
            vo.setPlanName(rowSet.getString("planName"));
            vo.setDetailId(rowSet.getString("DETAILID"));
            vo.setState(rowSet.getInt("FSTATE"));
            vo.setConfigState(rowSet.getInt("CONFIGSTATE"));
            vo.setCalState(rowSet.getInt("FCALSTATE"));
            vo.setTaxUnitName(rowSet.getString("TAXUNITNAME"));
            vo.setPersonName(rowSet.getString("PERSONNAME"));
            vo.setPersonNumber(rowSet.getString("PERNUMBER"));
            vo.setConfigId(rowSet.getString("CONFIGID"));
            vo.setLast(rowSet.getBoolean("FISLAST"));
            list.add(vo);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        for (InitDetailSubmitVO initDetailSubmitVO : list) {
            String calId = initDetailSubmitVO.getCmpCalTableId();
            List subList = map.computeIfAbsent(calId, k -> new ArrayList());
            subList.add(initDetailSubmitVO);
        }
        list = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            List subList = (List)entry.getValue();
            for (InitDetailSubmitVO vo : subList) {
                if (!StringUtils.isNotEmpty((CharSequence)vo.getTaxUnitId())) continue;
                this.removeIfTaxUnitIdIsEmpty(subList);
                break;
            }
            if (subList.isEmpty()) continue;
            list.addAll(subList);
        }
        return list;
    }

    private void removeIfTaxUnitIdIsEmpty(List<InitDetailSubmitVO> subList) {
        subList.removeIf(vo -> StringUtils.isEmpty((CharSequence)vo.getTaxUnitId()));
    }

    private String getMessageKey(String calTableId, String incomeItemName) {
        return calTableId + "_" + incomeItemName;
    }

    private void submit(Context ctx, Salary2TaxCalculatorProxy calculator, BatchMessageTipsHeader header, List<String> succList, Map<String, Set<String>> taxItemPlanTaxUnitMap, Map<String, Integer> calIdIndex, Map<String, String> secondSubSendCAL, String cmpCalIds, Date periodBegin) throws BOSException {
        try {
            this.initZeroIncomeData(ctx, cmpCalIds, periodBegin, calculator);
            int curStep = 0;
            int maxStep = taxItemPlanTaxUnitMap.size();
            HashSet<String> failedSet = new HashSet<String>();
            HashSet<String> successSet = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : taxItemPlanTaxUnitMap.entrySet()) {
                String taxItemPlanID = entry.getKey();
                TaxItemPlanInfo taxItemPlan = TaxItemPlanFactory.getLocalInstance(ctx).getTaxItemPlanInfo("select id, name, incomeItem.incomeCode, incomeItem.name, incomeItem.id where id = '" + taxItemPlanID + "'");
                calculator.setTaxItemPlan(taxItemPlan);
                Set<String> taxUnitSet = entry.getValue();
                String condition = cmpCalIds + " and FTaxUnitID in (" + CmpStrUtil.convertSetToSqlString(taxUnitSet) + ")";
                String mainTableRowFilter = "t_hr_scmpcaltable.fid in (" + condition + ")";
                calculator.setMainTableRowFilter(mainTableRowFilter);
                calculator.setFilterSql(cmpCalIds);
                calculator.post(curStep++, maxStep);
                Map<String, String> verifyDataResult = calculator.getVerifyResult();
                if (null == verifyDataResult || verifyDataResult.size() <= 0) continue;
                List result = header.getResult();
                int failureCount = header.getFailureCount();
                int successCount = header.getSuccessCount();
                for (Map.Entry<String, String> verifyData : verifyDataResult.entrySet()) {
                    String key = verifyData.getKey();
                    String message = verifyData.getValue();
                    String[] arr = key.split("_");
                    String calId = arr[0];
                    String incomeName = arr[1];
                    int index = calIdIndex.get(key);
                    BatchMessageTipsBody batchMessageTipsBody = (BatchMessageTipsBody)result.get(index);
                    boolean state = false;
                    if (null == message) {
                        state = true;
                        message = "\u6240\u5f97\u9879\u76ee[" + incomeName + "]\uff0c\u63d0\u4ea4\u521d\u7b97\u6210\u529f";
                        successSet.add(calId);
                    } else {
                        ++failureCount;
                        --successCount;
                        failedSet.add(calId);
                    }
                    batchMessageTipsBody.setMuitTipsState(state);
                    batchMessageTipsBody.setMuitTipsMessage(message);
                }
                header.setSuccessCount(successCount);
                header.setFailureCount(failureCount);
            }
            this.dealSuccList(successSet, failedSet, succList, secondSubSendCAL);
            Set<String> calTableSet = calculator.getCalculator().getCalTableSet();
            if (!calTableSet.isEmpty()) {
                this.deleteInvalidData(ctx, calTableSet);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void dealSuccList(Set<String> successSet, Set<String> failedSet, List<String> succList, Map<String, String> secondSubSendCAL) {
        for (String calId : failedSet) {
            if (successSet.contains(calId)) continue;
            succList.remove(calId);
            secondSubSendCAL.remove(calId);
        }
    }

    private void initZeroIncomeData(Context ctx, String cmpCalIds, Date periodBegin, Salary2TaxCalculatorProxy calculator) throws BOSException, SQLException {
        String zeroIncomeSQL = "select fPersonId, fTaxUnitId from t_hr_sTaxCalInitDetail where fTaxUnitId in (select fTaxUnitId from t_hr_sCmpCalTable where fid in (" + cmpCalIds + ")) and fIncomeItemId in (select fid from t_hr_sTaxIncomeItem where fIncomeCode = '0101')  and fPeriodBegin = " + CmpDateUtil.toKSqlDate(periodBegin) + " and fIsZeroIncome = 1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)zeroIncomeSQL);
        ArrayList<String> zeroIncomeList = new ArrayList<String>();
        while (rs.next()) {
            zeroIncomeList.add(CmpStrUtil.getZeroIncomeInfo(rs.getString("fPersonId"), rs.getString("fTaxUnitId")));
        }
        calculator.setZeroIncomeList(zeroIncomeList);
    }

    private void deleteInvalidData(Context ctx, Set<String> calTableSet) throws BOSException {
        String deleteInitSQL = "delete from t_hr_sTaxCalInitDetail where fCmpCalTableId = ? and fIncomeItemId not in (select p.fIncomeItemId from t_hr_sCmpCalTable c,t_hr_sTaxItemPlanShemeRel r, t_hr_sTaxItemPlan p where c.fid = ? and c.fCalSchemeId = r.fCalSchemeId and r.fTaxItemPlanId = p.fid )";
        String deleteConfigSQL = "delete from t_hr_sTaxCalConfigDetail where fCmpCalTableId = ? and fIncomeItemId not in (select p.fIncomeItemId from t_hr_sCmpCalTable c,t_hr_sTaxItemPlanShemeRel r, t_hr_sTaxItemPlan p where c.fid = ? and c.fCalSchemeId = r.fCalSchemeId and r.fTaxItemPlanId = p.fid )";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String calTableId : calTableSet) {
            Object[] param = new Object[]{calTableId, calTableId};
            params.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)deleteInitSQL, params);
        DbUtil.executeBatch((Context)ctx, (String)deleteConfigSQL, params);
    }

    private void afterSubmit(Context ctx, boolean isCal, List<String> succList, Map<String, String> secondSubSendCAL, Set<String> taxUnitIds, Date taxPeriodBegin) throws BOSException {
        if (!succList.isEmpty()) {
            this.sendTaxCalMessage(ctx, succList, isCal, secondSubSendCAL);
            String updateTaxStateSql = "UPDATE T_HR_SCmpCalTable SET  FCalTaxDataState = case when FCalTaxDataState in (0,1) then 1 else 4 end WHERE FID in (" + CmpStrUtil.convertListToString(succList) + ")";
            DbUtil.execute((Context)ctx, (String)updateTaxStateSql);
            try {
                this.saveReduSummary(ctx, taxUnitIds, taxPeriodBegin);
            }
            catch (Exception e) {
                logger.error((Object)"saveReduSummary error: ", (Throwable)e);
            }
        }
    }

    private void saveReduSummary(Context ctx, Set<String> taxUnitIds, Date taxPeriodBegin) throws BOSException {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        for (String taxUnitId : taxUnitIds) {
            ReductionSummaryFacadeFactory.getLocalInstance(ctx).save(taxUnitId, taxPeriodBegin, userId);
        }
    }

    private void sendTaxCalMessage(Context ctx, List<String> succList, boolean isCal, Map<String, String> secondSubSendCAL) {
        Map<String, Object> sendUserMap = this.getSendUserMap(ctx, succList, secondSubSendCAL);
        Set firstSubTaxUnitSet = (Set)sendUserMap.get("firstSubTaxUnitSet");
        Map secondSendMsgMap = (Map)sendUserMap.get("secondSendMsgMap");
        if (firstSubTaxUnitSet.size() > 0) {
            this.firstSubSendMsg(ctx, firstSubTaxUnitSet, isCal);
        }
        if (secondSendMsgMap.size() > 0) {
            this.secondSubSendMsg(ctx, secondSendMsgMap, isCal);
        }
    }

    private Map<String, Object> getSendUserMap(Context ctx, List<String> succList, Map<String, String> secondSubSendCAL) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String personName;
            IRowSet rowSet;
            StringBuffer str = new StringBuffer();
            String calIdSetStr = CmpStrUtil.convertSetToSqlString(secondSubSendCAL.keySet());
            HashSet<String> calPersonSet = new HashSet<String>();
            if (secondSubSendCAL.size() > 0) {
                str.append(" SELECT FPERSONID FROM T_HR_SCMPCALTABLE WHERE FID IN (").append(calIdSetStr).append(")");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                String personID = "";
                while (rowSet.next()) {
                    personID = rowSet.getString("FPERSONID");
                    calPersonSet.add(personID);
                }
            }
            str = new StringBuffer();
            str.append(" SELECT CAL.FID CALID, CAL.FPERSONID,CAL.FCALTAXDATASTATE , CAL.FTAXUNITID,TAXUNIT.FNAME_L2 TAXUNITNAME, ");
            str.append(" PERSON.FNAME_L2 PERSONNAME,PERSON.FNUMBER PERSONNUMBER ");
            str.append(" FROM T_HR_SCMPCALTABLE CAL ");
            str.append(" INNER JOIN T_BD_PERSON PERSON ON CAL.FPERSONID = PERSON.FID ");
            str.append(" INNER JOIN T_HR_TAXUNIT TAXUNIT ON CAL.FTAXUNITID = TAXUNIT.FID ");
            str.append(" WHERE CAL.FID IN  (").append(CmpStrUtil.convertListToString(succList)).append(")");
            if (secondSubSendCAL.size() > 0) {
                str.append(" OR CAL.FID IN  (").append(calIdSetStr).append(")");
            }
            HashSet<String> firstSubTaxUnitSet = new HashSet<String>();
            HashMap secondSendMsgMap = new HashMap();
            rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            ArrayList<String> tempList = new ArrayList<String>();
            HashSet<String> dupNameList = new HashSet<String>();
            while (rowSet.next()) {
                personName = rowSet.getString("PERSONNAME");
                if (tempList.contains(personName)) {
                    dupNameList.add(personName);
                    continue;
                }
                tempList.add(personName);
            }
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (!calPersonSet.contains(rowSet.getString("FPERSONID"))) {
                    firstSubTaxUnitSet.add(rowSet.getString("FTAXUNITID"));
                    continue;
                }
                String sendUserID = secondSubSendCAL.get(rowSet.getString("CALID"));
                if (StringUtils.isEmpty((CharSequence)sendUserID)) continue;
                Map taxUnit = secondSendMsgMap.containsKey(sendUserID) ? (Map)secondSendMsgMap.get(sendUserID) : new HashMap();
                String taxUnitName = rowSet.getString("TAXUNITNAME");
                Set personSet = taxUnit.containsKey(taxUnitName) ? (Set)taxUnit.get(taxUnitName) : new HashSet();
                personName = rowSet.getString("PERSONNAME");
                if (dupNameList.contains(personName)) {
                    String personNumber = rowSet.getString("PERSONNUMBER");
                    personName = personName + "\uff08" + personNumber + "\uff09";
                }
                personSet.add(personName);
                taxUnit.put(taxUnitName, personSet);
                secondSendMsgMap.put(sendUserID, taxUnit);
            }
            result.put("firstSubTaxUnitSet", firstSubTaxUnitSet);
            result.put("secondSendMsgMap", secondSendMsgMap);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void firstSubSendMsg(Context ctx, Set<String> firstSubTaxUnitSet, boolean isCal) {
        StringBuilder str = new StringBuilder();
        str.append(" SELECT DISTINCT");
        str.append(" TPMUSER.FID SENDUSERID,");
        str.append(" TAXUNIT.FNAME_L2 TAXUNITNAME ");
        str.append(" FROM    ");
        str.append(" T_HR_STAXUNITDATAPERM DATAPERM   ");
        str.append(" INNER JOIN T_HR_TAXUNIT TAXUNIT ON DATAPERM.FTAXUNITID = TAXUNIT.FID ");
        str.append(" INNER JOIN T_PM_USER TPMUSER ON DATAPERM.FPERSONID = TPMUSER.FPERSONID   ");
        str.append(" WHERE TAXUNIT.FID IN  (").append(CmpStrUtil.convertSetToSqlString(firstSubTaxUnitSet)).append(")");
        str.append(" GROUP BY TPMUSER.FID ,TAXUNIT.FNAME_L2");
        try {
            Set taxUnitSet;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            HashMap taxUnitMap = new HashMap();
            String sendUserID = "";
            MessageUtil.setNeedSending(ctx);
            while (rowSet.next()) {
                sendUserID = rowSet.getString("SENDUSERID");
                taxUnitSet = taxUnitMap.containsKey(sendUserID) ? (Set)taxUnitMap.get(sendUserID) : new HashSet();
                taxUnitSet.add(rowSet.getString("TAXUNITNAME"));
                taxUnitMap.put(sendUserID, taxUnitSet);
            }
            Set keySet = taxUnitMap.keySet();
            Iterator iterator = keySet.iterator();
            String title = "";
            String msgTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label44", (Locale)ctx.getLocale());
            String category = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label45", (Locale)ctx.getLocale());
            String msg = "";
            title = isCal ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label46", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label47", (Locale)ctx.getLocale());
            while (iterator.hasNext()) {
                sendUserID = (String)iterator.next();
                taxUnitSet = (Set)taxUnitMap.get(sendUserID);
                msg = MessageFormat.format(msgTemplate, ((Object)taxUnitSet).toString().replace("[", "").replace("]", "").replace(",", "\u3001"));
                MessageUtil.sendMessage(ctx, sendUserID, title, msg, category);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void secondSubSendMsg(Context ctx, Map<String, Map<String, Set<String>>> secondSendMsgMap, boolean isCal) {
        String title = "";
        String msgTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label48", (Locale)ctx.getLocale());
        String category = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label49", (Locale)ctx.getLocale());
        title = isCal ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label50", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label51", (Locale)ctx.getLocale());
        Set<String> keySet = secondSendMsgMap.keySet();
        Iterator<String> iterator = keySet.iterator();
        MessageUtil.setNeedSending(ctx);
        while (iterator.hasNext()) {
            StringBuilder msgBuffer = new StringBuilder();
            String sendUserID = iterator.next();
            Map<String, Set<String>> taxUnitMap = secondSendMsgMap.get(sendUserID);
            Set<String> keySet2 = taxUnitMap.keySet();
            for (String taxUnitName : keySet2) {
                Set<String> personNameSet = taxUnitMap.get(taxUnitName);
                msgBuffer.append("\uff1b\r\n").append(MessageFormat.format(msgTemplate, taxUnitName, personNameSet.toString().replace("[", "").replace("]", "").replace(",", "\u3001")));
            }
            MessageUtil.sendMessage(ctx, sendUserID, title, msgBuffer.toString().replaceFirst("\uff1b\r\n", ""), category);
        }
    }

    private void checkNeededCalSchemeInfo(Context ctx, CalSchemeInfo calSchemeInfo) throws BOSException {
        boolean isValidate = CalSchemeBizHelper.checkCalSchemeLegal(calSchemeInfo);
        if (!isValidate) {
            throw new BOSException(CalSchemeBizHelper.getCalValidateMessage(ctx));
        }
    }

    private Map<String, Object> getTaxItemPlanMap(Context ctx, String cmpCalIds, String calSchemeId, boolean isNeedSre) throws BOSException {
        String calTypeCondition = isNeedSre ? " and formula.FCalType in (0,2) " : " and formula.FCalType in (1,2) ";
        String sql = "/*dialect*/ select t.fTaxUnitId,t.fTaxItemPlanId from  (select tn.*, row_number() over(partition by tn.fHrOrgUnitId,tn.fTaxUnitId,tn.fIncomeItemId order by tn.fLevel) as rn from    (select distinct cmp.fHrOrgUnitId, cmp.fTaxUnitId,tpr.fTaxItemPlanId, tip.fIncomeItemId, tpr.fLevel     from T_HR_SCmpCalTable cmp, T_HR_STaxItemPlanRel tpr, t_hr_sTaxItemPlan tip, T_HR_STaxUnitRecord tur, T_HR_SBusinessRelationConfig config, T_HR_SBaseFormula formula    where cmp.fid in (" + cmpCalIds + ")       and cmp.fHrOrgUnitId = tpr.fHrOrgUnitId      and tpr.fTaxItemPlanId = tur.fTaxItemPlanId      and tpr.fTaxItemPlanId = tip.fid      and tur.fTaxUnitId =cmp.fTaxUnitId       and tpr.fTaxItemPlanId in (SELECT fTaxItemPlanId FROM T_HR_STaxItemPlanShemeRel where fCalSchemeId = '" + calSchemeId + "')       and tpr.fTaxItemPlanId = config.FBusinessId       and config.fid = formula.FBusinessRelationConfigID and formula.FISCAL = 1 " + calTypeCondition + "    ) tn ) t where t.rn = 1";
        HashMap<String, Object> taxItemPlanMap = new HashMap<String, Object>();
        HashMap taxItemPlanTaxUnitMap = new HashMap();
        ArrayList<String> taxItemPlanList = new ArrayList<String>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String taxItemPlanID = rowSet.getString("fTaxItemPlanId");
                String taxUnitID = rowSet.getString("fTaxUnitId");
                Set taxUnitSet = !taxItemPlanTaxUnitMap.containsKey(taxItemPlanID) ? new HashSet() : (Set)taxItemPlanTaxUnitMap.get(taxItemPlanID);
                taxUnitSet.add(taxUnitID);
                taxItemPlanTaxUnitMap.put(taxItemPlanID, taxUnitSet);
                if (taxItemPlanList.contains(taxItemPlanID)) continue;
                taxItemPlanList.add(taxItemPlanID);
            }
        }
        catch (SQLException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
        }
        taxItemPlanMap.put("taxItemPlanTaxUnitMap", taxItemPlanTaxUnitMap);
        taxItemPlanMap.put("taxItemPlanList", taxItemPlanList);
        return taxItemPlanMap;
    }

    @Override
    protected Map _getData(Context ctx, HashMap mapParam) throws BOSException {
        String cmpSchemeId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String cmpCalId = (String)mapParam.get("cmpcalid");
        Map<String, Object> taxItemPlanMap = this.getTaxItemPlanMap(ctx, cmpCalId, cmpSchemeId = (String)mapParam.get("cmpschemeid"), false);
        List taxItemPlanList = (List)taxItemPlanMap.get("taxItemPlanList");
        if (null == taxItemPlanList || taxItemPlanList.isEmpty()) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label240", (Locale)ctx.getLocale()));
        }
        ArrayList<String> allIdList = new ArrayList<String>();
        ArrayList<String> succList = new ArrayList<String>();
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        int sucsess = 0;
        int fail = 0;
        StringBuilder str = new StringBuilder();
        str.append("/*dialect*/ SELECT calInfo.FID FCMPCALTABLEID, calInfo.FPERSONID, calInfo.fIncomeItemId, ");
        str.append(" taxUnit.FID taxUnitID, taxUnit.FNAME_L2 TAXUNITNAME, CONFIG.FSTATE CONFIGSTATE, ");
        str.append(" calInfo.FCALSTATE ,calInfo.FCALTAXDATASTATE, calInfo.planName, ");
        str.append(" PERSON.FNAME_L2 PERSONNAME, PERSON.FNUMBER PERNUMBER, CONFIG.FID CONFIGID, calInfo.incomeItemName ");
        str.append(" FROM (").append(this.getSQLFromHierarchy(cmpCalId, cmpSchemeId)).append(") calInfo ");
        str.append(" INNER JOIN T_BD_PERSON PERSON ON calInfo.FPERSONID = PERSON.FID ");
        str.append(" INNER JOIN T_HR_TaxUnit taxUnit ON calInfo.FTaxUnitID = taxUnit.FID ");
        str.append(" LEFT JOIN T_HR_STAXCALCONFIGDETAIL CONFIG ON CONFIG.FCMPCALTABLEID = calInfo.FID and CONFIG.fIncomeItemId = calInfo.fIncomeItemId ");
        str.append(" ORDER BY PERSON.FINDEX,PERSON.FNUMBER ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (rowSet.next()) {
                boolean isSuccess = true;
                String msg = "";
                String calId = rowSet.getString("FCMPCALTABLEID");
                String planName = rowSet.getString("planName");
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                body.setId(calId);
                if (rowSet.getInt("FCALSTATE") != 4) {
                    isSuccess = false;
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label54", (Locale)ctx.getLocale());
                } else if (0 == rowSet.getInt("FCALTAXDATASTATE") || 3 == rowSet.getInt("FCALTAXDATASTATE")) {
                    isSuccess = false;
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label55", (Locale)ctx.getLocale());
                } else if (20 != rowSet.getInt("CONFIGSTATE")) {
                    isSuccess = false;
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label56", (Locale)ctx.getLocale());
                }
                if (isSuccess) {
                    ++sucsess;
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label57", (Locale)ctx.getLocale());
                    succList.add(calId);
                } else {
                    ++fail;
                }
                body.setMuitTipsState(isSuccess);
                body.setMuitTipsMessage(msg);
                ArrayList<String> messageListExt = new ArrayList<String>();
                messageListExt.add(rowSet.getString("PERNUMBER"));
                messageListExt.add(rowSet.getString("PERSONNAME"));
                messageListExt.add(planName);
                messageListExt.add(rowSet.getString("incomeItemName"));
                body.addMessageListExt(messageListExt);
                header.addResult(body);
                allIdList.add(calId);
            }
            header.setBillId(CmpStrUtil.convertListToString(allIdList));
            header.setFailureCount(fail);
            header.setSuccessCount(sucsess);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (succList.size() > 0) {
            try {
                List<String> stepCal = this.tax2SalaryCal(ctx, taxItemPlanList, succList);
                if (stepCal.size() > 0) {
                    CmpSQLUtil.executeBatchSql(ctx, stepCal.toArray());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        result.put("header", header);
        result.put("succList", succList);
        return result;
    }

    private List<String> tax2SalaryCal(Context ctx, List<String> taxItemPlanList, List<String> succList) throws BOSException, SQLException {
        IRowSet da = this.searchSchemeFormulas(ctx, taxItemPlanList);
        Map<String, List<Cmp2TaxItemMapper>> itemMapper = this.initItemMapper(da);
        Map<String, Boolean> taxItemMap = this.initTaxItem(ctx);
        return this.getChangeSQLList(ctx, succList, taxItemPlanList, itemMapper, taxItemMap);
    }

    private List<String> getChangeSQLList(Context ctx, List<String> succList, List<String> taxItemPlanList, Map<String, List<Cmp2TaxItemMapper>> itemMapper, Map<String, Boolean> taxItemMap) throws BOSException, SQLException {
        ArrayList<String> changeSQLList = new ArrayList<String>();
        Set<String> taxItemSet = taxItemMap.keySet();
        Iterator<String> iterator = taxItemSet.iterator();
        StringBuilder selectSQL = new StringBuilder();
        HashMap<String, Map<String, Object>> configMap = new HashMap<String, Map<String, Object>>();
        selectSQL.append(" SELECT FCmpCalTableID, taxItemPlan.fid taxItemPlanId");
        while (iterator.hasNext()) {
            String taxItem = iterator.next();
            selectSQL.append(",").append(taxItem);
        }
        selectSQL.append(" FROM T_HR_STaxCalConfigDetail detail");
        selectSQL.append(" inner join T_HR_STaxItemPlanShemeRel rel on rel.FCalSchemeId  = detail.FCalSchemeId");
        selectSQL.append(" inner join T_HR_STaxItemPlan taxItemPlan on taxItemPlan.fid  = rel.FTaxItemPlanId and taxItemPlan.FIncomeItemId = detail.FIncomeItemId");
        selectSQL.append(" inner join t_hr_sTaxUnitRecord tur on  taxItemPlan.fid = tur.FTaxItemPlanID  and detail.FTaxUnitId = tur.FTaxUnitId");
        selectSQL.append(" where");
        selectSQL.append(" detail.FCmpCalTableID in (").append(CmpStrUtil.convertListToString(succList)).append(")");
        selectSQL.append(" and taxItemPlan.fid in (").append(CmpStrUtil.convertListToString(taxItemPlanList)).append(")");
        selectSQL.append(" and detail.FState = 20");
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
        while (executeQuery.next()) {
            Map<String, Object> tableMap;
            String tableId = executeQuery.getString("FCmpCalTableID");
            String taxItemPlanId = executeQuery.getString("taxItemPlanId");
            if (configMap.containsKey(tableId)) {
                tableMap = (Map)configMap.get(tableId);
            } else {
                tableMap = new HashMap();
                configMap.put(tableId, tableMap);
            }
            List<Cmp2TaxItemMapper> taxItemToCmpItem = itemMapper.get(taxItemPlanId);
            for (Cmp2TaxItemMapper mapper : taxItemToCmpItem) {
                String taxItem = mapper.getTaxItem();
                String cmpItem = mapper.getCmpItem();
                Object cmpItemValue = executeQuery.getObject(taxItem);
                if (cmpItemValue == null || cmpItemValue instanceof BigDecimal && ((BigDecimal)cmpItemValue).compareTo(BigDecimal.ZERO) == 0) {
                    cmpItemValue = BigDecimal.ZERO;
                }
                if (tableMap.containsKey(cmpItem)) {
                    BigDecimal cmpItemTempValue = (BigDecimal)tableMap.get(cmpItem);
                    if (taxItemMap.get(taxItem).booleanValue()) {
                        cmpItemValue = ((BigDecimal)cmpItemValue).add(cmpItemTempValue);
                    } else if (cmpItemTempValue.compareTo((BigDecimal)cmpItemValue) > 0) {
                        cmpItemValue = cmpItemTempValue;
                    }
                }
                tableMap.put(cmpItem, cmpItemValue);
            }
        }
        StringBuilder updateSqlPrefix = new StringBuilder();
        updateSqlPrefix.append("UPDATE T_HR_SCmpCalTable SET ");
        updateSqlPrefix.append(" FCalTaxDataState = case when FCalTaxDataState in (1,2) then 2 else 5 end");
        Set cmpItemKeySet = configMap.keySet();
        Iterator cmpItemIterator = cmpItemKeySet.iterator();
        while (cmpItemIterator.hasNext()) {
            StringBuilder updateSqlSuffix = new StringBuilder();
            updateSqlSuffix.append((CharSequence)updateSqlPrefix);
            String tableId = (String)cmpItemIterator.next();
            Map tableIdMap = (Map)configMap.get(tableId);
            for (Map.Entry entry : tableIdMap.entrySet()) {
                updateSqlSuffix.append(", ").append((String)entry.getKey()).append(" = ").append(entry.getValue());
            }
            updateSqlSuffix.append(" WHERE FID = '").append(tableId).append("';");
            changeSQLList.add(updateSqlSuffix.toString());
        }
        return changeSQLList;
    }

    private Map<String, Boolean> initTaxItem(Context ctx) {
        HashMap<String, Boolean> taxItemMap = new HashMap<String, Boolean>();
        String sql = "select fieldsn, fismerge from T_HR_STaxItem where FDataType = 0";
        try {
            IRowSet da = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (da.next()) {
                String fieldSn = "T" + da.getString("fieldsn");
                boolean isMerge = da.getBoolean("fismerge");
                taxItemMap.put(fieldSn, isMerge);
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return taxItemMap;
    }

    private Map<String, List<Cmp2TaxItemMapper>> initItemMapper(IRowSet da) throws SQLException {
        da.beforeFirst();
        HashMap<String, List<Cmp2TaxItemMapper>> taxItemPlanMap = new HashMap<String, List<Cmp2TaxItemMapper>>();
        while (da.next()) {
            String taxItemPlanId = da.getString("taxItemPlanId");
            String taxItem = da.getString("FCalItem");
            String express = da.getString("FExpress");
            String calItem = express.split("=")[1].replace(";", "").trim();
            if (!(calItem = calItem.toUpperCase(Locale.ENGLISH).replace("T_HR_SCMPCALTABLE_", "")).startsWith("S")) continue;
            ArrayList<Cmp2TaxItemMapper> list = (ArrayList<Cmp2TaxItemMapper>)taxItemPlanMap.get(taxItemPlanId);
            Cmp2TaxItemMapper mapper = new Cmp2TaxItemMapper(taxItem, calItem);
            if (null == list) {
                list = new ArrayList<Cmp2TaxItemMapper>();
                taxItemPlanMap.put(taxItemPlanId, list);
            }
            list.add(mapper);
        }
        return taxItemPlanMap;
    }

    private IRowSet searchSchemeFormulas(Context ctx, List<String> taxItemPlanList) throws BOSException {
        String sb = "SELECT formula.FID, formula.FName_l2,formula.FCalItem, formula.FExpress, formula.FListItem, formula.FSortSn, taxItemPlan.fid taxItemPlanId FROM T_HR_STaxItemPlan taxItemPlan INNER JOIN T_HR_SBusinessRelationConfig config on taxItemPlan.FID = config.FBusinessId INNER JOIN T_HR_SBaseformula formula on config.FID = formula.FBusinessRelationConfigID where taxItemPlan.FID in (" + CmpStrUtil.convertListToString(taxItemPlanList) + ") and formula.FCalType in (1,2) and formula.FISCAL = 1  ORDER BY formula.FSortSn";
        IRowSet da = DbUtil.executeQuery((Context)ctx, (String)sb);
        if (da.size() == 0) {
            TaxItemPlanInfo taxItemPlanInfo;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("name");
            try {
                taxItemPlanInfo = TaxItemPlanFactory.getLocalInstance(ctx).getTaxItemPlanInfo((IObjectPK)new ObjectUuidPK(taxItemPlanList.get(0)), selector);
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            String name = taxItemPlanInfo.getName();
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label58", (Locale)ctx.getLocale()) + name + EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label59", (Locale)ctx.getLocale()));
        }
        return da;
    }
}

