/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.budgetadjust.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.BudgetManageCollection;
import com.kingdee.shr.compensation.app.budget.BudgetManageFactory;
import com.kingdee.shr.compensation.app.budget.BudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateTypeEnum;
import com.kingdee.shr.compensation.app.budget.BudgetYesNoEnum;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemDataType;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillFactory;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryFactory;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.budget.budgetadjust.IBudgetAdjustService;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetAdjustEntryParam;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetItemMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetPeriodMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustEntryHelper;
import com.kingdee.shr.compensation.budget.budgetadjust.util.BudgetAdjustEntryUtils;
import com.kingdee.shr.compensation.budget.budgetadjust.util.BudgetAdjustSqlUtils;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudgetAdjustService
implements IBudgetAdjustService {
    private static final Logger logger = LoggerFactory.getLogger(BudgetAdjustService.class);

    @Override
    public Map<String, Object> createBillData(Context ctx, String budgetSchemeId, String budgetManageIdsStr, String isValid) throws BOSException, SQLException, EASBizException {
        List<String> colNameHisList;
        String queryBudgetManageSql;
        IRowSet rs;
        boolean existEnableOrApprovingData;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String billId = BOSUuid.create((String)"D9BE91AE").toString();
        result.put("billId", billId);
        if (StringUtils.isEmpty((CharSequence)budgetSchemeId) || StringUtils.isEmpty((CharSequence)budgetManageIdsStr)) {
            return result;
        }
        List budgetManageIds = Arrays.asList((Object[])budgetManageIdsStr.split(","));
        CmpInSql inSqlObj = CmpInSqlFactory.getInstance();
        String createInSql = inSqlObj.createInSqlBaseOnFId(ctx, budgetManageIds);
        if (!"0".equals(isValid) && (existEnableOrApprovingData = this.existEnableOrApprovingData(ctx, budgetSchemeId, "where id in " + createInSql))) {
            result.put("errorMsg", BudgetAdjustEntryUtils.getMultiLan("label10", ctx));
            return result;
        }
        BudgetItemMapInfo itemMap = this.getItemMapByScheme(ctx, budgetSchemeId);
        Map<String, Integer> itemDataTypeMap = itemMap.getItemDataTypeMap();
        List<String> fieldSnList = itemMap.getFieldSnList();
        BudgetAdjustEntryCollection newEntryCol = BudgetAdjustSqlUtils.assembleNewEntryCol(fieldSnList, rs = DbUtil.executeQuery((Context)ctx, (String)(queryBudgetManageSql = BudgetAdjustSqlUtils.queryBudgetManageSqlWithoutApprovingBill(colNameHisList = itemMap.getColNameHisList(), "and fid in " + createInSql + "")).toString()), itemDataTypeMap);
        if (newEntryCol.isEmpty()) {
            return result;
        }
        BudgetAdjustEntryHelper entryHelper = new BudgetAdjustEntryHelper(ctx, billId, itemMap, null);
        List<String> colNameAllList = itemMap.getColNameAllList();
        entryHelper.saveEntryData(newEntryCol, colNameAllList);
        CmpBudgetSchemeInfo schemeInfo = this.getSchemeInfo(ctx, budgetSchemeId);
        if (!this.hasSubEntry(schemeInfo)) {
            return result;
        }
        BudgetPeriodMapInfo subItemMap = this.getSubItemMapByScheme(ctx, schemeInfo);
        Map<String, Object> subItemFieldSnMap = itemMap.getSubItemFieldSnMap();
        List<String> subItemIdList = itemMap.getSubItemIdList();
        List<String> budgetPeriodFields = subItemMap.getFieldNameList();
        List<String> budgetPeriodColNames = subItemMap.getColNameList();
        String querySubBudgetManageSql = BudgetAdjustSqlUtils.querySubBudgetManageSqlWithoutApprovingBill(ctx, subItemFieldSnMap, subItemIdList, budgetPeriodFields, budgetPeriodColNames, " and t.FCmpBudgetItemID in " + CmpStrUtil.concatList(subItemIdList) + " and entry.FBillId = ? and  t.FBudgetMangeID in " + createInSql + "");
        IRowSet subRowSet = DbUtil.executeQuery((Context)ctx, (String)querySubBudgetManageSql.toString(), (Object[])new Object[]{billId});
        SubBudgetAdjustEntryCollection subEntryCol = BudgetAdjustSqlUtils.assembleNewSubEntryCol(budgetPeriodColNames, subItemFieldSnMap, subRowSet);
        entryHelper.saveSubEntryData(subEntryCol, budgetPeriodColNames, budgetPeriodFields);
        inSqlObj.release(ctx);
        return result;
    }

    public boolean existEnableOrApprovingData(Context ctx, String budgetSchemeId, String filterSql) throws BOSException, SQLException {
        BudgetManageCollection manageCol;
        if (StringUtils.isEmpty((CharSequence)budgetSchemeId)) {
            return false;
        }
        StringBuilder queryOql = new StringBuilder();
        queryOql.append("select adminOrgUnit.id,costType.id,id,state ");
        if (!StringUtils.isEmpty((CharSequence)filterSql)) {
            queryOql.append(filterSql);
        }
        if ((manageCol = BudgetManageFactory.getLocalInstance(ctx).getBudgetManageCollection(queryOql.toString())) == null || manageCol.isEmpty()) {
            return false;
        }
        ArrayList<String> enableIds = new ArrayList<String>();
        ArrayList<BudgetAdjustEntryParam> entryParams = new ArrayList<BudgetAdjustEntryParam>();
        for (int i = 0; i < manageCol.size(); ++i) {
            BudgetManageInfo manageInfo = manageCol.get(i);
            String manageId = manageInfo.getId().toString();
            StateEnum state = manageInfo.getState();
            if (state == StateEnum.DISABLE) {
                enableIds.add(manageId);
            }
            if (manageInfo.getAdminOrgUnit() == null || manageInfo.getAdminOrgUnit().getId() == null || manageInfo.getCostType() == null || manageInfo.getCostType().getId() == null) continue;
            BudgetAdjustEntryParam entryParam = new BudgetAdjustEntryParam();
            entryParam.setAdminOrgUnitId(manageInfo.getAdminOrgUnit().getId().toString());
            entryParam.setCostTypeID(manageInfo.getCostType().getId().toString());
            entryParams.add(entryParam);
        }
        if (!enableIds.isEmpty()) {
            return true;
        }
        boolean existApproving = false;
        List<BudgetAdjustEntryParam> existApprovingBill = this.existApprovingBill(ctx, budgetSchemeId, entryParams);
        if (existApprovingBill != null && !existApprovingBill.isEmpty()) {
            for (BudgetAdjustEntryParam entryParam : existApprovingBill) {
                if (!entryParam.isExistApproving()) continue;
                existApproving = true;
                break;
            }
        }
        return existApproving;
    }

    public boolean existEnableOrApprovingData(Context ctx, String billId, String budgetSchemeId, List<BudgetAdjustEntryParam> entryParams) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)billId) || StringUtils.isEmpty((CharSequence)budgetSchemeId) || entryParams == null || entryParams.isEmpty()) {
            return false;
        }
        boolean existEnableData = this.existEnableData(ctx, budgetSchemeId, entryParams);
        if (existEnableData) {
            return true;
        }
        boolean existApproving = false;
        List<BudgetAdjustEntryParam> existApprovingBill = this.existApprovingBill(ctx, billId, budgetSchemeId, entryParams);
        if (existApprovingBill != null && !existApprovingBill.isEmpty()) {
            for (BudgetAdjustEntryParam entryParam : existApprovingBill) {
                if (!entryParam.isExistApproving()) continue;
                existApproving = true;
                break;
            }
        }
        return existApproving;
    }

    public boolean existEnableData(Context ctx, String budgetSchemeId, List<BudgetAdjustEntryParam> entryParams) throws BOSException {
        ArrayList<Object[]> batchInserTempParam = new ArrayList<Object[]>();
        for (BudgetAdjustEntryParam entryParam : entryParams) {
            ArrayList<String> insertParam = new ArrayList<String>();
            insertParam.add(entryParam.getAdminOrgUnitId());
            insertParam.add(entryParam.getCostTypeID());
            batchInserTempParam.add(insertParam.toArray());
        }
        String createInSql = BudgetAdjustSqlUtils.createTempTable(ctx, "t_hr_sbudgetmanage", "FAdminOrgUnitID,FCostTypeID", batchInserTempParam);
        StringBuilder queryOql = new StringBuilder();
        queryOql.append("select adminOrgUnit.id,costType.id,id,state where id in (select manage1.fid from t_hr_sbudgetmanage manage1 inner join " + createInSql + " temp1 on manage1.FAdminOrgUnitID=temp1.FAdminOrgUnitID and manage1.FCostTypeID=temp1.FCostTypeID and manage1.FBudgetSchemeID='" + budgetSchemeId + "')");
        BudgetManageCollection manageCol = BudgetManageFactory.getLocalInstance(ctx).getBudgetManageCollection(queryOql.toString());
        ArrayList<String> enableIds = new ArrayList<String>();
        if (manageCol != null && !manageCol.isEmpty()) {
            for (int i = 0; i < manageCol.size(); ++i) {
                BudgetManageInfo budgetManageInfo = manageCol.get(i);
                if (budgetManageInfo.getState() != StateEnum.DISABLE) continue;
                enableIds.add(budgetManageInfo.getId().toString());
            }
        }
        return !enableIds.isEmpty();
    }

    @Override
    public boolean hasSubEntry(CmpBudgetSchemeInfo schemeInfo) {
        if (schemeInfo == null) {
            return false;
        }
        BudgetPeriodEnum budgetPeriod = schemeInfo.getBudgetPeriod();
        return BudgetPeriodEnum.YEAR != budgetPeriod;
    }

    @Override
    public void updateBillEntryData(Context ctx, String billId) throws EASBizException, BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)billId)) {
            return;
        }
        BudgetAdjustBillInfo billInfo = this.getBillInfo(ctx, billId);
        CmpBudgetSchemeInfo budgetScheme = billInfo.getBudgetScheme();
        String budgetSchemeId = budgetScheme.getId().toString();
        BudgetItemMapInfo itemMap = this.getItemMapByScheme(ctx, budgetSchemeId);
        Map<String, Integer> itemColDataTypeMap = itemMap.getItemColDataTypeMap();
        List<String> colNameHisList = itemMap.getColNameHisList();
        String sql = BudgetAdjustSqlUtils.queryBudgetManageAndEntrySql(colNameHisList, "where entry.fBillId = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        BudgetAdjustEntryCollection entryCol = BudgetAdjustSqlUtils.assembleEntryCol(colNameHisList, rs, itemColDataTypeMap);
        BudgetAdjustEntryHelper helper = new BudgetAdjustEntryHelper(ctx, billId, itemMap, null);
        helper.updateEntryData(entryCol, colNameHisList);
        if (!this.hasSubEntry(budgetScheme)) {
            return;
        }
        BudgetPeriodMapInfo subItemMap = this.getSubItemMapByScheme(ctx, budgetScheme);
        List<String> periodFields = subItemMap.getFieldNameList();
        List<String> periodColNames = subItemMap.getColNameList();
        String querySubManageSql = BudgetAdjustSqlUtils.querySubManageSqlNotById(periodFields, periodColNames, " and subentry.fBillId = ?");
        IRowSet subEntryRs = DbUtil.executeQuery((Context)ctx, (String)querySubManageSql, (Object[])new Object[]{billId});
        SubBudgetAdjustEntryCollection subEntryCol = BudgetAdjustSqlUtils.assembleSubEntryCol(periodColNames, subEntryRs);
        helper.updateSubEntryData(subEntryCol, periodColNames, periodFields);
    }

    @Override
    public BudgetAdjustBillInfo getBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        BudgetAdjustBillInfo billInfo = BudgetAdjustBillFactory.getLocalInstance(ctx).getBudgetAdjustBillInfo("select id, billState,budgetScheme.id,budgetScheme.template.id,budgetScheme.template.hrOrgUnit,budgetScheme.template.templateType,budgetScheme.currency.id,budgetScheme.budgetPeriod,budgetScheme.effectDate,budgetScheme.expiryDate,budgetScheme.subBudgetAssignType,budgetScheme.subBalanceTypeEnum,budgetScheme.budgetYear where id = '" + billId + "'");
        CmpBudgetSchemeInfo schemeInfo = billInfo.getBudgetScheme();
        billInfo.put("entry", null);
        billInfo.put("subEntry", null);
        if (schemeInfo == null || schemeInfo.getId() == null) {
            throw new BOSException("budgetScheme is null!");
        }
        return billInfo;
    }

    @Override
    public CmpBudgetSchemeInfo getSchemeInfo(Context ctx, String schemeId) throws BOSException, EASBizException {
        return CmpBudgetSchemeFactory.getLocalInstance(ctx).getCmpBudgetSchemeInfo("select id,name,template.id,template.name,template.hrOrgUnit.id,template.templateType,currency.id,currency.name,budgetPeriod,effectDate,expiryDate,subBudgetAssignType,subBalanceTypeEnum,budgetYear where id = '" + schemeId + "'");
    }

    @Override
    public BudgetPeriodMapInfo getSubItemMapByScheme(Context ctx, CmpBudgetSchemeInfo budgetSchemeInfo) throws BOSException {
        BudgetPeriodMapInfo mapInfo = new BudgetPeriodMapInfo();
        if (budgetSchemeInfo == null) {
            return mapInfo;
        }
        List<String> fieldNameList = mapInfo.getFieldNameList();
        List<String> colNameList = mapInfo.getColNameList();
        List<String> colLiasList = mapInfo.getColLiasList();
        int timeGaps = 0;
        int budgetYear = budgetSchemeInfo.getBudgetYear();
        BudgetPeriodEnum budgetPeriod = budgetSchemeInfo.getBudgetPeriod();
        if (budgetPeriod == null) {
            return mapInfo;
        }
        switch (budgetPeriod.getValue()) {
            case 1: {
                fieldNameList.add("FirstHalfYear");
                fieldNameList.add("FLastHalfYear");
                colNameList.add("firstHalfYear");
                colNameList.add("lastHalfYear");
                colLiasList.add(budgetYear + "H01");
                colLiasList.add(budgetYear + "H02");
                timeGaps = 6;
                break;
            }
            case 2: {
                int i;
                for (i = 1; i <= 4; ++i) {
                    fieldNameList.add("FQuarter" + i);
                    colNameList.add("quarter" + i);
                    colLiasList.add(budgetYear + "Q0" + i);
                }
                timeGaps = 3;
                break;
            }
            case 3: {
                int i;
                for (i = 1; i <= 12; ++i) {
                    fieldNameList.add("FMonth" + i);
                    colNameList.add("month" + i);
                    if (i < 10) {
                        colLiasList.add(budgetYear + "M0" + i);
                        continue;
                    }
                    colLiasList.add(budgetYear + "M" + i);
                }
                timeGaps = 1;
                break;
            }
        }
        mapInfo.setFieldNameList(fieldNameList);
        mapInfo.setColNameList(colNameList);
        mapInfo.setColLiasList(colLiasList);
        LinkedHashMap<String, Map<String, Object>> subQueryMap = new LinkedHashMap<String, Map<String, Object>>();
        Date effectDate = budgetSchemeInfo.getEffectDate();
        Date expiryDate = budgetSchemeInfo.getExpiryDate();
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < colLiasList.size(); ++i) {
            calendar.setTime(effectDate);
            calendar.add(2, timeGaps);
            calendar.add(5, -1);
            HashMap<String, Comparable<Date>> dateMap = new HashMap<String, Comparable<Date>>();
            dateMap.put("effectDate", effectDate);
            if (i == colLiasList.size() - 1) {
                dateMap.put("expiryDate", expiryDate);
            } else {
                dateMap.put("dateMap", calendar);
            }
            subQueryMap.put(colLiasList.get(i), dateMap);
        }
        mapInfo.setSubQueryMap(subQueryMap);
        return mapInfo;
    }

    @Override
    public BudgetItemMapInfo getItemMapByScheme(Context ctx, String budgetSchemeId) throws BOSException {
        BudgetItemMapInfo mapInfo = new BudgetItemMapInfo();
        if (StringUtils.isEmpty((CharSequence)budgetSchemeId)) {
            return mapInfo;
        }
        BudgetTemplateItemCollection itemCollection = BudgetTemplateItemFactory.getLocalInstance(ctx).getBudgetTemplateItemCollection("select template.id,template.templateType,budgetItem.*,isSubBudgetAssign,isRequired where template.id in (select FTemplateID from T_HR_SCmpBudgetScheme where fid = '" + budgetSchemeId + "') order by sortSn");
        if (itemCollection.isEmpty()) {
            return mapInfo;
        }
        List<String> colNameAllList = mapInfo.getColNameAllList();
        List<String> colNameHisList = mapInfo.getColNameHisList();
        List<String> colNameList = mapInfo.getColNameList();
        List<String> fieldSnList = mapInfo.getFieldSnList();
        List<String> numberFieldSnList = mapInfo.getNumberFieldSnList();
        List<CmpBudgetItemInfo> itemInfoList = mapInfo.getItemInfoList();
        Map<String, CmpBudgetItemInfo> itemInfoMap = mapInfo.getItemInfoMap();
        Map<String, Integer> itemDataTypeMap = mapInfo.getItemDataTypeMap();
        Map<String, Integer> itemColDataTypeMap = mapInfo.getItemColDataTypeMap();
        Set<String> requireColNameSet = mapInfo.getRequireColNameSet();
        List<String> subItemIdList = mapInfo.getSubItemIdList();
        Map<String, Object> subItemFieldSnMap = mapInfo.getSubItemFieldSnMap();
        Map<String, Object> subItemIdMap = mapInfo.getSubItemIdMap();
        Map<String, Map<String, Object>> subItemColNameMap = mapInfo.getSubItemColNameMap();
        Locale locale = ctx.getLocale();
        if (itemCollection.get(0) != null && itemCollection.get(0).getTemplate() != null) {
            mapInfo.setTemplateType(itemCollection.get(0).getTemplate().getTemplateType());
        }
        for (int i = 0; i < itemCollection.size(); ++i) {
            CmpBudgetItemInfo budgetItem;
            BudgetTemplateItemInfo templateItemInfo = itemCollection.get(i);
            if (templateItemInfo == null || (budgetItem = templateItemInfo.getBudgetItem()) == null) continue;
            budgetItem.put("isRequired", (Object)templateItemInfo.getIsRequired());
            itemInfoList.add(budgetItem);
            int fieldSn = budgetItem.getFieldSn();
            if (templateItemInfo.getIsRequired() == BudgetYesNoEnum.YES) {
                requireColNameSet.add("M" + fieldSn);
            }
            colNameAllList.add("T" + fieldSn);
            colNameAllList.add("M" + fieldSn);
            fieldSnList.add("" + fieldSn);
            colNameHisList.add("T" + fieldSn);
            colNameList.add("M" + fieldSn);
            CmpBudgetItemDataType dataType = budgetItem.getDataType();
            BudgetYesNoEnum isSubBudgetAssign = templateItemInfo.getIsSubBudgetAssign();
            if (CmpBudgetItemDataType.NUMBER == dataType && BudgetYesNoEnum.YES == isSubBudgetAssign) {
                subItemIdList.add(budgetItem.getId().toString());
                subItemFieldSnMap.put(budgetItem.getId().toString(), fieldSn);
                subItemIdMap.put("" + fieldSn, budgetItem.getId().toString());
                HashMap<String, String> ColNameMap = new HashMap<String, String>();
                ColNameMap.put("id", budgetItem.getId().toString());
                ColNameMap.put("name", budgetItem.getName(locale));
                subItemColNameMap.put(budgetItem.getId().toString(), ColNameMap);
            }
            if (CmpBudgetItemDataType.NUMBER == dataType) {
                numberFieldSnList.add("" + fieldSn);
            }
            itemDataTypeMap.put(fieldSn + "", dataType.getValue());
            itemInfoMap.put("T" + fieldSn, budgetItem);
            itemInfoMap.put("M" + fieldSn, budgetItem);
            itemColDataTypeMap.put("T" + fieldSn, dataType.getValue());
            itemColDataTypeMap.put("M" + fieldSn, dataType.getValue());
        }
        return mapInfo;
    }

    @Override
    public Map<String, Object> getYearAndSubBudgetManageData(Context ctx, String budgetSchemeId, String adminOrgUnitId, String costTypeId) throws BOSException, SQLException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)budgetSchemeId) || StringUtils.isEmpty((CharSequence)adminOrgUnitId) || StringUtils.isEmpty((CharSequence)costTypeId)) {
            return null;
        }
        BudgetItemMapInfo itemMap = this.getItemMapByScheme(ctx, budgetSchemeId);
        Map<String, Object> subItemFieldSnMap = itemMap.getSubItemFieldSnMap();
        Map<String, Map<String, Object>> subItemColNameMap = itemMap.getSubItemColNameMap();
        result.put("subItemFieldSnMap", subItemFieldSnMap);
        result.put("subItemColNameMap", subItemColNameMap);
        List<String> colNameHisList = itemMap.getColNameHisList();
        String queryBudgetManageSql = BudgetAdjustSqlUtils.queryBudgetManageSql(colNameHisList, "where FBudgetSchemeID= ? and FAdminOrgUnitID=? and FCostTypeID=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryBudgetManageSql, (Object[])new Object[]{budgetSchemeId, adminOrgUnitId, costTypeId});
        List<String> fieldSnList = itemMap.getFieldSnList();
        ArrayList<String> budgetManageIdList = new ArrayList<String>();
        while (rs.next()) {
            for (String fieldSn : fieldSnList) {
                result.put(fieldSn, rs.getString("T" + fieldSn));
            }
            budgetManageIdList.add(rs.getString("budgetManage"));
            int dataVersion = -1;
            if (rs.getObject("dataVersion") != null) {
                dataVersion = rs.getInt("dataVersion");
            }
            result.put("budgetManage", rs.getString("budgetManage"));
            result.put("backupVersion", dataVersion);
            result.put("syncVersion", dataVersion + 1);
        }
        result.put("fieldSnList", fieldSnList);
        if (budgetManageIdList.isEmpty()) {
            return result;
        }
        CmpBudgetSchemeInfo schemeInfo = this.getSchemeInfo(ctx, budgetSchemeId);
        if (!this.hasSubEntry(schemeInfo)) {
            return result;
        }
        List<String> subItemIdList = itemMap.getSubItemIdList();
        BudgetPeriodMapInfo subItemMap = this.getSubItemMapByScheme(ctx, schemeInfo);
        List<String> budgetPeriodColNames = subItemMap.getColNameList();
        List<String> budgetPeriodFields = subItemMap.getFieldNameList();
        CmpInSql sqlUtil = CmpInSqlFactory.getInstance();
        String createInSql = sqlUtil.createInSqlBaseOnFId(ctx, budgetManageIdList);
        String querySubBudgetManageSql = BudgetAdjustSqlUtils.querySubBudgetManageSqlToQuery(ctx, budgetPeriodColNames, budgetPeriodFields, "where t.FBudgetMangeID in " + createInSql + " and t.FCmpBudgetItemID in " + CmpStrUtil.concatList(subItemIdList));
        IRowSet subRowSet = DbUtil.executeQuery((Context)ctx, (String)querySubBudgetManageSql);
        HashMap<String, Object> subManageData = null;
        ArrayList subManageDataList = new ArrayList();
        while (subRowSet.next()) {
            subManageData = new HashMap<String, Object>();
            subManageData.put("subBudgetManage", subRowSet.getString("subBudgetManage"));
            subManageData.put("fieldSn", subRowSet.getString("fieldSn"));
            subManageData.put("budgetManage", subRowSet.getString("budgetManage"));
            String budgetItemId = subRowSet.getString("budgetItem");
            Map<String, Object> budgetItem = null;
            if (subItemColNameMap.get(budgetItemId) != null) {
                budgetItem = subItemColNameMap.get(budgetItemId);
            }
            subManageData.put("budgetItem", budgetItem);
            for (String colName : budgetPeriodColNames) {
                subManageData.put(colName, this.handleZero(subRowSet.getBigDecimal(colName)));
            }
            subManageDataList.add(subManageData);
        }
        result.put("subManageDataList", subManageDataList);
        return result;
    }

    @Override
    public Map<String, Object> getSubBudgetAssign(Context ctx, String budgetSchemeId) throws BOSException, SQLException, EASBizException {
        if (StringUtils.isEmpty((CharSequence)budgetSchemeId)) {
            return null;
        }
        CmpBudgetSchemeInfo schemeInfo = this.getSchemeInfo(ctx, budgetSchemeId);
        if (!this.hasSubEntry(schemeInfo)) {
            return null;
        }
        BudgetPeriodMapInfo subItemMap = this.getSubItemMapByScheme(ctx, schemeInfo);
        List<String> colNameList = subItemMap.getColNameList();
        List<String> fieldNameList = subItemMap.getFieldNameList();
        StringBuilder queryRatioSql = new StringBuilder();
        queryRatioSql.append("select fid");
        for (int i = 0; i < colNameList.size(); ++i) {
            queryRatioSql.append(",").append(fieldNameList.get(i)).append(" ").append(colNameList.get(i));
        }
        queryRatioSql.append(" from T_HR_SBudgetSchemeRatio where FBudgetSchemeID = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryRatioSql.toString(), (Object[])new Object[]{budgetSchemeId});
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (rs.next()) {
            for (String colName : colNameList) {
                resultMap.put(colName, this.handleZero(rs.getBigDecimal(colName)));
            }
        } else {
            int size = colNameList.size();
            for (int i = 0; i < size - 1; ++i) {
                resultMap.put(colNameList.get(i), 0);
            }
            resultMap.put(colNameList.get(size - 1), 100);
        }
        return resultMap;
    }

    @Override
    public boolean existApprovingEntry(Context ctx, String billId) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)billId)) {
            throw new BOSException("billId is null");
        }
        String querySql = "SELECT entry.fid FROM T_HR_SBudgetAdjustEntry entry inner join T_HR_SBudgetAdjustBill bill on entry.FBillID=bill.FId  where entry.fbillId = ?  and exists(select otherEntry.fid from T_HR_SBudgetAdjustEntry otherEntry inner join T_HR_SBudgetAdjustBill otherBill on otherEntry.FBillID=otherBill.FId  where otherEntry.FBillId <> ? and otherEntry.FAdminOrgUnitID=entry.FAdminOrgUnitID and otherEntry.FCostTypeID=entry.FCostTypeID and otherBill.FBudgetSchemeID = bill.FBudgetSchemeID and otherBill.FBillState in (1,2))";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{billId, billId});
        return rs.next();
    }

    @Override
    public List<String> existDisableManageData(Context ctx, String filterSql) throws EASBizException, BOSException {
        BudgetManageCollection manageCol = BudgetManageFactory.getLocalInstance(ctx).getBudgetManageCollection("select adminOrgUnit.name,costType.name where state = 2 " + filterSql);
        ArrayList<String> errorList = new ArrayList<String>();
        if (manageCol.isEmpty()) {
            return errorList;
        }
        Locale locale = ctx.getLocale();
        for (int i = 0; i < manageCol.size(); ++i) {
            BudgetManageInfo info = manageCol.get(i);
            if (info.getAdminOrgUnit() == null || info.getCostType() == null) continue;
            errorList.add(info.getAdminOrgUnit().getName(locale) + "-" + info.getCostType().getName(locale));
        }
        return errorList;
    }

    @Override
    public List<BudgetAdjustEntryParam> existApprovingBill(Context ctx, String budgetSchemeId, List<BudgetAdjustEntryParam> entryParams) throws BOSException, SQLException {
        if (budgetSchemeId == null || StringUtils.isEmpty((CharSequence)budgetSchemeId) || entryParams == null || entryParams.isEmpty()) {
            return null;
        }
        ArrayList<Object[]> batchInserTempParam = new ArrayList<Object[]>();
        for (BudgetAdjustEntryParam entryParam : entryParams) {
            ArrayList<String> insertParam = new ArrayList<String>();
            insertParam.add(entryParam.getAdminOrgUnitId());
            insertParam.add(entryParam.getCostTypeID());
            batchInserTempParam.add(insertParam.toArray());
        }
        String createInSql = BudgetAdjustSqlUtils.createTempTable(ctx, "t_hr_sbudgetmanage", "FAdminOrgUnitID,FCostTypeID", batchInserTempParam);
        String querySql = "SELECT bill1.fid billId,bill1.fnumber billNumber,manage1.FAdminOrgUnitID adminOrgUnitId,manage1.FCostTypeID costTypeId  FROM " + createInSql + " manage1  left join T_HR_SBudgetAdjustEntry entry1 on manage1.FAdminOrgUnitID = entry1.FAdminOrgUnitID and manage1.FCostTypeID=entry1.FCostTypeID  inner join T_HR_SBudgetAdjustBill bill1 on entry1.fbillid = bill1.fid and bill1.FBudgetSchemeID=?  where bill1.FBillState in (" + 1 + "," + 2 + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{budgetSchemeId});
        while (rs.next()) {
            String adminOrgUnitId = rs.getString("adminOrgUnitId");
            String costTypeId = rs.getString("costTypeId");
            if (StringUtils.isEmpty((CharSequence)adminOrgUnitId) || StringUtils.isEmpty((CharSequence)costTypeId)) continue;
            String billId = rs.getString("billId");
            String billNumber = rs.getString("billNumber");
            boolean existApproving = !StringUtils.isEmpty((CharSequence)billId);
            for (BudgetAdjustEntryParam param : entryParams) {
                if (!adminOrgUnitId.equals(param.getAdminOrgUnitId()) || !costTypeId.equals(param.getCostTypeID())) continue;
                param.setBillId(billId);
                param.setBillNumber(billNumber);
                param.setExistApproving(existApproving);
            }
        }
        return entryParams;
    }

    @Override
    public List<BudgetAdjustEntryParam> existApprovingBill(Context ctx, String curBillId, String budgetSchemeId, List<BudgetAdjustEntryParam> entryParams) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)curBillId) || StringUtils.isEmpty((CharSequence)budgetSchemeId) || entryParams == null || entryParams.isEmpty()) {
            return null;
        }
        ArrayList<Object[]> batchInserTempParam = new ArrayList<Object[]>();
        for (BudgetAdjustEntryParam entryParam : entryParams) {
            ArrayList<String> insertParam = new ArrayList<String>();
            insertParam.add(entryParam.getAdminOrgUnitId());
            insertParam.add(entryParam.getCostTypeID());
            batchInserTempParam.add(insertParam.toArray());
        }
        String createInSql = BudgetAdjustSqlUtils.createTempTable(ctx, "t_hr_sbudgetmanage", "FAdminOrgUnitID,FCostTypeID", batchInserTempParam);
        String querySql = "SELECT bill1.fid billId,bill1.fnumber billNumber,manage1.FAdminOrgUnitID adminOrgUnitId,manage1.FCostTypeID costTypeId  FROM " + createInSql + " manage1  left join T_HR_SBudgetAdjustEntry entry1 on manage1.FAdminOrgUnitID = entry1.FAdminOrgUnitID and manage1.FCostTypeID=entry1.FCostTypeID  inner join T_HR_SBudgetAdjustBill bill1 on entry1.fbillid = bill1.fid and bill1.FBudgetSchemeID=? and bill1.Fid <>? where bill1.FBillState in (" + 1 + "," + 2 + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{budgetSchemeId, curBillId});
        while (rs.next()) {
            String adminOrgUnitId = rs.getString("adminOrgUnitId");
            String costTypeId = rs.getString("costTypeId");
            if (StringUtils.isEmpty((CharSequence)adminOrgUnitId) || StringUtils.isEmpty((CharSequence)costTypeId)) continue;
            String billId = rs.getString("billId");
            String billNumber = rs.getString("billNumber");
            boolean existApproving = !StringUtils.isEmpty((CharSequence)billId);
            for (BudgetAdjustEntryParam param : entryParams) {
                if (!adminOrgUnitId.equals(param.getAdminOrgUnitId()) || !costTypeId.equals(param.getCostTypeID())) continue;
                param.setBillId(billId);
                param.setBillNumber(billNumber);
                param.setExistApproving(existApproving);
            }
        }
        return entryParams;
    }

    @Override
    public boolean existVersionDifferent(Context ctx, String billId, CmpBudgetSchemeInfo schemeInfo, boolean sync) throws BOSException, SQLException {
        String entryVersion = sync ? "FBackupVersion" : "FSyncVersion";
        String querySql = "SELECT entry.FBackupVersion,entry.FSyncVersion,manage.fdataversion,manage.fid manageid,entry.fid entryid,entry.FBudgetManageID entrymanageid FROM t_hr_sbudgetadjustentry entry  inner join t_hr_sbudgetadjustbill bill on bill.fid = entry.fbillid  left join t_hr_sbudgetmanage manage on entry.FAdminOrgUnitID=manage.FAdminOrgUnitID and entry.FCostTypeID=manage.FCostTypeID and bill.FBudgetSchemeID = manage.FBudgetSchemeID   where entry.fbillid = ?  and ( entry.fbackupversion=-1 and manage.fdataversion>entry." + entryVersion + " ) union SELECT entry.FBackupVersion,entry.FSyncVersion,manage.fdataversion,manage.fid manageid,entry.fid entryid,entry.FBudgetManageID entrymanageid FROM t_hr_sbudgetadjustentry entry  left join t_hr_sbudgetmanage manage on entry.FBudgetManageID=manage.fid   where entry.fbillid = ?  and ( entry.fbackupversion <>-1 and (manage.fdataversion is null or manage.fdataversion<>entry." + entryVersion + "))";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{billId, billId});
        return rs.next();
    }

    @Override
    public String updateManageVersion(Context ctx, List<String> manageIds, boolean versionPosition) {
        if (manageIds == null || manageIds.isEmpty()) {
            return null;
        }
        String inSql = CmpStrUtil.concatList(manageIds);
        StringBuilder sqlVersion = new StringBuilder();
        String updateVersion = !versionPosition ? "fDataVersion+1" : "fDataVersion-1";
        sqlVersion.append("update t_hr_sBudgetManage set fDataVersion = case when fDataVersion is null then 0 else ").append(updateVersion).append(" end  where fid in ").append(inSql);
        try {
            DbUtil.execute((Context)ctx, (String)sqlVersion.toString());
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void executeBatchSql(Context ctx, String executeSql, List<Object[]> executeParams) throws BOSException {
        if (!executeParams.isEmpty() && !StringUtils.isEmpty((CharSequence)executeSql)) {
            CmpSQLUtil.executeBatch(ctx, executeSql, executeParams);
        }
    }

    @Override
    public BigDecimal handleZero(BigDecimal value) {
        return BudgetAdjustSqlUtils.handleZero(value);
    }

    @Override
    public boolean submitNotEntry(Context ctx, String billId) throws BOSException, SQLException, EASBizException {
        return !BudgetAdjustEntryFactory.getLocalInstance(ctx).exists("where bill.id='" + billId + "'");
    }

    @Override
    public boolean submitValidateRuleError(Context ctx, String billId) throws EASBizException, BOSException {
        return BudgetAdjustEntryFactory.getLocalInstance(ctx).exists("where bill.id='" + billId + "' and forwarnContent is not null");
    }

    @Override
    public Map<String, Object> getSubManageData(Context ctx, String subManageIdsStr, String budgetSchemeId) throws EASBizException, BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)subManageIdsStr) || StringUtils.isEmpty((CharSequence)budgetSchemeId)) {
            return null;
        }
        subManageIdsStr = StringEscapeUtils.escapeSql((String)subManageIdsStr);
        CmpBudgetSchemeInfo schemeInfo = null;
        schemeInfo = this.getSchemeInfo(ctx, budgetSchemeId);
        if (!this.hasSubEntry(schemeInfo)) {
            return null;
        }
        BudgetPeriodMapInfo subItemMap = this.getSubItemMapByScheme(ctx, schemeInfo);
        List<String> budgetPeriodFields = subItemMap.getFieldNameList();
        List<String> budgetPeriodColNames = subItemMap.getColNameList();
        String createInSql = CmpSQLUtil.createInSql(ctx, StringEscapeUtils.escapeSql((String)subManageIdsStr), "t_hr_ssubbudgetmanage", "fid");
        String querySubManageSql = BudgetAdjustSqlUtils.querySubManageSql(budgetPeriodFields, budgetPeriodColNames, "and submanage.fid in (" + createInSql + ")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySubManageSql);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        while (rs.next()) {
            HashMap<String, BigDecimal> rowMap = new HashMap<String, BigDecimal>();
            String subManageId = rs.getString("subBudgetManage");
            for (String colName : budgetPeriodColNames) {
                rowMap.put(colName, rs.getBigDecimal(colName));
            }
            resultMap.put(subManageId, rowMap);
        }
        return resultMap;
    }

    @Override
    public void deleteSubEntryByEntryIds(Context ctx, Set<String> entryIds) throws BOSException {
        if (entryIds == null || entryIds.isEmpty()) {
            return;
        }
        CmpInSql<String> sqlUtil = CmpInSqlFactory.getInstance();
        String createInsql = sqlUtil.createInSqlBaseOnFId(ctx, entryIds);
        String sql = "delete from T_HR_SSubBudgetAdjustEntry where FYearBudgetEntryID in " + createInsql + "";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    public boolean existNewEntryExpenseData(Context ctx, String billId, List<String> manageExpenseIdList) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)billId) || manageExpenseIdList == null || manageExpenseIdList.isEmpty()) {
            return false;
        }
        String queryEntrySql = "select fid from t_hr_sbudgetadjustentry where FBillId = ? and fbackupversion=-1 and FBudgetManageID in (" + CmpStrUtil.convertListToString(manageExpenseIdList) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryEntrySql, (Object[])new Object[]{billId});
        return rs.next();
    }

    @Override
    public boolean existNewEntrySnapshot(Context ctx, String billId, CmpBudgetSchemeInfo schemeInfo) throws BOSException, SQLException {
        String standingBookIdFieldName;
        String snapshotTable;
        String schemeTable;
        if (schemeInfo == null || schemeInfo.getTemplate() == null) {
            return false;
        }
        BudgetTemplateTypeEnum templateType = schemeInfo.getTemplate().getTemplateType();
        if (templateType == BudgetTemplateTypeEnum.SALARY_TYPE) {
            schemeTable = "T_HR_SCalScheme";
            snapshotTable = "T_HR_BudgetSnapshotTotalCmp";
            standingBookIdFieldName = "FCmpStandingBookID";
        } else if (templateType == BudgetTemplateTypeEnum.SPIRE_TYPE || templateType == BudgetTemplateTypeEnum.SUBMIT_TYPE) {
            schemeTable = "T_HR_SCalSubmitScheme";
            snapshotTable = "T_HR_SBudgetSnapshot";
            standingBookIdFieldName = "FBookTableId";
        } else {
            throw new BOSException("not supported template type");
        }
        String querySql = "select manage1.fid manageId from T_HR_SBudgetManage manage1  inner join T_HR_SBudgetAdjustEntry entry1 on entry1.FBudgetManageID = manage1.fid and entry1.FBackupVersion=-1 inner join T_HR_SCmpBudgetScheme budgetScheme on budgetScheme.fid = manage1.FBudgetSchemeID  inner join T_HR_SBudgetTemplate template on template.fid = budgetScheme.FTemplateID  inner join " + schemeTable + " submitScheme on submitScheme.FBudgetTemplateID = template.fid  inner join T_HR_SCmpStandingBook bookTable on bookTable.FBudgetManageID = manage1.fid inner join " + snapshotTable + " shot on shot." + standingBookIdFieldName + " = bookTable.fid  where entry1.FBillId = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{billId});
        return rs.next();
    }
}

