/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.result.analysis;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.File;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class GetClassFromInterface {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.result.analysis.GetClassFromInterface");
    public static Map<String, List<Class<?>>> classMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Class<?>> getAllClass(Context ctx, Class<?> interfaceClass) throws Exception {
        if (classMap.containsKey(interfaceClass.toString())) return classMap.get(interfaceClass.toString());
        Class<GetClassFromInterface> clazz = GetClassFromInterface.class;
        synchronized (GetClassFromInterface.class) {
            if (classMap.containsKey(interfaceClass.toString())) return classMap.get(interfaceClass.toString());
            List<Class<?>> classList = GetClassFromInterface.getAchieveClassByInterface(ctx, interfaceClass);
            classMap.put(interfaceClass.toString(), classList);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return classMap.get(interfaceClass.toString());
        }
    }

    private static List<Class<?>> getAchieveClassByInterface(Context ctx, Class<?> interfaceClass) throws Exception {
        ArrayList classList = new ArrayList();
        String sql = "select FImplClassStr from T_HR_SCmpCalResuleHandle where FInterFaceStr = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interfaceClass.getName()});
        while (rowSet.next()) {
            String implClassStr = rowSet.getString("FImplClassStr");
            try {
                Class<?> implClass = Class.forName(implClassStr);
                classList.add(implClass);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        GetClassFromInterface.afterGetClass(classList, interfaceClass);
        return classList;
    }

    private static List<Class<?>> getAchieveClassByInterface(Class<?> interfaceClass) throws Exception {
        String packageName = interfaceClass.getPackage().getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace(".", "/");
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> files = new ArrayList<File>();
        ArrayList classList = new ArrayList();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (null == url) continue;
            String type = url.getProtocol();
            if ("file".equals(type)) {
                String newPath = url.getFile().replace("20%", " ");
                files.add(new File(newPath));
                continue;
            }
            if (!"jar".equals(type)) continue;
            JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            GetClassFromInterface.getClassNameByJar(classList, jarFile, path);
        }
        for (int i = 0; i < files.size(); ++i) {
            GetClassFromInterface.findClass(classList, (File)files.get(i), packageName);
        }
        return classList;
    }

    private static void findClass(List<Class<?>> classList, File file, String packageName) throws Exception {
        File[] files;
        if (!file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                GetClassFromInterface.findClass(classList, f, packageName + "." + f.getName());
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            classList.add(Class.forName(packageName + "." + f.getName().substring(0, f.getName().length() - 6)));
        }
    }

    private static void afterGetClass(List<Class<?>> classList, Class<?> interfaceClass) throws Exception {
        for (int i = classList.size() - 1; i >= 0; --i) {
            Class<?>[] interfaces;
            boolean isChild = false;
            if (classList.get(i).isInterface() || Modifier.isAbstract(classList.get(i).getModifiers())) {
                classList.remove(i);
                continue;
            }
            for (Class<?> c : interfaces = classList.get(i).getSuperclass().getInterfaces()) {
                if (!c.equals(interfaceClass)) continue;
                isChild = true;
                break;
            }
            if (isChild) continue;
            classList.remove(i);
        }
    }

    private static void getClassNameByJar(List<Class<?>> classList, JarFile jarFile, String packagePath) {
        try {
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.startsWith(packagePath) || !entryName.endsWith(".class")) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                classList.add(Class.forName(entryName));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("getClassNameByJar error:" + e.getMessage());
        }
    }
}

