/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.integrate.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.entity.Pair;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.DateTypeEnum;
import com.kingdee.shr.compensation.exception.SubmitBillVerifyException;
import com.kingdee.shr.compensation.integrate.verify.ISubmitBillVerifyInterface;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateEntryHelper;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSubmitBillVerify
implements ISubmitBillVerifyInterface {
    @Override
    public void verify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException, EASBizException {
        this.beforeVerify(ctx, model, otherParams);
        this.runVerify(ctx, model, otherParams);
        this.afterVerify(ctx, model, otherParams);
    }

    protected void beforeVerify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException, EASBizException {
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        this.verifyBillState(ctx, (CoreBaseInfo)info);
    }

    protected void verifyBillState(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        BatchSubmitShemeBillCollection colsInDB = BatchSubmitShemeBillFactory.getLocalInstance(ctx).getBatchSubmitShemeBillCollection("select billState where id = '" + info.getId().toString() + "'");
        if (colsInDB.isEmpty()) {
            return;
        }
        HRBillStateEnum billState = colsInDB.get(0).getBillState();
        if (HRBillStateEnum.SAVED != billState && HRBillStateEnum.SUBMITED != billState) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION4);
        }
    }

    protected void runVerify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException, EASBizException {
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        this.verifyRemovedCmpFile(ctx, info);
        this.verifyCmpEmpRe(ctx, info);
        this.verifySubmitPeriod(ctx, info);
    }

    protected void verifyRemovedCmpFile(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        String billEntryTable = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId(ctx, info.getSubmitScheme().getId().toString());
        String sqlTemplate = "SELECT entry.fpersonId, person.FName_%s personName, person.FNumber personNum FROM %s entry LEFT JOIN T_BD_PERSON person ON entry.FPersonId = person.Fid WHERE NOT EXISTS(SELECT 1 FROM T_HR_SCmpEmpORelation empOrel WHERE entry.FCmpEmpORelationID = empOrel.FID) AND entry.fbillId = '%s'";
        HashSet<String> nameAndNumSet = new HashSet<String>();
        String personHint = SHRServerResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label195", (Locale)ctx.getLocale());
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)String.format(sqlTemplate, LocaleUtils.getShortCode((Locale)ctx.getLocale()), billEntryTable, info.getId().toString()));
            while (rs.next()) {
                nameAndNumSet.add(MessageFormat.format(personHint, rs.getString("personName"), rs.getString("personNum")));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (!nameAndNumSet.isEmpty()) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION1, nameAndNumSet.toArray());
        }
    }

    protected void afterVerify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException {
    }

    protected void verifyCmpEmpRe(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        BatchSubmitShemeBillEntryCollection coll;
        Map<String, Pair<java.util.Date, java.util.Date>> empCmpRelationsFromDb = this.getEmpCmpRelationsFromDb(ctx, info);
        if (empCmpRelationsFromDb.isEmpty()) {
            return;
        }
        HashSet<String> errorPersons = new HashSet<String>();
        DateTypeEnum effectDateDisplay = null;
        CalSubmitSchemeCollection submitScheme = CalSubmitSchemeFactory.getLocalInstance(ctx).getCalSubmitSchemeCollection("where id = '" + info.getSubmitScheme().getId().toString() + "'");
        if (submitScheme != null && submitScheme.size() > 0) {
            effectDateDisplay = submitScheme.get(0).getEffectDateDisplay();
        }
        if ((coll = info.getEntry()) != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                BatchSubmitShemeBillEntryInfo entryInfo = coll.get(i);
                String employeeTypeId = entryInfo.getCmpEmpORelation().getId().toString();
                java.util.Date entryDate = entryInfo.getEffectDate();
                String personId = entryInfo.getPerson().getId().toString();
                String positionId = entryInfo.getPosition().getId().toString();
                Pair<java.util.Date, java.util.Date> pair = empCmpRelationsFromDb.get(personId + "_" + positionId + "_" + employeeTypeId);
                if (null == pair) continue;
                java.util.Date effectDate = pair.getFirst();
                java.util.Date leffectDate = pair.getSecond();
                String personName = this.getPersonNameIfVerified(entryInfo);
                if (effectDateDisplay == DateTypeEnum.yyyyMM) {
                    if (CmpDateUtil.compareMonth(entryDate, effectDate) >= 0 && CmpDateUtil.compareMonth(entryDate, leffectDate) <= 0) continue;
                    errorPersons.add(personName);
                    continue;
                }
                if (entryDate.compareTo(effectDate) >= 0 && entryDate.compareTo(leffectDate) <= 0) continue;
                errorPersons.add(personName);
            }
        }
        int maxSize = 30;
        int size = 1;
        StringBuilder errorMessage = new StringBuilder();
        for (String errorPersonName : errorPersons) {
            if (maxSize <= size) break;
            errorMessage.append(errorPersonName).append("\u3001");
            ++size;
        }
        if (errorMessage.length() > 0) {
            String message = errorMessage.substring(0, errorMessage.length() - 1);
            if (size == maxSize) {
                message = message + "...";
            }
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION5, new Object[]{message});
        }
    }

    protected String getPersonNameIfVerified(BatchSubmitShemeBillEntryInfo entryInfo) throws EASBizException {
        String personName = entryInfo.getPerson().getName();
        if (StringUtils.isEmpty((CharSequence)personName)) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.PERSON_PERM_ERROR);
        }
        return personName;
    }

    protected Map<String, Pair<java.util.Date, java.util.Date>> getEmpCmpRelationsFromDb(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        BatchSubmitShemeBillEntryCollection coll = info.getEntry();
        HashSet<String> personIds = new HashSet<String>();
        boolean personIsNull = false;
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getPerson() == null || coll.get(i).getPerson().getId() == null) {
                personIsNull = true;
                continue;
            }
            personIds.add(coll.get(i).getPerson().getId().toString());
        }
        if (personIsNull) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION9);
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String personInSql = cmpInSql.createInSqlBaseOnFId(ctx, personIds);
        String hrOrgUnitId = info.getHrOrgUnit().getId().toString();
        String adminOrgId = info.getAdminOrg().getId().toString();
        String longNumber = this.getLongNumber(ctx, adminOrgId);
        StringBuilder filter = new StringBuilder();
        String sql = "select p.Fid personId, p.FNumber, ce.FEffectDate, ce.FLeffectDate, pt.Fid positionId,ce.Fid employeeTypeId  FROM T_HR_SCmpEmpORelation AS ce  INNER JOIN T_HR_SPersonCmp AS pc ON ce.FPersonCmpID = pc.FID  INNER JOIN T_HR_EmpOrgRelation AS er ON ce.FEmpOrgRelationID = er.FID  INNER JOIN T_BD_Person AS p ON ce.FPersonID = p.FID  INNER JOIN T_ORG_HRO AS h ON pc.FHrOrgUnitID = h.FID  LEFT OUTER JOIN T_ORG_Admin AS ad ON er.FAdminOrgID = ad.FID  LEFT OUTER JOIN T_ORG_Position AS pt ON er.FPositionID = pt.FID LEFT OUTER JOIN T_HR_EmpLaborRelationHis AS re ON er.FlaborRelationID =re.FHistoryRelateID and er.FEndDateTime >=re.FStartDateTime and er.FEndDateTime <=re.FEndDateTime LEFT OUTER JOIN T_HR_BDEmployeeType AS et ON re.FLaborRelationStateID =et.FID ";
        filter.append(sql);
        filter.append(" where h.FID = '").append(hrOrgUnitId).append("'");
        filter.append(" and ((ad.flongNumber LIKE '").append(longNumber).append("%' and ce.fuseDefault=1) or ce.fuseDefault=0)");
        filter.append(" and p.FID in").append(personInSql);
        HashMap<String, Pair<java.util.Date, java.util.Date>> dbMap = new HashMap<String, Pair<java.util.Date, java.util.Date>>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)filter.toString());
            while (rs.next()) {
                Pair<Date, Date> pair = new Pair<Date, Date>();
                Date effectDate = rs.getDate("FEffectDate");
                Date leffectDate = rs.getDate("FLeffectDate");
                pair.setFirst(effectDate);
                pair.setSecond(leffectDate);
                String personIdDB = rs.getString("personId");
                String positionIdDB = rs.getString("positionId");
                String employeeTypeId = rs.getString("employeeTypeId");
                dbMap.put(personIdDB + "_" + positionIdDB + "_" + employeeTypeId, pair);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        cmpInSql.release(ctx);
        return dbMap;
    }

    protected String getLongNumber(Context ctx, String id) throws BOSException {
        String sql = "select FLongNumber from T_ORG_Admin where fid = '" + id + "'";
        String longNumber = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                longNumber = rs.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return longNumber;
    }

    protected void checkBillNumber(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        boolean flag = BatchSubmitShemeBillFactory.getLocalInstance(ctx).exists("where number = '" + number + "' and id <> '" + info.getId().toString() + "'");
        if (flag) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION6, new Object[]{number});
        }
    }

    protected void verifySubmitPeriod(Context ctx, BatchSubmitShemeBillInfo info) throws EASBizException, BOSException {
    }

    protected String getMultiLan(Context ctx, String label) {
        return SHRServerResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)label, (Locale)ctx.getLocale());
    }
}

