/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.confirm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelMatchDataInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelState;
import com.kingdee.shr.compensation.app.intelligent.HandleTypeEnum;
import com.kingdee.shr.compensation.intelligent.biz.CmpIntelCalSchemeHelper;
import com.kingdee.shr.compensation.intelligent.confirm.AbstractCmpIntelConfirm;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.CmpTaxUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CalSchemeIncreasePersonConfirm
extends AbstractCmpIntelConfirm {
    protected Context ctx;
    protected List<CmpIntelMatchDataInfo> matchDataInfos;

    @Override
    public Map<String, Object> confirm() throws EASBizException, BOSException {
        List<CmpIntelMatchDataInfo> matchDatas = this.getMatchDataInfos();
        ArrayList<CmpIntelMatchDataInfo> autoAddDatas = new ArrayList<CmpIntelMatchDataInfo>();
        ArrayList<CmpIntelMatchDataInfo> handAddDatas = new ArrayList<CmpIntelMatchDataInfo>();
        String errorMsg = "";
        CmpIntelState state = null;
        HandleTypeEnum handleType = null;
        CmpIntelMatchDataInfo matchDataInfo = null;
        int size = matchDatas.size();
        for (int i = 0; i < size; ++i) {
            matchDataInfo = matchDatas.get(i);
            state = matchDataInfo.getState();
            if (CmpIntelState.CONFIRMED.equals((Object)state)) {
                String label25;
                errorMsg = label25 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label25", (Locale)this.ctx.getLocale());
                continue;
            }
            handleType = matchDataInfo.getHandleType();
            if (handleType.equals((Object)HandleTypeEnum.AUTO)) {
                autoAddDatas.add(matchDataInfo);
                continue;
            }
            handAddDatas.add(matchDataInfo);
        }
        Map<String, Object> confirmMap = this.getConfirmMap(autoAddDatas, handAddDatas);
        if (CmpStrUtil.isNotEmpty(errorMsg)) {
            confirmMap.put("errorMsg", errorMsg);
        }
        return confirmMap;
    }

    private Map<String, Object> getConfirmMap(List<CmpIntelMatchDataInfo> autoAddDatas, List<CmpIntelMatchDataInfo> handAddDatas) throws BOSException {
        Set addPersonSet;
        Set calSchemeIDSet;
        CmpTaxUtil cmpTaxUtil;
        Map calSchemeAddPerson;
        String addPeronSql;
        List addParams;
        Set successSet;
        int successSize = 0;
        String errorMsg = "";
        this.cacheMap = this.getCacheMap();
        HashMap<String, Object> confirmMap = new HashMap<String, Object>();
        CmpIntelCalSchemeHelper helper = CmpIntelCalSchemeHelper.getInstance();
        if (autoAddDatas.size() > 0) {
            Map<String, Object> autoMap = helper.addSchemeResultAuto(this.ctx, autoAddDatas, this.cacheMap);
            successSet = (Set)autoMap.get("successSet");
            addParams = (List)autoMap.get("addParams");
            errorMsg = (String)autoMap.get("errorMsg");
            if (addParams.size() > 0) {
                addPeronSql = helper.getAddPeronSql(this.ctx);
                DbUtil.executeBatch((Context)this.ctx, (String)addPeronSql, (List)addParams);
                calSchemeAddPerson = (Map)autoMap.get("calSchemeAddPerson");
                cmpTaxUtil = new CmpTaxUtil();
                calSchemeIDSet = calSchemeAddPerson.keySet();
                for (CalSchemeInfo calScheme : calSchemeIDSet) {
                    addPersonSet = (Set)calSchemeAddPerson.get(calScheme);
                    cmpTaxUtil.updateTaxUnit(this.ctx, addPersonSet, calScheme);
                }
                this.changeState(successSet);
                successSize += ((Integer)autoMap.get("successSize")).intValue();
            }
        }
        if (handAddDatas.size() > 0) {
            Map<String, Object> handMap = helper.addSchemeResultHand(this.ctx, handAddDatas);
            successSet = (Set)handMap.get("successSet");
            addParams = (List)handMap.get("addParams");
            errorMsg = (String)handMap.get("errorMsg");
            if (addParams.size() > 0) {
                addPeronSql = helper.getAddPeronSql(this.ctx);
                DbUtil.executeBatch((Context)this.ctx, (String)addPeronSql, (List)addParams);
                calSchemeAddPerson = (Map)handMap.get("calSchemeAddPerson");
                cmpTaxUtil = new CmpTaxUtil();
                calSchemeIDSet = calSchemeAddPerson.keySet();
                for (CalSchemeInfo calScheme : calSchemeIDSet) {
                    addPersonSet = (Set)calSchemeAddPerson.get(calScheme);
                    cmpTaxUtil.updateTaxUnit(this.ctx, addPersonSet, calScheme);
                }
                this.changeState(successSet);
                successSize += ((Integer)handMap.get("successSize")).intValue();
            }
        }
        confirmMap.put("successSize", successSize);
        confirmMap.put("errorMsg", errorMsg);
        return confirmMap;
    }

    @Override
    public Context getCtx() {
        return this.ctx;
    }

    @Override
    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setMatchDataInfos(List<CmpIntelMatchDataInfo> matchDataInfos) {
        this.matchDataInfos = matchDataInfos;
    }

    @Override
    public List<CmpIntelMatchDataInfo> getMatchDataInfos() {
        return this.matchDataInfos;
    }
}

