/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.BizManageState;
import com.kingdee.shr.base.bizmanage.DataSource;
import com.kingdee.shr.base.bizmanage.ItemState;
import com.kingdee.shr.base.bizmanage.PersonBURelationCollection;
import com.kingdee.shr.base.bizmanage.PersonBURelationFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.base.bizmanage.util.BatchPromptsInfo;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageHelpUtil;
import com.kingdee.shr.compensation.record.PersonBizManageImp;
import com.kingdee.shr.compensation.record.assemble.RecordUtil;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.record.factory.AbstractEmpOrgRelation;
import com.kingdee.shr.compensation.record.factory.AbstractRecord;
import com.kingdee.shr.compensation.record.operate.RecordOperateInterface;
import com.kingdee.shr.compensation.record.util.RecordInstanceFactory;
import com.kingdee.shr.compensation.record.validator.RecordValidator;
import com.kingdee.shr.compensation.record.validator.RocordValidatorInfo;
import com.kingdee.shr.compensation.sql.record.CmpRecordSQL;
import com.kingdee.shr.compensation.sql.record.RecordCommonSQL;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpPBManageImpl
extends PersonBizManageImp {
    private Logger logger = Logger.getLogger(CmpPBManageImpl.class);
    private RecordValidator validator = RecordInstanceFactory.getRecordValidatorInstance(RecordInstanceFactory.CATEGORY.CMP);
    private AbstractEmpOrgRelation cmpORelation = RecordInstanceFactory.getRelationInstance(RecordInstanceFactory.CATEGORY.CMP);
    private RecordOperateInterface operate = RecordInstanceFactory.getRecordOperateInstance(RecordInstanceFactory.CATEGORY.CMP);

    public Map batchEnablePersonBizManage(Context ctx, List<String> list) throws BOSException, EASBizException {
        if ((list = this.beforeBatchEnablePersonBizManage(ctx, list)).size() == 0) {
            return null;
        }
        this.operate.enablePBURelation(ctx, list);
        return null;
    }

    public IObjectPK[] batchAddNewPersonBizManage(Context ctx, List<PersonBURelationInfo> list) throws BOSException, EASBizException {
        CoreBaseCollection coll = new CoreBaseCollection();
        ArrayList<ObjectUuidPK> listObjectPK = new ArrayList<ObjectUuidPK>();
        for (PersonBURelationInfo info : list) {
            String hrOrgUnitID;
            String bizManageTypeID;
            String personID;
            String empOrgRelationID = info.getEmpOrgRelation().getId().toString();
            if (!CmpPBManageImpl.checkPersonBURelationExist((Context)ctx, (String)empOrgRelationID, (String)(personID = info.getPerson().getId().toString()), (String)(bizManageTypeID = info.getBizManageType().getId().toString()), (String)(hrOrgUnitID = info.getHrOrgUnit().getId().toString()), (String)"0,1")) {
                info.setState(BizManageState.New);
                info.setItemState(ItemState.unsubmit);
                boolean isDefault = SHRBizManageHelpUtil.isPerosnBuRelationDefault((Context)ctx, (String)info.getBizManageType().getId().toString(), (String)info.getEmpOrgRelation().getId().toString(), (String)info.getHrOrgUnit().getId().toString());
                info.setUseDefault(isDefault);
                if (info.getDataSource() == null) {
                    info.setDataSource(DataSource.ChangeOperation);
                }
                coll.add((CoreBaseInfo)info);
                continue;
            }
            String sql = "SELECT FID FROM T_HR_PersonBURelation WHERE FEmpOrgRelationID = '" + empOrgRelationID + "' AND FPERSONID = '" + personID + "' AND FBizManageTypeID = '" + bizManageTypeID + "' AND FHrOrgUnitID = '" + hrOrgUnitID + "' AND FState IN (0, 1)";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (executeQuery.next()) {
                    String id = executeQuery.getString("fid");
                    ObjectUuidPK objectPK = new ObjectUuidPK(id);
                    listObjectPK.add(objectPK);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Object[] objectPkArr = PersonBURelationFactory.getLocalInstance((Context)ctx).addnewBatchData(coll);
        listObjectPK.addAll(Arrays.asList((Object[])objectPkArr));
        return listObjectPK.toArray(new IObjectPK[listObjectPK.size()]);
    }

    public List<BatchPromptsInfo> checkBeforeDeletePersonBizManageByPersonId(Context ctx, List<String> personIdList, String bizManageTypeId, boolean isEmpInitDelete) throws BOSException, EASBizException {
        ArrayList<BatchPromptsInfo> list = new ArrayList<BatchPromptsInfo>();
        int size = personIdList.size();
        for (int i = 0; i < size; ++i) {
            List<RecordDataInfo> info = this.validator.deletePersonReturnList(ctx, personIdList.get(i));
            if (null == info || info.size() == 0) continue;
            for (int j = 0; j < info.size(); ++j) {
                RecordDataInfo dataInfo = info.get(j);
                if (dataInfo == null || CmpStrUtil.isEmpty(dataInfo.getPersonId())) continue;
                BatchPromptsInfo param = new BatchPromptsInfo();
                param.setDomain(dataInfo.getDomain());
                param.setModules(dataInfo.getModules());
                if ("CALTABLE".equals(dataInfo.getOperation())) {
                    param.setOperation(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label68", (Locale)ctx.getLocale()));
                } else {
                    param.setOperation(dataInfo.getOperation());
                }
                param.setPersonId(dataInfo.getPersonId());
                param.setDesc(dataInfo.getMsg());
                list.add(param);
            }
        }
        return list;
    }

    public Map deletePersonBizManageByPersonId(Context ctx, List<String> personIdList, String bizManageTypeId, boolean isEmpInitDelete) throws BOSException, EASBizException {
        String personIds = CmpStrUtil.convertListToString(personIdList);
        String recordIdSql = "select fid from T_HR_SPersonCmp where FPersonId in (" + personIds + ")";
        CmpSQLUtil.execute(ctx, "delete from T_HR_STaxSumCumulation where FPersonID in (select FPersonId from T_HR_SPersonCmp where fid in (" + recordIdSql + ") ) ");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SCmpIntelMatchData where FPersonID in (select FPersonId from T_HR_SPersonCmp where fid in (" + recordIdSql + ") ) ");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SCalResultEditedLog where FPersonID in (select FPersonId from T_HR_SPersonCmp where fid in (" + recordIdSql + ") ) ");
        CmpSQLUtil.execute(ctx, "delete from T_HR_FixAdjustSalaryRecord where FPersonID in (select FPersonId from T_HR_SPersonCmp where fid in (" + recordIdSql + ") ) ");
        AbstractRecord cmpRecord = RecordInstanceFactory.getRecordInstance(RecordInstanceFactory.CATEGORY.CMP);
        cmpRecord.deleteRecords(ctx, recordIdSql, true);
        super.deletePersonBizManageByPersonId(ctx, personIdList, bizManageTypeId, isEmpInitDelete);
        return null;
    }

    @Override
    public List<BatchPromptsInfo> checkRecoverEmpOrgRelation(Context ctx, List<String> empRelaIdList) throws BOSException, EASBizException {
        ArrayList<BatchPromptsInfo> list = new ArrayList<BatchPromptsInfo>();
        ArrayList<String> billIdList = new ArrayList<String>();
        HashSet<String> personSet = new HashSet<String>();
        String empIds = CmpStrUtil.convertListToString(empRelaIdList);
        String sql = "select fid, FPersonId from T_HR_SCmpEmpORelation where FEmpOrgRelationID in (" + empIds + ")";
        IRowSet r = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (r.next()) {
                if (billIdList.contains(r.getString(1))) continue;
                personSet.add(r.getString(2));
                billIdList.add(r.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (billIdList.size() > 0) {
            String returnValue = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"is_allow_empOrgRelationRecoverying", null, (boolean)true);
            for (int i = 0; i < billIdList.size(); ++i) {
                List<RocordValidatorInfo> info = this.validator.deleteEmpRelationReturnList(ctx, (String)billIdList.get(i));
                if (null == info || info.size() == 0) continue;
                for (int j = 0; j < info.size(); ++j) {
                    RocordValidatorInfo dataInfo = info.get(j);
                    if (dataInfo == null || CmpStrUtil.isEmpty(dataInfo.getCode())) continue;
                    BatchPromptsInfo param = new BatchPromptsInfo();
                    if ("CALTABLE".equals(dataInfo.getOperation())) {
                        if ("true".equalsIgnoreCase(returnValue)) {
                            param.setOperation(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label69", (Locale)ctx.getLocale()));
                        } else {
                            param.setOperation(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label70", (Locale)ctx.getLocale()));
                        }
                    } else {
                        param.setOperation(dataInfo.getOperation());
                    }
                    param.setDomain(dataInfo.getDomain());
                    param.setModules(dataInfo.getModules());
                    param.setPersonId(dataInfo.getCode());
                    param.setDesc(dataInfo.getMsg());
                    list.add(param);
                }
            }
        }
        return list;
    }

    @Override
    public Map<String, String> recoverEmpOrgRelation(Context ctx, List<String> empRelaIdList) throws BOSException, EASBizException {
        for (int i = 0; i < empRelaIdList.size(); ++i) {
            int state = 1;
            EmpPosOrgRelationCollection coll = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(" where id = '" + empRelaIdList.get(i) + "'");
            if (null != coll && coll.size() > 0 && coll.get(0).getAssignType().getValue() == 0) {
                state = 5;
            }
            String sql = CmpRecordSQL.updateCalTableEmpState(state, empRelaIdList.get(i));
            DbUtil.execute((Context)ctx, (String)sql);
            StringBuffer str = new StringBuffer();
            str.append(" delete from T_HR_SCmpIntelMatchData where FPbuConfirmID in(");
            str.append(" select fid from T_HR_PersonBURelaConfirm where FNewEmpOrgRelationID  = '" + empRelaIdList.get(i) + "' ");
            str.append(" ) and fstate in ('10','0')");
            DbUtil.execute((Context)ctx, (String)str.toString());
            this.cmpORelation.undoRelations(ctx, empRelaIdList.get(i));
        }
        return super.recoverEmpOrgRelation(ctx, empRelaIdList);
    }

    public List<BatchPromptsInfo> checkBeforeEnrollErrorModifyPersonBizManageByBURelaDataId(Context ctx, List<String> empRelaIdList, List<String> personBURelaIdList, String bizManageTypeId) throws BOSException, EASBizException {
        ArrayList<BatchPromptsInfo> list = new ArrayList<BatchPromptsInfo>();
        ArrayList<String> billIdList = new ArrayList<String>();
        HashSet<String> personSet = new HashSet<String>();
        empRelaIdList = this.getRecoverEmpOrgRelation(ctx, empRelaIdList);
        String empIds = CmpStrUtil.convertListToString(empRelaIdList);
        String sql = "select fid, FPersonId from T_HR_SCmpEmpORelation where FEmpOrgRelationID in (" + empIds + ")";
        IRowSet r = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (r.next()) {
                if (billIdList.contains(r.getString(1))) continue;
                personSet.add(r.getString(2));
                billIdList.add(r.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (billIdList.size() > 0) {
            String returnValue = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"is_allow_adjustEmpEnrollErroring", null, (boolean)true);
            for (int i = 0; i < billIdList.size(); ++i) {
                List<RocordValidatorInfo> info = this.validator.deleteEmpRelationReturnList(ctx, (String)billIdList.get(i));
                if (null == info || info.size() == 0) continue;
                for (int j = 0; j < info.size(); ++j) {
                    RocordValidatorInfo dataInfo = info.get(j);
                    if (dataInfo == null || CmpStrUtil.isEmpty(dataInfo.getCode())) continue;
                    BatchPromptsInfo param = new BatchPromptsInfo();
                    if ("CALTABLE".equals(dataInfo.getOperation())) {
                        if ("true".equalsIgnoreCase(returnValue)) {
                            param.setOperation(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label71", (Locale)ctx.getLocale()));
                        } else {
                            param.setOperation(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label72", (Locale)ctx.getLocale()));
                        }
                    } else {
                        param.setOperation(dataInfo.getOperation());
                    }
                    param.setDomain(dataInfo.getDomain());
                    param.setModules(dataInfo.getModules());
                    param.setPersonId(dataInfo.getCode());
                    param.setDesc(dataInfo.getMsg());
                    list.add(param);
                }
            }
        }
        return list;
    }

    public Map<String, String> enrollErrorModifyPersonBizManageByBURelaDataId(Context ctx, List<String> empRelaIdList, List<String> personBURelaIdList, String bizManageTypeId) throws BOSException, EASBizException {
        String oldHrId = null;
        String newHrId = null;
        String empIds = CmpStrUtil.convertListToString(empRelaIdList);
        String empSql = CmpRecordSQL.getPBUIdByEmpORelation(empIds);
        IRowSet empRowSet = CmpSQLUtil.executeQuery(ctx, empSql);
        try {
            while (empRowSet.next()) {
                String empId = empRowSet.getString("FEmpOrgRelationID");
                String pbuSqlId = "'" + empRowSet.getString("FPersonBURelId") + "'";
                String sql = CmpRecordSQL.updateCalTableEmpState(2, empId);
                DbUtil.execute((Context)ctx, (String)sql);
                sql = RecordCommonSQL.getHrOrgUnitByEmp(empId, bizManageTypeId);
                IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sql);
                try {
                    if (rowSet.next()) {
                        newHrId = rowSet.getString("hrOrgUnit");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (CmpStrUtil.isEmpty(newHrId)) {
                    return null;
                }
                if (CmpStrUtil.isEmpty(empRowSet.getString("FPersonBURelId"))) continue;
                PersonBURelationCollection coll = PersonBURelationFactory.getLocalInstance((Context)ctx).getPersonBURelationCollection(" select hrOrgUnit.id where id = " + pbuSqlId);
                PersonBURelationInfo pbuInfo = null;
                if (null == coll || coll.size() < 1) continue;
                pbuInfo = coll.get(0);
                oldHrId = pbuInfo.getHrOrgUnit().getId().toString();
                if (newHrId.equals(oldHrId)) {
                    RecordUtil.updatePBUState(ctx, pbuSqlId, 2, false);
                    continue;
                }
                AbstractRecord record = RecordInstanceFactory.getRecordInstance(RecordInstanceFactory.CATEGORY.CMP);
                ArrayList<String> recordList = new ArrayList<String>();
                sql = "select FPersonCmpID from T_HR_SCmpEmpORelation where FEmpOrgRelationID = '" + empId + "'";
                IRowSet r = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (r.next()) {
                    recordList.add(r.getString(1));
                }
                record.deleteRecords(ctx, CmpStrUtil.convertListToString(recordList), true);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        return null;
    }
}

