/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.TaxExceptionEnum;
import com.kingdee.shr.compensation.app.tax.CountryInfo;
import com.kingdee.shr.compensation.app.tax.FamilyRelationEnum;
import com.kingdee.shr.compensation.app.tax.IDTypeEnum;
import com.kingdee.shr.compensation.app.tax.SupportCollection;
import com.kingdee.shr.compensation.app.tax.SupportEntryCollection;
import com.kingdee.shr.compensation.app.tax.SupportEntryFactory;
import com.kingdee.shr.compensation.app.tax.SupportEntryInfo;
import com.kingdee.shr.compensation.app.tax.SupportFactory;
import com.kingdee.shr.compensation.app.tax.SupportInfo;
import com.kingdee.shr.compensation.app.tax.SupportShareEnum;
import com.kingdee.shr.compensation.app.tax.TaxBaseFactory;
import com.kingdee.shr.compensation.app.tax.TaxBaseInfo;
import com.kingdee.shr.compensation.app.tax.TaxStateEnum;
import com.kingdee.shr.compensation.app.tax.TaxTypeEnum;
import com.kingdee.shr.compensation.tax.TaxUtil;
import com.kingdee.shr.compensation.tax.service.TaxCommonService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SupportService
extends TaxCommonService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.tax.service.SupportService");

    @Override
    protected TaxTypeEnum getTaxTypeEnum() {
        return TaxTypeEnum.SUPPORT;
    }

    @Override
    public String saveInfo(Context ctx, String jsonPara) throws Exception {
        List attList;
        String countryId;
        String IDNumber;
        String name;
        Map dataMap;
        int i;
        SupportEntryInfo entryInfo = null;
        CoreBaseCollection entryColl = new CoreBaseCollection();
        Map map = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonPara, Map.class);
        if (null == map.get("state")) {
            return TaxUtil.error(ctx, TaxExceptionEnum.STATE_NOT_NULL.getValue(), TaxExceptionEnum.STATE_NOT_NULL.getName());
        }
        TaxStateEnum state = TaxStateEnum.getEnum(TaxUtil.getMapInt(map, "state"));
        Map sMap = (Map)map.get("support");
        double money = Double.valueOf(sMap.get("money").toString());
        String billIds = this.getTaxBaseInfoByState(ctx, 50, state.getValue());
        if (null != billIds) {
            StringBuilder str = new StringBuilder();
            SupportCollection supColl = SupportFactory.getLocalInstance(ctx).getSupportCollection("where bill.id in (" + billIds + ")");
            for (int i2 = 0; i2 < supColl.size(); ++i2) {
                str.append("'").append(supColl.get(i2).getId().toString()).append("',");
            }
            if (str.length() > 0) {
                String supIds = str.substring(0, str.length() - 1);
                DbUtil.execute((Context)ctx, (String)("delete from T_HR_SSupportEntry where FSupportID in (" + supIds + ")"));
                DbUtil.execute((Context)ctx, (String)("delete from T_HR_SSupport where Fid in (" + supIds + ")"));
            }
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_STaxBase where fid in (" + billIds + ")"));
        }
        TaxBaseInfo baseInfo = this.setTaxBaseInfoForSave(ctx, state, money);
        IObjectPK basePk = TaxBaseFactory.getLocalInstance(ctx).save(baseInfo);
        baseInfo.setId(BOSUuid.read((String)basePk.toString()));
        SupportInfo supportInfo = new SupportInfo();
        supportInfo.setMoney(money);
        supportInfo.setIsOnly(TaxUtil.getMapBoolean(sMap, "isOnly"));
        if (null != sMap.get("shareWay")) {
            supportInfo.setShareWay(SupportShareEnum.getEnum(TaxUtil.getMapInt(sMap, "shareWay")));
        }
        supportInfo.setId(null);
        supportInfo.setRemark(TaxUtil.getMapString(sMap, "remark"));
        supportInfo.setBill(baseInfo);
        StringBuilder activeStr = new StringBuilder();
        StringBuilder activeNameStr = new StringBuilder();
        StringBuilder passiveStr = new StringBuilder();
        StringBuilder passiveNameStr = new StringBuilder();
        CountryInfo countryInfo = null;
        if (sMap.containsKey("passive")) {
            List supportedList = (List)sMap.get("passive");
            for (i = 0; i < supportedList.size(); ++i) {
                dataMap = (Map)supportedList.get(i);
                entryInfo = new SupportEntryInfo();
                name = TaxUtil.getMapString(dataMap, "name");
                IDNumber = TaxUtil.getMapString(dataMap, "IDNumber");
                countryId = TaxUtil.getMapString(dataMap, "country");
                countryInfo = new CountryInfo();
                countryInfo.setId(BOSUuid.read((String)countryId));
                entryInfo.setName(name);
                entryInfo.setRelation(FamilyRelationEnum.getEnum(TaxUtil.getMapInt(dataMap, "relation")));
                entryInfo.setIDType(IDTypeEnum.getEnum(TaxUtil.getMapInt(dataMap, "IDType")));
                entryInfo.setIDNumber(IDNumber);
                entryInfo.setIsSupported(true);
                entryInfo.setSupport(supportInfo);
                entryInfo.setBirthday(CmpDateUtil.parseDate(dataMap.get("birthday").toString()));
                entryInfo.setCountry(countryInfo);
                entryColl.add((CoreBaseInfo)entryInfo);
                passiveNameStr.append(name).append(";");
                passiveStr.append(name).append(" : ").append(IDNumber).append(";");
            }
            if (passiveStr.length() > 0) {
                supportInfo.setPassive(passiveStr.substring(0, passiveStr.length() - 1));
                supportInfo.setPassiveName(passiveNameStr.substring(0, passiveNameStr.length() - 1));
            }
        }
        if (sMap.containsKey("active")) {
            List supportList = (List)sMap.get("active");
            for (i = 0; i < supportList.size(); ++i) {
                dataMap = (Map)supportList.get(i);
                entryInfo = new SupportEntryInfo();
                name = TaxUtil.getMapString(dataMap, "name");
                IDNumber = TaxUtil.getMapString(dataMap, "IDNumber");
                countryId = TaxUtil.getMapString(dataMap, "country");
                countryInfo = new CountryInfo();
                countryInfo.setId(BOSUuid.read((String)countryId));
                entryInfo.setName(name);
                entryInfo.setIDType(IDTypeEnum.getEnum(TaxUtil.getMapInt(dataMap, "IDType")));
                entryInfo.setIDNumber(IDNumber);
                entryInfo.setIsSupported(false);
                entryInfo.setCountry(countryInfo);
                entryInfo.setSupport(supportInfo);
                entryColl.add((CoreBaseInfo)entryInfo);
                activeNameStr.append(name).append(";");
                activeStr.append(name).append(" : ").append(IDNumber).append(";");
            }
            if (activeStr.length() > 0) {
                supportInfo.setActive(activeStr.substring(0, activeStr.length() - 1));
                supportInfo.setActiveName(activeNameStr.substring(0, activeNameStr.length() - 1));
            }
        }
        IObjectPK supportPk = SupportFactory.getLocalInstance(ctx).save(supportInfo);
        supportInfo.setId(BOSUuid.read((String)supportPk.toString()));
        SupportEntryFactory.getLocalInstance(ctx).save(entryColl);
        if (sMap.containsKey("attachment") && null != (attList = (List)sMap.get("attachment")) && attList.size() > 0) {
            this.saveAttactment(attList, supportPk.toString());
        }
        return TaxUtil.success(ctx, basePk.toString());
    }

    @Override
    public String getInfo(Context ctx, String billId) throws Exception {
        Map<Object, Object> map = new HashMap();
        if (StringUtils.isEmpty((String)billId)) {
            return TaxUtil.success(ctx, map);
        }
        String ksql = "select *, bill.*, entry.*, entry.country.id, entry.country.name where bill = '" + billId + "' ";
        SupportCollection coll = null;
        try {
            coll = SupportFactory.getLocalInstance(ctx).getSupportCollection(ksql);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return TaxUtil.error(ctx, TaxExceptionEnum.BILL_KEY_INVALID.getValue(), TaxExceptionEnum.BILL_KEY_INVALID.getName());
        }
        if (null == coll || coll.size() < 1) {
            return TaxUtil.success(ctx, map);
        }
        map = this.convertInfoToJson(ctx, coll.get(0));
        return TaxUtil.success(ctx, map);
    }

    @Override
    public String getHisInfo(Context ctx) throws Exception {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String personId = TaxUtil.getPersonId(ctx);
        String ksql = "select *, bill.*, entry.*, entry.country.* where bill.person.id = '" + personId + "' and bill.state in (20, 30, 40) order by bill.state asc";
        SupportCollection coll = SupportFactory.getLocalInstance(ctx).getSupportCollection(ksql);
        if (null == coll || coll.size() < 1) {
            return TaxUtil.success(ctx, list);
        }
        for (int i = 0; i < coll.size(); ++i) {
            Map<String, Object> map = this.convertInfoToJson(ctx, coll.get(i));
            list.add(map);
        }
        return TaxUtil.success(ctx, list);
    }

    @Override
    protected Map<String, Object> convertInfoToJson(Context ctx, CoreBaseInfo info) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<Object, Object> dataMap = new HashMap();
        Map<Object, Object> entryMap = new HashMap();
        ArrayList<Map<Object, Object>> supportList = new ArrayList<Map<Object, Object>>();
        ArrayList<Map<Object, Object>> supporedtList = new ArrayList<Map<Object, Object>>();
        SupportInfo supportInfo = (SupportInfo)info;
        dataMap = TaxUtil.getMapDataFromCoreInfo(ctx, supportInfo, "com.kingdee.shr.compensation.app.tax.Support");
        dataMap.remove("id");
        dataMap.remove("passiveName");
        dataMap.remove("activeName");
        dataMap.remove("passive");
        dataMap.remove("active");
        this.setBillHeadMapForWeb(supportInfo.getBill(), map);
        SupportEntryCollection entry = supportInfo.getEntry();
        for (int i = 0; i < entry.size(); ++i) {
            SupportEntryInfo entryInfo = entry.get(i);
            entryMap = TaxUtil.getMapDataFromCoreInfo(ctx, entryInfo, "com.kingdee.shr.compensation.app.tax.SupportEntry");
            entryMap.remove("isSupported");
            entryMap.remove("id");
            if (entryInfo.isIsSupported()) {
                supporedtList.add(entryMap);
                continue;
            }
            entryMap.remove("relation");
            entryMap.remove("birthday");
            supportList.add(entryMap);
        }
        dataMap.put("passive", supporedtList);
        dataMap.put("active", supportList);
        map.put("support", dataMap);
        return map;
    }
}

