/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.TaxDeclareStatusEnum;
import com.kingdee.shr.compensation.app.tax.Annu;
import com.kingdee.shr.compensation.app.tax.CalSchemeAnnu;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.tax.TaxYearCollection;
import com.kingdee.shr.compensation.app.tax.TaxYearFactory;
import com.kingdee.shr.compensation.app.tax.TaxYearInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.helper.CalSchemeBizUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.SHRStringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpTaxUtil {
    private static final Logger LOG = Logger.getLogger(CmpTaxUtil.class);
    private static final String BEGIN_DATE = "beginDate";
    private static final String END_DATE = "endDate";
    public static List<String> accIncomeItems = Arrays.asList("8r0AAABCg2nDiOoP", "8r0AAABCg3DDiOoP", "8r0AAABCg3PDiOoP");

    public int getTaxYear(Context ctx, CalSchemeInfo calSchemeInfo, int periodYear, int periodMonth) {
        int taxYear = -1;
        try {
            if (calSchemeInfo.getAnnu() != CalSchemeAnnu.not && calSchemeInfo.getBeginMonth() >= 1 && calSchemeInfo.getBeginMonth() <= 12) {
                taxYear = periodYear;
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.lastyear && periodMonth > calSchemeInfo.getEndMonth()) {
                    ++taxYear;
                }
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.thatyear && periodMonth < calSchemeInfo.getBeginMonth()) {
                    --taxYear;
                }
                return taxYear;
            }
            TaxYearCollection taxYearCol = TaxYearFactory.getLocalInstance(ctx).getTaxYearCollection();
            if (taxYearCol != null && taxYearCol.size() > 0) {
                TaxYearInfo taxYearInf = taxYearCol.get(0);
                taxYear = periodYear;
                if (taxYearInf.getAnnu() == Annu.lastyear && periodMonth > taxYearInf.getEndMonth()) {
                    ++taxYear;
                }
                if (taxYearInf.getAnnu() == Annu.thatyear && periodMonth < taxYearInf.getBeginMonth()) {
                    --taxYear;
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return taxYear;
    }

    public int getTaxYear(Context ctx, CalSchemeInfo calSchemeInfo) {
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        return this.getTaxYear(ctx, calSchemeInfo, periodYear, periodMonth);
    }

    public int getTaxYear(Context ctx, String calSchemeId) {
        CalSchemeInfo calSchemeinfo = CalSchemeBizUtil.getCalSchemeInfo(ctx, calSchemeId);
        return this.getTaxYear(ctx, calSchemeinfo);
    }

    public int getTaxYear(CalSchemeInfo calSchemeInfo, TaxYearCollection taxYearCol) {
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int taxYear = -1;
        if (calSchemeInfo.getAnnu() != CalSchemeAnnu.not && calSchemeInfo.getBeginMonth() >= 1 && calSchemeInfo.getBeginMonth() <= 12) {
            taxYear = periodYear;
            if (calSchemeInfo.getAnnu() == CalSchemeAnnu.lastyear && periodMonth > calSchemeInfo.getEndMonth()) {
                ++taxYear;
            }
            if (calSchemeInfo.getAnnu() == CalSchemeAnnu.thatyear && periodMonth < calSchemeInfo.getBeginMonth()) {
                --taxYear;
            }
            return taxYear;
        }
        if (taxYearCol != null && taxYearCol.size() > 0) {
            TaxYearInfo taxYearInf = taxYearCol.get(0);
            taxYear = periodYear;
            if (taxYearInf.getAnnu() == Annu.lastyear && periodMonth > taxYearInf.getEndMonth()) {
                ++taxYear;
            }
            if (taxYearInf.getAnnu() == Annu.thatyear && periodMonth < taxYearInf.getBeginMonth()) {
                --taxYear;
            }
        }
        return taxYear;
    }

    public Map<String, Date> getTaxYearRange(Context ctx, CalSchemeInfo calSchemeInfo) {
        HashMap<String, Date> rangeMap = null;
        int taxYear = -1;
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        try {
            if (calSchemeInfo.getAnnu() != CalSchemeAnnu.not && calSchemeInfo.getBeginMonth() >= 1 && calSchemeInfo.getBeginMonth() <= 12) {
                taxYear = periodYear;
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.lastyear && periodMonth > calSchemeInfo.getEndMonth()) {
                    ++taxYear;
                }
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.thatyear && periodMonth < calSchemeInfo.getBeginMonth()) {
                    --taxYear;
                }
                rangeMap = new HashMap<String, Date>();
                Calendar pal = Calendar.getInstance();
                int beginYear = taxYear;
                int endYear = taxYear;
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.lastyear && calSchemeInfo.getBeginMonth() > 1) {
                    beginYear = taxYear - 1;
                } else if (calSchemeInfo.getAnnu() == CalSchemeAnnu.thatyear && calSchemeInfo.getBeginMonth() > 1) {
                    endYear = taxYear + 1;
                }
                pal.set(1, beginYear);
                pal.set(2, calSchemeInfo.getBeginMonth() - 1);
                pal.set(5, 1);
                pal.set(10, 0);
                pal.set(12, 0);
                pal.set(13, 0);
                rangeMap.put(BEGIN_DATE, pal.getTime());
                pal.set(1, endYear);
                pal.set(2, calSchemeInfo.getEndMonth() - 1);
                pal.set(5, pal.getActualMaximum(5));
                rangeMap.put(END_DATE, pal.getTime());
                return rangeMap;
            }
            TaxYearCollection taxYearCol = TaxYearFactory.getLocalInstance(ctx).getTaxYearCollection();
            if (taxYearCol != null && taxYearCol.size() > 0) {
                TaxYearInfo taxYearInf = taxYearCol.get(0);
                taxYear = periodYear;
                if (taxYearInf.getAnnu() == Annu.lastyear && periodMonth > taxYearInf.getEndMonth()) {
                    ++taxYear;
                }
                if (taxYearInf.getAnnu() == Annu.thatyear && periodMonth < taxYearInf.getBeginMonth()) {
                    --taxYear;
                }
                rangeMap = new HashMap();
                Calendar pal = Calendar.getInstance();
                int beginYear = taxYear;
                int endYear = taxYear;
                if (taxYearInf.getAnnu() == Annu.lastyear && taxYearInf.getBeginMonth() > 1) {
                    beginYear = taxYear - 1;
                } else if (taxYearInf.getAnnu() == Annu.thatyear && taxYearInf.getBeginMonth() > 1) {
                    endYear = taxYear + 1;
                }
                pal.set(1, beginYear);
                pal.set(2, taxYearInf.getBeginMonth() - 1);
                pal.set(5, 1);
                pal.set(10, 0);
                pal.set(12, 0);
                pal.set(13, 0);
                rangeMap.put(BEGIN_DATE, pal.getTime());
                pal.set(1, endYear);
                pal.set(2, taxYearInf.getEndMonth() - 1);
                pal.set(5, pal.getActualMaximum(5));
                rangeMap.put(END_DATE, pal.getTime());
                return rangeMap;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rangeMap;
    }

    public void updateTaxUnit(Context ctx, Set<String> personSet, CalSchemeInfo calSchemeInfo) throws BOSException {
        if (personSet.isEmpty() || calSchemeInfo == null) {
            return;
        }
        try {
            String[] ids = new String[personSet.size()];
            personSet.toArray(ids);
            String personIds = CmpSQLUtil.createInSql(ctx, ids, "T_BD_PERSON", "FID");
            boolean jump = false;
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            String sql = "select caltableId,personId,taxUnitId,\"index\",judgeDate from (select caltable.fid as caltableId,tpr.fpersonid as personId,tpre.FTaxUnitID as taxUnitId, 1 as \"index\",  tpre.FEmployedDate as judgeDate  from T_HR_STaxPersonRecord tpr inner join  T_HR_STaxPersonRecordEntry tpre on tpr.fid = tpre.FBillID  inner join t_hr_scmpcaltable caltable on tpr.FPERSONID = caltable.FPERSONID  and caltable.fcalschemeId = '" + calSchemeInfo.getId() + "' and caltable.fperiodYear =" + calSchemeInfo.getPeriodYear() + " and caltable.fperiodMonth =" + calSchemeInfo.getPeriodMonth() + " and caltable.fcaltime = " + calSchemeInfo.getCalTime() + " where caltable.FPERSONID in (" + personIds + ") and tpre.FEmployedDate <= caltable.FrealEnddate and (tpre.FDepartureDate is null or tpre.FDepartureDate >=caltable.FrealEnddate) union all select caltable.fid as caltableId,ptu.FPersonId as personId,ptu.FTaxUnitId as taxUnitId,2 as \"index\",  ptu.FEFFDT as judgeDate from T_HR_SPERSONTAXUNIT ptu  inner join t_hr_scmpcaltable caltable on ptu.FPERSONID = caltable.FPERSONID  and caltable.fcalschemeId = '" + calSchemeInfo.getId() + "' and caltable.fperiodYear =" + calSchemeInfo.getPeriodYear() + " and caltable.fperiodMonth =" + calSchemeInfo.getPeriodMonth() + " and caltable.fcaltime = " + calSchemeInfo.getCalTime() + " where caltable.FPERSONID in (" + personIds + ") and ptu.FEFFDT <=caltable.FrealEnddate and ptu.FLEFFDT >= caltable.FrealEnddate) temp order by personId,\"index\",judgeDate desc";
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
            String tempPersonId = "";
            int tempIndex = 0;
            while (rs.next()) {
                String personId = rs.getString("personId");
                int index = rs.getInt("index");
                if (!tempPersonId.equals(personId)) {
                    tempPersonId = personId;
                    tempIndex = rs.getInt("index");
                    jump = false;
                    params.add(new Object[]{rs.getString("taxUnitId"), rs.getString("caltableId")});
                    continue;
                }
                if (jump || tempIndex != index) continue;
                params.remove(params.size() - 1);
                jump = true;
            }
            String updateSql = "update t_hr_scmpcaltable set FTaxUnitID=? where fid=?";
            if (!params.isEmpty()) {
                CmpSQLUtil.executeBatch(ctx, updateSql, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static boolean isHaveTaxService(Context ctx) {
        boolean result = false;
        String sql = "select top 1 1 from T_CDS_CLOUDSERVICECONFIG";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String genIncomeItemId(Context ctx, String tbTypeEnumVal) throws BOSException {
        String incomeItemInSql = "''";
        if ("1".equals(tbTypeEnumVal)) {
            incomeItemInSql = "('0101','0401','0402','0403','0499','0500','0600','0103','0108','0489')";
        } else if ("2".equals(tbTypeEnumVal)) {
            incomeItemInSql = "('')";
        } else if ("3".equals(tbTypeEnumVal)) {
            incomeItemInSql = "('0102','0401','0402','0403','0499','0108','0489')";
        }
        ArrayList<String> idSet = new ArrayList<String>();
        String sql = "SELECT FID FROM T_HR_STaxIncomeItem where FincomeCode in " + incomeItemInSql;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                idSet.add(SHRStringUtil.getStr(rowSet.getString("FID")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return CmpSQLUtil.createInSql(ctx, idSet, "T_HR_STaxIncomeItem", "fid");
    }

    public static TaxCalTaskInfo getTaskByAcceptIdAndCatalog(Context ctx, String acceptId, TaxCalTaskCatalogEnum catalogEnum) throws BOSException {
        if (catalogEnum == null) {
            return null;
        }
        String oql = "select id,accept_id,message_id,msg,state,creator where accept_id='" + acceptId + "' and catalog=" + catalogEnum.getValue();
        TaxCalTaskCollection collection = TaxCalTaskFactory.getLocalInstance(ctx).getTaxCalTaskCollection(oql);
        if (null != collection && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    public static void updateTaskStateAndMsgByAcceptIdAndCata(Context ctx, TaxCalTaskStateEnum stateEnum, String msg, String acceptId, TaxCalTaskCatalogEnum catalogEnum) throws BOSException {
        String updateStateSQL = "UPDATE T_HR_STaxCalTask SET FState=" + stateEnum.getValue() + ",FMsg='" + msg + "'  WHERE  FAccept_id='" + acceptId + "' and FCatalog=" + catalogEnum.getValue();
        DbUtil.execute((Context)ctx, (String)updateStateSQL);
    }

    public static void handleFailTaxDeclar(Context ctx, IncomeTaxDeclarInfo declarInfo) throws BOSException, EASBizException {
        String tbTypeVal = declarInfo.getTbType().getValue();
        String incomeItemInId = CmpTaxUtil.genIncomeItemId(ctx, tbTypeVal);
        String yearMonth = declarInfo.getYearMonth();
        String taxUnitId = "''";
        TaxUnitInfo taxUnit = declarInfo.getTaxUnit();
        if (taxUnit != null) {
            taxUnitId = taxUnit.getId() == null ? "''" : "'" + taxUnit.getId().toString() + "'";
        }
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("declareStatus"));
        declarInfo.setDeclareStatus(TaxDeclareStatusEnum.getEnum("3"));
        IncomeTaxDeclarFactory.getLocalInstance(ctx).updatePartial(declarInfo, selectorItemCollection);
        CmpTaxUtil.updateTaxDecalrRecordStatus(ctx, tbTypeVal, taxUnitId, incomeItemInId, yearMonth, "3");
    }

    private static void updateTaxDecalrRecordStatus(Context ctx, String tbTypeVal, String taxUnitId, String incomeItemInId, String yearMonth, String declareStatus) throws BOSException {
        StringBuilder updateBuffer = new StringBuilder();
        updateBuffer.append(" UPDATE T_HR_STaxDeclareRecord SET FdeclareStatus='").append(declareStatus).append("'");
        updateBuffer.append(" WHERE FtaxUnitId =  ");
        updateBuffer.append(taxUnitId);
        if ("1".equals(tbTypeVal)) {
            updateBuffer.append(" and FIsPersonal=0 ");
        } else if ("3".equals(tbTypeVal)) {
            updateBuffer.append(" and FIsPersonal=1 ");
        }
        updateBuffer.append(" and FINCOMEITEMID in  ");
        updateBuffer.append(incomeItemInId);
        updateBuffer.append(" and ");
        updateBuffer.append(CmpSQLUtil.generateSqlDateFilter("FPeriodBegin", "FPeriodEnd", yearMonth));
        DbUtil.execute((Context)ctx, (String)updateBuffer.toString());
    }

    public static String getMessageReceivers(Context ctx, String taxUnitId) {
        String sql = "select u.fid from T_PM_User u, T_HR_STaxUnitDataPerm p where u.fPersonId = p.fPersonId and p.fTaxUnitId ='" + taxUnitId + "' and p.fPermType = '" + "1" + "'";
        StringBuilder users = new StringBuilder();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                if (users.length() > 0) {
                    users.append(";");
                }
                users.append(rs.getString("fid"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"getMessageReceivers error: ", (Throwable)e);
        }
        return users.toString();
    }
}

