/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.adj;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.SHRCodingRule;
import com.kingdee.shr.base.syssetting.api.service.SHRCodingRuleApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecEmpAdjSalaryUtil {
    private static Logger logger = Logger.getLogger(RecEmpAdjSalaryUtil.class);

    public static boolean isCmpItemUsedByTable(Context ctx, String cmpItemId) {
        boolean isUsed = false;
        StringBuilder sb = new StringBuilder();
        sb.append(" select 1 from T_HR_SAdjustItemMappingScheme ");
        sb.append(" where ");
        sb.append(" FCMPITEMID = '").append(cmpItemId).append("' ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet.next()) {
                isUsed = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isUsed;
    }

    public static boolean isAdjSchemeUsedByTable(Context ctx, String adjSchemeId) {
        boolean isUsed = false;
        StringBuilder sb = new StringBuilder();
        sb.append(" select 1 from T_HR_SAdjustItemMappingScheme ");
        sb.append(" where ");
        sb.append(" FAdjustSchemeID = '").append(adjSchemeId).append("' ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet.next()) {
                isUsed = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isUsed;
    }

    public static boolean isAdjSchemeItemUsedByTable(Context ctx, String adjSchemeItemId) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select 1 from T_HR_SAdjustItemMappingScheme a left join ");
        sb.append(" T_HR_SBatchAdjustRuleItem b on a.FAdjustSchemeID = b.FCalSubmitSchemeID and a.FAdjustItemID = b.FAdjustSalaryItemID ");
        sb.append(" where ");
        sb.append(" b.FID = '").append(adjSchemeItemId).append("' ");
        boolean isUsed = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet.next()) {
                isUsed = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isUsed;
    }

    public static boolean isSubSchemeUsedByTable(Context ctx, String subSchemeId) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select 1 from T_HR_SSubmitItemMappingScheme  ");
        sb.append(" where ");
        sb.append(" FSubmitScheme = '").append(subSchemeId).append("' ");
        boolean isUsed = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet.next()) {
                isUsed = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isUsed;
    }

    public static boolean isSubSchemeItemUsedByTable(Context ctx, String subSchemeItemId) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select 1 from T_HR_SSubmitItemMappingScheme a ");
        sb.append(" left join T_HR_SCalSubmitSchemeItem b on a.FSubmitScheme = b.FCalSubmitSchemeID and a.FSubmitItemID = b.FCalSubmitItemID ");
        sb.append(" where ");
        sb.append(" b.FID = '").append(subSchemeItemId).append("' ");
        boolean isUsed = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet.next()) {
                isUsed = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isUsed;
    }

    public static boolean isSubElementUsedByTable(Context ctx, String subElementId) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select 1 from T_HR_SSubmitItemMappingScheme  ");
        sb.append(" where ");
        sb.append(" FSubmitElementID = '").append(subElementId).append("' ");
        boolean isUsed = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet.next()) {
                isUsed = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isUsed;
    }

    public static String createBillNumber(Context ctx, String hrOrgUnitId, HRBillBaseInfo info) throws BOSException {
        String currentCUID = HRFilterUtils.getCurrentCUID((Context)ctx);
        String codeOrgId = StringUtil.isEmpty((String)hrOrgUnitId) ? currentCUID : hrOrgUnitId;
        boolean isUseCodingRule = RecEmpAdjSalaryUtil.isUseCodingRule(ctx, (IObjectValue)info, codeOrgId);
        if (isUseCodingRule) {
            try {
                SHRCodingRule shrCodingRule = SHRCodingRuleApi.getCodingNumber((Context)ctx, (IObjectValue)info, (String)codeOrgId);
                return shrCodingRule.getCodingRuleNumber();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    public static String[] createBillNumbers(Context ctx, IObjectValue coreBase, String hrOrgUnitId, String bindProperty, String bindValue, int count) throws BOSException {
        String currentCUID = HRFilterUtils.getCurrentCUID((Context)ctx);
        String codeOrgId = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)hrOrgUnitId) ? currentCUID : hrOrgUnitId;
        boolean isUseCodingRule = SHRCodingRuleApi.hasCodingRule((Context)ctx, (IObjectValue)coreBase, (String)codeOrgId);
        if (isUseCodingRule) {
            try {
                return CodingRuleManagerFactory.getLocalInstance((Context)ctx).getBatchNumberForNoBreak(coreBase, codeOrgId, bindProperty, bindValue, count);
            }
            catch (BOSException | EASBizException e) {
                throw new BOSException(e);
            }
        }
        return null;
    }

    public static boolean isUseCodingRule(Context ctx, IObjectValue model, String orgId) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist(model, orgId)) {
                return true;
            }
            String companyId = RecEmpAdjSalaryUtil.getNextCompanyId(ctx);
            return companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(model, companyId);
        }
        catch (Exception err) {
            logger.error((Object)err.getMessage(), (Throwable)err);
            return false;
        }
    }

    public static String getNextCompanyId(Context ctx) throws Exception {
        ObjectUuidPK pk;
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo rootCU = iCtrlUnit.getCtrlUnitInfo((IObjectPK)(pk = new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4")));
        if (rootCU != null) {
            return rootCU.getId().toString();
        }
        return null;
    }

    public static String getCmpAdjQuerySql(String personId, String empORelId, String endKsqlDate, String recordType, String adjBusinessTypeId) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select ");
        sb.append(" record.FPERSONID FPERSONID, ");
        sb.append(" record.fhrorgunitid fhrorgunitid, ");
        sb.append(" (case when esa.FEffect >= record.FEffectDate then esa.FEffect else record.FEffectDate end) FEffectDate, ");
        sb.append(" esa.FEffect FEffect, ");
        sb.append(" esa.FLeffdt FLeffdt, ");
        sb.append(" cmpeor.fid EORID, ");
        sb.append(" cmpeor.FUseDefault useDefault, ");
        sb.append(" eor.fpositionid fpositionid, ");
        sb.append(" eor.FAdminOrgID FAdminOrgID, ");
        sb.append(" esa.FID ESAID, ");
        sb.append(" esa.FCurrency FCurrencyId, ");
        sb.append(" esa.FItemVal FItemVal, ");
        sb.append(" esa.FSalaryItem FSalaryItem, ");
        sb.append(" si.FDataType FDataType, ");
        sb.append(" esa.FSalaryAdjustTypeID FSalaryAdjustTypeID, ");
        sb.append(" esa.FAffairId FAffairId, ");
        sb.append(" esa.FDescription_l1, esa.FDescription_l2, esa.FDescription_l3, esa.FSegment, ");
        sb.append(" esa.FDataSourceCreatorID as PROPOSERID, ");
        sb.append(" esa.FDataSourceCreateTime as APPLYDATE, ");
        sb.append(" esa.FSalaryStandardId as FSALARYSTANDARDID ,");
        sb.append(" esa.FSalaryLevel as FSALARYLEVEL ,");
        sb.append(" esa.FSalaryPoint as FSALARYPOINT ,");
        sb.append(" esa.FSalaryScope as FSALARYSCOPE ");
        if ("ADJ".equals(recordType)) {
            sb.append(" from  T_HR_SAdjustPersonRecord record ");
            sb.append(" inner join T_HR_SAdjustEmpORelation cmpeor on record.fid = cmpeor.fpersonrecordid ");
        } else if ("CMP".equals(recordType)) {
            sb.append(" from  T_HR_SPersonCmp record ");
            sb.append(" inner join T_HR_SCmpEmpORelation cmpeor on record.fid = cmpeor.FPersonCmpID ");
        }
        sb.append(" inner join T_HR_EmpOrgRelation eor on cmpeor.FEmpOrgRelationID = eor.fid ");
        sb.append(" inner join T_HR_EmpSalaryAdjustment esa on record.fpersonid = esa.fpersonid and eor.FFlowInAffairID = esa.FAffairId ");
        sb.append(" left join T_HR_SalaryItem si on si.fid = esa.FSalaryItem  ");
        sb.append(" where ");
        sb.append(" record.fhrorgunitid in (@_HRORGUNITID) ");
        if ("CMP".equals(recordType)) {
            sb.append(" and (");
            sb.append(" (cmpeor.FUseDefault = 1 and eor.FAdminOrgID in (@_ADMINRANGE))");
            sb.append(" or");
            sb.append(" (cmpeor.FUseDefault = 0)");
            sb.append(" )");
        }
        if (!StringUtils.isEmpty((String)endKsqlDate)) {
            sb.append(" and cmpeor.fcreatetime <= ").append(endKsqlDate);
        }
        sb.append(" and esa.FEffect is not null ");
        sb.append(" and ((esa.FSalaryBillId not in (select fid from T_HR_SAdjustSalaryApply) and esa.FSalaryBillId not in (select fid from T_HR_SBATCHSUBMITSHEMEBILL)) or esa.FSalaryBillId is null)");
        sb.append(" and esa.FSalaryDealState = ").append(0);
        sb.append(" and esa.FSalaryItem in (@_SALARYITEM)");
        if (!StringUtils.isEmpty((String)personId)) {
            sb.append(" and record.fpersonid in (").append(personId).append(")");
        }
        if (!StringUtils.isEmpty((String)empORelId)) {
            sb.append(" and cmpeor.fid in (").append(empORelId).append(")");
        }
        if (!StringUtils.isEmpty((String)adjBusinessTypeId)) {
            sb.append(" and esa.FSalaryAdjustTypeID = '").append(adjBusinessTypeId).append("' ");
        }
        sb.append(" order by record.fpersonId, esa.FEffect, esa.FCreateTime desc, ");
        sb.append(" si.FDataType asc,");
        sb.append(" esa.FCurrency ");
        return sb.toString();
    }

    public static void updateEmpSalaryState(Context ctx, List<Object[]> updateESAStateParams) throws BOSException {
        if (updateESAStateParams.size() > 0) {
            try {
                DbUtil.executeBatch((Context)ctx, (String)"update T_HR_EmpSalaryAdjustment set FSalaryBillId = ?, FSalaryDealState = 1 where FID = ?", updateESAStateParams);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void saveExceptionLog(Context ctx, List<Object[]> paramsList) throws BOSException {
        String sql = "insert into T_HR_SGenCmpAdjDataLog (FPersonID, FEmpORelID, FLog) values (?, ?, ?)";
        CmpSQLUtil.executeBatch(ctx, sql, paramsList);
    }

    public static Set<String> getAdjSchemeUsedItem(Context ctx, List<String> ids) {
        HashSet<String> adjSchemeUsed = new HashSet<String>();
        if (ids == null || ids.size() < 1) {
            return adjSchemeUsed;
        }
        try {
            CmpInSql<String> instance = CmpInSqlFactory.getInstance();
            String calSubItemFIdSql = instance.createInSql(ctx, ids, "T_HR_SCalSubmitSchemeItem", "fid");
            String sb = " select b.fid as schemeItemId from T_HR_SSubmitItemMappingScheme a  left join T_HR_SCalSubmitSchemeItem b on a.FSubmitScheme = b.FCalSubmitSchemeID and a.FSubmitItemID = b.FCalSubmitItemID  where  b.FID in " + calSubItemFIdSql;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb);
            while (rowSet.next()) {
                adjSchemeUsed.add(rowSet.getString("schemeItemId"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return adjSchemeUsed;
    }

    public static boolean checkIsQuoteByDistributionRule(Context ctx, String subSchemeId) {
        try {
            String sql = "select per.FID from T_HR_SDistributionRule rul left join T_HR_SDistributionPeriod per on rul.FCurrentPeriodId = per.FID where rul.FSubmitSchemeID = ? and per.FIsCompleted = 50";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{subSchemeId});
            while (rs.next()) {
                if (StringUtils.isEmpty((String)rs.getString("FID"))) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

