/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.integrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.json.JSONUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitSchemeType;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class IntegrateFunctionUtil {
    public static Map<String, String> handleBeginAndEndDate(CalSchemeInfo calScheme, String beginDate, String endDate) {
        HashMap<String, String> resulteMap = new HashMap<String, String>();
        boolean isBeginDateEmp = beginDate == null || "".equals(beginDate.trim());
        boolean isEndDateEmp = endDate == null || "".equals(endDate.trim());
        resulteMap.put("beginDate", beginDate);
        resulteMap.put("endDate", endDate);
        if (isBeginDateEmp && isEndDateEmp) {
            Date begin = calScheme.getBeginDate();
            Date end = calScheme.getEndDate();
            SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar cal = Calendar.getInstance();
            cal.setTime(begin);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            begin = cal.getTime();
            cal = Calendar.getInstance();
            cal.setTime(end);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            end = cal.getTime();
            resulteMap.put("beginDate", dateFormate.format(begin));
            resulteMap.put("endDate", dateFormate.format(end));
        }
        return resulteMap;
    }

    public static String getDefaulteMutiSchemeNum(Context ctx, HashMap tempMap, SubmitSchemeType submitSchemeType) {
        submitSchemeType = submitSchemeType == null ? SubmitSchemeType.NORMAL_SUBMIT : submitSchemeType;
        String key = "getDefaulteMutiSchemeNum_Default_" + submitSchemeType.getValue();
        Map<String, String> schemeMap = new HashMap();
        if (null == tempMap.get(key)) {
            StringBuilder str = new StringBuilder();
            str.append(" SELECT FNUMBER from T_HR_SCALSUBMITSCHEME SCHEME ");
            str.append(" where SCHEME.FSUBMITSCHEMETYPE = ").append(submitSchemeType.getValue());
            str.append(" and  SCHEME.Fid = 'jJ0AAAAA1thRn/us' ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    schemeMap.put("DEFAULTEMUTISCHEMENUM", rowSet.getString("FNUMBER"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempMap.put(key, schemeMap);
        } else {
            schemeMap = (Map)tempMap.get(key);
        }
        return null == schemeMap.get("DEFAULTEMUTISCHEMENUM") ? "" : ((String)schemeMap.get("DEFAULTEMUTISCHEMENUM")).toString();
    }

    public static String initSubmitSchemeTable(Context ctx, HashMap tempMap, String schemeNumber, SubmitSchemeType submitSchemeType) {
        submitSchemeType = submitSchemeType == null ? SubmitSchemeType.NORMAL_SUBMIT : submitSchemeType;
        String key = "CALFUNCTIONINTEGRATESERVICE_SCHEMETABLE_" + submitSchemeType.getValue();
        Map<String, String> schemeMap = new HashMap();
        if (null == tempMap.get(key)) {
            StringBuilder str = new StringBuilder();
            str.append(" SELECT REL.FCALSHEMETABLENAME PROPERTYTABLE, REL.FBILLENTRYTABLENAME DATATABLE, SCHEME.FNUMBER ");
            str.append(" FROM T_HR_SCALSHEMETABLERELATION REL ");
            str.append(" INNER JOIN T_HR_SCALSUBMITSCHEME SCHEME ON REL.FSUBMITSCHEMEID = SCHEME.FID ");
            str.append(" where  SCHEME.FSUBMITSCHEMETYPE = ").append(submitSchemeType.getValue());
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    schemeMap.put(rowSet.getString("FNUMBER"), rowSet.getString("DATATABLE"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempMap.put(key, schemeMap);
        } else {
            schemeMap = (Map)tempMap.get(key);
        }
        return null == schemeMap.get(schemeNumber) ? null : ((String)schemeMap.get(schemeNumber)).toString();
    }

    public static CalSubmitItemInfo initSubmitItem(Context ctx, HashMap tempMap, String itemNumber) {
        CalSubmitItemInfo calSubmitItemInfo;
        String key = "CALFUNCTIONINTEGRATESERVICE_SUBMITITEM";
        String basicItemKey = "CALFUNCTIONINTEGRATESERVICE_SUBMITITEM_" + itemNumber;
        String basicItemValKey = "CALFUNCTIONINTEGRATESERVICE_SUBMITITEM_VAL_" + itemNumber;
        Map<String, CalSubmitItemInfo> itemMap = new HashMap();
        if (null == tempMap.get(key)) {
            CalSubmitItemCollection itemColl = null;
            try {
                itemColl = CalSubmitItemFactory.getLocalInstance(ctx).getCalSubmitItemCollection("select id, fieldSn, number, dateType, dataType,dataDot,filterField.entityName,filterField.entity ");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (null == itemColl) {
                return null;
            }
            for (int i = 0; i < itemColl.size(); ++i) {
                calSubmitItemInfo = itemColl.get(i);
                itemMap.put(calSubmitItemInfo.getNumber(), calSubmitItemInfo);
            }
            tempMap.put(key, itemMap);
        } else {
            itemMap = (Map)tempMap.get(key);
        }
        calSubmitItemInfo = (CalSubmitItemInfo)itemMap.get(itemNumber);
        if (null == calSubmitItemInfo) {
            return null;
        }
        if (calSubmitItemInfo.getDataType().equals((Object)CalSubmitItemDataType.F7) && null == tempMap.get(basicItemKey)) {
            HashMap<String, String> basicItemMap = new HashMap<String, String>();
            HashMap<String, String> basicItemMapName = new HashMap<String, String>();
            String entityName = calSubmitItemInfo.getFilterField().getEntity();
            MetaDataPK meataDataPk = MetaDataPK.create((String)entityName);
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)meataDataPk);
            String tableName = entityInfo.getTable().getName();
            String l = LocaleUtils.getShortCode((Locale)ctx.getLocale());
            String sql = "SELECT FID, FNUMBER,Fname_" + l + " as FNAME FROM " + tableName;
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rowSet.next()) {
                    basicItemMap.put(rowSet.getString("FNUMBER"), rowSet.getString("FID"));
                    basicItemMapName.put(rowSet.getString("FID"), rowSet.getString("FNAME"));
                }
                basicItemMap.put("TABLENAME", tableName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempMap.put(basicItemKey, basicItemMap);
            tempMap.put(basicItemValKey, basicItemMapName);
        }
        return (CalSubmitItemInfo)itemMap.get(itemNumber);
    }

    public static Set<String> initSchemeItem(Context ctx, HashMap tempMap, String schemeNumber, SubmitSchemeType submitSchemeType) {
        submitSchemeType = submitSchemeType == null ? SubmitSchemeType.NORMAL_SUBMIT : submitSchemeType;
        String key = "CALFUNCTIONINTEGRATESERVICE_SCHEMEITEM_" + submitSchemeType.getValue();
        HashSet<String> itemSet = new HashSet<String>();
        Map schemeItemMap = new HashMap();
        if (null == tempMap.get(key)) {
            StringBuilder str = new StringBuilder();
            str.append(" SELECT SCHEME.FNUMBER, ITEM.FIELDSN ");
            str.append(" FROM T_HR_SCALSUBMITSCHEME SCHEME ");
            str.append(" INNER JOIN T_HR_SCALSUBMITSCHEMEITEM SCHEMEITEM ON SCHEME.FID = SCHEMEITEM.FCALSUBMITSCHEMEID ");
            str.append(" INNER JOIN T_HR_SCALSUBMITITEM ITEM ON ITEM.FID = SCHEMEITEM.FCALSUBMITITEMID ");
            str.append(" where  SCHEME.FSUBMITSCHEMETYPE = ").append(submitSchemeType.getValue());
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    String number = rowSet.getString("FNUMBER");
                    if (schemeItemMap.containsKey(number)) {
                        ((Set)schemeItemMap.get(number)).add(rowSet.getString("FIELDSN"));
                        continue;
                    }
                    itemSet = new HashSet();
                    itemSet.add(rowSet.getString("FIELDSN"));
                    schemeItemMap.put(number, itemSet);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            schemeItemMap = (Map)tempMap.get(key);
        }
        return schemeItemMap.containsKey(schemeNumber) ? (Set)schemeItemMap.get(schemeNumber) : new HashSet();
    }

    public static String getPersonFilterSql(CalSchemeInfo calScheme, String company, double needSubOrg, String beginDate, String endDate, String mainTableRowFilter) {
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        boolean haveSubOrg = 1.0 == needSubOrg;
        String salaryPeriod = periodYear + "-" + periodMonth + "-" + calTime;
        String beginDateSql = "{ts '" + beginDate + "'}";
        String endDateSql = "{ts '" + endDate + "'}";
        if (beginDate == null || "".equals(beginDate.trim())) {
            beginDateSql = null;
        }
        if (endDate == null || "".equals(endDate.trim())) {
            endDateSql = null;
        }
        String personSql = IntegrateFunctionUtil.getSchemePersonFilterSql(calScheme, mainTableRowFilter);
        String adminOrgSql = IntegrateFunctionUtil.getAdminOrgIdFilterSql(company, haveSubOrg);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("salaryPeriod", salaryPeriod);
        paramMap.put("beginDateSql", beginDateSql);
        paramMap.put("endDateSql", endDateSql);
        paramMap.put("personSql", personSql);
        paramMap.put("adminOrgSql", adminOrgSql);
        return IntegrateFunctionUtil.getCommomFilterSql(paramMap);
    }

    public static String getPersonFilterSqlForMutiSpire(CalSchemeInfo calScheme, String mainTableRowFilter) {
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String salaryPeriod = periodYear + "-" + periodMonth + "-" + calTime;
        String personSql = IntegrateFunctionUtil.getSchemePersonFilterSql(calScheme, mainTableRowFilter);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("salaryPeriod", salaryPeriod);
        paramMap.put("beginDateSql", null);
        paramMap.put("endDateSql", null);
        paramMap.put("personSql", personSql);
        paramMap.put("isMutiSpire", true);
        return IntegrateFunctionUtil.getCommomFilterSql(paramMap);
    }

    private static String getCommomFilterSql(Map<String, Object> paramMap) {
        String salaryPeriod = (String)paramMap.get("salaryPeriod");
        String beginDateSql = (String)paramMap.get("beginDateSql");
        String endDateSql = (String)paramMap.get("endDateSql");
        String personSql = (String)paramMap.get("personSql");
        String adminOrgSql = (String)paramMap.get("adminOrgSql");
        boolean isMutiSpire = (Boolean)(paramMap.get("isMutiSpire") == null ? Boolean.valueOf(false) : paramMap.get("isMutiSpire"));
        StringBuilder str = new StringBuilder();
        str.append(" WHERE ");
        str.append(" FPERSONID  IN ( " + personSql + " )");
        if (!isMutiSpire) {
            str.append(" AND ").append(adminOrgSql);
        }
        if (beginDateSql != null && !"".equals(beginDateSql)) {
            str.append(" AND FEFFECTDATE >= ").append(beginDateSql);
        }
        if (endDateSql != null && !"".equals(endDateSql)) {
            str.append(" AND FEFFECTDATE <= ").append(endDateSql);
        }
        str.append(" AND FCALSTATE = '03' ");
        str.append(" AND FSALARYPERIOD ='").append(salaryPeriod).append("'");
        return str.toString();
    }

    private static String getSchemePersonFilterSql(CalSchemeInfo calScheme, String mainTableRowFilter) {
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        StringBuilder str = new StringBuilder();
        str.append(" select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '").append(calschemeid).append("' ");
        str.append(" and FperiodYear = ").append(periodYear);
        str.append(" and FperiodMonth = ").append(periodMonth);
        str.append(" and FcalTime = ").append(calTime);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            str.append(" and ").append(mainTableRowFilter);
        }
        return str.toString();
    }

    public static String getAdminOrgIdFilterSql(String companyNum, boolean haveSubOrg) {
        Context ctx = Tools.getInstance().getCtx();
        StringBuilder sqlBuffer = new StringBuilder();
        String queryOrg = "SELECT FLONGNUMBER,FID FROM T_ORG_ADMIN WHERE FNUMBER = '" + companyNum + "'";
        String companyLongNumber = "";
        String adminOrgUnitId = "";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)queryOrg);
            while (executeQuery.next()) {
                companyLongNumber = executeQuery.getString("fLongNumber");
                adminOrgUnitId = executeQuery.getString("fid");
            }
            if (StringUtils.isEmpty((String)companyLongNumber)) {
                return null;
            }
            if (haveSubOrg) {
                sqlBuffer.append(" FADMINORGUNITID IN (SELECT FID FROM T_ORG_ADMIN WHERE FLONGNUMBER LIKE '" + companyLongNumber + "%')");
            } else {
                sqlBuffer.append(" FADMINORGUNITID IN ('" + adminOrgUnitId + "')");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sqlBuffer.toString();
    }

    public static void putSubmitDataToParam(Context ctx, Map paramMap, HashMap tempMap, String calItem, String relyKey) {
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        List relyList = new ArrayList();
        Map relyMap = (Map)tempMap.get(relyKey);
        if (null == relyMap || !relyMap.containsKey(personId)) {
            return;
        }
        if (paramMap.containsKey("SUBMITRELY")) {
            Map paramRelayMap = (Map)paramMap.get("SUBMITRELY");
            if (paramRelayMap.containsKey(calItem)) {
                relyList = (List)paramRelayMap.get(calItem);
                relyList.addAll((Collection)relyMap.get(personId));
            } else {
                paramRelayMap.put(calItem, relyMap.get(personId));
            }
        } else {
            HashMap<String, List> paramRelayMap = new HashMap<String, List>();
            String data = JSONUtils.convertObjectToJson((Context)ctx, relyMap.get(personId));
            paramRelayMap.put(calItem, (List)JSONUtils.convertJsonToObject((Context)ctx, (String)data, List.class));
            paramMap.put("SUBMITRELY", paramRelayMap);
        }
    }

    public static void putSubmitDataToParamNew(Context ctx, Map paramMap, HashMap tempMap, String calItem, String relyKey, String calSubmitItemNum) {
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        List relyList = new ArrayList();
        Map submitItemRelyMap = tempMap.get(relyKey) == null ? new HashMap() : (Map)tempMap.get(relyKey);
        Map relyMap = (Map)submitItemRelyMap.get(calSubmitItemNum);
        if (null == relyMap || !relyMap.containsKey(personId)) {
            return;
        }
        if (paramMap.containsKey("SUBMITRELY")) {
            Map paramRelayMap = (Map)paramMap.get("SUBMITRELY");
            if (paramRelayMap.containsKey(calItem)) {
                relyList = (List)paramRelayMap.get(calItem);
                relyList.addAll((Collection)relyMap.get(personId));
            } else {
                paramRelayMap.put(calItem, relyMap.get(personId));
            }
        } else {
            HashMap<String, List> paramRelayMap = new HashMap<String, List>();
            String data = JSONUtils.convertObjectToJson((Context)ctx, relyMap.get(personId));
            paramRelayMap.put(calItem, (List)JSONUtils.convertJsonToObject((Context)ctx, (String)data, List.class));
            paramMap.put("SUBMITRELY", paramRelayMap);
        }
    }
}

