/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.costbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.costbudget.StaffingAddBillFactory;
import com.kingdee.shr.costbudget.StaffingAddBillInfo;
import com.kingdee.shr.costbudget.StaffingApplyType;
import com.kingdee.shr.costbudget.StaffingFactory;
import com.kingdee.shr.costbudget.app.AbstractStaffingAddBillControllerBean;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class StaffingAddBillControllerBean
extends AbstractStaffingAddBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.costbudget.app.StaffingAddBillControllerBean");

    public void setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.afterProcessCallBack(ctx, billID, HRBillStateEnum.SUBMITED);
    }

    public void setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.afterProcessCallBack(ctx, billID, HRBillStateEnum.AUDITED);
    }

    public void setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.afterProcessCallBack(ctx, billID, HRBillStateEnum.AUDITING);
    }

    public void setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.afterProcessCallBack(ctx, billID, HRBillStateEnum.AUDITEND);
    }

    private void afterProcessCallBack(Context ctx, BOSUuid billID, HRBillStateEnum billState) throws EASBizException, BOSException {
        int addNum;
        StaffingAddBillInfo billInfo = StaffingAddBillFactory.getLocalInstance(ctx).getStaffingAddBillInfo((IObjectPK)new ObjectUuidPK(billID));
        if (billInfo.getApplyMode() == StaffingApplyType.NEW && HRBillStateEnum.AUDITED == billState && (addNum = billInfo.getAuditCount()) > 0) {
            StaffingFactory.getLocalInstance(ctx).updateStaffingData(billInfo.getAdminOrg().getId().toString(), billInfo.getPosition().getId().toString(), billInfo.getEFFECTDT(), addNum);
        }
        this.updateBillState(ctx, billInfo, billState);
        logger.info((Object)MessageFormat.format("staffingAddBillCallBack param billID= {0}, billState= {1}", billID, billState.getAlias()));
    }

    private void updateBillState(Context ctx, StaffingAddBillInfo billInfo, HRBillStateEnum state) throws EASBizException, BOSException {
        billInfo.setBillState(state);
        StaffingAddBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)billInfo);
    }

    @Override
    protected void _setAuditingForMan(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.afterProcessCallBack(ctx, billID, HRBillStateEnum.AUDITING);
    }

    protected void _checkNumDup(Context ctx, HRBillBaseInfo info) {
    }

    protected void _checkNumDup(Context ctx, IObjectPK pk, HRBillBaseInfo info) throws BOSException, EASBizException {
    }
}

