/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.costbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.util.HRBaseDBUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.costbudget.IStaffing;
import com.kingdee.shr.costbudget.IStaffingBase;
import com.kingdee.shr.costbudget.IStaffingOrg;
import com.kingdee.shr.costbudget.IStaffingPost;
import com.kingdee.shr.costbudget.StaffingBaseInfo;
import com.kingdee.shr.costbudget.StaffingChannel;
import com.kingdee.shr.costbudget.StaffingException;
import com.kingdee.shr.costbudget.StaffingFactory;
import com.kingdee.shr.costbudget.StaffingInfo;
import com.kingdee.shr.costbudget.StaffingLaborRelationFactory;
import com.kingdee.shr.costbudget.StaffingOrgFactory;
import com.kingdee.shr.costbudget.StaffingOrgInfo;
import com.kingdee.shr.costbudget.StaffingPostFactory;
import com.kingdee.shr.costbudget.StaffingPostInfo;
import com.kingdee.shr.costbudget.StaffingStateEnum;
import com.kingdee.shr.costbudget.app.AbstractStaffingControllerBean;
import com.kingdee.shr.costbudget.util.DateHelper;
import java.sql.Date;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class StaffingControllerBean
extends AbstractStaffingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.costbudget.app.StaffingControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException {
        HRBaseDBUtil.updateInfoState((Context)ctx, (String)id, (String)"FState", (int)1);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException {
        HRBaseDBUtil.updateInfoState((Context)ctx, (String)id, (String)"FState", (int)2);
    }

    @Override
    protected void _copyStaffingData(Context ctx, String staffingId, int sourceMonth, int targetMonth, String userId, String permItemId) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)userId)) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            userId = userInfo.getId().toString();
        }
        this.deleteStaffingData(ctx, userId, targetMonth, staffingId, "T_HR_StaffingOrg", permItemId);
        this.deleteStaffingData(ctx, userId, targetMonth, staffingId, "T_HR_StaffingPost", permItemId);
        this.deleteStaffingData(ctx, userId, targetMonth, staffingId, "T_HR_StaffingLaborRelation", permItemId);
        IStaffingBase icoreBase = StaffingOrgFactory.getLocalInstance(ctx);
        this.insertStaffingData(ctx, staffingId, sourceMonth, targetMonth, userId, (ICoreBase)icoreBase, permItemId);
        icoreBase = StaffingPostFactory.getLocalInstance(ctx);
        this.insertStaffingData(ctx, staffingId, sourceMonth, targetMonth, userId, (ICoreBase)icoreBase, permItemId);
        icoreBase = StaffingLaborRelationFactory.getLocalInstance(ctx);
        this.insertStaffingData(ctx, staffingId, sourceMonth, targetMonth, userId, (ICoreBase)icoreBase, permItemId);
    }

    private void insertStaffingData(Context ctx, String staffingId, int sourceMonth, int targetMonth, String userId, ICoreBase icoreBase, String permItemId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String userOrgRangeSql = HRFilterUtils.getUserAdminRangeSql((Context)ctx, (String)userId, (String)permItemId);
        filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)userOrgRangeSql, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("staffing.id", (Object)staffingId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("month", (Object)sourceMonth, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        CoreBaseCollection coreBaseColl = icoreBase.getCollection(viewInfo);
        CoreBaseInfo coreBaseInfo = null;
        StaffingOrgInfo staffingOrgInfo = new StaffingOrgInfo();
        IStaffing iSta = StaffingFactory.getLocalInstance(ctx);
        StaffingInfo info = iSta.getStaffingInfo((IObjectPK)new ObjectUuidPK(staffingId));
        int size = coreBaseColl.size();
        for (int i = 0; i < size; ++i) {
            coreBaseInfo = coreBaseColl.get(i);
            Date date = coreBaseInfo.getDate("startDate");
            java.util.Date startDate = DateHelper.getMonthOfFirstDay(Integer.parseInt(info.getYear()), targetMonth);
            java.util.Date endDate = DateHelper.getMonthOfLastDay(Integer.parseInt(info.getYear()), targetMonth);
            coreBaseInfo.put("id", (Object)BOSUuid.create((BOSObjectType)staffingOrgInfo.getBOSType()));
            coreBaseInfo.put("month", (Object)targetMonth);
            coreBaseInfo.put("startDate", (Object)startDate);
            coreBaseInfo.put("endDate", (Object)endDate);
        }
        icoreBase.addnewBatchData(coreBaseColl);
    }

    private void deleteStaffingData(Context ctx, String userId, int targetMonth, String staffingId, String tableName, String permItemId) throws BOSException {
        String userOrgRangeSql = HRFilterUtils.getUserAdminRangeSql((Context)ctx, (String)userId, (String)permItemId);
        StringBuffer delStaffing = new StringBuffer();
        delStaffing.append(" delete from ").append(tableName).append(" where FAdminOrgUnit in (").append(userOrgRangeSql).append(")").append(" and FStaffing='").append(staffingId).append("' and fMonth=").append(targetMonth);
        DbUtil.execute((Context)ctx, (String)delStaffing.toString());
    }

    private StaffingInfo getStaffingByYear(Context ctx, int year) throws EASBizException, BOSException {
        String enableStaffingSql;
        StaffingInfo staffingInfo = null;
        IStaffing iStaffing = StaffingFactory.getLocalInstance(ctx);
        if (iStaffing.exists(enableStaffingSql = "select * where year = " + year + " and state = " + 1)) {
            staffingInfo = iStaffing.getStaffingInfo(enableStaffingSql);
        } else {
            String changingStaffingSql = "select * where year = " + year + " and state = " + 3;
            if (iStaffing.exists(changingStaffingSql)) {
                staffingInfo = iStaffing.getStaffingInfo(changingStaffingSql);
            }
        }
        return staffingInfo;
    }

    private void setStaffingBaseInfoData(StaffingBaseInfo staffingBaseInfo, StaffingStateEnum state, int month, java.util.Date startDate, java.util.Date endDate) {
        staffingBaseInfo.setState(state);
        staffingBaseInfo.setMonth(month);
        staffingBaseInfo.setStartDate(startDate);
        staffingBaseInfo.setEndDate(endDate);
    }

    @Override
    protected void _updateStaffingData(Context ctx, String orgid, String postid, java.util.Date effectDate, int addNum) throws BOSException, EASBizException {
        StaffingPostInfo staffingPostInfo;
        int year = DateHelper.getYearOfDate(effectDate);
        int month = 0;
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminOrgUnitInfo = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        PositionInfo positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(postid));
        if (positionInfo.getDeletedStatus().getValue() == 2) {
            throw new StaffingException(StaffingException.POSITION_IS_SEALUP);
        }
        StaffingInfo staffingInfo = this.getStaffingByYear(ctx, year);
        if (staffingInfo == null) {
            return;
        }
        String staffingid = staffingInfo.getId().toString();
        StaffingStateEnum state = staffingInfo.getState();
        StringBuffer segment = new StringBuffer();
        StaffingChannel staffingChannel = staffingInfo.getChannel();
        if (staffingChannel.equals((Object)StaffingChannel.MONTH)) {
            month = DateHelper.getMonthOfDate(effectDate);
            startDate = DateHelper.getMonthOfFirstDay(year, month);
            endDate = DateHelper.getMonthOfLastDay(year, month);
        } else if (staffingChannel.equals((Object)StaffingChannel.YEAR)) {
            startDate = DateHelper.getYearOfFirstDay(year);
            endDate = DateHelper.getYearOfLastDay(year);
        }
        segment.append(" and month = ").append(month);
        logger.info((Object)("start update staffing for StaffingAddBill Audited ,param is org: " + orgid + " postid: " + postid + " effectDate: " + effectDate + " addNum: " + addNum));
        logger.info((Object)("update staffing is " + staffingid));
        StringBuffer staffingPostSql = new StringBuffer();
        staffingPostSql.append("select * where staffing.id = '").append(staffingid).append("'");
        staffingPostSql.append(" and adminOrgUnit.id ='").append(orgid).append("'");
        staffingPostSql.append(" and position.id ='").append(postid).append("'");
        staffingPostSql.append(segment);
        IStaffingPost iStaffingPost = StaffingPostFactory.getLocalInstance(ctx);
        if (iStaffingPost.exists(staffingPostSql.toString())) {
            staffingPostInfo = iStaffingPost.getStaffingPostInfo(staffingPostSql.toString());
            staffingPostInfo.setAllStaffing(staffingPostInfo.getAllStaffing() + addNum);
            logger.info((Object)("update staffingPostInfo id is " + staffingPostInfo.getId().toString()));
        } else {
            staffingPostInfo = this.createStaffingPostInfo(adminOrgUnitInfo, staffingInfo, positionInfo);
            staffingPostInfo.setAllStaffing(addNum);
            this.setStaffingBaseInfoData(staffingPostInfo, state, month, startDate, endDate);
            logger.info((Object)"create a new staffingPostInfo");
        }
        iStaffingPost.save((CoreBaseInfo)staffingPostInfo);
        boolean IS_Auto_Summarizing = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_Auto_Summarizing", null);
        if (!IS_Auto_Summarizing) {
            StaffingOrgInfo staffingOrgInfo;
            StringBuffer staffingOrgSql = new StringBuffer();
            staffingOrgSql.append("select * where staffing.id = '").append(staffingid).append("'");
            staffingOrgSql.append(" and adminOrgUnit.id ='").append(orgid).append("'");
            staffingOrgSql.append(segment);
            IStaffingOrg iStaffingOrg = StaffingOrgFactory.getLocalInstance(ctx);
            if (iStaffingOrg.exists(staffingOrgSql.toString())) {
                staffingOrgInfo = iStaffingOrg.getStaffingOrgInfo(staffingOrgSql.toString());
            } else {
                staffingOrgInfo = this.createStaffingOrgInfo(staffingInfo, adminOrgUnitInfo);
                this.setStaffingBaseInfoData(staffingOrgInfo, state, month, startDate, endDate);
            }
            staffingOrgInfo.setAllStaffing(staffingOrgInfo.getAllStaffing() + addNum);
            StringBuffer adminOrgUnitSql = new StringBuffer("select * where parent.id ='");
            adminOrgUnitSql.append(orgid).append("'");
            staffingOrgInfo.setDirectStaffing(staffingOrgInfo.getDirectStaffing() + addNum);
            logger.info((Object)"the org has direct org,so update direct staffing num");
            CoreBaseCollection saveStaffingOrgList = new CoreBaseCollection();
            saveStaffingOrgList.add((CoreBaseInfo)staffingOrgInfo);
            String orgOql = "select fid from t_org_admin where charindex(flongnumber || '!','" + adminOrgUnitInfo.getLongNumber() + "') > 0 and fid != '" + orgid + "' ";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)orgOql);
            try {
                while (iRowSet.next()) {
                    StaffingOrgInfo parentStaffingOrgInfo = null;
                    String orgId = iRowSet.getString("fid");
                    String parentAdminOrgSql = "select * where staffing = '" + staffingid + "' and adminOrgUnit = '" + orgId + "' and month = " + month;
                    AdminOrgUnitInfo parentAdminOrgUnit = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                    if (iStaffingOrg.exists(parentAdminOrgSql)) {
                        parentStaffingOrgInfo = iStaffingOrg.getStaffingOrgInfo(parentAdminOrgSql);
                        parentStaffingOrgInfo.setAllStaffing(parentStaffingOrgInfo.getAllStaffing() + addNum);
                        logger.info((Object)("update the parent org,orgid is " + orgId));
                    } else {
                        parentStaffingOrgInfo = this.createStaffingOrgInfo(staffingInfo, parentAdminOrgUnit);
                        parentStaffingOrgInfo.setAllStaffing(addNum);
                        this.setStaffingBaseInfoData(parentStaffingOrgInfo, state, month, startDate, endDate);
                        logger.info((Object)("create a new parent org data,orgid is " + orgId));
                    }
                    saveStaffingOrgList.add((CoreBaseInfo)parentStaffingOrgInfo);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            iStaffingOrg.save(saveStaffingOrgList);
        }
    }

    private StaffingPostInfo createStaffingPostInfo(AdminOrgUnitInfo adminOrgUnitInfo, StaffingInfo staffingInfo, PositionInfo positionInfo) {
        StaffingPostInfo staffingPostInfo = new StaffingPostInfo();
        staffingPostInfo.setAdminOrgUnit(adminOrgUnitInfo);
        staffingPostInfo.setStaffing(staffingInfo);
        staffingPostInfo.setPosition(positionInfo);
        return staffingPostInfo;
    }

    private StaffingOrgInfo createStaffingOrgInfo(StaffingInfo staffingInfo, AdminOrgUnitInfo adminOrgUnitInfo) {
        StaffingOrgInfo staffingOrgInfo = new StaffingOrgInfo();
        staffingOrgInfo.setStaffing(staffingInfo);
        staffingOrgInfo.setAdminOrgUnit(adminOrgUnitInfo);
        return staffingOrgInfo;
    }
}

