/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.costbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.costbudget.IStaffing;
import com.kingdee.shr.costbudget.StaffingException;
import com.kingdee.shr.costbudget.StaffingFactory;
import com.kingdee.shr.costbudget.app.AbstractStaffingFacadeControllerBean;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class StaffingFacadeControllerBean
extends AbstractStaffingFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.costbudget.app.StaffingFacadeControllerBean");

    @Override
    protected void _deleteStaffing(Context ctx, Set staffingIdSet) throws BOSException, EASBizException {
        IStaffing biz = this.getStafffingBizInterface(ctx);
        Iterator iter = staffingIdSet.iterator();
        while (iter.hasNext()) {
            String staffingId = String.valueOf(iter.next());
            this.doDeleteStaffing(ctx, staffingId);
        }
    }

    private IStaffing getStafffingBizInterface(Context ctx) throws BOSException {
        IStaffing biz = StaffingFactory.getLocalInstance(ctx);
        return biz;
    }

    private void doDeleteStaffing(Context ctx, String staffingId) throws BOSException, EASBizException {
        try {
            this.beforeDelete(ctx, staffingId);
            this.deleteOtherStaffing(ctx, staffingId);
            this.getStafffingBizInterface(ctx).delete((IObjectPK)new ObjectUuidPK(staffingId));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void deleteOtherStaffing(Context ctx, String staffingId) throws BOSException {
        String orgDelSql = "delete from t_hr_staffingorg where fstaffing = '" + staffingId + "'";
        String postDelSql = "delete from t_hr_staffingpost where fstaffing = '" + staffingId + "'";
        String relationDelSql = "delete from t_hr_staffinglaborrelation where fstaffing = '" + staffingId + "'";
        DbUtil.execute((Context)ctx, (String)orgDelSql);
        DbUtil.execute((Context)ctx, (String)postDelSql);
        DbUtil.execute((Context)ctx, (String)relationDelSql);
    }

    private void beforeDelete(Context ctx, String staffingId) throws EASBizException, BOSException {
        if (this.checkCanDeleteAble(ctx, staffingId)) {
            throw new StaffingException(StaffingException.STAFFINGISENABLE);
        }
    }

    private boolean checkCanDeleteAble(Context ctx, String staffingId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)staffingId)) {
            return false;
        }
        IStaffing biz = this.getStafffingBizInterface(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)staffingId));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        return biz.exists(filter);
    }
}

