/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.staffcontrol.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.staffcontrol.StaffManageApplyBillFactory;
import com.kingdee.shr.staffcontrol.StaffManageApplyBillInfo;
import com.kingdee.shr.staffcontrol.StaffManageOperateLogFactory;
import com.kingdee.shr.staffcontrol.StaffManageOperateLogInfo;
import com.kingdee.shr.staffcontrol.StaffManageOperateTypeEnum;
import com.kingdee.shr.staffcontrol.app.AbstractStaffManageApplyBillControllerBean;
import com.kingdee.shr.staffcontrol.util.StaffManageGatherUtilEx;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class StaffManageApplyBillControllerBean
extends AbstractStaffManageApplyBillControllerBean {
    private static final long serialVersionUID = 1451421844367776202L;
    private static final String AUDITED = "Audited";
    private static final String UNTI_CHECK = "UntiCheck";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.staffcontrol.app.StaffManageApplyBillControllerBean");

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._abortBizBill(ctx, billId);
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
        this.refreshStaffCount(ctx, billId, UNTI_CHECK);
    }

    public void setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.afterAudit(ctx, billID, HRBillStateEnum.AUDITED);
        this.refreshStaffCount(ctx, billID.toString(), AUDITED);
    }

    public void setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.afterAudit(ctx, billID, HRBillStateEnum.AUDITING);
    }

    public void setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.afterAudit(ctx, billID, HRBillStateEnum.AUDITEND);
    }

    protected void afterAudit(Context ctx, BOSUuid billId, HRBillStateEnum billState) throws EASBizException, BOSException {
        this.refreshBillState(ctx, billId, billState);
        logger.info((Object)MessageFormat.format("StaffManageApplyBillCallBack param billID= {0}, billState= {1}", billId, billState.getAlias()));
    }

    public void refreshStaffCount(Context ctx, String billId, String type) throws BOSException, EASBizException {
        StaffManageGatherUtilEx.refreshStaffCount(ctx, billId, type);
        StaffManageOperateLogInfo logInfo = new StaffManageOperateLogInfo();
        if (AUDITED.equals(type)) {
            logInfo.setType(StaffManageOperateTypeEnum.APPLY_BILL_AUDITED);
        } else if (UNTI_CHECK.equals(type)) {
            logInfo.setType(StaffManageOperateTypeEnum.APPLY_BILL_UNTI);
        }
        StaffManageOperateLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)logInfo);
    }

    public void refreshBillState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws EASBizException, BOSException {
        StaffManageApplyBillInfo applyBillInfo = StaffManageApplyBillFactory.getLocalInstance(ctx).getStaffManageApplyBillInfo((IObjectPK)new ObjectUuidPK(billId));
        applyBillInfo.setBillState(state);
        StaffManageApplyBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)applyBillInfo);
    }
}

