/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.staffcontrol.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.shr.staffcontrol.app.AbstractStaffManageBaseBillControllerBean;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class StaffManageBaseBillControllerBean
extends AbstractStaffManageBaseBillControllerBean {
    private static final long serialVersionUID = -7301271220455970747L;

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                iHRBillBase.setSaved(BOSUuid.read((String)billId));
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, billInfo);
            } else {
                throw new AffairBizException(AffairBizException.BILLSTATECANTSUPPORT);
            }
        }
    }

    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (!HRBillStateEnum.AUDITED.equals((Object)billState)) {
                throw new AffairBizException(AffairBizException.BILLSTATECANUNCHECK);
            }
            iHRBillBase.passUnaudit(BOSUuid.read((String)billId));
        }
    }

    protected UserInfo getUserInfo(Context ctx) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected String getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp timestamp = new Timestamp(d.getTime().getTime());
        return DateUtils.paseTimestamp2String((Timestamp)timestamp, (String)"yyyy-MM-dd HH:mm:ss");
    }
}

