/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.staffcontrol.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.org.util.OrgCacheServiceHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.costbudget.util.DateHelper;
import com.kingdee.shr.manager.HRAffairException;
import com.kingdee.shr.manager.util.HRManagerUtil;
import com.kingdee.shr.staffcontrol.IStaffManageProject;
import com.kingdee.shr.staffcontrol.StaffManageException;
import com.kingdee.shr.staffcontrol.StaffManageOrgSubInfoDTO;
import com.kingdee.shr.staffcontrol.StaffManageOrgTrendFactory;
import com.kingdee.shr.staffcontrol.StaffManageOrgTrendInfo;
import com.kingdee.shr.staffcontrol.StaffManageProjectCollection;
import com.kingdee.shr.staffcontrol.StaffManageProjectFactory;
import com.kingdee.shr.staffcontrol.StaffManageProjectInfo;
import com.kingdee.shr.staffcontrol.StaffManageRuleFieldCollection;
import com.kingdee.shr.staffcontrol.app.AbstractStaffManageFacadeControllerBean;
import com.kingdee.shr.staffcontrol.util.IStaffManageChannel;
import com.kingdee.shr.staffcontrol.util.StaffManageChannelUtil;
import com.kingdee.shr.staffcontrol.util.StaffManageServiceUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class StaffManageFacadeControllerBean
extends AbstractStaffManageFacadeControllerBean {
    private static final long serialVersionUID = 3468761100037505909L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.staffcontrol.app.StaffManageFacadeControllerBean");

    @Override
    protected void _refreshStaffPersonCount(Context ctx) throws BOSException, EASBizException {
        try {
            this._alterColumnToStaffManage(ctx);
            StaffManageProjectCollection projectColl = this.getProjects(ctx);
            if (projectColl == null || projectColl.size() == 0) {
                logger.error((Object)"StaffManageFacadeControllerBean refreshStaffPersonCount: project is null");
                return;
            }
            for (int i = 0; i < projectColl.size(); ++i) {
                StaffManageProjectInfo projectInfo = projectColl.get(i);
                String tableName = projectInfo.getTableName();
                if (StringUtils.isEmpty((String)tableName)) {
                    logger.error((Object)("StaffManageFacadeControllerBean.refreshStaffPersonCount tableName is null:" + projectInfo.getName()));
                    continue;
                }
                StaffManageRuleFieldCollection dimensionColl = StaffManageProjectFactory.getLocalInstance(ctx).getDimensions(projectInfo);
                String dimensionStr = "";
                ArrayList<String> dimensionList = new ArrayList<String>();
                for (int j = 0; j < dimensionColl.size(); ++j) {
                    dimensionList.add(dimensionColl.get(j).getColumn());
                    dimensionStr = dimensionStr + "staff." + dimensionColl.get(j).getColumn() + " " + dimensionColl.get(j).getColumn() + ",";
                }
                IStaffManageChannel iStaffManageChannel = StaffManageChannelUtil.getInstance(projectInfo.getChannel());
                Map<String, Date> personCountToDateMap = iStaffManageChannel.getActualPersonCountToDateMap(Integer.valueOf(projectInfo.getYear()));
                String actualSQLChip = iStaffManageChannel.getActualSQLChip();
                ArrayList<String> otherActualSQLs = new ArrayList<String>();
                for (String actualSQLStr : actualSQLChip.split(",")) {
                    if (personCountToDateMap.keySet().contains(actualSQLStr)) continue;
                    otherActualSQLs.add(actualSQLStr);
                }
                StringBuffer sql = new StringBuffer(" select ");
                sql.append(dimensionStr);
                sql.append(" staff.FContainSub  as isHassub,");
                sql.append(" staff.fid as fid");
                sql.append(" from  " + tableName + " staff ");
                IRowSet idRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (idRowSet.next()) {
                    String staffId = idRowSet.getString("fid");
                    String updateSql = "update " + tableName + " set ";
                    int personCount = 0;
                    boolean isFirstChannel = true;
                    for (Map.Entry<String, Date> entry : personCountToDateMap.entrySet()) {
                        if (isFirstChannel) {
                            personCount = StaffManageServiceUtil.getPersonCountByStaffId(ctx, projectInfo.getId().toString(), staffId, StaffManageChannelUtil.getMonthOfLastDay(Integer.valueOf(projectInfo.getYear()) - 1, 12));
                            isFirstChannel = false;
                            updateSql = updateSql + entry.getKey() + "Start = " + personCount + ",";
                        } else {
                            updateSql = updateSql + entry.getKey() + "Start = " + personCount + ",";
                        }
                        personCount = StaffManageServiceUtil.getPersonCountByStaffId(ctx, projectInfo.getId().toString(), staffId, entry.getValue());
                        updateSql = updateSql + entry.getKey() + " = " + personCount + ",";
                    }
                    for (String string : otherActualSQLs) {
                        updateSql = updateSql + string + " = " + personCount + ",";
                    }
                    LinkedHashMap<String, String> staffRowDimensionMap = new LinkedHashMap<String, String>();
                    for (String dimensionCol : dimensionList) {
                        String dimensionValue = idRowSet.getString(dimensionCol);
                        staffRowDimensionMap.put(dimensionCol, dimensionValue);
                    }
                    boolean bl = idRowSet.getInt("isHassub") == 1;
                    int onWayAddCount = StaffManageServiceUtil.getOnWayAddCount(ctx, bl, dimensionColl, staffRowDimensionMap);
                    int onWaySubCount = StaffManageServiceUtil.getOnWaySubCount(ctx, bl, dimensionColl, staffRowDimensionMap);
                    updateSql = updateSql + " FOnWayAddCount='" + onWayAddCount + "',";
                    updateSql = updateSql + " FOnWaySubCount='" + onWaySubCount + "',";
                    updateSql = updateSql + " FPersonCount='" + personCount + "'  where fid ='" + staffId + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _alterColumnToStaffManage(Context ctx) throws BOSException {
        if ((String)OrgCacheServiceHelper.getValueFromCache((String)"SHRStaffManageHasAddOnWayColumn") != null) {
            return true;
        }
        StaffManageProjectCollection projectColl = StaffManageProjectFactory.getLocalInstance(ctx).getStaffManageProjectCollection("select tableName,channel where state in ('1','2')");
        if (projectColl == null || projectColl.size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"StaffManageFacadeControllerBean.alterColumnToStaffManage: staffmanageproject size is zero");
            }
            return true;
        }
        StringBuffer alterSQL = null;
        for (int i = 0; i < projectColl.size(); ++i) {
            String tableName = projectColl.get(i).getTableName();
            if (StringUtils.isEmpty((String)tableName)) continue;
            alterSQL = new StringBuffer("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FONWAYADDCOUNT' and KSQL_COL_TABNAME='").append(tableName).append("')").append(" ALTER TABLE ").append(tableName).append(" ADD FONWAYADDCOUNT INT;").append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FONWAYSUBCOUNT' and KSQL_COL_TABNAME='").append(tableName).append("')").append(" ALTER TABLE ").append(tableName).append(" ADD FONWAYSUBCOUNT INT;");
            String actualSQLChip = StaffManageChannelUtil.getInstance(projectColl.get(i).getChannel()).getActualSQLChip();
            for (String actualSQLStr : actualSQLChip.split(",")) {
                actualSQLStr = actualSQLStr + "START";
                alterSQL.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='").append(actualSQLStr.toUpperCase()).append("'").append(" and KSQL_COL_TABNAME='").append(tableName).append("')").append(" ALTER TABLE ").append(tableName).append(" ADD ").append(actualSQLStr.toUpperCase()).append(" INT;");
            }
            try {
                DbUtil.execute((Context)ctx, (String)alterSQL.toString());
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)("StaffManageFacadeControllerBean.alterColumnToStaffManage: tableGG---" + tableName));
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        OrgCacheServiceHelper.setValueToCache((String)"SHRStaffManageHasAddOnWayColumn", (Object)"true");
        return true;
    }

    @Override
    protected List<StaffManageOrgSubInfoDTO> _getOrgSubStaff(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        this.checkParam(ctx, orgId, permItemId);
        ArrayList<StaffManageOrgSubInfoDTO> orgStaffDTOs = new ArrayList<StaffManageOrgSubInfoDTO>();
        int year = DateTimeUtils.getYear((Date)new Date());
        List<Integer> channels = this.getStaffManageChannels(ctx, year);
        if (channels.size() == 0) {
            logger.error((Object)"StaffManageFacadeControllerBean _getOrgSubStaff: no enable staff project");
            return orgStaffDTOs;
        }
        StaffManageOrgSubInfoDTO orgDirectStaffDTO = this.getOrgDirectStaffInfo(ctx, orgId, channels, new Date());
        String tempTableName = StaffManageFacadeControllerBean.createTempTable(ctx, orgId, permItemId);
        try {
            Map<String, Integer> orgSubStaffMap = this.getOrgStaffMap(ctx, this.getOrgIds(ctx, tempTableName), channels, new Date(), 1);
            Map<String, Integer> orgSubActualMap = this.getSubActualStaffing(ctx, orgId, tempTableName, permItemId);
            Map<String, Integer> subOnWayPersoncountMap = this.getSubOnWayPersoncount(ctx, orgId, tempTableName, permItemId);
            StringBuffer sql = new StringBuffer("select fid,fname,fisleaf from ").append(tempTableName).append(" order by flongnumber asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                StaffManageOrgSubInfoDTO orgStaffDTO = new StaffManageOrgSubInfoDTO();
                String adminOrgId = rowSet.getString("fid");
                int orgSubStaffCount = orgSubStaffMap.get(adminOrgId) == null ? 0 : orgSubStaffMap.get(adminOrgId);
                int orgSubActualCount = orgSubActualMap.get(adminOrgId);
                int subOnWayPersoncount = subOnWayPersoncountMap.get(adminOrgId);
                int orgSubAvaliableCount = orgSubStaffCount - orgSubActualCount - subOnWayPersoncount;
                orgStaffDTO.setOrgId(adminOrgId);
                orgStaffDTO.setOrgName(rowSet.getString("fname"));
                orgStaffDTO.setIsLeaf(rowSet.getBoolean("fisleaf"));
                orgStaffDTO.setIsDirect(Boolean.FALSE);
                orgStaffDTO.setHaveStaffData(Boolean.TRUE);
                if (orgSubStaffMap.get(adminOrgId) == null) {
                    orgStaffDTO.setHaveStaffData(Boolean.FALSE);
                }
                orgStaffDTO.setOrgSubStaff(orgSubStaffCount);
                orgStaffDTO.setOrgSubActualCount(orgSubActualCount);
                orgStaffDTO.setOrgSubOnWayCount(subOnWayPersoncount);
                orgStaffDTO.setOrgSubAvaliableStaff(orgSubAvaliableCount);
                orgStaffDTOs.add(orgStaffDTO);
                if (!adminOrgId.equals(orgId)) continue;
                orgDirectStaffDTO.setOrgName(rowSet.getString("fname") + EASResource.getString((String)"com.kingdee.shr.staffcontrol.StaffManageResource", (String)"label84", (Locale)ctx.getLocale()));
                orgDirectStaffDTO.setIsLeaf(Boolean.TRUE);
                orgStaffDTOs.add(orgDirectStaffDTO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            StaffManageServiceUtil.relaseTempTable(ctx, tempTableName);
        }
        return orgStaffDTOs;
    }

    @Override
    protected Map<String, Integer> _getOrgStaffMap(Context ctx, String orgIdsStr, String channelsStr, Date date, int containSub) throws BOSException, EASBizException {
        this.checkParam(ctx, orgIdsStr, channelsStr, date, containSub);
        List<String> orgIds = StaffManageServiceUtil.idStrToList(orgIdsStr);
        return this.getOrgStaffMap(ctx, orgIds, StaffManageFacadeControllerBean.channelStrToList(channelsStr), date, containSub);
    }

    @Override
    protected Map<String, Integer> _getPositionStaffMap(Context ctx, String positionIdsStr, String channelsStr, Date date) throws BOSException, EASBizException {
        this.checkParam(ctx, positionIdsStr, channelsStr, date, 0);
        List<String> positionIds = StaffManageServiceUtil.idStrToList(positionIdsStr);
        return this.getPositionStaffMap(ctx, positionIds, StaffManageFacadeControllerBean.channelStrToList(channelsStr), date);
    }

    @Override
    protected Map<String, List<String>> _getStaffManageOrgTrend(Context ctx, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        this.checkParam(ctx, orgId, startDate, endDate);
        HashMap<String, List<String>> staffManageOrgMap = new HashMap<String, List<String>>();
        ArrayList labelList = new ArrayList();
        ArrayList dataList = new ArrayList();
        staffManageOrgMap.put("labelList", labelList);
        staffManageOrgMap.put("dataList", dataList);
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        List<Integer> stYearChannels = this.getStaffManageChannels(ctx, startYear);
        List<Integer> endYearChannels = this.getStaffManageChannels(ctx, endYear);
        if (stYearChannels.size() == 0 && endYearChannels.size() == 0) {
            return staffManageOrgMap;
        }
        if (startYear < endYear) {
            Boolean isOldYearHaveData = this.getStaffManageOrgTrend(ctx, staffManageOrgMap, orgId, stYearChannels, startDate, HRManagerUtil.getDefaultMaxEndDate((Date)startDate), 1);
            Boolean isNewYearHaveData = this.getStaffManageOrgTrend(ctx, staffManageOrgMap, orgId, endYearChannels, HRManagerUtil.getDefaultMinStartDate((Date)endDate), endDate, 1);
            this.afterGetStaffManage(staffManageOrgMap, startDate, endDate, isOldYearHaveData, isNewYearHaveData);
        } else {
            this.getStaffManageOrgTrend(ctx, staffManageOrgMap, orgId, stYearChannels, startDate, endDate, 1);
        }
        return staffManageOrgMap;
    }

    @Override
    protected Map<String, Map<String, Object>> _getOrgAndPositionStaffMap(Context ctx, String orgId, String positionId, String permItemId) throws BOSException, EASBizException {
        this.checkParam(ctx, orgId, positionId, permItemId);
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        int year = DateTimeUtils.getYear((Date)new Date());
        List<Integer> channels = this.getStaffManageChannels(ctx, year);
        if (channels.size() == 0) {
            return result;
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            ArrayList<String> orgIds = new ArrayList<String>();
            orgIds.add(orgId);
            StaffManageOrgSubInfoDTO orgSubStaffDTO = this.getOrgSubStaffInfo(ctx, orgId, channels, new Date());
            StaffManageOrgSubInfoDTO orgDirectStaffDTO = this.getOrgDirectStaffInfo(ctx, orgId, channels, new Date());
            LinkedHashMap<String, Comparable<Boolean>> orgSubMap = new LinkedHashMap<String, Comparable<Boolean>>();
            orgSubMap.put("orgSubStaffHaveData", Boolean.valueOf(orgSubStaffDTO.isHaveStaffData()));
            orgSubMap.put("orgSubStaff", Integer.valueOf(orgSubStaffDTO.getOrgSubStaff()));
            orgSubMap.put("orgSubActualCount", Integer.valueOf(orgSubStaffDTO.getOrgSubActualCount()));
            orgSubMap.put("orgSubOnWayCount", Integer.valueOf(orgSubStaffDTO.getOrgSubOnWayCount()));
            orgSubMap.put("orgSubAvaliableCount", Integer.valueOf(orgSubStaffDTO.getOrgSubAvaliableStaff()));
            result.put("orgSubInfo", orgSubMap);
            LinkedHashMap<String, Comparable<Boolean>> orgDirectMap = new LinkedHashMap<String, Comparable<Boolean>>();
            orgDirectMap.put("orgDirectStaffHaveData", Boolean.valueOf(orgDirectStaffDTO.isHaveStaffData()));
            orgDirectMap.put("orgDirectStaff", Integer.valueOf(orgDirectStaffDTO.getOrgDirectStaff()));
            orgDirectMap.put("orgDirectActualCount", Integer.valueOf(orgDirectStaffDTO.getOrgDirectActualCount()));
            orgDirectMap.put("orgDirectOnWayCount", Integer.valueOf(orgDirectStaffDTO.getOrgDirectOnWayCount()));
            orgDirectMap.put("orgDirectAvaliableCount", Integer.valueOf(orgDirectStaffDTO.getOrgDirectAvaliableStaff()));
            result.put("orgDirectInfo", orgDirectMap);
        }
        if (!StringUtils.isEmpty((String)positionId)) {
            int posActualCount = StaffManageServiceUtil.getLimitActualPersonCount(ctx, null, positionId, null, false);
            ArrayList<String> positionIds = new ArrayList<String>();
            positionIds.add(positionId);
            Map<String, Integer> posStaffMap = this.getPositionStaffMap(ctx, positionIds, channels, new Date());
            int posOnWayCount = StaffManageServiceUtil.getPositionOnWayCount(ctx, orgId, positionId);
            LinkedHashMap<String, Comparable<Boolean>> posMap = new LinkedHashMap<String, Comparable<Boolean>>();
            posMap.put("posStaffHaveData", Boolean.TRUE);
            posMap.put("posStaff", posStaffMap.get(positionId));
            if (posStaffMap.get(positionId) == null) {
                posMap.put("posStaffHaveData", Boolean.FALSE);
                posMap.put("posStaff", Integer.valueOf(0));
            }
            posMap.put("posActualCount", Integer.valueOf(posActualCount));
            posMap.put("posOnWayCount", Integer.valueOf(posOnWayCount));
            posMap.put("posAvaliableCount", Integer.valueOf((Integer)posMap.get("posStaff") - posActualCount - posOnWayCount));
            result.put("posInfo", posMap);
        }
        return result;
    }

    protected void checkParam(Context ctx, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        if (startDate == null) {
            throw new HRAffairException(HRAffairException.EMPTY_STARTDATE);
        }
        if (endDate == null) {
            throw new HRAffairException(HRAffairException.EMPTY_ENDDATE);
        }
        if (endDate.before(startDate)) {
            throw new HRAffairException(HRAffairException.ERROR_DATE);
        }
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        if (startYear + 1 < endYear || startYear + 1 == endYear && startMonth - 1 < endMonth) {
            throw new HRAffairException(HRAffairException.LIMIT_DATE);
        }
        if (StringUtils.isEmpty((String)orgId)) {
            throw new StaffManageException(StaffManageException.ORG_ID_CANNOT_NULL);
        }
        try {
            BOSUuid.read((String)orgId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StaffManageException(StaffManageException.PARAM_ID_NOT_REASONABLE, new Object[]{orgId});
        }
    }

    protected void checkParam(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            throw new StaffManageException(StaffManageException.ORG_ID_CANNOT_NULL);
        }
        if (StringUtils.isEmpty((String)permItemId)) {
            throw new StaffManageException(StaffManageException.PERMITEM_ID_CANNOT_NULL);
        }
        try {
            BOSUuid.read((String)orgId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StaffManageException(StaffManageException.PARAM_ID_NOT_REASONABLE, new Object[]{orgId});
        }
    }

    protected void checkParam(Context ctx, String orgId, String positionId, String permItemId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId) && StringUtils.isEmpty((String)positionId)) {
            throw new StaffManageException(StaffManageException.ORG_ID_CANNOT_NULL);
        }
        try {
            if (!StringUtils.isEmpty((String)orgId)) {
                BOSUuid.read((String)orgId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StaffManageException(StaffManageException.PARAM_ID_NOT_REASONABLE, new Object[]{orgId});
        }
        try {
            if (!StringUtils.isEmpty((String)positionId)) {
                BOSUuid.read((String)positionId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StaffManageException(StaffManageException.PARAM_ID_NOT_REASONABLE, new Object[]{positionId});
        }
    }

    protected void checkParam(Context ctx, String idsStr, String channelsStr, Date date, int containSub) throws BOSException, EASBizException {
        String[] channels;
        String[] ids;
        if (StringUtils.isEmpty((String)idsStr)) {
            throw new StaffManageException(StaffManageException.PARAM_ID_CANNOT_NULL);
        }
        if (StringUtils.isEmpty((String)channelsStr)) {
            throw new StaffManageException(StaffManageException.CHANNEL_CAN_NOT_NULL);
        }
        for (String id : ids = idsStr.split(",")) {
            if (StringUtils.isEmpty((String)id)) {
                throw new StaffManageException(StaffManageException.PARAM_ID_CANNOT_NULL);
            }
            try {
                BOSUuid.read((String)id);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new StaffManageException(StaffManageException.PARAM_ID_NOT_REASONABLE, new Object[]{id});
            }
        }
        for (String channel : channels = channelsStr.split(",")) {
            if (!StringUtils.isEmpty((String)channel) && Integer.valueOf(channel) >= 1 && Integer.valueOf(channel) <= 4) continue;
            throw new StaffManageException(StaffManageException.CHANNEL_NOT_REASONABLE, new Object[]{channel});
        }
        if (containSub > 1) {
            throw new StaffManageException(StaffManageException.CONTAINSUB_NOT_REASONABLE, new Object[]{containSub});
        }
    }

    protected StaffManageProjectCollection getProjects(Context ctx) throws BOSException, EASBizException {
        return StaffManageProjectFactory.getLocalInstance(ctx).getStaffManageProjectCollection("where state = 1");
    }

    protected Map<String, Integer> getOrgStaffMap(Context ctx, List<String> orgIds, List<Integer> channels, Date date, int containSub) throws BOSException, EASBizException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        this.getOrgProjectOrgStaff(ctx, result, channels, orgIds, date, containSub, "FAdminOrgID");
        this.getOtherProjectOrgStaff(ctx, result, channels, orgIds, date, containSub, "FpositionID");
        return result;
    }

    protected Map<String, Integer> getPositionStaffMap(Context ctx, List<String> positionIds, List<Integer> channels, Date date) throws BOSException, EASBizException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        this.getPosProjectPosStaff(ctx, result, channels, positionIds, date, "FpositionID");
        this.getOtherProjectPosStaff(ctx, result, channels, positionIds, date, "FpositionID");
        return result;
    }

    protected List<Integer> getStaffManageChannels(Context ctx, int year) throws BOSException, EASBizException {
        ArrayList<Integer> channels = new ArrayList<Integer>();
        boolean haveYearChannel = false;
        String staffChannelSQL = "select fchannel from T_HR_StaffManageProject where fyear = ? and fstate = 1 group by fchannel order by fchannel desc";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)staffChannelSQL, (Object[])new Object[]{year + ""});
        try {
            while (rowSet.next()) {
                int channelVal = rowSet.getInt("fchannel");
                if (channelVal == 1) {
                    haveYearChannel = true;
                    continue;
                }
                channels.add(channelVal);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (haveYearChannel) {
            channels.add(0, 1);
        }
        return channels;
    }

    public static String createTempTable(Context ctx, String orgId, String permItemId) throws BOSException {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String tempTableName = null;
        try {
            tempTableName = StaffManageServiceUtil.getTempTableName(ctx);
            StringBuffer sql = new StringBuffer(" select adminOrg.fid,adminOrg.fname_" + StaffManageServiceUtil.getLocal(ctx) + " as fname,adminOrg.flongnumber,adminOrg.fisleaf,adminOrg.fsortcode into ").append(tempTableName).append(" from T_ORG_Admin adminOrg").append(" inner join (").append(StaffManageServiceUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(StaffManageServiceUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) orgRange on adminOrg.fid = orgRange.forgid").append(" where (adminOrg.fparentid = '").append(orgId).append("'").append(" or adminOrg.fid = '").append(orgId).append("')").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            return tempTableName;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void getOrgProjectOrgStaff(Context ctx, Map<String, Integer> result, List<Integer> channels, List<String> orgIds, Date date, int containSub, String dimensionType) throws BOSException, EASBizException {
        try {
            for (Integer channel : channels) {
                if (orgIds.size() != 0 && orgIds.size() != result.size()) {
                    String channelDBCol = StaffManageChannelUtil.getStaffChannel(channel, DateTimeUtils.getMonth((Date)date));
                    StaffManageProjectCollection projectColl = this.getProjects(ctx, date, channel);
                    List<StaffManageProjectInfo> orgProjects = this.getProjectsOnType(ctx, projectColl, dimensionType);
                    if (orgProjects == null || orgProjects.size() == 0) continue;
                    orgIds.removeAll(result.keySet());
                    String orgStaffSQL = this.getOrgStaffSql(orgProjects, orgIds, channelDBCol, dimensionType);
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)orgStaffSQL, (Object[])new Object[]{containSub});
                    while (rowSet.next()) {
                        result.put(rowSet.getString("FAdminOrgID"), rowSet.getInt(channelDBCol));
                    }
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void getOtherProjectOrgStaff(Context ctx, Map<String, Integer> result, List<Integer> channels, List<String> orgIds, Date date, int containSub, String dimensionType) throws BOSException, EASBizException {
        this.getOrgProjectOrgStaff(ctx, result, channels, orgIds, date, containSub, dimensionType);
    }

    protected StaffManageProjectCollection getProjects(Context ctx, Date date, int channel) throws BOSException, EASBizException {
        int year = DateTimeUtils.getYear((Date)date);
        IStaffManageProject iStaffManageProject = StaffManageProjectFactory.getLocalInstance(ctx);
        return iStaffManageProject.getStaffManageProjectCollection("select * where year = '" + year + "' and channel = '" + channel + "' and state = 1");
    }

    protected List<StaffManageProjectInfo> getProjectsOnType(Context ctx, StaffManageProjectCollection projectColl, String type) throws BOSException, EASBizException {
        if (projectColl == null || projectColl.size() == 0) {
            logger.error((Object)"getOrgProjects no porject");
            return Collections.emptyList();
        }
        ArrayList<StaffManageProjectInfo> projects = new ArrayList<StaffManageProjectInfo>();
        for (int i = 0; i < projectColl.size(); ++i) {
            StaffManageRuleFieldCollection dimensions = StaffManageProjectFactory.getLocalInstance(ctx).getDimensions(projectColl.get(i));
            String dimensionType = this.getDimension(dimensions);
            if (!type.equals(dimensionType)) continue;
            projects.add(projectColl.get(i));
        }
        return projects;
    }

    protected String getOrgStaffSql(List<StaffManageProjectInfo> projects, List<String> orgIds, String channelDBCol, String dimensionType) {
        StringBuffer selectSql = new StringBuffer("select * from ");
        StringBuffer tableUnionSql = new StringBuffer("(");
        StringBuffer whereSql = new StringBuffer();
        for (int i = 0; i < projects.size(); ++i) {
            if ("FAdminOrgID".equals(dimensionType)) {
                tableUnionSql.append(" select FAdminOrgID,FContainSub,FState,FShareState,");
            } else if ("FpositionID".equals(dimensionType)) {
                tableUnionSql.append(" select FAdminOrgID,FpositionID,FContainSub,FState,FShareState,");
            } else {
                tableUnionSql.append(this.getOtherDimensionUnionSelectSQL());
            }
            tableUnionSql.append(channelDBCol);
            tableUnionSql.append(" from ");
            tableUnionSql.append(projects.get(i).getTableName());
            if (i >= projects.size() - 1) continue;
            tableUnionSql.append(" union ");
        }
        tableUnionSql.append(" ) tab ");
        whereSql.append(" where tab.FContainSub = ? and tab.FState = 1 and tab.FShareState <> 1 ");
        if (orgIds.size() == 1) {
            whereSql.append(" and tab.FAdminOrgID = '").append(orgIds.get(0)).append("'");
        } else {
            whereSql.append(" and tab.FAdminOrgID in (");
            whereSql.append(StaffManageServiceUtil.fidsToInSQL(new HashSet<String>(orgIds))).append(")");
        }
        if ("FpositionID".equals(dimensionType)) {
            whereSql.append(" and (tab.FpositionID = '' or tab.FpositionID is null)");
        } else {
            whereSql.append(this.getOtherDimensionWhereSQL());
        }
        logger.error((Object)("StaffManageFacadeControllerBean getOrgStaffSql SQL:" + selectSql.toString() + tableUnionSql.toString() + whereSql.toString()));
        return selectSql.append(tableUnionSql.append(whereSql)).toString();
    }

    protected String getOtherDimensionUnionSelectSQL() {
        return "";
    }

    protected String getOtherDimensionWhereSQL() {
        return "";
    }

    protected List<String> getOrgIds(Context ctx, String tableName) throws BOSException {
        ArrayList<String> orgIds = new ArrayList<String>();
        StringBuffer orgIdSql = new StringBuffer("select fid from " + tableName);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)orgIdSql.toString());
        try {
            while (rowSet.next()) {
                orgIds.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return orgIds;
    }

    protected Map<String, Integer> getSubActualStaffing(Context ctx, String orgId, String tempTableName, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        try {
            StringBuffer sql = new StringBuffer("select adminOrg.fid,isnull(actualStaffing.subActualStaffing,0) subActualStaffing").append(" from ").append(tempTableName).append(" adminOrg").append(" left join (").append(" select adcount.fid adcountid,count(emprelation.fpersonid) subActualStaffing from T_ORG_Admin adcount").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(StaffManageServiceUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(StaffManageServiceUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" left join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" left join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" left join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" where (adcount.fparentid = '").append(orgId).append("'").append(" or adcount.fid = '").append(orgId).append("')").append(" and adcount.fissealup = 0 and child.fissealup = 0").append(" and adcount.fisstartshr = 1 and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" group by adcount.fid").append(" ) actualStaffing on adminOrg.fid = actualStaffing.adcountid");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                result.put(rowSet.getString("fid"), rowSet.getInt("subActualStaffing"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected Map<String, Integer> getSubOnWayPersoncount(Context ctx, String orgId, String tempTableName, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        try {
            StringBuffer sql = new StringBuffer("select adminOrg.fid,isnull(onWayPerson.onWayPersoncount,0) subOnWayPersoncount").append(" from ").append(tempTableName).append(" adminOrg").append(" left join (").append(" select adcount.fid adcountid,sum(changedata.fcount) onWayPersoncount  from T_ORG_Admin adcount").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(StaffManageServiceUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(StaffManageServiceUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpPosChangeData changedata on child.fid = changedata.fadminorgid").append(" where (adcount.fparentid = '").append(orgId).append("'").append(" or adcount.fid = '").append(orgId).append("')").append(" and adcount.fissealup = 0 and child.fissealup = 0").append(" and adcount.fisstartshr = 1 and child.fisstartshr = 1").append(" and changedata.fisenrolled = 1 and changedata.fisexcluded = 0").append(" and (changedata.fbillstate in (1,2) or (changedata.fbillstate = 3 and changedata.fbizdate > ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)new Date())).append("))").append(" group by adcount.fid").append(" ) onWayPerson on adminOrg.fid = onWayPerson.adcountid");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                result.put(rowSet.getString("fid"), rowSet.getInt("subOnWayPersoncount"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected String getDimension(StaffManageRuleFieldCollection dimensionColl) {
        if (dimensionColl.size() == 1 && "FAdminOrgID".equals(dimensionColl.get(0).getColumn())) {
            return "FAdminOrgID";
        }
        if (dimensionColl.size() == 2 && "FAdminOrgID".equals(dimensionColl.get(0).getColumn()) && "FpositionID".equals(dimensionColl.get(1).getColumn())) {
            return "FpositionID";
        }
        return this.otherDimension(dimensionColl);
    }

    protected String otherDimension(StaffManageRuleFieldCollection dimensionColl) {
        return "";
    }

    protected StaffManageOrgSubInfoDTO getOrgSubStaffInfo(Context ctx, String orgId, List<Integer> channels, Date date) throws BOSException, EASBizException {
        StaffManageOrgSubInfoDTO orgStaffDTO = new StaffManageOrgSubInfoDTO();
        ArrayList<String> orgIds = new ArrayList<String>();
        orgIds.add(orgId);
        Map<String, Integer> orgSubStaffMap = this.getOrgStaffMap(ctx, orgIds, channels, date, 1);
        int orgSubStaffCount = orgSubStaffMap.get(orgId) == null ? 0 : orgSubStaffMap.get(orgId);
        int actualStaffCount = StaffManageServiceUtil.getLimitActualPersonCount(ctx, orgId, null, null, true);
        int onWayPersoncount = StaffManageServiceUtil.getOrgSubOnWayCount(ctx, orgId);
        int avaliableStaffCount = orgSubStaffCount - actualStaffCount - onWayPersoncount;
        orgStaffDTO.setOrgId(orgId);
        orgStaffDTO.setOrgSubStaff(orgSubStaffCount);
        orgStaffDTO.setOrgSubActualCount(actualStaffCount);
        orgStaffDTO.setOrgSubOnWayCount(onWayPersoncount);
        orgStaffDTO.setOrgSubAvaliableStaff(avaliableStaffCount);
        orgStaffDTO.setIsDirect(Boolean.FALSE);
        orgStaffDTO.setHaveStaffData(Boolean.TRUE);
        if (orgSubStaffMap.get(orgId) == null) {
            orgStaffDTO.setHaveStaffData(Boolean.FALSE);
        }
        return orgStaffDTO;
    }

    protected StaffManageOrgSubInfoDTO getOrgDirectStaffInfo(Context ctx, String orgId, List<Integer> channels, Date date) throws BOSException, EASBizException {
        StaffManageOrgSubInfoDTO orgStaffDTO = new StaffManageOrgSubInfoDTO();
        ArrayList<String> orgIds = new ArrayList<String>();
        orgIds.add(orgId);
        Map<String, Integer> orgDirectStaffMap = this.getOrgStaffMap(ctx, orgIds, channels, date, 0);
        int orgDirectStaffCount = orgDirectStaffMap.get(orgId) == null ? 0 : orgDirectStaffMap.get(orgId);
        int actualStaffCount = StaffManageServiceUtil.getOrgDirectActualCount(ctx, orgId);
        int onWayPersoncount = StaffManageServiceUtil.getOrgDirectOnWayCount(ctx, orgId);
        int avaliableStaffCount = orgDirectStaffCount - actualStaffCount - onWayPersoncount;
        orgStaffDTO.setOrgId(orgId);
        orgStaffDTO.setOrgDirectStaff(orgDirectStaffCount);
        orgStaffDTO.setOrgDirectActualCount(actualStaffCount);
        orgStaffDTO.setOrgDirectOnWayCount(onWayPersoncount);
        orgStaffDTO.setOrgDirectAvaliableStaff(avaliableStaffCount);
        orgStaffDTO.setIsDirect(Boolean.TRUE);
        orgStaffDTO.setHaveStaffData(Boolean.TRUE);
        if (orgDirectStaffMap.get(orgId) == null) {
            orgStaffDTO.setHaveStaffData(Boolean.FALSE);
        }
        return orgStaffDTO;
    }

    protected void getPosProjectPosStaff(Context ctx, Map<String, Integer> result, List<Integer> channels, List<String> positionIds, Date date, String dimensionType) throws BOSException, EASBizException {
        try {
            for (Integer channel : channels) {
                if (positionIds.size() != 0 && positionIds.size() != result.size()) {
                    String channelDBCol = StaffManageChannelUtil.getStaffChannel(channel, DateTimeUtils.getMonth((Date)date));
                    StaffManageProjectCollection projectColl = this.getProjects(ctx, date, channel);
                    List<StaffManageProjectInfo> orgProjects = this.getProjectsOnType(ctx, projectColl, dimensionType);
                    if (orgProjects == null || orgProjects.size() == 0) continue;
                    positionIds.removeAll(result.keySet());
                    String orgStaffSQL = this.getPositionStaffSql(orgProjects, positionIds, channelDBCol, dimensionType);
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)orgStaffSQL);
                    while (rowSet.next()) {
                        result.put(rowSet.getString("FpositionID"), rowSet.getInt(channelDBCol));
                    }
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void getOtherProjectPosStaff(Context ctx, Map<String, Integer> result, List<Integer> channels, List<String> positionIds, Date date, String dimensionType) throws BOSException, EASBizException {
    }

    protected String getPositionStaffSql(List<StaffManageProjectInfo> projects, List<String> positionIds, String channelDBCol, String dimensionType) {
        StringBuffer selectSql = new StringBuffer("select * from ");
        StringBuffer tableUnionSql = new StringBuffer("(");
        StringBuffer whereSql = new StringBuffer();
        for (int i = 0; i < projects.size(); ++i) {
            if ("FpositionID".equals(dimensionType)) {
                tableUnionSql.append(" select FAdminOrgID,FpositionID,FContainSub,FState,");
            } else {
                tableUnionSql.append(this.getOtherDimensionUnionSelectSQL());
            }
            tableUnionSql.append(channelDBCol);
            tableUnionSql.append(" from ");
            tableUnionSql.append(projects.get(i).getTableName());
            if (i >= projects.size() - 1) continue;
            tableUnionSql.append(" union ");
        }
        tableUnionSql.append(" ) tab ");
        whereSql.append(" where tab.FState = 1 ");
        if (positionIds.size() == 1) {
            whereSql.append(" and tab.FpositionID = '").append(positionIds.get(0)).append("'");
        } else {
            whereSql.append(" and tab.FpositionID in (");
            whereSql.append(StaffManageServiceUtil.fidsToInSQL(new HashSet<String>(positionIds))).append(")");
        }
        whereSql.append(this.getOtherDimensionWhereSQL());
        logger.error((Object)("StaffManageFacadeControllerBean getPositionStaffSql SQL:" + selectSql.toString() + tableUnionSql.toString() + whereSql.toString()));
        return selectSql.append(tableUnionSql.append(whereSql)).toString();
    }

    protected Boolean getStaffManageOrgTrend(Context ctx, Map<String, List<String>> staffManageOrgMap, String orgId, List<Integer> channels, Date startDate, Date endDate, int containSub) throws BOSException, EASBizException {
        if (channels == null || channels.size() == 0) {
            return Boolean.FALSE;
        }
        LinkedHashMap<String, String> channelDBToStaffMap = new LinkedHashMap<String, String>();
        this.getOrgProjectOrgStaff(ctx, channelDBToStaffMap, orgId, channels, startDate, endDate, containSub, "FAdminOrgID");
        this.getOtherProjectOrgStaff(ctx, channelDBToStaffMap, orgId, channels, startDate, endDate, containSub, "FpositionID");
        int year = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        block0: for (int i = startMonth; i <= endMonth; ++i) {
            if (channelDBToStaffMap.size() == 0) {
                return Boolean.FALSE;
            }
            staffManageOrgMap.get("labelList").add(year + "-" + i);
            for (Integer channel : channels) {
                if (channelDBToStaffMap.get(StaffManageChannelUtil.getStaffChannel(channel, i)) == null) continue;
                staffManageOrgMap.get("dataList").add((String)channelDBToStaffMap.get(StaffManageChannelUtil.getStaffChannel(channel, i)));
                continue block0;
            }
        }
        return Boolean.TRUE;
    }

    protected void getOrgProjectOrgStaff(Context ctx, Map<String, String> channelDBToStaffMap, String orgId, List<Integer> channels, Date startDate, Date endDate, int containSub, String dimensionType) throws BOSException, EASBizException {
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        ArrayList<String> orgIds = new ArrayList<String>();
        orgIds.add(orgId);
        try {
            for (Integer channel : channels) {
                if (channelDBToStaffMap.size() == 0) {
                    List<String> channelDBCols = this.getChannelDBCols(ctx, channel, startMonth, endMonth);
                    String channelDBColStr = "";
                    for (int i = 0; i < channelDBCols.size(); ++i) {
                        channelDBColStr = channelDBColStr + channelDBCols.get(i);
                        if (i >= channelDBCols.size() - 1) continue;
                        channelDBColStr = channelDBColStr + ",";
                    }
                    StaffManageProjectCollection projectColl = this.getProjects(ctx, startDate, channel);
                    List<StaffManageProjectInfo> orgProjects = this.getProjectsOnType(ctx, projectColl, dimensionType);
                    if (orgProjects == null || orgProjects.size() == 0) continue;
                    String orgStaffSQL = this.getOrgStaffSql(orgProjects, orgIds, channelDBColStr, dimensionType);
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)orgStaffSQL, (Object[])new Object[]{containSub});
                    if (rowSet.size() > 1) {
                        logger.error((Object)("getStaffManageOrgTrend org staff line more than 1:" + rowSet.size() + " orgId:" + orgId));
                    }
                    if (!rowSet.next()) continue;
                    for (String channelDBCol : channelDBCols) {
                        channelDBToStaffMap.put(channelDBCol, rowSet.getString(channelDBCol));
                    }
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void getOtherProjectOrgStaff(Context ctx, Map<String, String> channelDBToStaffMap, String orgId, List<Integer> channels, Date startDate, Date endDate, int containSub, String dimensionType) throws BOSException, EASBizException {
        this.getOrgProjectOrgStaff(ctx, channelDBToStaffMap, orgId, channels, startDate, endDate, containSub, dimensionType);
    }

    protected void afterGetStaffManage(Map<String, List<String>> staffManageOrgMap, Date startDate, Date endDate, Boolean isOldYearHaveData, Boolean isNewYearHaveData) throws BOSException {
        int endMonth;
        int startMonth;
        int year;
        if (isOldYearHaveData.booleanValue() && isNewYearHaveData.booleanValue() || !isOldYearHaveData.booleanValue() && !isNewYearHaveData.booleanValue()) {
            return;
        }
        if (isOldYearHaveData.booleanValue()) {
            year = DateTimeUtils.getYear((Date)endDate);
            startMonth = DateTimeUtils.getMonth((Date)HRManagerUtil.getDefaultMinStartDate((Date)endDate));
            endMonth = DateTimeUtils.getMonth((Date)endDate);
            for (int i = startMonth; i <= endMonth; ++i) {
                staffManageOrgMap.get("labelList").add(year + "-" + i);
                staffManageOrgMap.get("dataList").add("0");
            }
        }
        if (isNewYearHaveData.booleanValue()) {
            year = DateTimeUtils.getYear((Date)startDate);
            startMonth = DateTimeUtils.getMonth((Date)startDate);
            endMonth = DateTimeUtils.getMonth((Date)HRManagerUtil.getDefaultMaxEndDate((Date)startDate));
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<String> datas = new ArrayList<String>();
            for (int i = startMonth; i <= endMonth; ++i) {
                labels.add(year + "-" + i);
                datas.add("0");
            }
            staffManageOrgMap.get("labelList").addAll(0, labels);
            staffManageOrgMap.get("dataList").addAll(0, datas);
        }
    }

    protected List<String> getChannelDBCols(Context ctx, int channel, int startMonth, int endMonth) {
        ArrayList<String> channelDBCols = new ArrayList<String>();
        for (int i = startMonth; i <= endMonth; ++i) {
            String channelDBCol = StaffManageChannelUtil.getStaffChannel(channel, i);
            if (channelDBCols.contains(channelDBCol)) continue;
            channelDBCols.add(channelDBCol);
        }
        return channelDBCols;
    }

    public static List<Integer> channelStrToList(String channelStr) {
        if (StringUtils.isEmpty((String)channelStr)) {
            return Collections.emptyList();
        }
        String[] channelArray = channelStr.split(",");
        ArrayList<Integer> channels = new ArrayList<Integer>();
        for (String channel : channelArray) {
            channels.add(Integer.valueOf(channel));
        }
        return channels;
    }

    @Override
    protected boolean _useOldStaff(Context ctx) throws BOSException {
        try {
            boolean newParam = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_USE_SHR_StaffManage", null);
            boolean oldParam = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_USE_SHR_PersonPlan", null);
            if (!newParam && oldParam) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"staffmanagefacade useOldStaff get param error!");
        }
        return false;
    }

    @Override
    protected void _refreshStaffManageOrgTrend(Context ctx) throws BOSException, EASBizException {
        StaffManageOrgTrendFactory.getLocalInstance(ctx).delete("where id is not null");
        List<String> orgIds = this.getOrgTrendOrgs(ctx);
        Date startDate = this.getOrgTrendStartDate(ctx);
        Date endDate = this.getOrgTrendEndDate(ctx);
        if (startDate.after(endDate)) {
            return;
        }
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        CoreBaseCollection orgTrendColl = new CoreBaseCollection();
        for (int year = startYear; year <= endYear; ++year) {
            List<Integer> yearChannels = this.getStaffManageChannels(ctx, year);
            if (yearChannels.size() == 0) continue;
            HashMap<String, Map<String, Integer>> orgToStaffMap = new HashMap<String, Map<String, Integer>>();
            if (year == startYear) {
                endDate = HRManagerUtil.getDefaultMaxEndDate((Date)startDate);
            } else if (year == endYear) {
                endDate = this.getOrgTrendEndDate(ctx);
                startDate = HRManagerUtil.getDefaultMinStartDate((Date)endDate);
            } else {
                startDate = DateHelper.getYearOfFirstDay(year);
                endDate = DateHelper.getYearOfLastDay(year);
            }
            this.getOrgProjectAllOrgStaff(ctx, orgToStaffMap, yearChannels, orgIds, startDate, 1, "FAdminOrgID");
            this.getOtherProjectAllOrgStaff(ctx, orgToStaffMap, yearChannels, orgIds, startDate, 1, "FpositionID");
            if (orgToStaffMap.size() == 0) continue;
            int startMonth = DateTimeUtils.getMonth((Date)startDate);
            int endMonth = DateTimeUtils.getMonth((Date)endDate);
            block1: for (Map.Entry entry : orgToStaffMap.entrySet()) {
                String adminOrgId = (String)entry.getKey();
                for (Integer channel : yearChannels) {
                    if (((Map)orgToStaffMap.get(adminOrgId)).get(StaffManageChannelUtil.getStaffChannel(channel, endMonth)) == null) continue;
                    AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
                    adminInfo.setId(BOSUuid.read((String)adminOrgId));
                    for (int month = startMonth; month <= endMonth; ++month) {
                        StaffManageOrgTrendInfo orgTrendInfo = new StaffManageOrgTrendInfo();
                        orgTrendInfo.setAdminOrgUnit(adminInfo);
                        orgTrendInfo.setYear(year);
                        orgTrendInfo.setMonth(month);
                        orgTrendInfo.setStaffCount((Integer)((Map)orgToStaffMap.get(adminOrgId)).get(StaffManageChannelUtil.getStaffChannel(channel, month)));
                        orgTrendInfo.setIsStaffManage(Boolean.TRUE);
                        orgTrendColl.add((CoreBaseInfo)orgTrendInfo);
                    }
                    continue block1;
                }
            }
        }
        if (orgTrendColl != null && orgTrendColl.size() > 0) {
            StaffManageOrgTrendFactory.getLocalInstance(ctx).addnew(orgTrendColl);
        }
    }

    protected List<String> getOrgTrendOrgs(Context ctx) throws BOSException {
        ArrayList<String> orgIds = new ArrayList<String>();
        String orgSql = "select fid from t_org_admin where FISSEALUP = 0 and fisstartshr=1";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)orgSql);
            while (iRowSet.next()) {
                orgIds.add(iRowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return orgIds;
    }

    protected Date getOrgTrendStartDate(Context ctx) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(1, -10);
        return ca.getTime();
    }

    protected Date getOrgTrendEndDate(Context ctx) {
        return new Date();
    }

    protected void getOrgProjectAllOrgStaff(Context ctx, Map<String, Map<String, Integer>> orgToStaffMap, List<Integer> channels, List<String> orgIds, Date date, int containSub, String dimensionType) throws BOSException, EASBizException {
        try {
            for (Integer channel : channels) {
                if (orgIds.size() != 0 && orgIds.size() != orgToStaffMap.size()) {
                    StaffManageProjectCollection projectColl = this.getProjects(ctx, date, channel);
                    List<StaffManageProjectInfo> orgProjects = this.getProjectsOnType(ctx, projectColl, dimensionType);
                    if (orgProjects == null || orgProjects.size() == 0) continue;
                    IStaffManageChannel iStaffManageChannel = StaffManageChannelUtil.getInstance(orgProjects.get(0).getChannel());
                    String channelDBColStr = iStaffManageChannel.getSQLChip();
                    String[] channelDBColArr = channelDBColStr.split(",");
                    String orgStaffSQL = this.getOrgStaffSql(orgProjects, orgIds, channelDBColStr, dimensionType);
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)orgStaffSQL, (Object[])new Object[]{containSub});
                    while (rowSet.next()) {
                        HashMap<String, Integer> channelColToStaffCounts = new HashMap<String, Integer>();
                        for (String channelDBCol : channelDBColArr) {
                            channelColToStaffCounts.put(channelDBCol, rowSet.getInt(channelDBCol));
                        }
                        orgToStaffMap.put(rowSet.getString("FAdminOrgID"), channelColToStaffCounts);
                    }
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void getOtherProjectAllOrgStaff(Context ctx, Map<String, Map<String, Integer>> orgToStaffMap, List<Integer> channels, List<String> orgIds, Date date, int containSub, String dimensionType) throws BOSException, EASBizException {
        this.getOrgProjectAllOrgStaff(ctx, orgToStaffMap, channels, orgIds, date, containSub, dimensionType);
    }
}

