/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.staffcontrol.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.shr.staffcontrol.AbstractStaffManageProjectInfo;
import com.kingdee.shr.staffcontrol.IStaffManageProject;
import com.kingdee.shr.staffcontrol.IStaffManageRule;
import com.kingdee.shr.staffcontrol.StaffManageControlLimitEnum;
import com.kingdee.shr.staffcontrol.StaffManageControlWayEnum;
import com.kingdee.shr.staffcontrol.StaffManageException;
import com.kingdee.shr.staffcontrol.StaffManageProjectCollection;
import com.kingdee.shr.staffcontrol.StaffManageProjectFactory;
import com.kingdee.shr.staffcontrol.StaffManageProjectInfo;
import com.kingdee.shr.staffcontrol.StaffManageProjectStateEnum;
import com.kingdee.shr.staffcontrol.StaffManageProjectTableCollection;
import com.kingdee.shr.staffcontrol.StaffManageProjectTableFactory;
import com.kingdee.shr.staffcontrol.StaffManageProjectTableInfo;
import com.kingdee.shr.staffcontrol.StaffManageProjectTableShareStateEnum;
import com.kingdee.shr.staffcontrol.StaffManageRuleFactory;
import com.kingdee.shr.staffcontrol.StaffManageRuleFieldCollection;
import com.kingdee.shr.staffcontrol.StaffManageRuleFieldInfo;
import com.kingdee.shr.staffcontrol.StaffManageRuleInfo;
import com.kingdee.shr.staffcontrol.app.AbstractStaffManageProjectControllerBean;
import com.kingdee.shr.staffcontrol.util.IStaffManageChannel;
import com.kingdee.shr.staffcontrol.util.StaffManageChannelUtil;
import com.kingdee.shr.staffcontrol.util.StaffManageServiceUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class StaffManageProjectControllerBean
extends AbstractStaffManageProjectControllerBean {
    private static final long serialVersionUID = 1L;
    private static final String ADMIN_ORG_ID = "FAdminOrgID";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.staffcontrol.app.StaffManageProjectControllerBean");

    @Override
    protected void _enableProject(Context ctx, String projectId) throws BOSException, EASBizException {
        StaffManageProjectInfo projectInfo = super.getStaffManageProjectInfo(ctx, (IObjectPK)new ObjectUuidPK(projectId));
        String dateStr = "";
        if (projectInfo == null) {
            throw new StaffManageException(StaffManageException.PROJECT_IS_NULL);
        }
        StaffManageProjectCollection coll = super.getStaffManageProjectCollection(ctx, "select id where tableName is not null");
        if (coll != null && coll.size() >= 500) {
            throw new StaffManageException(StaffManageException.STAFF_TABLE_CANNOT_MORE_THAN_FIVEHUNDRED);
        }
        if (StringUtils.isEmpty((String)projectInfo.getTableName())) {
            StaffManageRuleFieldCollection dimensions = this._getDimensions(ctx, (IObjectValue)projectInfo);
            if (dimensions == null || dimensions.size() == 0) {
                throw new StaffManageException(StaffManageException.DIMENSION_IS_NULL);
            }
            if (dimensions.size() >= 100) {
                throw new StaffManageException(StaffManageException.DIMENSION_CANNOT_MORE_THAN_HUNDRED);
            }
            StringBuffer sb = new StringBuffer();
            dateStr = StaffManageProjectControllerBean.getStrByDate(new Date());
            sb.append("Create Table T_HR_Staff" + dateStr);
            sb.append("( ");
            sb.append("FNumber VARCHAR(170),");
            sb.append(this.getCreateDimensionsSQL(dimensions));
            sb.append("FContainSub INT,");
            sb.append(this.getCreateChannelSQL(projectInfo));
            sb.append("FONWAYADDCOUNT INT,");
            sb.append("FONWAYSUBCOUNT INT,");
            sb.append("FPersonCount INT,");
            sb.append("FStaffShare INT,");
            sb.append("FShareState INT,");
            sb.append("FShareParent VARCHAR(44),");
            sb.append("FControlWay INT,");
            sb.append("FEnableTime DateTime,");
            sb.append("FState INT,");
            sb.append("FHROrgUnit VARCHAR(100),");
            sb.append("FDescription NVARCHAR(255),");
            sb.append("FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),");
            sb.append("FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FID VARCHAR(44) DEFAULT '' NOT NULL,");
            sb.append("CONSTRAINT PK_HR_SM" + dateStr + " PRIMARY KEY (FID)");
            sb.append(" )");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        String updateProjectSQL = "update t_hr_staffmanageproject set fstate = 1,FLastUpdateUserID = '" + this.getUserInfo(ctx).getId() + "',FLastUpdateTime = {ts'" + this.getTime() + "'} where fid = '" + projectId + "' ";
        if (dateStr != "") {
            updateProjectSQL = "update t_hr_staffmanageproject set fstate = 1,ftableName =  'T_HR_Staff" + dateStr + "' ,FLastUpdateUserID = '" + this.getUserInfo(ctx).getId() + "',FLastUpdateTime = {ts'" + this.getTime() + "'} where fid = '" + projectId + "' ";
        }
        DbUtil.execute((Context)ctx, (String)updateProjectSQL);
    }

    protected StaffManageRuleFieldCollection _getDimensions(Context ctx, IObjectValue projectInfo) throws BOSException, EASBizException {
        if (projectInfo == null) {
            throw new StaffManageException(StaffManageException.PROJECT_IS_NULL);
        }
        StaffManageRuleInfo ruleInfo = ((AbstractStaffManageProjectInfo)projectInfo).getRule();
        if (ruleInfo == null || ruleInfo.getId() == null) {
            throw new StaffManageException(StaffManageException.RULEID_IS_NULL);
        }
        IStaffManageRule staffManageRule = StaffManageRuleFactory.getLocalInstance(ctx);
        ruleInfo = staffManageRule.getStaffManageRuleInfo((IObjectPK)new ObjectUuidPK(ruleInfo.getId().toString()));
        if (ruleInfo == null) {
            throw new StaffManageException(StaffManageException.RULEINFO_ID_NULL);
        }
        return ruleInfo.getStaffManageRuleField();
    }

    protected String getCreateDimensionsSQL(StaffManageRuleFieldCollection dimensions) throws EASBizException {
        String sql = "";
        boolean haveAdminOrg = false;
        for (int i = 0; i < dimensions.size(); ++i) {
            StaffManageRuleFieldInfo ruleFieldInfo = dimensions.get(i);
            String columnSQL = ruleFieldInfo.getColumn() + " VARCHAR(100),";
            if (ADMIN_ORG_ID.equals(ruleFieldInfo.getColumn())) {
                columnSQL = "FAdminOrgID VARCHAR(100) DEFAULT '' NOT NULL,";
                haveAdminOrg = true;
            }
            sql = sql + columnSQL;
        }
        if (!haveAdminOrg) {
            throw new StaffManageException(StaffManageException.DONOT_HAVE_ADMINORGID);
        }
        return sql;
    }

    protected String getCreateChannelSQL(StaffManageProjectInfo projectInfo) {
        String sql = "";
        switch (projectInfo.getChannel().getValue()) {
            case 2: {
                sql = "FStaffHaffYear1 INT, FHAFFYEARACTUAL1START INT, FHaffYearActual1 INT, FStaffHaffYear2 INT, FHAFFYEARACTUAL2START INT, FHaffYearActual2 INT,";
                break;
            }
            case 3: {
                for (int i = 1; i <= 4; ++i) {
                    sql = sql + "FStaffQuarter" + i + " INT, FQUARTERACTUAL" + i + "START INT, FQuarterActual" + i + " INT,";
                }
                break;
            }
            case 4: {
                for (int i = 1; i <= 12; ++i) {
                    sql = sql + "FStaffMonth" + i + " INT, FMONTHACTUAL" + i + "START INT, FMonthActual" + i + " INT,";
                }
                break;
            }
            default: {
                sql = "FStaffYear INT, FYEARACTUALSTART INT, FYearActual INT,";
            }
        }
        return sql;
    }

    @Override
    protected void _disableProject(Context ctx, String projectId) throws BOSException {
        String sql = "update t_hr_staffmanageproject set fstate = 2,FLastUpdateUserID = '" + this.getUserInfo(ctx).getId() + "',FLastUpdateTime = {ts'" + this.getTime() + "'} where fid = '" + projectId + "' ";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected static String getStrByDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(date);
    }

    protected UserInfo getUserInfo(Context ctx) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected String getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp timestamp = new Timestamp(d.getTime().getTime());
        return DateUtils.paseTimestamp2String((Timestamp)timestamp, (String)"yyyy-MM-dd HH:mm:ss");
    }

    @Override
    protected void _copyStaffProject(Context ctx, Map param) throws BOSException, EASBizException {
        this.checkParam(ctx, param);
        StaffManageProjectInfo projectInfo = super.getStaffManageProjectInfo(ctx, (IObjectPK)new ObjectUuidPK(param.get("projectId").toString()));
        param.put("tableName", projectInfo.getTableName());
        StaffManageProjectInfo copyProjectInfo = this.copyProject(ctx, param, projectInfo);
        this._enableProject(ctx, copyProjectInfo.getId().toString());
        this.copyStaffTableRowInfo(ctx, param, copyProjectInfo);
    }

    protected void checkParam(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null || param.get("projectId") == null || param.get("projectNumber") == null || param.get("projectName") == null || param.get("year") == null) {
            throw new StaffManageException(StaffManageException.EXCEPTION75);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("_copyStaffProject param:" + param.toString()));
        }
        if (StringUtils.isEmpty((String)param.get("projectId").toString()) || StringUtils.isEmpty((String)param.get("projectNumber").toString()) || StringUtils.isEmpty((String)param.get("projectName").toString()) || StringUtils.isEmpty((String)param.get("year").toString())) {
            throw new StaffManageException(StaffManageException.EXCEPTION75);
        }
        try {
            BOSUuid.read((String)param.get("projectId").toString());
        }
        catch (Exception e) {
            throw new StaffManageException(StaffManageException.PARAM_ID_NOT_REASONABLE, new Object[]{param.get("projectId")});
        }
    }

    protected StaffManageProjectInfo copyProject(Context ctx, Map<String, String> param, StaffManageProjectInfo projectInfo) throws BOSException, EASBizException {
        String year = param.get("year");
        StaffManageProjectInfo copyProjectInfo = new StaffManageProjectInfo();
        copyProjectInfo.setHrOrgUnit(projectInfo.getHrOrgUnit());
        copyProjectInfo.setAdminOrgUnit(projectInfo.getAdminOrgUnit());
        copyProjectInfo.setRule(projectInfo.getRule());
        copyProjectInfo.setChannel(projectInfo.getChannel());
        copyProjectInfo.setState(projectInfo.getState());
        copyProjectInfo.setGather(projectInfo.isGather());
        copyProjectInfo.setNumber(param.get("projectNumber"));
        copyProjectInfo.setYear(year);
        Map projectNameMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)param.get("projectName").toString(), Map.class);
        for (Map.Entry entry : projectNameMap.entrySet()) {
            copyProjectInfo.setName((String)entry.getValue(), new Locale((String)entry.getKey(), ""));
        }
        super._checkNumberDup(ctx, (IObjectValue)copyProjectInfo);
        this.checkExistEnableProject(ctx, copyProjectInfo);
        IObjectPK copyPk = StaffManageProjectFactory.getLocalInstance(ctx).addnew(copyProjectInfo);
        copyProjectInfo.setId(BOSUuid.read((String)copyPk.toString()));
        return copyProjectInfo;
    }

    protected void checkExistEnableProject(Context ctx, StaffManageProjectInfo projectInfo) throws BOSException, EASBizException {
        IStaffManageProject staffManageProjectService = StaffManageProjectFactory.getLocalInstance(ctx);
        FilterInfo numberFilter = new FilterInfo();
        numberFilter.getFilterItems().add(new FilterItemInfo("number", (Object)projectInfo.getNumber(), CompareType.EQUALS));
        if (staffManageProjectService.exists(numberFilter)) {
            throw new StaffManageException(StaffManageException.EXCEPTION77, new Object[]{projectInfo.getNumber()});
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)projectInfo.getYear()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)StaffManageProjectStateEnum.ENABLE));
        filter.getFilterItems().add(new FilterItemInfo("channel", (Object)projectInfo.getChannel()));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)projectInfo.getHrOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit", (Object)projectInfo.getAdminOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("rule", (Object)projectInfo.getRule().getId().toString()));
        if (staffManageProjectService.exists(filter)) {
            throw new StaffManageException(StaffManageException.EXCEPTION76);
        }
    }

    protected void copyStaffTableRowInfo(Context ctx, Map<String, String> param, StaffManageProjectInfo projectInfo) throws BOSException, EASBizException {
        String tableName = param.get("tableName");
        String year = param.get("year");
        StaffManageProjectInfo copyProjectInfo = null;
        try {
            copyProjectInfo = super.getStaffManageProjectInfo(ctx, (IObjectPK)new ObjectUuidPK(projectInfo.getId().toString()));
            StaffManageRuleFieldCollection dimensionColl = this._getDimensions(ctx, (IObjectValue)copyProjectInfo);
            IStaffManageChannel staffManageChannel = StaffManageChannelUtil.getInstance(copyProjectInfo.getChannel());
            List<String> channelCols = Arrays.asList(staffManageChannel.getSQLChip().split(","));
            String tableRowSQL = "select * from " + tableName;
            StaffManageProjectTableCollection rowColl = new StaffManageProjectTableCollection();
            StaffManageProjectTableInfo rowInfo = null;
            String dimensionColumn = null;
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)tableRowSQL);
            while (iRowSet.next()) {
                rowInfo = new StaffManageProjectTableInfo();
                for (int i = 0; i < dimensionColl.size(); ++i) {
                    dimensionColumn = dimensionColl.get(i).getColumn();
                    rowInfo.put(dimensionColumn, iRowSet.getString(dimensionColumn));
                }
                rowInfo.setStaffManageProject(copyProjectInfo);
                rowInfo.setControlWay(StaffManageControlWayEnum.getEnum(iRowSet.getInt("FControlWay")));
                rowInfo.setContainSub(StaffManageControlLimitEnum.getEnum(iRowSet.getInt("FContainSub")));
                rowInfo.setState(BaseItemStateEnum.getEnum((int)0));
                for (String channelCol : channelCols) {
                    rowInfo.put(channelCol, iRowSet.getInt(channelCol));
                }
                rowInfo.setShareState(StaffManageProjectTableShareStateEnum.getEnum(iRowSet.getInt("FShareState")));
                rowInfo.setShareParent(iRowSet.getString("FShareParent"));
                rowInfo.setDescription(iRowSet.getString("FDescription"));
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                StaffManageProjectTableInfo tableInfo = new StaffManageProjectTableInfo();
                String mainId = this.getCU(ctx, (ObjectBaseInfo)rowInfo).getId().toString();
                if (!iCodingRuleManager.isExist((IObjectValue)tableInfo, mainId)) {
                    rowInfo.setNumber(iRowSet.getString("FNumber") + "_" + year);
                }
                if (StaffManageServiceUtil.isExist(ctx, rowInfo, copyProjectInfo, dimensionColl)) continue;
                rowColl.add(rowInfo);
            }
            if (rowColl.size() > 0) {
                StaffManageProjectTableFactory.getLocalInstance(ctx).batchAddNew(rowColl);
            }
            String shareInSQL = "select fid,FShareParent from " + copyProjectInfo.getTableName() + " where FShareState = 2 ";
            IRowSet shareRowSet = DbUtil.executeQuery((Context)ctx, (String)shareInSQL);
            while (shareRowSet.next()) {
                String updateSQL = "update " + copyProjectInfo.getTableName() + " set FShareParent = '" + shareRowSet.getString("fid") + "' where FShareParent = '" + shareRowSet.getString("FShareParent") + "'";
                DbUtil.execute((Context)ctx, (String)updateSQL);
            }
            String noShareSQL = "select fid from " + copyProjectInfo.getTableName() + " where FShareState = 0 ";
            IRowSet noShareRowSet = DbUtil.executeQuery((Context)ctx, (String)noShareSQL);
            while (noShareRowSet.next()) {
                String updateSQL1 = "update " + copyProjectInfo.getTableName() + " set FShareParent = fid where fid = '" + noShareRowSet.getString("fid") + "'";
                DbUtil.execute((Context)ctx, (String)updateSQL1);
            }
        }
        catch (Exception e) {
            this.projectInfoRollBack(ctx, copyProjectInfo);
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void projectInfoRollBack(Context ctx, StaffManageProjectInfo projectInfo) {
        try {
            String delRowsSQL = "delete from " + projectInfo.getTableName();
            String dropSQL = "drop table " + projectInfo.getTableName();
            String delProjectSQL = "delete from t_hr_staffmanageproject where fid = '" + projectInfo.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)delRowsSQL);
            DbUtil.execute((Context)ctx, (String)dropSQL);
            DbUtil.execute((Context)ctx, (String)delProjectSQL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

