/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.staffcontrol.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.shr.staffcontrol.IStaffManageProject;
import com.kingdee.shr.staffcontrol.StaffManageException;
import com.kingdee.shr.staffcontrol.StaffManageProjectCollection;
import com.kingdee.shr.staffcontrol.StaffManageProjectFactory;
import com.kingdee.shr.staffcontrol.StaffManageProjectInfo;
import com.kingdee.shr.staffcontrol.StaffManageProjectTableCollection;
import com.kingdee.shr.staffcontrol.StaffManageProjectTableInfo;
import com.kingdee.shr.staffcontrol.StaffManageProjectTableShareStateEnum;
import com.kingdee.shr.staffcontrol.StaffManageRuleFactory;
import com.kingdee.shr.staffcontrol.StaffManageRuleFieldCollection;
import com.kingdee.shr.staffcontrol.StaffManageRuleFieldInfo;
import com.kingdee.shr.staffcontrol.StaffManageRuleInfo;
import com.kingdee.shr.staffcontrol.app.AbstractStaffManageProjectTableControllerBean;
import com.kingdee.shr.staffcontrol.util.IStaffManageChannel;
import com.kingdee.shr.staffcontrol.util.StaffManageChannelUtil;
import com.kingdee.shr.staffcontrol.util.StaffManageGatherUtilEx;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StaffManageProjectTableControllerBean
extends AbstractStaffManageProjectTableControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.staffcontrol.app.StaffManageProjectTableControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StaffManageProjectTableInfo table = (StaffManageProjectTableInfo)model;
        String shareParent = table.getShareParent();
        StaffManageProjectInfo staffManageProject = this.getStaffManangeProjectInfo(table, ctx);
        IStaffManageChannel channel = StaffManageChannelUtil.getInstance(staffManageProject.getChannel());
        if (!StringUtils.isEmpty((String)shareParent)) {
            String updateSql = "update " + staffManageProject.getTableName() + " set FShareState=2 , FShareParent='" + shareParent + "'   where fid='" + shareParent + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
            String fieldSql = "select " + channel.getSQLChip() + ",FControlWay  from  " + staffManageProject.getTableName() + "  where fid='" + shareParent + "'";
            IRowSet fieldRs = DbUtil.executeQuery((Context)ctx, (String)fieldSql);
            try {
                while (fieldRs.next()) {
                    table.put("FControlWay", fieldRs.getString("FControlWay"));
                    Map<String, String> channelNameMap = channel.getName2AliasMap(ctx);
                    for (String channelName : channelNameMap.keySet()) {
                        table.put(channelName, fieldRs.getString(channelName));
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
        }
        StringBuffer sql = new StringBuffer("insert into " + staffManageProject.getTableName() + "(");
        StringBuffer valueSql = new StringBuffer("values(");
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.addStaffManageRuleFields(ctx, table, staffManageProject, sql, valueSql, paramList);
        this.addStaffChannel(ctx, table, channel, sql, valueSql, paramList);
        this.addUserAndCU(sql, valueSql, ctx, table, paramList);
        String fid = this.addCommonFields(sql, valueSql, ctx, table, staffManageProject, paramList);
        sql.append(")");
        valueSql.append(")");
        sql.append(valueSql);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        BOSUuid id = table.getId();
        if (null != id) {
            StringBuffer updateShareInSql = new StringBuffer("update " + staffManageProject.getTableName() + " set FControlWay='" + table.getControlWay().getValue() + "', ");
            Map<String, String> channelNameMap = channel.getName2AliasMap(ctx);
            for (String channelName : channelNameMap.keySet()) {
                updateShareInSql.append(channelName + "=" + this.defaultZero(table.get(channelName)) + ",");
            }
            String subSql = updateShareInSql.substring(0, updateShareInSql.length() - 1);
            subSql = subSql + " where fshareparent='" + id.toString() + "'";
            DbUtil.execute((Context)ctx, (String)subSql);
        }
        return new ObjectUuidPK(fid);
    }

    protected void addStaffManageRuleFields(Context ctx, StaffManageProjectTableInfo table, StaffManageProjectInfo staffManageProject, StringBuffer sql, StringBuffer valueSql, List<Object> paramList) throws EASBizException, BOSException {
        StaffManageRuleInfo rule = StaffManageRuleFactory.getLocalInstance(ctx).getStaffManageRuleInfo((IObjectPK)new ObjectUuidPK(staffManageProject.getRule().getId()));
        if (!BaseItemStateEnum.ENABLE.equals((Object)rule.getState())) {
            throw new StaffManageException(StaffManageException.RULE_STATE_NOT_ENABLE);
        }
        StaffManageRuleFieldCollection fields = rule.getStaffManageRuleField();
        for (int i = 0; i < fields.size(); ++i) {
            StaffManageRuleFieldInfo field = fields.get(i);
            if (table.get(field.getColumn()) == null || "".equals(table.get(field.getColumn()))) continue;
            sql.append(field.getColumn() + ",");
            valueSql.append(" ?,");
            paramList.add(table.get(field.getColumn()));
        }
    }

    protected void addStaffChannel(Context ctx, StaffManageProjectTableInfo table, IStaffManageChannel channel, StringBuffer sql, StringBuffer valueSql, List<Object> paramList) throws EASBizException {
        String[] actualChannelSqlColArr;
        if (channel == null) {
            throw new StaffManageException(StaffManageException.PROJECT_CHANNEL_ERROR);
        }
        sql.append(channel.getSQLChip() + ",");
        Map<String, String> channelNameMap = channel.getName2AliasMap(ctx);
        for (String channelName : channelNameMap.keySet()) {
            valueSql.append(" ?,");
            paramList.add(this.defaultZero(table.get(channelName)));
        }
        String actualChannelSqlCols = channel.getActualSQLChip();
        sql.append(actualChannelSqlCols).append(",");
        for (String sqlCol : actualChannelSqlColArr = actualChannelSqlCols.split(",")) {
            valueSql.append(" ?,");
            paramList.add(this.defaultZero(table.get(sqlCol)));
        }
    }

    protected Object defaultZero(Object staffNum) {
        return staffNum == null || "".equals(staffNum) ? Integer.valueOf(0) : staffNum;
    }

    protected void addUserAndCU(StringBuffer sql, StringBuffer valueSql, Context ctx, StaffManageProjectTableInfo table, List<Object> paramList) {
        UserInfo userInfo = this.getUserInfo(ctx);
        CtrlUnitInfo cu = this.getCU(ctx, (ObjectBaseInfo)table);
        table.setCU(cu);
        Timestamp createtime = this.getTime();
        sql.append("FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,");
        valueSql.append(" ?,?,?,?,?, ");
        if (table.getCreator() != null && table.getCreateTime() != null) {
            paramList.add(table.getCreator().getId().toString());
            paramList.add(table.getCreateTime());
        } else {
            paramList.add(userInfo.getId().toString());
            paramList.add(createtime);
        }
        paramList.add(userInfo.getId().toString());
        paramList.add(createtime);
        paramList.add(cu.getId().toString());
    }

    protected String addCommonFields(StringBuffer sql, StringBuffer valueSql, Context ctx, StaffManageProjectTableInfo table, StaffManageProjectInfo staffManageProject, List<Object> paramList) throws EASBizException, BOSException {
        sql.append("FContainSub,FControlWay,FState,FHROrgUnit,FID,FNumber,FPersonCount,FShareParent,FShareState,FDescription");
        valueSql.append("?,?,?,?,?,?,?,?,?,?");
        if (table.get("FContainSub") != null) {
            paramList.add(table.get("FContainSub"));
        } else {
            paramList.add(table.getContainSub() != null ? table.getContainSub().getValue() : 1);
        }
        if (table.get("FControlWay") != null && !"".equals(table.get("FControlWay"))) {
            paramList.add(table.get("FControlWay"));
        } else {
            paramList.add(table.getControlWay().getValue());
        }
        paramList.add(table.getState() == null ? 0 : table.getState().getValue());
        paramList.add(table.getHrOrgUnit() == null ? "" : table.getHrOrgUnit().getId().toString());
        BOSUuid fid = table.getId() != null ? table.getId() : BOSUuid.create((BOSObjectType)table.getBOSType());
        paramList.add(fid.toString());
        this.generateNumberByCodingRule(table, staffManageProject, ctx);
        paramList.add(table.getNumber());
        paramList.add(this.defaultZero(table.get("FPersonCount")));
        String shareParent = table.getShareParent();
        if (StringUtil.isEmpty((String)shareParent)) {
            shareParent = fid.toString();
        }
        paramList.add(shareParent);
        StaffManageProjectTableShareStateEnum shareState = table.getShareState();
        if (shareState == null) {
            shareState = StaffManageProjectTableShareStateEnum.DO_NOT_SHARE;
        }
        paramList.add(shareState.getValue());
        if (table.get("FDescription") != null && !"".equals(table.get("FDescription"))) {
            paramList.add(table.get("FDescription"));
        } else if (table.get("description") != null && !"".equals(table.get("description"))) {
            paramList.add(table.get("description"));
        } else {
            paramList.add("");
        }
        return fid.toString();
    }

    protected void generateNumberByCodingRule(StaffManageProjectTableInfo table, StaffManageProjectInfo staffManageProject, Context ctx) throws BOSException, EASBizException {
        if (table == null || staffManageProject == null) {
            logger.warn((Object)"table or staffManageProject is null, generateNumber failed!");
            throw new StaffManageException(StaffManageException.GENERATE_TABLENUMBER_FAILED);
        }
        if (StringUtil.isEmpty((String)table.getNumber())) {
            String mainId;
            StaffManageProjectTableInfo tableInfo = new StaffManageProjectTableInfo();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (iCodingRuleManager.isExist((IObjectValue)tableInfo, mainId = table.getCU().getId().toString())) {
                StaffManageProjectCollection projects;
                if (table.get("FAdminOrgID") instanceof AdminOrgUnitInfo) {
                    tableInfo.setAdminOrg((AdminOrgUnitInfo)table.get("FAdminOrgID"));
                } else {
                    String adminOrgId = table.get("FAdminOrgID") + "";
                    AdminOrgUnitCollection admins = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("select id,number,name  where id = '" + adminOrgId + "'");
                    if (admins.size() > 0) {
                        tableInfo.setAdminOrg(admins.get(0));
                    }
                }
                tableInfo.setStaffManageProject(table.getStaffManageProject());
                if (table.getStaffManageProject().getNumber() == null && (projects = StaffManageProjectFactory.getLocalInstance(ctx).getStaffManageProjectCollection("select id,number,name where id ='" + table.getStaffManageProject().getId() + "'")).size() > 0) {
                    tableInfo.setStaffManageProject(projects.get(0));
                }
                iCodingRuleManager.getNumber((IObjectValue)tableInfo, mainId);
                String number = iCodingRuleManager.readNumber((IObjectValue)tableInfo, mainId);
                table.setNumber(number);
            } else {
                logger.warn((Object)"codingrule is not exist or unused,please check!");
                throw new StaffManageException(StaffManageException.GENERATE_TABLENUMBER_FAILED);
            }
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        StaffManageProjectTableInfo table = (StaffManageProjectTableInfo)model;
        StaffManageProjectInfo staffManageProject = this.getStaffManangeProjectInfo(table, ctx);
        String deleteSql = "delete from " + staffManageProject.getTableName() + " where fid = '" + pk.toString() + "'";
        table.setId(BOSUuid.read((String)pk.toString()));
        DbUtil.execute((Context)ctx, (String)deleteSql);
        this._addnew(ctx, model);
    }

    protected StaffManageProjectInfo getStaffManangeProjectInfo(StaffManageProjectTableInfo table, Context ctx) throws BOSException, EASBizException {
        IStaffManageProject staffManageProjectService;
        StaffManageProjectCollection staffManageProjects;
        StaffManageProjectInfo staffManageProject = table.getStaffManageProject();
        if (staffManageProject == null || staffManageProject.getId() == null) {
            throw new StaffManageException(StaffManageException.PROJECT_IS_NOT_EXIST);
        }
        if (staffManageProject.getTableName() == null && (staffManageProjects = (staffManageProjectService = StaffManageProjectFactory.getLocalInstance(ctx)).getStaffManageProjectCollection("select tableName,rule.id,channel from where id = '" + staffManageProject.getRule().getId() + "'")) != null && staffManageProjects.size() > 0) {
            staffManageProject = staffManageProjects.get(0);
        }
        return staffManageProject;
    }

    protected UserInfo getUserInfo(Context ctx) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp timestamp = new Timestamp(d.getTime().getTime());
        return timestamp;
    }

    protected String getTimeStr() {
        Timestamp timestamp = this.getTime();
        return DateUtils.paseTimestamp2String((Timestamp)timestamp, (String)"yyyy-MM-dd HH:mm:ss");
    }

    @Override
    protected void _enable(Context ctx, String tableName, String billId) throws BOSException, EASBizException {
        String parentSql = " select fnumber from " + tableName + "  where fid =(select fshareparent from " + tableName + " where fid='" + billId + "' and   fid<>fshareparent )   and fstate in (0,2) ";
        try {
            IRowSet parentrs = DbUtil.executeQuery((Context)ctx, (String)parentSql.toString());
            if (parentrs.next()) {
                String parentNumber = parentrs.getString("fnumber");
                throw new StaffManageException(StaffManageException.STAFF_MANAGE_EXCEPTION60, new Object[]{parentNumber});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        String sql = "update " + tableName + " set fstate = 1,FLastUpdateUserID = '" + this.getUserInfo(ctx).getId() + "',FLastUpdateTime = {ts'" + this.getTimeStr() + "'}, FEnableTime = {ts'" + this.getTimeStr() + "'} where fid ='" + billId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _disable(Context ctx, String tableName, String billId) throws BOSException, EASBizException {
        String sql = "update " + tableName + " set fstate = 2,FLastUpdateUserID = '" + this.getUserInfo(ctx).getId() + "',FLastUpdateTime = {ts'" + this.getTimeStr() + "'}, FEnableTime = null where fshareparent ='" + billId + "' or fid='" + billId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _delete(Context ctx, String tableName, String billId) throws BOSException, EASBizException {
        boolean isupdate = false;
        String shareparent = "";
        String existSql = "select  FShareParent,count(*) num from " + tableName + " where FShareParent =(select fshareparent  from " + tableName + "  where fid ='" + billId + "')  group by fshareparent";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)existSql);
        try {
            while (rowSet.next()) {
                int existcount = rowSet.getInt("num");
                shareparent = rowSet.getString("FShareParent");
                if (existcount != 2) continue;
                isupdate = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String sql = "delete from " + tableName + " where FShareParent ='" + billId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        String deleteIdSql = "delete from " + tableName + " where fid ='" + billId + "'";
        DbUtil.execute((Context)ctx, (String)deleteIdSql);
        if (isupdate) {
            String updatesql = "update " + tableName + "  set  fsharestate=0 where  fid ='" + shareparent + "'";
            DbUtil.execute((Context)ctx, (String)updatesql);
        }
    }

    @Override
    protected void _batchAddNew(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        StaffManageProjectTableCollection tableCollection = (StaffManageProjectTableCollection)collection;
        for (int i = 0; i < tableCollection.size(); ++i) {
            StaffManageProjectTableInfo tableInfo = tableCollection.get(i);
            IObjectPK pk = this._addnew(ctx, (IObjectValue)tableInfo);
            tableInfo.setId(BOSUuid.read((String)pk.toString()));
        }
    }

    @Override
    protected void _batchUpdate(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        StaffManageProjectTableCollection tableCollection = (StaffManageProjectTableCollection)collection;
        if (tableCollection == null || tableCollection.size() == 0) {
            return;
        }
        StaffManageProjectTableInfo tableInfo = tableCollection.get(0);
        StaffManageProjectInfo staffManageProject = this.getStaffManangeProjectInfo(tableInfo, ctx);
        IStaffManageChannel channel = StaffManageChannelUtil.getInstance(staffManageProject.getChannel());
        if (channel == null) {
            throw new StaffManageException(StaffManageException.PROJECT_CHANNEL_ERROR);
        }
        Map<String, String> channelNameMap = channel.getName2AliasMap(ctx);
        UserInfo userInfo = this.getUserInfo(ctx);
        userInfo.getId().toString();
        Timestamp createtime = this.getTime();
        String updateSql = this.getUpdateSql(staffManageProject, channelNameMap);
        for (int i = 0; i < tableCollection.size(); ++i) {
            StaffManageProjectTableInfo table = tableCollection.get(i);
            ArrayList<Object> dataList = new ArrayList<Object>();
            for (String channelName : channelNameMap.keySet()) {
                dataList.add(this.defaultZero(table.get(channelName)));
            }
            dataList.add(table.get("FContainSub"));
            dataList.add(table.get("FControlWay"));
            dataList.add(table.get("FDescription"));
            dataList.add(userInfo.getId().toString());
            dataList.add(createtime);
            dataList.add(table.get("id"));
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])dataList.toArray());
        }
    }

    protected String getUpdateSql(StaffManageProjectInfo staffManageProject, Map<String, String> channelNameMap) {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update ");
        updateSql.append(staffManageProject.getTableName());
        updateSql.append(" set ");
        for (String channelName : channelNameMap.keySet()) {
            updateSql.append(channelName);
            updateSql.append(" = ? , ");
        }
        updateSql.append(" FContainSub = ? , FControlWay = ? , FDescription = ? , FLastUpdateUserID = ? , FLastUpdateTime = ? where fshareparent = ?");
        return updateSql.toString();
    }

    @Override
    public void _copyStaffManageDatas(Context ctx, String projectId, String rowIds, String curChannel, String destChannel) throws BOSException, EASBizException {
        StaffManageProjectInfo projectInfo = StaffManageProjectFactory.getLocalInstance(ctx).getStaffManageProjectInfo((IObjectPK)new ObjectUuidPK(projectId));
        Object[] rowIdArray = rowIds.split(",");
        IStaffManageChannel iStaffManageChannel = StaffManageChannelUtil.getInstance(projectInfo.getChannel());
        String curChannelInDB = iStaffManageChannel.getDBColumnByChannelVal(Integer.valueOf(curChannel));
        String[] destChannelArr = destChannel.split(",");
        String assginChannelSQL = "";
        for (String destChan : destChannelArr) {
            String destChannelInDB = iStaffManageChannel.getDBColumnByChannelVal(Integer.valueOf(destChan));
            assginChannelSQL = assginChannelSQL + destChannelInDB + "=" + curChannelInDB + ",";
        }
        UserInfo userInfo = this.getUserInfo(ctx);
        Timestamp createtime = this.getTime();
        String updateSql = this.getUpdateSql(projectInfo, assginChannelSQL, StaffManageGatherUtilEx.getFidStr(rowIdArray));
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{userInfo.getId().toString(), createtime});
    }

    protected String getUpdateSql(StaffManageProjectInfo projectInfo, String assginChannelSQL, String rowIds) {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update ");
        updateSql.append(projectInfo.getTableName());
        updateSql.append(" set ");
        updateSql.append(assginChannelSQL);
        updateSql.append(" FLastUpdateUserID = ? , FLastUpdateTime = ? where fid in (" + rowIds + ")");
        return updateSql.toString();
    }
}

