/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.staffcontrol.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EmpPosChangeDataCollection;
import com.kingdee.eas.hr.base.EmpPosChangeDataFactory;
import com.kingdee.eas.hr.base.EmpPosChangeDataInfo;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.hr.base.app.util.CoreBaseObjectUtil;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.common.util.SHREnumUtil;
import com.kingdee.shr.costbudget.util.DateHelper;
import com.kingdee.shr.staffcontrol.RelateContentTypeEnum;
import com.kingdee.shr.staffcontrol.StaffManageChannelEnum;
import com.kingdee.shr.staffcontrol.StaffManageException;
import com.kingdee.shr.staffcontrol.StaffManageMappingCollection;
import com.kingdee.shr.staffcontrol.StaffManageMappingFactory;
import com.kingdee.shr.staffcontrol.StaffManageMappingInfo;
import com.kingdee.shr.staffcontrol.StaffManageProjectCollection;
import com.kingdee.shr.staffcontrol.StaffManageProjectFactory;
import com.kingdee.shr.staffcontrol.StaffManageProjectInfo;
import com.kingdee.shr.staffcontrol.StaffManageProjectTableInfo;
import com.kingdee.shr.staffcontrol.StaffManageRuleFieldCollection;
import com.kingdee.shr.staffcontrol.StaffManageRuleFieldFactory;
import com.kingdee.shr.staffcontrol.StaffManageRuleFieldInfo;
import com.kingdee.shr.staffcontrol.StaffManageRuleInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.apache.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class StaffManageServiceUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.staffcontrol.util.StaffManageServiceUtil");
    public static final String SHR_STAFF_MANAGE_HAS_ADD_ONWAY_COLUMN_KEY = "SHRStaffManageHasAddOnWayColumn";

    public static String getTempTableName(Context ctx) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTableName = pool.createTempTableName();
        return tempTableName;
    }

    public static void relaseTempTable(Context ctx, String tempTableName) throws BOSException {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(tempTableName);
        }
    }

    public static String getPersonPositionResponseAdminSql(String userId) {
        StringBuffer sql = new StringBuffer("select child.fid as forgId").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid= emprelation.fpositionid").append(" inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and child.fissealup = 0").append(" and child.fisstartshr = 1");
        return sql.toString();
    }

    public static String getAdminRangeSql(Context ctx, String userId, String permItemId) {
        StringBuffer sql = new StringBuffer("select adminOrg.fid as forgId").append(" from t_org_admin adminOrg").append(" where fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId) + ")");
        return sql.toString();
    }

    public static String getUserAdminRangeSql(Context ctx) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        StringBuffer sql = new StringBuffer(" select ");
        sql.append(" T_PM_OrgRange.FOrgID ");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        sql.append(" WHERE T_ORG_Admin.FIsSealUp = 0 ");
        sql.append(" AND T_PM_OrgRange.FType = 20 ");
        sql.append(" AND T_PM_OrgRange.FUserID = '" + userId + "' ");
        return sql.toString();
    }

    public static String fidsToInSQL(Set<String> fids) {
        StringBuffer sBuffer = new StringBuffer("'abc'");
        if (fids == null || fids.size() == 0) {
            return sBuffer.toString();
        }
        for (String fid : fids) {
            sBuffer.append(",'");
            sBuffer.append(fid);
            sBuffer.append("'");
        }
        return sBuffer.toString();
    }

    public static int getOrgDirectActualCount(Context ctx, String orgId) throws BOSException {
        StringBuffer actualStaffingSql = new StringBuffer("select count(emprelation.fpersonid) actualStafCount").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1");
        try {
            IRowSet actualStaffingSet = DbUtil.executeQuery((Context)ctx, (String)actualStaffingSql.toString());
            if (actualStaffingSet.next()) {
                return actualStaffingSet.getInt("actualStafCount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    public static int getOrgSubOnWayCount(Context ctx, String orgId) throws BOSException {
        try {
            String longNumber = StaffManageServiceUtil.getAdminLongnumber(ctx, orgId);
            StringBuffer onWayPersoncountSql = new StringBuffer("select isnull(sum(changedata.fcount),0) onWayPersoncount").append(" from T_HR_EmpPosChangeData changedata").append(" inner join T_ORG_Admin org").append(" on org.fid = changedata.fadminorgid").append(" where changedata.fisenrolled = 1 and changedata.fisexcluded = 0").append(" and (org.FLongNumber = '").append(longNumber).append("'").append(" or org.FLongNumber LIKE '").append(longNumber).append("!%')").append(" and (changedata.fbillstate in (1,2) or (changedata.fbillstate = 3 and changedata.fbizdate > ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)new Date())).append("))");
            IRowSet onWayPersoncountSet = DbUtil.executeQuery((Context)ctx, (String)onWayPersoncountSql.toString());
            if (onWayPersoncountSet.next()) {
                return onWayPersoncountSet.getInt("onWayPersoncount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    public static int getOrgDirectOnWayCount(Context ctx, String orgId) throws BOSException {
        StringBuffer onWayPersoncountSql = new StringBuffer("select isnull(sum(changedata.fcount),0) onWayPersoncount").append(" from T_HR_EmpPosChangeData changedata").append(" where changedata.fisenrolled = 1 and changedata.fisexcluded = 0").append(" and changedata.fadminorgid = '").append(orgId).append("'").append(" and (changedata.fbillstate in (1,2) or (changedata.fbillstate = 3 and changedata.fbizdate > ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)new Date())).append("))");
        try {
            IRowSet onWayPersoncountSet = DbUtil.executeQuery((Context)ctx, (String)onWayPersoncountSql.toString());
            if (onWayPersoncountSet.next()) {
                return onWayPersoncountSet.getInt("onWayPersoncount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    public static int getPositionOnWayCount(Context ctx, String orgId, String positionId) throws BOSException {
        StringBuffer onWayPersoncountSql = new StringBuffer("select isnull(sum(changedata.fcount),0) onWayPersoncount").append(" from T_HR_EmpPosChangeData changedata").append(" inner join T_ORG_Position pos on pos.fid = changedata.FPositionID");
        if (!StringUtils.isEmpty((String)orgId)) {
            onWayPersoncountSql.append(" inner join T_ORG_Admin org on org.fid = changedata.fadminorgid");
        }
        onWayPersoncountSql.append(" where changedata.fisenrolled = 1 and changedata.fisexcluded = 0").append(" and changedata.FPositionID = '").append(positionId).append("'").append(" and (changedata.fbillstate in (1,2) or (changedata.fbillstate = 3 and changedata.fbizdate > ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)new Date())).append("))");
        if (!StringUtils.isEmpty((String)orgId)) {
            onWayPersoncountSql.append(" and changedata.fadminorgid = '").append(orgId).append("'");
        }
        try {
            IRowSet onWayPersoncountSet = DbUtil.executeQuery((Context)ctx, (String)onWayPersoncountSql.toString());
            if (onWayPersoncountSet.next()) {
                return onWayPersoncountSet.getInt("onWayPersoncount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    public static String getLocal(Context ctx) {
        String local = ctx.getLocale() != null ? ctx.getLocale().toString() : "l2";
        return local;
    }

    public static int getLimitActualPersonCount(Context ctx, String orgId, String positionIds, String employeeModleIds, boolean orgContainSub) throws EASBizException, BOSException {
        String setToStrValue;
        String[] multiVal;
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append(" select count(*) ");
        sbuffer.append(" from T_HR_EmpOrgRelation rela ");
        sbuffer.append(" inner join T_ORG_Admin org on org.FID = rela.FAdminOrgID ");
        sbuffer.append(" inner join t_hr_emplaborrelation  elh  on rela.FLABORRELATIONID = elh.FID ");
        sbuffer.append(" left join T_HR_BDEMPLOYEETYPE emptype on emptype.FID = elh.FLABORRELATIONSTATEID ");
        sbuffer.append(" WHERE rela.fisInner = 1 and rela.fisenrolled = 1 ");
        sbuffer.append(" and rela.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate()));
        sbuffer.append(" and rela.FIsLatestInAday = 1 ");
        sbuffer.append(" and emptype.fisOnTheStrength = 1");
        if (!StringUtils.isEmpty((String)orgId)) {
            AdminOrgUnitInfo adminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
            if (orgContainSub) {
                sbuffer.append(" and (org.flongnumber ='").append(adminOrg.getLongNumber()).append("'").append(" or org.flongnumber like '").append(adminOrg.getLongNumber()).append("!%')");
            } else {
                sbuffer.append(" and org.flongnumber ='").append(adminOrg.getLongNumber()).append("'");
            }
        }
        if (!StringUtils.isEmpty((String)positionIds)) {
            multiVal = positionIds.split(",");
            Set<String> positions = StaffManageServiceUtil.getValSet(multiVal);
            setToStrValue = StaffManageServiceUtil.fidsToInSQL(positions);
            sbuffer.append(" and rela.FPositionID in (").append(setToStrValue).append(")");
        }
        if (!StringUtils.isEmpty((String)employeeModleIds)) {
            multiVal = employeeModleIds.split(",");
            Set<String> employeeModles = StaffManageServiceUtil.getValSet(multiVal);
            setToStrValue = StaffManageServiceUtil.fidsToInSQL(employeeModles);
            sbuffer.append(" and emptype.FEmployeeModleID in (").append(setToStrValue).append(")");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)sbuffer.toString());
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbuffer.toString());
        int currentCount = 0;
        try {
            if (rs.next()) {
                currentCount = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return currentCount;
    }

    public static Set<String> getValSet(String[] multiVal) {
        HashSet<String> valSet = new HashSet<String>();
        for (int i = 0; i < multiVal.length; ++i) {
            valSet.add(multiVal[i]);
        }
        return valSet;
    }

    public static Map<String, String> assembleSelector(String selector) {
        String[] columnModel = selector.split(",");
        String columnName2 = null;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String columnName2 : columnModel) {
            map.put(columnName2, columnName2);
        }
        return map;
    }

    public static String getSelectorByfields(StaffManageRuleFieldCollection fieldCollection) {
        if (fieldCollection == null || fieldCollection.size() == 0) {
            return "";
        }
        String selector = "";
        for (int i = 0; i < fieldCollection.size(); ++i) {
            StaffManageRuleFieldInfo fieldInfo = fieldCollection.get(i);
            String field = fieldInfo.getField();
            selector = selector + "," + field;
        }
        return selector.substring(1);
    }

    public static String getAdminLongnumber(Context ctx, String adminId) throws Exception {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("longnumber"));
        AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminId));
        if (adminInfo == null) {
            // empty if block
        }
        return adminInfo == null ? "" : adminInfo.getLongNumber();
    }

    public static List<String> idStrToList(String idStr) {
        if (StringUtils.isEmpty((String)idStr)) {
            return Collections.emptyList();
        }
        String[] idArray = idStr.split(",");
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : idArray) {
            ids.add(id);
        }
        return ids;
    }

    public static int getPersonCountByStaffId(Context ctx, String projectId, String staffId, Date date) throws Exception {
        int personCount = -1;
        StaffManageProjectInfo projectInfo = StaffManageProjectFactory.getLocalInstance(ctx).getStaffManageProjectInfo((IObjectPK)new ObjectUuidPK(projectId));
        StaffManageRuleInfo rule = projectInfo.getRule();
        StaffManageRuleFieldCollection fieldCollection = StaffManageRuleFieldFactory.getLocalInstance(ctx).getStaffManageRuleFieldCollection("where  staffManageRule='" + rule.getId().toString() + "'");
        int curMonth = DateHelper.getCurrentMonth();
        StringBuffer baseSql = StaffManageServiceUtil.getStaffValueSqlForValidate(fieldCollection, projectInfo, curMonth);
        String enrollFilterSql = "empType.isOnTheStrength = '1' AND empOrgRelation.isEnrolled = '1'  ";
        StringBuffer staffsql = baseSql.append(" where fid='" + staffId + "'");
        IRowSet adminrs = DbUtil.executeQuery((Context)ctx, (String)staffsql.toString());
        while (adminrs.next()) {
            String adminOrgId = adminrs.getString("adminOrgId");
            boolean isHassub = adminrs.getInt("isHassub") == 1;
            String filterSql = enrollFilterSql;
            for (int j = 0; j < fieldCollection.size(); ++j) {
                String columnValue;
                StaffManageRuleFieldInfo fieldInfo = fieldCollection.get(j);
                String propName = fieldInfo.getField();
                String column = fieldInfo.getColumn();
                if ("FAdminOrgID".equals(column) || StringUtils.isEmpty((String)(columnValue = adminrs.getString(column)))) continue;
                filterSql = filterSql + "and " + propName + "= '" + columnValue + "' ";
            }
            if (isHassub) {
                String longNumber = StaffManageServiceUtil.getAdminLongnumber(ctx, adminOrgId);
                filterSql = filterSql + " and adminOrgUnit.id IN (SELECT FID FROM T_ORG_ADMIN WHERE (FLONGNUMBER = '" + longNumber + "' or FLONGNUMBER LIKE '" + longNumber + "!%' ))";
            } else {
                filterSql = filterSql + " and adminOrgUnit.id IN (SELECT FID FROM T_ORG_ADMIN WHERE fid IN ('" + adminOrgId + "'))";
            }
            personCount = StaffManageServiceUtil.getStaffCount(ctx, null, filterSql, null, date);
        }
        return personCount;
    }

    public static int getStaffCount(Context ctx, String selectorByfields, String filterSql, String personid, Date date) throws Exception {
        int personEnroll;
        IRowSet rsByPerson;
        int staffCount = -1;
        SqlParam sqlParam = new SqlParam();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.effdt", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.leffdt", (Object)date, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.effdt", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.leffdt", (Object)date, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.isLatestInAday", (Object)1));
        FilterInfo filterInfo = new FilterInfo(filterSql);
        filterInfo.mergeFilter(filter, "and");
        sqlParam.setFilterDate(date);
        if (!StringUtils.isEmpty((String)selectorByfields)) {
            sqlParam.setSelectMapping(StaffManageServiceUtil.assembleSelector(selectorByfields));
        }
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setScheme("001");
        sqlParam.setNeedDistinct(false);
        sqlParam.setHistoryMode(true);
        sqlParam.setNewSearch(true);
        sqlParam.setSupportQueryUuid(true);
        sqlParam.setAll(true);
        sqlParam.getInfoCtr().put("EMPORGRELATION", "false");
        String querySql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
        String subSql = querySql.substring(querySql.indexOf("FROM"));
        if (!StringUtils.isEmpty((String)personid) && (rsByPerson = DbUtil.executeQuery((Context)ctx, (String)("select count(*) " + subSql + " and  \"PERSON\".FHistoryRelateID='" + personid + "'"))).next() && (personEnroll = rsByPerson.getInt(1)) == 1) {
            return staffCount;
        }
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)("select count(*) " + subSql));
        logger.error((Object)("getStaffCount\u2014\u2014\u2014\u2014\u2014\u2014   select count(*) " + subSql));
        if (rs2.next()) {
            staffCount = rs2.getInt(1);
        }
        return staffCount;
    }

    public static StringBuffer getStaffValueSqlForValidate(StaffManageRuleFieldCollection fieldCollection, StaffManageProjectInfo projectInfo, int curMonth) {
        StringBuffer sql = new StringBuffer(" select ");
        StaffManageChannelEnum channel = projectInfo.getChannel();
        String tableName = projectInfo.getTableName();
        sql.append("staff.fnumber as number");
        sql.append(",staff.FContainSub  as isHassub");
        sql.append(",staff.FAdminOrgID as adminOrgId");
        sql.append(",staff.FStaffShare as shareValue");
        sql.append(",staff.FShareState as sharestate");
        sql.append(",staff.fid as fid");
        sql.append(",staff.FShareParent as shareParent");
        sql.append(",staff.FControlWay as controlWay");
        if (StaffManageChannelEnum.YEAR.equals((Object)channel)) {
            sql.append(",staff.FStaffYear  as staffValue");
        } else if (StaffManageChannelEnum.HALFYEAR.equals((Object)channel)) {
            if (1 == curMonth || 2 == curMonth || 3 == curMonth || 4 == curMonth || 5 == curMonth || 6 == curMonth) {
                sql.append(",staff.FStaffHaffYear1  as staffValue");
            } else if (7 == curMonth || 8 == curMonth || 9 == curMonth || 10 == curMonth || 11 == curMonth || 12 == curMonth) {
                sql.append(",staff.FStaffHaffYear2  as staffValue");
            }
        } else if (StaffManageChannelEnum.QUARTER.equals((Object)channel)) {
            if (1 == curMonth || 2 == curMonth || 3 == curMonth) {
                sql.append(",staff.FStaffQuarter1  as staffValue");
            } else if (4 == curMonth || 5 == curMonth || 6 == curMonth) {
                sql.append(",staff.FStaffQuarter2  as staffValue");
            } else if (7 == curMonth || 8 == curMonth || 9 == curMonth) {
                sql.append(",staff.FStaffQuarter3  as staffValue");
            } else if (10 == curMonth || 11 == curMonth || 12 == curMonth) {
                sql.append(",staff.FStaffQuarter4  as staffValue");
            }
        } else if (StaffManageChannelEnum.MONTH.equals((Object)channel)) {
            sql.append(",staff.FStaffMonth");
            sql.append(curMonth);
            sql.append(" as staffValue");
        }
        for (int j = 0; j < fieldCollection.size(); ++j) {
            StaffManageRuleFieldInfo fieldInfo = fieldCollection.get(j);
            String column = fieldInfo.getColumn();
            sql.append("," + column);
        }
        sql.append(" from  " + tableName + " staff ");
        return sql;
    }

    public static String getMappingSql(Context ctx, StaffManageRuleFieldCollection fieldCollection, CoreBaseInfo sourceModel, String entityName, int flowFlag) throws Exception {
        StringBuffer mappingSql = new StringBuffer("");
        for (int j = 0; j < fieldCollection.size(); ++j) {
            String fieldValue;
            String[] split;
            String content;
            StaffManageRuleFieldInfo fieldInfo = fieldCollection.get(j);
            String propName = fieldInfo.getField();
            String column = fieldInfo.getColumn();
            StaffManageMappingCollection mappingCollection = StaffManageMappingFactory.getLocalInstance(ctx).getStaffManageMappingCollection("where billType.entityName='" + entityName + "'  and  state=1 and field='" + propName + "' and flowFlag=" + flowFlag);
            StaffManageMappingInfo mappingInfo = mappingCollection.get(0);
            if (null != mappingInfo && null != mappingInfo.getBillType() && RelateContentTypeEnum.FIELDATTR.equals((Object)mappingInfo.getRelateContentType())) {
                content = mappingInfo.getRelateFieldContent();
                CoreBaseInfo model = sourceModel;
                String fieldFirst = content;
                split = content.split("\\.");
                if (null != split && split.length > 0) {
                    fieldFirst = split[0];
                } else {
                    split = new String[]{content};
                }
                if (null == model.get(fieldFirst)) {
                    if ("FAdminOrgID".equals(column)) continue;
                    mappingSql.append(" and (" + column + " is null or " + column + "='')");
                    continue;
                }
                fieldValue = StaffManageServiceUtil.getFieldValue(ctx, entityName, model, split);
                if ("FAdminOrgID".equals(column)) continue;
                mappingSql.append(" and (" + column + " = '" + fieldValue + "' or " + column + " is null or " + column + "='')");
                continue;
            }
            if (null != mappingInfo && null != mappingInfo.getBillType() && RelateContentTypeEnum.SQL.equals((Object)mappingInfo.getRelateContentType())) {
                IRowSet rs;
                String fieldContent = mappingInfo.getRelateFieldContent();
                String contentSql = mappingInfo.getRelateContent();
                CoreBaseInfo model = sourceModel;
                if (!StringUtils.isEmpty((String)fieldContent)) {
                    split = fieldContent.split("\\.");
                    if (null == model.get(split[0])) {
                        contentSql = contentSql.replace("?", "''");
                    } else {
                        fieldValue = StaffManageServiceUtil.getFieldValue(ctx, entityName, model, split);
                        contentSql = contentSql.replace("?", " '" + fieldValue + "' ");
                    }
                }
                if ((rs = DbUtil.executeQuery((Context)ctx, (String)contentSql)).next()) {
                    if ("FAdminOrgID".equals(column)) continue;
                    if (!StringUtils.isEmpty((String)rs.getString(1))) {
                        mappingSql.append(" and (" + column + " = '" + rs.getString(1) + "' or " + column + " is null or " + column + "='')");
                        continue;
                    }
                    mappingSql.append(" and (" + column + " is null or " + column + "='')");
                    continue;
                }
                mappingSql.append(" and (" + column + " is null or " + column + "='')");
                continue;
            }
            if (null != mappingInfo && null != mappingInfo.getBillType() && RelateContentTypeEnum.JAVA.equals((Object)mappingInfo.getRelateContentType())) {
                content = mappingInfo.getRelateContent();
                CtClass pt = null;
                long nowTime = System.currentTimeMillis();
                String className = "com.kingdee.shr.staffcontrol.service.tempClass" + nowTime;
                try {
                    ClassPool pool = ClassPool.getDefault();
                    if (pool == null) {
                        throw new RuntimeException((Throwable)((Object)new StaffManageException(StaffManageException.STAFF_MANAGE_EXCEPTION42)));
                    }
                    pool.clearImportedPackages();
                    pool.importPackage("java.util");
                    ClassLoader classLoader = StaffManageServiceUtil.class.getClassLoader();
                    pt = pool.makeClass(className);
                    String newContent = "public String invokeJava(String datePicker, String permItemId) throws Exception {" + content + "}";
                    CtMethod newMehtod = CtNewMethod.make((String)newContent, (CtClass)pt);
                    pt.addMethod(newMehtod);
                    Class clazz = pt.toClass(classLoader, classLoader.getClass().getProtectionDomain());
                    Method method = ReflectionUtils.findMethod((Class)clazz, (String)"invokeJava", (Class[])new Class[]{String.class, String.class});
                    String fieldValue2 = (String)ReflectionUtils.invokeMethod((Method)method, clazz.newInstance(), (Object[])new Object[]{sourceModel});
                    if ("FAdminOrgID".equals(column)) continue;
                    mappingSql.append(" and " + column + " = '" + fieldValue2 + "'");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
                finally {
                    if (pt != null) {
                        pt.detach();
                        pt.defrost();
                    }
                }
            }
            mappingSql.append(" and (" + column + " is null or " + column + "='')");
        }
        return mappingSql.toString();
    }

    public static String getFieldValue(Context ctx, String entityName, CoreBaseInfo model, String[] split) throws Exception {
        String fieldValue = "";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        for (int k = 0; k < split.length; ++k) {
            int valueIntEnum;
            CoreBaseInfo info;
            Object value;
            PropertyInfo property;
            String field = split[k];
            if (k == split.length - 1) {
                property = entityInfo.getPropertyByName(field);
                if (null == property || !property.isConfigured()) {
                    value = CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)model, (String)field);
                    if (value instanceof String) {
                        fieldValue = (String)value;
                    } else if (value instanceof CoreBaseInfo) {
                        info = (CoreBaseInfo)value;
                        if (null != info && null != info.getId()) {
                            fieldValue = info.getId().toString();
                        }
                    } else if (value instanceof BOSUuid) {
                        fieldValue = (String)value;
                    } else if (value instanceof Boolean) {
                        fieldValue = (String)value;
                    } else if (value instanceof Integer) {
                        fieldValue = ((Integer)value).toString();
                    } else if (value instanceof Long) {
                        fieldValue = ((Long)value).toString();
                    } else if (value instanceof Float) {
                        fieldValue = BigDecimal.valueOf(((Float)value).floatValue()).setScale(2).toString();
                    } else if (value instanceof Double) {
                        fieldValue = value.toString();
                    } else if (value instanceof BigDecimal) {
                        fieldValue = value.toString();
                    } else if (value instanceof IntEnum) {
                        int valueIntEnum2 = ((IntEnum)value).getValue();
                        fieldValue = valueIntEnum2 + "";
                    } else if (value instanceof StringEnum) {
                        fieldValue = ((StringEnum)value).getValue();
                    }
                    if (value != null) continue;
                    fieldValue = "";
                    continue;
                }
                if (property instanceof OwnPropertyInfo) {
                    OwnPropertyInfo p = (OwnPropertyInfo)property;
                    DataType dataType = p.getDataType();
                    if (DataType.ENUM.equals((Object)dataType)) {
                        if (model.get(field) instanceof IntEnum) {
                            valueIntEnum = ((IntEnum)model.get(field)).getValue();
                            fieldValue = valueIntEnum + "";
                            continue;
                        }
                        if (model.get(field) instanceof StringEnum) {
                            fieldValue = ((StringEnum)model.get(field)).getValue();
                            continue;
                        }
                        BizEnumInfo bizEnumInfo = SHREnumUtil.getBizEnumInfoByOwnProperty((OwnPropertyInfo)p);
                        fieldValue = bizEnumInfo.getInnerEnumValue((String)model.get(field)).getValue().toString();
                        continue;
                    }
                    if (DataType.OBJECTVALUE.equals((Object)dataType)) {
                        CoreBaseInfo info2 = (CoreBaseInfo)model.get(field);
                        fieldValue = info2.getId().toString();
                        continue;
                    }
                    if (DataType.STRING.equals((Object)dataType)) {
                        fieldValue = (String)model.get(field);
                        continue;
                    }
                    if (DataType.BOOLEAN.equals((Object)dataType)) {
                        fieldValue = (String)model.get(field);
                        continue;
                    }
                    if (DataType.DATE.equals((Object)dataType)) {
                        fieldValue = (String)model.get(field);
                        continue;
                    }
                    if (!DataType.DECIMAL.equals((Object)dataType)) continue;
                    fieldValue = (String)model.get(field);
                    continue;
                }
                CoreBaseInfo info3 = (CoreBaseInfo)model.get(field);
                if (null == info3 || null == info3.getId()) continue;
                fieldValue = info3.getId().toString();
                continue;
            }
            property = entityInfo.getPropertyByName(field);
            value = CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)model, (String)field);
            if (!(value instanceof CoreBaseInfo)) continue;
            info = (CoreBaseInfo)value;
            if (null != info.getId()) {
                String pk = info.getId().toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo(split[k + 1]));
                BOSObjectType bosType = BOSUuid.read((String)pk).getType();
                bosType = !bosType.toString().equals("CCE7AED4") ? bosType : BOSObjectType.create((String)"6A6435BE");
                model = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)bosType).getValue((IObjectPK)new ObjectUuidPK(pk), sic);
                entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType.toString()));
                continue;
            }
            if (!"talent".equals(split[k])) continue;
            value = info.get(split[k + 1]);
            if (value instanceof String) {
                fieldValue = (String)value;
            } else if (value instanceof CoreBaseInfo) {
                CoreBaseInfo preEntrybaseInfo = (CoreBaseInfo)value;
                fieldValue = preEntrybaseInfo.getId().toString();
            } else if (value instanceof BOSUuid) {
                fieldValue = (String)value;
            } else if (value instanceof Boolean) {
                fieldValue = (String)value;
            } else if (value instanceof Integer) {
                fieldValue = ((Integer)value).toString();
            } else if (value instanceof Long) {
                fieldValue = ((Long)value).toString();
            } else if (value instanceof Float) {
                fieldValue = BigDecimal.valueOf(((Float)value).floatValue()).setScale(2).toString();
            } else if (value instanceof Double) {
                fieldValue = value.toString();
            } else if (value instanceof BigDecimal) {
                fieldValue = value.toString();
            } else if (value instanceof IntEnum) {
                valueIntEnum = ((IntEnum)value).getValue();
                fieldValue = valueIntEnum + "";
            } else if (value instanceof StringEnum) {
                fieldValue = ((StringEnum)value).getValue();
            }
            if (value == null) {
                fieldValue = "";
            }
            return fieldValue;
        }
        return fieldValue;
    }

    public static String getParentLongNumber(String longNumber) {
        String sql = "in (";
        String[] numArray = longNumber.split("!");
        for (int i = 0; i < numArray.length; ++i) {
            StringBuffer numBuf = new StringBuffer();
            for (int j = 0; j <= i; ++j) {
                if (j == 0) {
                    numBuf.append(numArray[j]);
                    continue;
                }
                numBuf.append("!").append(numArray[j]);
            }
            sql = i == numArray.length - 1 ? sql + "'" + numBuf.toString() + "')" : sql + "'" + numBuf.toString() + "',";
        }
        return sql;
    }

    public static EmpPosChangeDataCollection getOnWayAddPersonCount(Context ctx, boolean isHassub, String orgId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = StaffManageServiceUtil.getOnWayCommonFilterInfo(ctx, isHassub, orgId);
        FilterInfo addFilter = (FilterInfo)filter.clone();
        FilterInfo addFilterInfo = new FilterInfo();
        addFilterInfo.getFilterItems().add(new FilterItemInfo("count", (Object)1, CompareType.EQUALS));
        addFilter.mergeFilter(addFilterInfo, "AND");
        viewInfo.setFilter(addFilter);
        EmpPosChangeDataCollection addDataColl = EmpPosChangeDataFactory.getLocalInstance((Context)ctx).getEmpPosChangeDataCollection(viewInfo);
        return addDataColl;
    }

    public static EmpPosChangeDataCollection getOnWaySubPersonCount(Context ctx, boolean isHassub, String orgId) throws BOSException, EASBizException {
        FilterInfo filter = StaffManageServiceUtil.getOnWayCommonFilterInfo(ctx, isHassub, orgId);
        FilterInfo subFilterInfo = (FilterInfo)filter.clone();
        FilterInfo subFilter = new FilterInfo();
        subFilter.getFilterItems().add(new FilterItemInfo("count", (Object)-1, CompareType.EQUALS));
        subFilterInfo.mergeFilter(subFilter, "AND");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(subFilterInfo);
        EmpPosChangeDataCollection subDataColl = EmpPosChangeDataFactory.getLocalInstance((Context)ctx).getEmpPosChangeDataCollection(viewInfo);
        return subDataColl;
    }

    public static FilterInfo getOnWayCommonFilterInfo(Context ctx, boolean isHassub, String orgId) throws EASBizException, BOSException {
        Date bizDate = DateTimeUtils.truncateDate((Date)new Date());
        FilterInfo filterInfo = new FilterInfo();
        HashSet<Integer> stateSet = new HashSet<Integer>();
        stateSet.add(1);
        stateSet.add(2);
        filterInfo.getFilterItems().add(new FilterItemInfo("billState", stateSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)3, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDate, CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("isExcluded", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("isEnrolled", (Object)1));
        if (isHassub) {
            AdminOrgUnitInfo adminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
            String longNumber = adminOrg.getLongNumber();
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)longNumber, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("(#0 or (#1 and #2)) and #3 and #4 and (#5 or #6)");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg", (Object)orgId, CompareType.EQUALS));
            filterInfo.setMaskString("(#0 or (#1 and #2)) and #3 and #4 and #5");
        }
        return filterInfo;
    }

    public static boolean isExist(Context ctx, StaffManageProjectTableInfo table, StaffManageProjectInfo project, StaffManageRuleFieldCollection fields) throws BOSException, SQLException, EASBizException {
        if (!(fields != null && fields.size() != 0 || (fields = StaffManageProjectFactory.getLocalInstance(ctx).getDimensions(project)) != null && fields.size() != 0)) {
            throw new BOSException((Throwable)((Object)new StaffManageException(StaffManageException.DIMENSION_IS_NULL)));
        }
        String whereSQL = StaffManageServiceUtil.getWhereSQL(ctx, table, project, fields);
        ArrayList<String> nowFields = new ArrayList<String>();
        for (int i = 0; i < fields.size(); ++i) {
            nowFields.add(fields.get(i).getColumn());
        }
        StringBuffer existSql = new StringBuffer();
        existSql.append("select fid from " + project.getTableName());
        existSql.append(whereSQL);
        existSql.append(" and fstate = 1");
        IRowSet infos = DbUtil.executeQuery((Context)ctx, (String)existSql.toString());
        if (infos.size() > 0) {
            while (infos.next()) {
                table.setId(BOSUuid.read((String)infos.getString("fid")));
            }
            return true;
        }
        StaffManageProjectCollection projects = StaffManageProjectFactory.getLocalInstance(ctx).getStaffManageProjectCollection("where state <> 0 and tableName is not null and year = '" + project.getYear() + "'");
        for (int i = 0; i < projects.size(); ++i) {
            StaffManageRuleFieldCollection ruleFiels = StaffManageProjectFactory.getLocalInstance(ctx).getDimensions(projects.get(i));
            ArrayList<String> otherfields = new ArrayList<String>();
            for (int j = 0; j < ruleFiels.size(); ++j) {
                otherfields.add(ruleFiels.get(j).getColumn());
            }
            if (nowFields.size() != otherfields.size() || !nowFields.containsAll(otherfields)) continue;
            existSql.setLength(0);
            existSql.append("select fid from " + projects.get(i).getTableName());
            existSql.append(whereSQL);
            existSql.append(" and fstate = 1");
            IRowSet info = DbUtil.executeQuery((Context)ctx, (String)existSql.toString());
            if (info.size() <= 0) continue;
            while (info.next()) {
                table.setId(BOSUuid.read((String)info.getString("fid")));
            }
            if (logger.isInfoEnabled()) {
                logger.error((Object)("isExist projectName:" + projects.get(i).getName() + "---" + whereSQL));
            }
            return true;
        }
        return false;
    }

    public static String getWhereSQL(Context ctx, StaffManageProjectTableInfo table, StaffManageProjectInfo project, StaffManageRuleFieldCollection fields) throws BOSException, SQLException {
        StringBuffer whereSql = new StringBuffer();
        String containSub = null;
        containSub = table.get("FcontainSub") != null ? table.get("FcontainSub") + "" : (table.getContainSub() != null ? table.getContainSub().getValue() : 1) + "";
        whereSql.append(" where 1=1 and fsharestate<>1 and fcontainSub = '" + containSub + "' ");
        for (int i = 0; i < fields.size(); ++i) {
            StaffManageRuleFieldInfo field = fields.get(i);
            whereSql.append(" and ");
            Object columnModel = table.get(field.getColumn());
            if (columnModel == null || "".equals(columnModel)) {
                whereSql.append(field.getColumn() + " is null ");
                continue;
            }
            whereSql.append(field.getColumn() + " = '" + columnModel + "'");
        }
        return whereSql.toString();
    }

    public static int getOnWayAddCount(Context ctx, boolean isHassub, StaffManageRuleFieldCollection dimensions, Map<String, String> staffRowDimensionMap) throws Exception {
        String staffOrgId = staffRowDimensionMap.get("FAdminOrgID");
        EmpPosChangeDataCollection addColl = StaffManageServiceUtil.getOnWayAddPersonCount(ctx, isHassub, staffOrgId);
        return StaffManageServiceUtil.getOnWayPersonCount(ctx, addColl, dimensions, staffRowDimensionMap, 1);
    }

    public static int getOnWaySubCount(Context ctx, boolean isHassub, StaffManageRuleFieldCollection dimensions, Map<String, String> staffRowDimensionMap) throws Exception {
        String staffOrgId = staffRowDimensionMap.get("FAdminOrgID");
        EmpPosChangeDataCollection addColl = StaffManageServiceUtil.getOnWaySubPersonCount(ctx, isHassub, staffOrgId);
        return StaffManageServiceUtil.getOnWayPersonCount(ctx, addColl, dimensions, staffRowDimensionMap, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static int getOnWayPersonCount(Context ctx, EmpPosChangeDataCollection onWayColl, StaffManageRuleFieldCollection dimensions, Map<String, String> staffRowDimensionMap, int flowFlag) throws Exception {
        int onWayPersonCount = 0;
        if (null == onWayColl || onWayColl.size() == 0) {
            return onWayPersonCount;
        }
        for (int k = 0; k < onWayColl.size(); ++k) {
            void var13_19;
            String comparesql;
            EmpPosChangeDataInfo changeDataInfo = onWayColl.get(k);
            CoreBaseInfo entryInfo = null;
            String entryEntity = "";
            try {
                BOSObjectType bosType = BOSUuid.read((String)changeDataInfo.getEntryId()).getType();
                EntityObjectInfo entityObject = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType.toString()));
                entryEntity = entityObject.getFullName();
                MetaDataPK entityPK = MetaDataPK.create((String)entryEntity);
                ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)entityPK);
                entryInfo = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(changeDataInfo.getEntryId()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entryInfo == null) continue;
            if (!StringUtils.isEmpty((String)entryEntity)) {
                entryEntity = entryEntity.substring(0, entryEntity.length() - 5);
            }
            String mappingSql = StaffManageServiceUtil.getMappingSql(ctx, dimensions, entryInfo, entryEntity, flowFlag);
            ArrayList<String> staffRowCompareSQLs = new ArrayList<String>();
            for (Map.Entry entry : staffRowDimensionMap.entrySet()) {
                if ("FAdminOrgID".equals(entry.getKey()) || StringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                comparesql = "and (" + (String)entry.getKey() + " = '" + (String)entry.getValue() + "' or " + (String)entry.getKey() + " is null or " + (String)entry.getKey() + "='')";
                staffRowCompareSQLs.add(comparesql);
            }
            boolean isOnCount = true;
            boolean bl = false;
            while (var13_19 < staffRowCompareSQLs.size()) {
                comparesql = (String)staffRowCompareSQLs.get((int)var13_19);
                if (mappingSql.indexOf(comparesql) == -1) {
                    isOnCount = false;
                }
                ++var13_19;
            }
            if (!isOnCount) continue;
            ++onWayPersonCount;
        }
        return onWayPersonCount;
    }
}

