/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.model.designtime.source;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.type.SourceType;
import com.kingdee.shr.dataset.model.ParamValueItem;
import com.kingdee.shr.dataset.model.ParamsItem;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DBSource
extends AbstractSource {
    private static final long serialVersionUID = 1002755430899620397L;
    private String name;
    private DBType dbType;
    private String dbAddress;
    private String dbPort;
    private String dbName;
    private String userName;
    private String password;
    private String schema;
    private String dbVersion;
    private String connectType;
    private UserSQL userSql;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public SourceType getType() {
        return SourceType.DB;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isUserDB() {
        return true;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public String getDbAddress() {
        return this.dbAddress;
    }

    public void setDbAddress(String dbAddress) {
        this.dbAddress = dbAddress;
    }

    public String getDbPort() {
        return this.dbPort;
    }

    public void setDbPort(String dbPort) {
        this.dbPort = dbPort;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    public String getConnectType() {
        return this.connectType;
    }

    public void setConnectType(String connectType) {
        this.connectType = connectType;
    }

    public UserSQL getUserSql() {
        return this.userSql;
    }

    public void setUserSql(UserSQL userSql) {
        this.userSql = userSql;
    }

    public boolean isUserSql() {
        return AssociateType.CUSTOMSQL.name().equals(this.name);
    }

    public static enum AssociateType {
        TABLE,
        CUSTOMSQL;

    }

    public static enum DBType {
        SQLSERVER,
        ORACLE,
        POSTGRESQL,
        DB2,
        DM,
        KINGBASE;


        public String toPersistance() {
            return this.name();
        }

        public static DBType fromPersistance(String name) throws BOSException {
            try {
                return DBType.valueOf(name);
            }
            catch (Exception ex) {
                throw new BOSException("Unknown DBType: " + name);
            }
        }

        public static int getKTargetDbType(DBType dbType) {
            switch (dbType) {
                case SQLSERVER: {
                    return 3;
                }
                case ORACLE: {
                    return 2;
                }
                case POSTGRESQL: {
                    return 5;
                }
                case DB2: {
                    return 9;
                }
                case DM: {
                    return 11;
                }
                case KINGBASE: {
                    return 12;
                }
            }
            return 0;
        }
    }

    public static class UserSQL
    implements Serializable {
        private static final long serialVersionUID = 5455672502922798203L;
        private Map<String, String> name;
        private String number;
        private String sqlType;
        private List<ParamsItem> params;
        private List<ParamValueItem> runParams;
        private String content;

        public UserSQL(Map<String, String> name, String number, String sqlType, String content, List<ParamsItem> params) {
            this.name = name;
            this.number = number;
            this.sqlType = sqlType;
            this.content = content;
            this.params = params;
        }

        public List<ParamsItem> getParams() {
            return this.params;
        }

        public void setParams(List<ParamsItem> params) {
            this.params = params;
        }

        public List<ParamValueItem> getRunParams() {
            return this.runParams;
        }

        public void setRunParams(List<ParamValueItem> runParams) {
            this.runParams = runParams;
        }

        public Map<String, String> getName() {
            return this.name;
        }

        public void setName(Map<String, String> name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getSqlType() {
            if (StringUtils.isEmpty((CharSequence)this.sqlType)) {
                return SQLType.KSQL.name();
            }
            return this.sqlType;
        }

        public void setSqlType(String sqlType) {
            this.sqlType = sqlType;
        }

        public static enum SQLType {
            SQL,
            KSQL;

        }
    }
}

