/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataplatform.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.card.model.CardParams;
import com.kingdee.shr.card.service.ICardService;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.dataplatform.CardConfigInfo;
import com.kingdee.shr.dataplatform.DataSetConfigFactory;
import com.kingdee.shr.dataplatform.DataSetConfigInfo;
import com.kingdee.shr.dataplatform.IDataSetConfig;
import com.kingdee.shr.dataplatform.ISQLResult;
import com.kingdee.shr.dataplatform.PageConfigInfo;
import com.kingdee.shr.dataplatform.SQLResultFactory;
import com.kingdee.shr.dataplatform.SQLResultInfo;
import com.kingdee.shr.dataplatform.SQLTypeEnum;
import com.kingdee.shr.dataplatform.WorkPFSolutionInfo;
import com.kingdee.shr.dataplatform.app.AbstractCardConfigControllerBean;
import com.kingdee.shr.dataplatform.cache.DataplatformCacheHelper;
import com.kingdee.shr.dataset.model.DataSourceItem;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.service.DataPlatformServiceFactory;
import com.kingdee.shr.pageset.model.Children;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class CardConfigControllerBean
extends AbstractCardConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.dataplatform.app.CardConfigControllerBean");

    @Override
    public IObjectPK[] _saveBatchDataByPage(Context ctx, IObjectCollection colls, IObjectValue model) throws BOSException, EASBizException {
        Object[] pks = super._saveBatchData(ctx, colls);
        FilterInfo filter = new FilterInfo();
        if (model instanceof PageConfigInfo) {
            PageConfigInfo pageConfigInfo = (PageConfigInfo)model;
            filter.getFilterItems().add(new FilterItemInfo("page.id", (Object)pageConfigInfo.getId().toString()));
            if (StringUtils.isEmpty((CharSequence)pageConfigInfo.getExtend())) {
                filter.getFilterItems().add(new FilterItemInfo("isPreset", (Object)1));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("isPreset", (Object)0));
            }
        }
        if (model instanceof WorkPFSolutionInfo) {
            WorkPFSolutionInfo workPFSolutionInfo = (WorkPFSolutionInfo)model;
            filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)workPFSolutionInfo.getId().toString()));
        }
        if (pks.length != 0) {
            String cardIds = Arrays.toString(pks);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)cardIds, CompareType.NOTINCLUDE));
        }
        this.saveSQLResultInfo(ctx, (IObjectPK[])pks, colls);
        this._delete(ctx, filter);
        return pks;
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        Object[] pks = super._delete(ctx, filter);
        if (pks.length != 0) {
            filter = new FilterInfo();
            String cardIds = Arrays.toString(pks);
            filter.getFilterItems().add(new FilterItemInfo("boid", (Object)cardIds, CompareType.INCLUDE));
            SQLResultFactory.getLocalInstance(ctx).delete(filter);
        }
        for (Object pk : pks) {
            DataplatformCacheHelper.remove(ctx, 3, pk.toString());
        }
        return pks;
    }

    private void saveSQLResultInfo(Context ctx, IObjectPK[] pks, IObjectCollection coll) throws EASBizException, BOSException {
        ICardService service = (ICardService)DataPlatformServiceFactory.getPlateformService("/dataplateform/card.do");
        IDataSetConfig iDataSetConfig = DataSetConfigFactory.getLocalInstance(ctx);
        ISQLResult iSQLResult = SQLResultFactory.getLocalInstance(ctx);
        int total = coll.size();
        for (int i = 0; i < total; ++i) {
            CardConfigInfo model = (CardConfigInfo)coll.getObject(i);
            if (null == model.getDataSet()) continue;
            Children card = (Children)JSONUtils.convertJsonToObject((Context)ctx, (String)model.getContent(), Children.class);
            CardParams cardParams = new CardParams();
            cardParams.setCardNodeId(model.getId().toString());
            cardParams.setCardPermItemId(null != model.getPermItem() ? model.getPermItem().getId().toString() : null);
            cardParams.setDataSetId(model.getDataSet().getId().toString());
            cardParams.setDimension(null != card.getProps() ? card.getProps().getDimension() : null);
            cardParams.setMeasure(null != card.getProps() ? card.getProps().getMeasure() : null);
            SQLResult sqlResult = service.getSQLResult(ctx, cardParams);
            DataSetConfigInfo info = iDataSetConfig.getDataSetConfigInfo((IObjectPK)new ObjectUuidPK(model.getDataSet().getId().toString()));
            sqlResult.setSetType(info.getSetType().getValue());
            DataSourceItem ds = new DataSourceItem();
            ds.setId(info.getDatasource().getId().toString());
            sqlResult.setDataSourceItem(ds);
            SQLResultInfo resultInfo = null;
            String oql = " where boid='" + model.getId().toString() + "'";
            if (iSQLResult.exists(oql)) {
                resultInfo = iSQLResult.getSQLResultInfo(oql);
            } else {
                resultInfo = new SQLResultInfo();
                resultInfo.setBoid(model.getId().toString());
                resultInfo.setType(SQLTypeEnum.DataSetSQL);
            }
            resultInfo.setContent(JSONUtils.convertObjectToJson((Context)ctx, (Object)sqlResult));
            iSQLResult.save((CoreBaseInfo)resultInfo);
            DataplatformCacheHelper.remove(ctx, 3, model.getId().toString());
        }
    }
}

